/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.autoissue;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.imc.bdm.common.helper.SchemeHelper;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.MetadataUtil;

public class AutoIssueFormPlugin
extends AbstractFormPlugin {
    public static final ImmutableSet<String> SYS_PRESET = new ImmutableSet.Builder().add((Object[])new String[]{"orgid", "systemsource", "billsource", "invoicetype", "drawer"}).add((Object[])new String[]{"buyername", "buyertaxno", "totalamount", "invoiceamount", "totaltax"}).add((Object[])new String[]{"textfield1", "textfield2", "textfield3", "textfield4", "textfield5"}).build();

    public void beforeBindData(EventObject e) {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
        filterGrid.setEntityNumber("sim_original_bill");
        HashSet<String> fieldList = new HashSet<String>((Collection<String>)SYS_PRESET);
        this.addConfigField(fieldList);
        this.addExtField(fieldList);
        filterGrid.setFilterFieldKeys(new ArrayList<String>(fieldList));
    }

    private void addConfigField(Set<String> fieldList) {
        String addFields = ImcConfigUtil.getValue((String)"bdm_auto_issue", (String)"extField");
        try {
            if (StringUtils.isNotBlank((CharSequence)addFields)) {
                fieldList.addAll(Splitter.on((String)",").splitToList((CharSequence)addFields));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addExtField(Set<String> fieldList) {
        List isvEntityItems = MetadataUtil.getIsvEntityItems((String)"sim_original_bill");
        DynamicObjectType billItemObjectType = ((EntryProp)EntityMetadataCache.getDataEntityType((String)"sim_original_bill").getProperty("sim_original_bill_item")).getDynamicCollectionItemPropertyType();
        for (String isvEntityItem : isvEntityItems) {
            if (billItemObjectType.getProperty(isvEntityItem) != null) continue;
            fieldList.add(isvEntityItem);
        }
    }

    public void afterBindData(EventObject e) {
        this.setFilterGrid();
        String repeatMode = (String)this.getModel().getValue("repeatmode");
        if ("month".equals(repeatMode)) {
            this.setSelect("day_");
        } else if ("week".equals(repeatMode)) {
            this.setSelect("week_");
        }
        this.getModel().setDataChanged(false);
    }

    private void setFilterGrid() {
        String filter = (String)this.getModel().getValue("filter_tag");
        FilterCondition filterCondition = null;
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filter, FilterCondition.class);
        }
        if (filterCondition != null) {
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
            filterGrid.SetValue(filterCondition);
        }
    }

    private void setSelect(String prefix) {
        String dayStr = (String)this.getModel().getValue("day");
        String[] dayArr = dayStr.split(",");
        IDataModel model = this.getModel();
        for (String day : dayArr) {
            if (this.getControl(prefix + day) == null) continue;
            model.setValue(prefix + day, (Object)true);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (StringUtils.equalsIgnoreCase((CharSequence)"save", (CharSequence)((FormOperate)args.getSource()).getOperateKey())) {
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
            this.getModel().setValue("filter_tag", (Object)SchemeHelper.getFilterStr((FilterGrid)filterGrid));
        }
    }
}

