/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.custommail;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.imc.bdm.common.helper.SchemeHelper;
import kd.imc.bdm.common.util.ImcConfigUtil;

public class BatchPushMailSettingPlugin
extends AbstractFormPlugin
implements BeforeFilterF7SelectListener {
    public void beforeBindData(EventObject e) {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
        ArrayList<String> fieldKeys = new ArrayList<String>(1);
        try {
            String mailExtraFiled = ImcConfigUtil.getValue((String)"sim_config", (String)"sim_mail_field_config");
            if (StringUtils.isNotBlank((CharSequence)mailExtraFiled)) {
                ArrayList<String> fileds = new ArrayList<String>(Arrays.asList(mailExtraFiled.split(",")));
                MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"sim_vatinvoice");
                List properties = entityType.getProperties().stream().filter(property -> fileds.contains(property.getName())).collect(Collectors.toList());
                for (IDataEntityProperty property2 : properties) {
                    if (null == property2.getDisplayName() || property2 instanceof EntryProp) continue;
                    fieldKeys.add(property2.getName());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        fieldKeys.add("buyername");
        SchemeHelper.initializeFilterGrid((FilterGrid)filterGrid, fieldKeys, (String)"sim_vatinvoice");
    }

    public void afterBindData(EventObject e) {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
        if (OperationStatus.EDIT.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            this.getView().getPageCache().put("sim_red_info_edit", "sim_red_info_edit");
        }
        FilterCondition filterCondition = null;
        String s = (String)this.getView().getModel().getValue("filter_tag");
        if (StringUtils.isNotBlank((CharSequence)s)) {
            filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)s, FilterCondition.class);
        }
        if (filterCondition != null) {
            filterGrid.SetValue(filterCondition);
        }
        this.getModel().setValue("org", (Object)RequestContext.get().getOrgId());
        this.getModel().setDataChanged(false);
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"tbmain"});
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
        filterGrid.addBeforeF7SelectListener((BeforeFilterF7SelectListener)this);
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent event) {
        ArrayList list = Lists.newArrayListWithExpectedSize((int)2);
        if ("bdm_operator_info".equals(event.getRefEntityId())) {
            list.add(new QFilter("org", "=", (Object)RequestContext.get().getOrgId()));
        }
        event.setCustomQFilters((List)list);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (StringUtils.equalsIgnoreCase((CharSequence)"save", (CharSequence)((FormOperate)args.getSource()).getOperateKey())) {
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
            this.getModel().setValue("filter_tag", (Object)SchemeHelper.getFilterStr((FilterGrid)filterGrid));
        }
    }
}

