/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.custommail;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.RichTextEditor;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.helper.MailSettingHelper;
import kd.imc.bdm.common.helper.SchemeHelper;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.bdm.formplugin.custommail.MailSettingPluginHelper;

public class RedConfirmMailSettingPlugin
extends AbstractFormPlugin {
    private static final String DEFAULT_FIELDS = String.join((CharSequence)",", "enteridentity", "uploaddate", "buyername", "salername", "number", "originalinvoicecode", "originalinvoiceno");

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtercontrol");
        List<String> fieldKeys = this.getFieldKeys();
        SchemeHelper.initializeFilterGrid((FilterGrid)filterGrid, fieldKeys, (String)"sim_red_confirm_bill");
    }

    private List<String> getFieldKeys() {
        ArrayList list = Lists.newArrayList();
        list.add("redreason");
        list.add("salername");
        list.add("buyername");
        try {
            ViewUtil.putFieldKeys((List)list, (String)ImcConfigUtil.getValue((String)"redconfirm_mail_filter_config", (String)"ext_fields"), (String)"sim_red_confirm_bill");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        ViewUtil.beforeSaveFilterTag((IFormView)this.getView(), (BeforeDoOperationEventArgs)args);
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"tbmain", "advcontoolbarap1", "advcontoolbarap2"});
        this.addClickListeners(new String[]{"choosefield", "itemchoosefield"});
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("number", (Object)String.format("RYXSZ%s", MailSettingPluginHelper.getID()));
        this.getModel().setValue("epinfos", (Object)"DONE");
        MailSettingPluginHelper.editorAutoFill(this, "bdm_mail_redconfirm", "RYZYXSZ01_s");
        Label label = (Label)this.getControl("labelap1");
        String tip = MailSettingPluginHelper.getMultiFieldsTip(DEFAULT_FIELDS, MailSettingHelper.getRedConfirmMap());
        label.setText(tip);
    }

    public void afterBindData(EventObject e) {
        String number = this.getModel().getValue("number").toString();
        if (StringUtils.isEmpty((CharSequence)number)) {
            this.getModel().setValue("number", (Object)String.format("RYXSZ%s", MailSettingPluginHelper.getID()));
        }
        RichTextEditor multiEditor = (RichTextEditor)this.getView().getControl("multimailbodyedit");
        RichTextEditor editor = (RichTextEditor)this.getView().getControl("mailbodyedit");
        String mailBody = this.getModel().getValue("mailbody_tag").toString();
        String multiMailBody = this.getModel().getValue("multimailbody_tag").toString();
        if (StringUtils.isBlank((CharSequence)mailBody)) {
            QFilter filter = new QFilter("number", "=", (Object)"RYZYXSZ01_s");
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)"bdm_mail_redconfirm", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_mail_redconfirm", (boolean)true), (QFilter[])new QFilter[]{filter});
            if (obj != null) {
                mailBody = obj.getString("mailbody_tag");
                multiMailBody = obj.getString("multimailbody_tag");
            }
        }
        editor.setText(mailBody);
        multiEditor.setText(multiMailBody);
        String fields = this.getModel().getValue("multifields").toString();
        if (StringUtils.isBlank((CharSequence)fields)) {
            fields = DEFAULT_FIELDS;
            this.getModel().setValue("multifields", (Object)fields);
        }
        Label label = (Label)this.getControl("labelap1");
        String tip = MailSettingPluginHelper.getMultiFieldsTip(fields, MailSettingHelper.getRedConfirmMap());
        label.setText(tip);
        String itemmultifields = this.getModel().getValue("itemmultifields").toString();
        if (StringUtils.isNotEmpty((CharSequence)itemmultifields)) {
            Label itemLabel = (Label)this.getControl("itemlabelap");
            String itemTip = MailSettingPluginHelper.getMultiFieldsTip(itemmultifields, MailSettingHelper.getRedConfirmItemMap());
            itemLabel.setText(itemTip);
        }
        ViewUtil.setFilterGrid((IFormView)this.getView());
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey()) {
            case "btn_testing": {
                MailSettingPluginHelper.testing(this);
                break;
            }
            case "btn_show": {
                HashMap<String, String> map = new HashMap<String, String>(1);
                map.put("pagetype", "redconfirm");
                ViewUtil.openDialog((AbstractFormPlugin)this, map, (String)"bdm_mail_show", (String)"mailShowCallBack");
                break;
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (control.getKey()) {
            case "choosefield": {
                HashMap<String, Object> customParam = new HashMap<String, Object>();
                customParam.put("formkey", "redconfirm");
                customParam.put("selectFields", this.getModel().getValue("multifields"));
                customParam.put("configId", "");
                String tipMsg = ResManager.loadKDString((String)"\u7ea2\u5b57\u786e\u8ba4\u5355\u5b57\u6bb5\u9009\u62e9", (String)"RedConfirmMailSettingPlugin_0", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
                ViewUtil.openDialog((AbstractFormPlugin)this, (String)tipMsg, customParam, (String)"bdm_customs_field_config", (String)"bdm_customs_field_config");
                break;
            }
            case "itemchoosefield": {
                HashMap<String, String> itemCustomParam = new HashMap<String, String>();
                itemCustomParam.put("formkey", "redconfirmitem");
                String itemmultifields = (String)this.getModel().getValue("itemmultifields");
                itemCustomParam.put("selectFields", itemmultifields);
                itemCustomParam.put("configId", "");
                String itemTipMsg = ResManager.loadKDString((String)"\u7ea2\u5b57\u786e\u8ba4\u5355\u660e\u7ec6\u5b57\u6bb5\u9009\u62e9", (String)"RedConfirmMailSettingPlugin_1", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
                ViewUtil.openDialog((AbstractFormPlugin)this, (String)itemTipMsg, itemCustomParam, (String)"bdm_customs_field_config", (String)"redconfirmitem_field_config");
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if ("bdm_customs_field_config".equals(actionId) && returnData != null) {
            String multiFields = (String)returnData;
            this.getModel().setValue("multifields", (Object)multiFields);
            if (StringUtils.isNotBlank((CharSequence)multiFields)) {
                Label label = (Label)this.getControl("labelap1");
                String tip = MailSettingPluginHelper.getMultiFieldsTip(multiFields, MailSettingHelper.getRedConfirmMap());
                label.setText(tip);
            }
        }
        if ("redconfirmitem_field_config".equals(actionId) && returnData != null) {
            String itemMultiFields = (String)returnData;
            this.getModel().setValue("itemmultifields", (Object)itemMultiFields);
            Label itemLabel = (Label)this.getControl("itemlabelap");
            String itemTip = "";
            if (StringUtils.isNotEmpty((CharSequence)itemMultiFields)) {
                itemTip = MailSettingPluginHelper.getMultiFieldsTip(itemMultiFields, MailSettingHelper.getRedConfirmItemMap());
            }
            itemLabel.setText(itemTip);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey()) {
            case "bar_save": {
                RichTextEditor editor = (RichTextEditor)this.getView().getControl("mailbodyedit");
                RichTextEditor multiEditor = (RichTextEditor)this.getView().getControl("multimailbodyedit");
                this.getModel().setValue("mailbody_tag", (Object)editor.getText());
                this.getModel().setValue("multimailbody_tag", (Object)multiEditor.getText());
            }
        }
    }
}

