/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.customsdeclaration;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.HttpUtil;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.declarationbill.SignUtil;

public class CustomsDeclarationFormPlugin
extends AbstractFormPlugin {
    private static Log LOGGER = LogFactory.getLog(CustomsDeclarationFormPlugin.class);

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        switch (itemKey = evt.getItemKey()) {
            case "verify": {
                String url = this.getModel().getValue("environment").toString().equals("1") ? "http://api.xunoi.com" : "http://test.xunoi.com:8082";
                String result = CustomsDeclarationFormPlugin.verifyInfo(this.getModel().getValue("appkey").toString(), this.getModel().getValue("secretkey").toString(), this.getModel().getValue("isvpublickey").toString(), this.getModel().getValue("taxnumber").toString(), url);
                if (result.equals("error")) {
                    String errorMsg = ResManager.loadKDString((String)"\u7a0e\u53f7\u4e3a\u7a7a\u6216\u6570\u636e\u672a\u4fdd\u5b58", (String)"CustomsDeclarationFormPlugin_0", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
                    throw new KDBizException(errorMsg);
                }
                if (StringUtils.isNotBlank((CharSequence)result)) {
                    JSONObject jsonObject = CustomsDeclarationFormPlugin.getJsonData(result);
                    if ("1000".equals(jsonObject.get((Object)"code").toString())) {
                        JSONObject msg = CustomsDeclarationFormPlugin.getData(jsonObject);
                        if (msg.get((Object)"nsrsbh").equals(this.getModel().getValue("taxnumber").toString())) {
                            String errorMsg = ResManager.loadKDString((String)"\u9a8c\u8bc1\u6210\u529f,\u8bf7\u53ca\u65f6\u4fdd\u5b58", (String)"CustomsDeclarationFormPlugin_1", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
                            this.getView().showSuccessNotification(errorMsg);
                            this.getModel().setValue("validation", (Object)"2");
                            break;
                        }
                        this.getModel().setValue("validation", (Object)"1");
                        String errorMsg = ResManager.loadKDString((String)"\u9a8c\u8bc1\u5931\u8d25\uff0c\u7a0e\u53f7\u4e0d\u5339\u914d", (String)"CustomsDeclarationFormPlugin_2", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
                        this.getView().showErrorNotification(errorMsg);
                        break;
                    }
                    this.getModel().setValue("validation", (Object)"1");
                    String errorMsg = ResManager.loadKDString((String)"\u9a8c\u8bc1\u5931\u8d25", (String)"CustomsDeclarationFormPlugin_3", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
                    this.getView().showErrorNotification(errorMsg);
                    break;
                }
                this.getModel().setValue("validation", (Object)"1");
                String errorMsg = ResManager.loadKDString((String)"\u9a8c\u8bc1\u5931\u8d25", (String)"CustomsDeclarationFormPlugin_3", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(errorMsg);
                break;
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue("createorg");
        this.getModel().setValue("name", (Object)dynamicObject.getString("ffirmname"));
        this.getModel().setValue("taxnumber", (Object)dynamicObject.getString("uniformsocialcreditcode"));
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        switch (e.getProperty().getName()) {
            case "appkey": 
            case "secretkey": 
            case "environment": 
            case "taxnumber": {
                if (this.getModel().getValue("validation").toString().equals("0")) break;
                this.getModel().setValue("validation", (Object)"0");
                String errorMsg = ResManager.loadKDString((String)"\u9a8c\u8bc1\u72b6\u6001\u5df2\u66f4\u65b0\u4e3a\u672a\u9a8c\u8bc1\uff0c\u8bf7\u91cd\u65b0\u9a8c\u8bc1", (String)"CustomsDeclarationFormPlugin_4", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(errorMsg);
                break;
            }
            case "useorg": {
                this.getModel().setValue("name", null);
                this.getModel().setValue("taxnumber", null);
                DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue("useorg");
                QFilter filter = new QFilter("org", "=", dynamicObject.get("id"));
                DynamicObject dynamicObject1 = BusinessDataServiceHelper.loadSingle((String)"bdm_enterprise_baseinfo", (String)String.join((CharSequence)",", "name", "number"), (QFilter[])filter.toArray());
                if (dynamicObject1 == null) break;
                this.getModel().setValue("name", (Object)dynamicObject1.getString("name"));
                this.getModel().setValue("taxnumber", (Object)dynamicObject1.getString("number"));
            }
        }
    }

    public static String verifyInfo(String appKey, String secret, String publicKey, String taxNumber, String url) {
        String result;
        String interfaceName = "queryDeveloperInfo";
        if (url.equals("error")) {
            return url;
        }
        HashMap<String, String> formData = CustomsDeclarationFormPlugin.getFormData(appKey, interfaceName, secret);
        try {
            int readTimeout = CustomsDeclarationFormPlugin.getDeclarationReadTime();
            result = HttpUtil.doPostJson((String)url, null, null, (String)JSONObject.toJSONString(formData), (int)readTimeout, (int)readTimeout);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            String errorMsg = ResManager.loadKDString((String)"\u9a8c\u8bc1\u4fe1\u606f\u5f02\u5e38", (String)"CustomsDeclarationFormPlugin_5", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
            throw new KDBizException(errorMsg + e.getMessage());
        }
        return result;
    }

    private static int getDeclarationReadTime() {
        try {
            String readTimeout = ImcConfigUtil.getValue((String)"declaration", (String)"read_time");
            if (StringUtils.isNotBlank((CharSequence)readTimeout)) {
                return Integer.parseInt(readTimeout);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 600000;
    }

    public static JSONObject getJsonData(String result) {
        JSONObject jsonObject = JSONObject.parseObject((String)result);
        jsonObject = jsonObject.getJSONObject("data");
        return jsonObject;
    }

    public static JSONObject getData(JSONObject jsonObject) {
        JSONArray data = jsonObject.getJSONArray("data");
        String s = data.toJSONString();
        s = s.substring(1, s.length() - 1);
        JSONObject msg = JSONObject.parseObject((String)s);
        return msg;
    }

    private static HashMap<String, String> getFormData(String appKey, String interfaceName, String secret) {
        HashMap<String, String> formData = new HashMap<String, String>();
        formData.put("access_token", "");
        JSONObject innerData = new JSONObject();
        innerData.put("app_key", (Object)appKey);
        innerData.put("data", (Object)"");
        String encodeFormData = CustomsDeclarationFormPlugin.getEncodeParam(innerData.toJSONString());
        formData.put("data", encodeFormData);
        formData.put("app_key", appKey);
        formData.put("format", "json");
        formData.put("name", interfaceName);
        formData.put("version", "1.0");
        String timeStamp = DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
        formData.put("timestamp", timeStamp);
        String sign = SignUtil.createSign(formData, (String)secret);
        formData.put("sign", sign);
        return formData;
    }

    private static String getEncodeParam(String params) {
        try {
            params = URLEncoder.encode(params, "utf-8");
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return params;
    }
}

