/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.equipment;

import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResultImpl;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.EquipmentType;
import kd.imc.bdm.common.helper.OrgHelper;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.bdm.formplugin.equipment.control.AddEquipmentControl;

public class AddEquipmentPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void afterBindData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"cabinet"});
        BillShowParameter formShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        Object pkId = formShowParameter.getPkId();
        if (pkId != null) {
            DynamicObject equipmentDO = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"bdm_tax_equipment");
            String authStatus = equipmentDO.getString("authstatus");
            if (EquipmentType.isLyServer((String)equipmentDO.getString("equipmenttype"))) {
                this.showCabinet(equipmentDO, "0");
            } else if ("8".equals(equipmentDO.getString("equipmenttype"))) {
                this.showCabinet(equipmentDO, "1");
            }
            if ("1".equals(authStatus) || "2".equals(authStatus)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"epinfo", "equipmentno", "equipmenttype", "cabinet", "terminalno", "fjh"});
            }
        }
    }

    private void showCabinet(DynamicObject equipmentDO, String type) {
        this.getView().setVisible(Boolean.TRUE, new String[]{"cabinet"});
        ViewUtil.setDropDownViewData((AbstractFormPlugin)this, (String)"cabinet", new AddEquipmentControl().getCabinetListFromISMC(type));
        this.getView().getModel().setValue("cabinet", (Object)equipmentDO.getString("cabinet"));
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap", "advcontoolbarap"});
        this.addClickListeners(new String[]{"sync"});
        BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl("epinfo");
        if (basedataEdit != null) {
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        String equipmentType = this.getModel().getValue("equipmenttype") + "";
        String devNo = this.getModel().getValue("equipmentno") + "";
        if ("sync".equals(itemKey)) {
            boolean enterpriseAuth = TaxUtils.isEnterpriseAuth((Object)DynamicObjectUtil.getDynamicObjectLongValue((Object)this.getModel().getValue("epinfo")));
            if (enterpriseAuth) {
                new AddEquipmentControl().syncDevLimit(equipmentType, devNo, this);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7a0e\u53f7\u8fd8\u672a\u6388\u6743\uff0c\u65e0\u6cd5\u8fdb\u884c\u9650\u989d\u540c\u6b65", (String)"AddEquipmentPlugin_0", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("equipmenttype".equals(name)) {
            new AddEquipmentControl().changeEquipmentType(e, this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        if ("epinfo".equals(name)) {
            ArrayList<QFilter> list = new ArrayList<QFilter>();
            HasPermOrgResultImpl userHasPermEpInfo = OrgHelper.getUserHasPermEpInfo();
            if (!userHasPermEpInfo.hasAllOrgPerm()) {
                list.add(new QFilter("id", "in", (Object)userHasPermEpInfo.getHasPermOrgs()));
            }
            beforeF7SelectEvent.setCustomQFilters(list);
        }
    }
}

