/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.equipment.control;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.EquipmentType;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.SynchronizationQuotaHelper;
import kd.imc.bdm.common.helper.UnitTestHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.message.model.MsgResponse;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.RandomString;
import kd.imc.bdm.common.util.RequestUtils;
import kd.imc.bdm.common.util.UUID;
import kd.imc.bdm.common.util.ViewUtil;

public class AddEquipmentControl {
    public HashMap<String, String> getCabinetListFromISMC(String type) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("type", (Object)type);
        MsgResponse msgResponse = UnitTestHelper.isUnitTest() ? MsgResponse.valueOfSuccess((String)"[{\"name\": \"ssss\", \"id\": \"1232434\"}]") : RequestUtils.doRequest((String)UUID.next(), (String)"TrusteeServerInfo", (Object)jsonObject);
        if (ErrorType.SUCCESS.getCode().equalsIgnoreCase(msgResponse.getErrorCode())) {
            String respData = msgResponse.getRespData();
            JSONArray jsonArray = JSON.parseArray((String)respData);
            HashMap<String, String> cabinetMap = new HashMap<String, String>();
            for (Object o : jsonArray) {
                JSONObject object = (JSONObject)o;
                cabinetMap.put(object.getString("name"), object.getString("id"));
            }
            return cabinetMap;
        }
        return new HashMap<String, String>();
    }

    public void getLYIsActive() {
        QFilter qFilter = new QFilter("authstatus", "=", (Object)"2");
        DynamicObject[] objects = BusinessDataServiceHelper.load((String)"bdm_tax_equipment", (String)"equipmentno, authstatus", (QFilter[])qFilter.toArray());
        if (objects.length < 1) {
            return;
        }
        MsgResponse msgResponse = RequestUtils.doRequest((String)UUID.next(), (String)"GetLyActive", (Object)DynamicObjectUtil.dynamicObjects2ListMap((DynamicObject[])objects, (boolean)true));
        if (ErrorType.SUCCESS.getCode().equalsIgnoreCase(msgResponse.getErrorCode())) {
            String respData = msgResponse.getRespData();
            JSONArray jsonArray = JSON.parseArray((String)respData);
            for (Object o : jsonArray) {
                JSONObject object = (JSONObject)o;
                for (DynamicObject dynamicObject : objects) {
                    if (!object.getString("devno").equals(dynamicObject.getString("equipmentno"))) continue;
                    dynamicObject.set("authstatus", (Object)object.getString("status"));
                }
            }
            ImcSaveServiceHelper.update((DynamicObject[])objects);
        }
    }

    public void syncDevLimit(String equipmentType, String devNo, AbstractFormPlugin plugin) {
        StringBuilder invoiceTypes = new StringBuilder();
        if ("0".equals(equipmentType) || "1".equals(equipmentType) || "2".equals(equipmentType)) {
            this.componentSync(equipmentType, devNo, invoiceTypes, plugin);
        } else if (EquipmentType.isLyServer((String)equipmentType)) {
            this.synLyServerQuota(devNo, invoiceTypes, plugin);
        } else {
            plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u8be5\u7c7b\u578b\u8bbe\u5907\u540c\u6b65\u9650\u989d", (String)"AddEquipmentControl_0", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
        }
        if (invoiceTypes.length() > 0) {
            plugin.getView().getModel().setValue("invoicetypes", (Object)invoiceTypes.substring(0, invoiceTypes.length() - 1));
        }
    }

    public void componentSync(String equipmentType, String devNo, StringBuilder invoiceTypes, AbstractFormPlugin plugin) {
        try {
            JSONObject resp = SynchronizationQuotaHelper.synEntityUKeyQuota((String)devNo);
            if ("0".equals(resp.get((Object)"errcode"))) {
                JSONObject sjd = resp.getJSONObject("sjd");
                if (sjd.containsKey((Object)"zyfpkpxe")) {
                    invoiceTypes.append("004,");
                }
                if (sjd.containsKey((Object)"ptfpkpxe")) {
                    invoiceTypes.append("007,");
                }
                if (sjd.containsKey((Object)"djdpfpkpxe")) {
                    invoiceTypes.append("026,");
                }
                if (sjd.containsKey((Object)"djdpzyfpkpxe")) {
                    invoiceTypes.append("028,");
                }
                plugin.getView().getModel().setValue("paperzticketquota", sjd.get((Object)"zyfpkpxe"));
                plugin.getView().getModel().setValue("paperpticketquota", sjd.get((Object)"ptfpkpxe"));
                plugin.getView().getModel().setValue("electzticketquota", sjd.get((Object)"djdpzyfpkpxe"));
                plugin.getView().getModel().setValue("electpticketquota", sjd.get((Object)"djdpfpkpxe"));
                plugin.getView().getModel().setValue("ticketquota", (Object)"");
                plugin.getView().getModel().setValue("motorticketquota", (Object)"");
            } else {
                ComboEdit com = (ComboEdit)plugin.getControl("equipmenttype");
                ComboProp prop = (ComboProp)com.getProperty();
                plugin.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5%1$s%2$s", (String)"AddEquipmentControl_4", (String)"imc-bdm-formplugin", (Object[])new Object[0]), prop.getItemByName(equipmentType), resp.get((Object)"description")), Integer.valueOf(2000));
            }
        }
        catch (MsgException msg) {
            plugin.getView().showTipNotification(msg.getErrorMsg());
        }
    }

    public void synLyServerQuota(String devNo, StringBuilder invoiceTypes, AbstractFormPlugin plugin) {
        MsgResponse resp = SynchronizationQuotaHelper.synLyServerQuota((String)devNo);
        if ("0000".equals(resp.getErrorCode())) {
            String json = resp.getRespData();
            if (StringUtils.isNotEmpty((CharSequence)json)) {
                List list = JSON.parseArray((String)json, Map.class);
                for (Map map : list) {
                    String num = map.get("limit") + "";
                    switch (map.get("invoiceType") + "") {
                        case "004": {
                            invoiceTypes.append("004,");
                            plugin.getView().getModel().setValue("paperzticketquota", (Object)num);
                            break;
                        }
                        case "007": {
                            invoiceTypes.append("007,");
                            plugin.getView().getModel().setValue("paperpticketquota", (Object)num);
                            break;
                        }
                        case "028": {
                            invoiceTypes.append("028,");
                            plugin.getView().getModel().setValue("electzticketquota", (Object)num);
                            break;
                        }
                        case "026": {
                            invoiceTypes.append("026,");
                            plugin.getView().getModel().setValue("electpticketquota", (Object)num);
                            break;
                        }
                        case "025": {
                            invoiceTypes.append("025,");
                            plugin.getView().getModel().setValue("ticketquota", (Object)num);
                            break;
                        }
                        case "005": {
                            invoiceTypes.append("005,");
                            plugin.getView().getModel().setValue("motorticketquota", (Object)num);
                            break;
                        }
                    }
                }
            } else {
                plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u540c\u6b65\u9650\u989d\u5931\u8d25\uff1a\u8054\u4e91\u540c\u6b65\u9650\u989d\u8fd4\u56de\u7a7a", (String)"AddEquipmentControl_2", (String)"imc-bdm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            }
        } else {
            plugin.getView().showTipNotification(resp.getErrorMsg(), Integer.valueOf(2000));
        }
    }

    public void changeEquipmentType(PropertyChangedArgs e, AbstractFormPlugin plugin) {
        if ("3".equals(e.getChangeSet()[0].getNewValue())) {
            plugin.getView().getModel().setValue("equipmentno", (Object)RandomString.nextString((int)10, (boolean)true, (boolean)true));
        }
        if ("3".equals(e.getChangeSet()[0].getOldValue())) {
            plugin.getView().getModel().setValue("equipmentno", (Object)"");
        }
        if (EquipmentType.isLyServer((String)((String)e.getChangeSet()[0].getNewValue()))) {
            plugin.getView().setVisible(Boolean.TRUE, new String[]{"cabinet"});
            HashMap<String, String> map = this.getCabinetListFromISMC("0");
            if (map.isEmpty()) {
                plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u6258\u7ba1\u673a\u67dc\u5217\u8868\u4e3a\u7a7a\uff0c\u8bf7\u5148\u5230\u7a0e\u63a7\u7cfb\u7edf\u4e91\u6dfb\u52a0\u673a\u67dc\u4fe1\u606f", (String)"AddEquipmentControl_3", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            } else {
                ViewUtil.setDropDownViewData((AbstractFormPlugin)plugin, (String)"cabinet", map);
            }
        } else if ("8".equals(e.getChangeSet()[0].getNewValue())) {
            plugin.getView().setVisible(Boolean.TRUE, new String[]{"cabinet"});
            HashMap<String, String> map = this.getCabinetListFromISMC("1");
            if (map.isEmpty()) {
                plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u6258\u7ba1\u673a\u67dc\u5217\u8868\u4e3a\u7a7a\uff0c\u8bf7\u5148\u5230\u7a0e\u63a7\u7cfb\u7edf\u4e91\u6dfb\u52a0\u673a\u67dc\u4fe1\u606f", (String)"AddEquipmentControl_3", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            } else {
                ViewUtil.setDropDownViewData((AbstractFormPlugin)plugin, (String)"cabinet", map);
            }
        } else {
            plugin.getView().setVisible(Boolean.FALSE, new String[]{"cabinet"});
        }
    }
}

