/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.estatelease;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.imc.bdm.common.helper.SchemeHelper;
import kd.imc.bdm.common.util.ImcConfigUtil;

public class EstateLeaseFormPlugin
extends AbstractFormPlugin {
    private static final String[] BUILD_INFO_MUST_INPUT = new String[]{"buildingname"};
    private static final String[] ESTATE_LEASE_INFO_MUST_INPUT = new String[]{"estateid", "areaunit"};
    private static final String[] cancelMustInput = new String[]{"buildingname", "estateid", "areaunit"};

    public void registerListener(EventObject eventObject) {
        this.addClickListeners(new String[]{"tbmain"});
    }

    public void itemClick(ItemClickEvent event) {
        super.itemClick(event);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtercontrol");
        ArrayList fieldKeys = new ArrayList();
        Collections.addAll(fieldKeys, "creator.name", "systemsource", "textfield1", "textfield5", "textfield2", "textfield3", "textfield4", "buyername");
        String fields = ImcConfigUtil.getValue((String)"matchBuildingExtraField", (String)"originalBillFields");
        if (StringUtils.isNotBlank((CharSequence)fields)) {
            try {
                String[] originalExtraFields = fields.split(",");
                Collections.addAll(fieldKeys, originalExtraFields);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        SchemeHelper.initializeFilterGrid((FilterGrid)filterGrid, fieldKeys, (String)"sim_original_bill");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (StringUtils.equalsIgnoreCase((CharSequence)"save", (CharSequence)((FormOperate)args.getSource()).getOperateKey())) {
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtercontrol");
            String filterStr = SchemeHelper.getFilterStr((FilterGrid)filterGrid);
            this.getModel().setValue("filter_tag", (Object)filterStr);
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.EstateTypeChange();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String filter = (String)this.getModel().getValue("filter_tag");
        FilterCondition filterCondition = null;
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filter, FilterCondition.class);
        }
        if (filterCondition != null) {
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtercontrol");
            filterGrid.SetValue(filterCondition);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        switch (e.getProperty().getName()) {
            case "estatetype": {
                this.EstateTypeChange();
            }
        }
    }

    public void EstateTypeChange() {
        for (String s : cancelMustInput) {
            this.changeInpute(s, false);
        }
        switch (this.getModel().getValue("estatetype").toString()) {
            case "buildInfo": {
                this.changeName("simpleaddress", ResManager.loadKDString((String)"\u5efa\u7b51\u670d\u52a1\u53d1\u751f\u5730", (String)"EstateLeaseFormPlugin_0", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
                this.changeName("detailaddress", ResManager.loadKDString((String)"\u5177\u4f53\u5730\u5740", (String)"EstateLeaseFormPlugin_1", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
                for (String s : BUILD_INFO_MUST_INPUT) {
                    this.changeInpute(s, true);
                }
                break;
            }
            case "estateLeaseInfo": {
                this.changeName("simpleaddress", ResManager.loadKDString((String)"\u4e0d\u52a8\u4ea7\u5730\u5740", (String)"EstateLeaseFormPlugin_2", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
                this.changeName("detailaddress", ResManager.loadKDString((String)"\u4e0d\u52a8\u4ea7\u8be6\u7ec6\u5730\u5740", (String)"EstateLeaseFormPlugin_3", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
                for (String mustInput1 : ESTATE_LEASE_INFO_MUST_INPUT) {
                    this.changeInpute(mustInput1, true);
                }
                break;
            }
            case "estateSaleInfo": {
                this.changeName("simpleaddress", ResManager.loadKDString((String)"\u4e0d\u52a8\u4ea7\u5730\u5740", (String)"EstateLeaseFormPlugin_2", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
                this.changeName("detailaddress", ResManager.loadKDString((String)"\u4e0d\u52a8\u4ea7\u8be6\u7ec6\u5730\u5740", (String)"EstateLeaseFormPlugin_3", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void changeName(String id, String name) {
        FieldEdit control = (FieldEdit)this.getControl(id);
        control.setCaption(new LocaleString(name));
    }

    public void changeInpute(String id, Boolean flag) {
        FieldEdit control = (FieldEdit)this.getControl(id);
        control.setMustInput(flag.booleanValue());
    }
}

