/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.goodsinfoctrlstrategy;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.imc.bdm.common.constant.TaxRate;
import kd.imc.bdm.common.constant.table.GoodsInfoConstant;
import kd.imc.bdm.common.helper.SchemeHelper;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.MaterialInfoUtil;
import kd.imc.bdm.common.util.TaxRateUtil;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.bdm.formplugin.goodsinfoctrlstrategy.contorller.GoodsInfoUintController;

public class GoodsInfoEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
AfterF7SelectListener {
    public static final String ENTRYENTITY = "bdm_goods_info_item";
    public static final String MATERIAL_TYPE = "materialtype";
    public static final String SOURCE_TYPE = "sourcetype";

    public void registerListener(EventObject e) {
        this.addBeforeAndAfterF7SelectListener("taxcode", "material_no", MATERIAL_TYPE, "expenseitem", "baseunit");
    }

    private void addBeforeAndAfterF7SelectListener(String ... keys) {
        for (String key : keys) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl(key);
            if (null == basedataEdit) continue;
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            basedataEdit.addAfterF7SelectListener((AfterF7SelectListener)this);
        }
    }

    public void beforeBindData(EventObject e) {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtercontrol");
        List fieldKeys = SchemeHelper.getFieldKeys();
        fieldKeys.remove("materialtype.name");
        SchemeHelper.initializeFilterGrid((FilterGrid)filterGrid, (List)fieldKeys, (String)"sim_original_bill");
    }

    public void afterBindData(EventObject e) {
        ViewUtil.setFilterGrid((IFormView)this.getView());
        DynamicObject goodsInfo = this.getModel().getDataEntity();
        this.setRate(goodsInfo.getDynamicObject("taxcode"), goodsInfo.get("privilegetype") + "");
        this.getModel().setDataChanged(false);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        ViewUtil.beforeSaveFilterTag((IFormView)this.getView(), (BeforeDoOperationEventArgs)args);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        ArrayList list = Lists.newArrayList();
        if ("taxcode".equals(key)) {
            this.openErTaxClassCode(list, evt);
        }
        if ("baseunit".equals(key)) {
            this.openErBaseUnit(list, evt);
        }
    }

    private void openErTaxClassCode(List<QFilter> list, BeforeF7SelectEvent evt) {
        QFilter qFilter = new QFilter("sumitem", "=", (Object)"0");
        list.add(qFilter);
        evt.setCustomQFilters(list);
    }

    private void openErBaseUnit(List<QFilter> list, BeforeF7SelectEvent evt) {
        DynamicObject[] units;
        int selectRow = this.getSelectRows()[0];
        IDataModel model = this.getModel();
        String sourceType = (String)model.getValue(SOURCE_TYPE, selectRow);
        if (!GoodsInfoConstant.SourceTypeEnum.MATERIAL.getCode().equals(sourceType)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8ba1\u91cf\u5355\u4f4d\u4ec5\u63d0\u4f9b\u7269\u6599\u4f7f\u7528", (String)"GoodsInfoEditPlugin_12", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        DynamicObject material = (DynamicObject)model.getValue("material_no", selectRow);
        if (null == material) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7269\u6599\u540e\u64cd\u4f5c", (String)"GoodsInfoEditPlugin_13", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        DynamicObject basisUint = material.getDynamicObject("baseunit");
        if (null == basisUint) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u7269\u6599\u6ca1\u6709\u57fa\u672c\u5355\u4f4d\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c", (String)"GoodsInfoEditPlugin_14", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        ArrayList pks = Lists.newArrayListWithCapacity((int)list.size());
        pks.add(basisUint.getPkValue());
        for (DynamicObject unit : units = MaterialInfoUtil.querySourceUnitByMater((Object)material.getPkValue(), null)) {
            pks.add(unit.getDynamicObject("measureunitid").getPkValue());
        }
        list.add(new QFilter("id", "in", (Object)pks));
        evt.setCustomQFilters(list);
    }

    private int[] getSelectRows() {
        EntryGrid grid = (EntryGrid)this.getControl(ENTRYENTITY);
        return grid.getSelectRows();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        switch (e.getProperty().getName()) {
            case "taxcode": {
                DynamicObject obj = (DynamicObject)e.getChangeSet()[0].getNewValue();
                if (StringUtils.isBlank((Object)obj)) {
                    return;
                }
                this.getModel().setValue("privilegeflag", (Object)"0");
                this.getModel().setValue("privilegetype", (Object)"");
                this.getView().setEnable(Boolean.FALSE, new String[]{"privilegetype"});
                if (StringUtils.isNotBlank((CharSequence)obj.getString("taxrate"))) {
                    this.getModel().setValue("taxrate", (Object)obj.getBigDecimal("taxrate").stripTrailingZeros());
                }
                if (!Arrays.asList(GoodsInfoConstant.getProductOilTaxCode()).contains(obj.getString("number"))) break;
                String unit = (String)this.getModel().getValue("unit");
                this.isOil(unit);
                break;
            }
            case "privilegeflag": {
                String flag = (String)e.getChangeSet()[0].getNewValue();
                if (flag.equals("0")) {
                    this.getModel().setValue("privilegetype", (Object)"");
                    Object taxRateCode = this.getModel().getValue("taxcode");
                    if (null != taxRateCode) {
                        DynamicObject taxRateObj = (DynamicObject)taxRateCode;
                        String taxRateStr = taxRateObj.getBigDecimal("taxrate").stripTrailingZeros().toPlainString();
                        if ("0.1".equals(taxRateStr)) {
                            taxRateStr = TaxRate.TEN_PERCENT.getRateValue();
                        }
                        this.getModel().setValue("taxrate", (Object)taxRateStr);
                    }
                    this.getView().setEnable(Boolean.FALSE, new String[]{"privilegetype"});
                    return;
                }
                this.setPrivilegeType(flag);
                break;
            }
            case "taxrate": {
                String rate1 = (String)e.getChangeSet()[0].getNewValue();
                if (StringUtils.isEmpty((CharSequence)rate1)) {
                    return;
                }
                String tipMsg = ResManager.loadKDString((String)"\u666e\u901a\u96f6\u7a0e\u7387", (String)"GoodsEditPlugin_0", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
                if (BigDecimal.ZERO.compareTo(new BigDecimal(rate1)) == 0) {
                    if (!"0".equals(this.getModel().getValue("privilegeflag"))) break;
                    this.getModel().setValue("privilegetype", (Object)tipMsg);
                    this.getView().setEnable(Boolean.FALSE, new String[]{"privilegetype"});
                    break;
                }
                if (!tipMsg.equals(this.getModel().getValue("privilegetype"))) break;
                this.getModel().setValue("privilegetype", (Object)"");
                break;
            }
            case "privilegetype": {
                this.setRate((DynamicObject)this.getModel().getValue("taxcode"), e.getChangeSet()[0].getNewValue() + "");
                break;
            }
            case "material_no": {
                this.setItemViewByRestoreData(e.getChangeSet()[0]);
                break;
            }
            case "sourcetype": {
                this.clearRelateField(e.getChangeSet()[0]);
                break;
            }
        }
    }

    private void setRate(DynamicObject taxcode, String privilegeType) {
        if (taxcode == null) {
            return;
        }
        Set taxRateSet = TaxRateUtil.setRate((String)privilegeType);
        BigDecimal taxCodeRate = taxcode.getBigDecimal("taxrate");
        String tipMsg = ResManager.loadKDString((String)"\u666e\u901a\u96f6\u7a0e\u7387", (String)"GoodsEditPlugin_0", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
        String tipMsg2 = ResManager.loadKDString((String)"\u514d\u7a0e", (String)"GoodsEditPlugin_1", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
        String tipMsg3 = ResManager.loadKDString((String)"\u4e0d\u5f81\u7a0e", (String)"GoodsEditPlugin_2", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
        if (!(taxCodeRate == null || privilegeType.equals(tipMsg2) || privilegeType.equals(tipMsg3) || privilegeType.equals(tipMsg) || taxCodeRate.compareTo(BigDecimal.ZERO) == 0)) {
            taxRateSet.add(TaxRateUtil.convertPercentTaxRate((String)taxCodeRate.stripTrailingZeros().toPlainString()));
        }
        List<String> list = taxRateSet.stream().filter(StringUtils::isNotBlank).sorted(Comparator.comparing(s -> Double.parseDouble(s.substring(0, s.length() - 1)))).collect(Collectors.toList());
        ArrayList items = new ArrayList(list.size());
        list.forEach(o -> items.add(new ComboItem(new LocaleString(TaxRateUtil.convertPercentTaxRate((String)o)), TaxRateUtil.percent2Point((String)o))));
        ComboEdit comboEdit = (ComboEdit)this.getControl("taxrate");
        comboEdit.setComboItems(items);
        this.setTaxRateValueByPrivilegetype(privilegeType);
        String tipMsg4 = ResManager.loadKDString((String)"\u7b80\u6613\u5f81\u6536", (String)"GoodsEditPlugin_3", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
        if (String.valueOf(this.getModel().getValue("privilegetype")).contains(tipMsg4)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"taxrate"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"taxrate"});
        }
    }

    protected void isOil(String unit) {
        if (!Arrays.asList(GoodsInfoConstant.getOilUnit()).contains(unit)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\"\u5355\u4f4d\"\u3002\u6210\u54c1\u6cb9\u53ea\u80fd\u4f7f\u7528\u201c\u5428\u201d\u6216\u201c\u5347\u201d\u4e3a\u5355\u4f4d\uff01", (String)"GoodsInfoEditPlugin_19", (String)"imc-bdm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
        }
    }

    private boolean setTaxRateValueByPrivilegetype(String s) {
        String tipMsg = ResManager.loadKDString((String)"\u7b80\u6613\u5f81\u6536", (String)"GoodsEditPlugin_3", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
        String tipMsg2 = ResManager.loadKDString((String)"\u7b80\u6613\u5f81\u6536\u51cf\u6309", (String)"GoodsEditPlugin_4", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
        String tipMsg3 = ResManager.loadKDString((String)"\u6309", (String)"GoodsEditPlugin_5", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
        String tipMsg4 = ResManager.loadKDString((String)"%\u7b80\u6613\u5f81\u6536", (String)"GoodsEditPlugin_6", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
        if (s.contains(tipMsg)) {
            this.getModel().setValue("privilegetype", (Object)s);
            if (s.contains(tipMsg2)) {
                s = "1.5";
            } else {
                s = s.replace(tipMsg3, "");
                s = s.replace(tipMsg4, "");
            }
            if (BigDecimalUtil.isNumber((String)s)) {
                String rateValue = new BigDecimal(s).divide(new BigDecimal("100")).toPlainString();
                this.getModel().setValue("taxrate", (Object)rateValue);
            }
            return true;
        }
        String tipMsg5 = ResManager.loadKDString((String)"\u514d\u7a0e", (String)"GoodsEditPlugin_1", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
        String tipMsg6 = ResManager.loadKDString((String)"\u4e0d\u5f81\u7a0e", (String)"GoodsEditPlugin_2", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
        if (tipMsg5.equals(s) || tipMsg6.equals(s)) {
            this.getModel().setValue("taxrate", (Object)"0");
        }
        return false;
    }

    private void setPrivilegeType(String privilegeFlag) {
        if ("1".equals(privilegeFlag)) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"privilegetype"});
        } else {
            String taxRate = (String)this.getModel().getValue("taxrate");
            if (StringUtils.isNotBlank((CharSequence)taxRate) && BigDecimal.ZERO.compareTo(new BigDecimal(taxRate)) == 0) {
                ComboEdit comboEdit = (ComboEdit)this.getControl("privilegetype");
                String tipMsg = ResManager.loadKDString((String)"\u666e\u901a\u96f6\u7a0e\u7387", (String)"GoodsEditPlugin_0", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
                comboEdit.setComboItems(Collections.singletonList(new ComboItem(new LocaleString(tipMsg), tipMsg)));
                this.getModel().setValue("privilegetype", (Object)tipMsg);
            } else {
                this.getModel().setValue("privilegetype", (Object)"");
            }
            this.getView().setEnable(Boolean.FALSE, new String[]{"privilegetype"});
        }
    }

    private void setJAJZ(String zzstsgl) {
        String tipMsg = ResManager.loadKDString((String)"\u7b80\u6613\u5f81\u6536", (String)"GoodsEditPlugin_3", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
        if (StringUtils.isNotBlank((CharSequence)zzstsgl) && zzstsgl.contains(tipMsg)) {
            String[] arr;
            for (String s : arr = zzstsgl.split("\u3001")) {
                if (this.setTaxRateValueByPrivilegetype(s)) break;
            }
        }
    }

    public void afterF7Select(AfterF7SelectEvent event) {
        if ("baseunit".equals(((Control)event.getSource()).getKey())) {
            GoodsInfoUintController.setSelectBasisUint(this, event, this.getSelectRows()[0]);
        }
    }

    private void setItemViewByRestoreData(ChangeData changeData) {
        DynamicObject material = (DynamicObject)changeData.getNewValue();
        int rowIndex = changeData.getRowIndex();
        IDataModel model = this.getModel();
        if (material == null) {
            model.setValue("material_name", (Object)"", rowIndex);
            model.setValue("material_modelnum", (Object)"", rowIndex);
            model.setValue("baseunit", null, rowIndex);
            model.setValue("modelnum_rate", (Object)"", rowIndex);
            return;
        }
        model.setValue("material_name", (Object)material.getString("name"), rowIndex);
        model.setValue("material_modelnum", (Object)material.getString("modelnum"), rowIndex);
        model.setValue(SOURCE_TYPE, (Object)"0", rowIndex);
        model.setValue("baseunit", material.get("baseunit"), rowIndex);
        model.setValue("modelnum_rate", (Object)"1", rowIndex);
        DynamicObjectCollection items = this.getModel().getEntryEntity(ENTRYENTITY);
        if (items.getRowCount() == 1) {
            OrmLocaleValue goodsName = (OrmLocaleValue)this.getModel().getValue("name");
            if (goodsName == null || StringUtils.isBlank((CharSequence)goodsName.toString())) {
                model.setValue("name", (Object)material.getString("name"));
            }
            model.setValue("specifications", (Object)material.getString("modelnum"));
            model.setValue("unit", (Object)material.getString("baseunit.name"));
        }
    }

    private void clearRelateField(ChangeData changeData) {
        String sourceType = (String)changeData.getNewValue();
        IDataModel model = this.getModel();
        if (GoodsInfoConstant.SourceTypeEnum.MATERIAL.getCode().equals(sourceType)) {
            model.setValue("material_name", (Object)"");
            model.setValue("modelnum_code", (Object)"");
            model.setValue("modelnum_unit", (Object)"");
            model.setValue("modelnum_rate", (Object)"");
        }
    }
}

