/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.goodsinfoctrlstrategy.op.validator;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.imc.bdm.common.util.GoodsUtil;
import kd.imc.bdm.common.util.TaxRateUtil;

public class GoodsInfoFormValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.dataEntities) {
            DynamicObject goodsInfo = dataEntity.getDataEntity();
            try {
                this.checkBill(goodsInfo);
            }
            catch (KDBizException e) {
                this.addErrorMessage(dataEntity, e.getMessage());
            }
        }
    }

    private void checkBill(DynamicObject goodsInfo) {
        String privilegeFlag = goodsInfo.getString("privilegeflag");
        String privilegeType = goodsInfo.getString("privilegetype");
        if ("1".equals(privilegeFlag)) {
            if (StringUtils.isBlank((CharSequence)privilegeType)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\"\u4f18\u60e0\u653f\u7b56\u5185\u5bb9\"\u3002\u4eab\u53d7\u4f18\u60e0\u653f\u7b56\u65f6\u4f18\u60e0\u653f\u7b56\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"GoodsInfoFormValidator_1", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            }
            String msg = TaxRateUtil.checkPrivilegeType((String)"", (String)privilegeType, (String)goodsInfo.getString("taxrate"));
            if (null != msg) {
                throw new KDBizException(msg);
            }
        }
        this.calculatePrices(goodsInfo);
    }

    private void calculatePrices(DynamicObject goodsInfo) {
        BigDecimal price = goodsInfo.getBigDecimal("price");
        String taxRate = goodsInfo.getString("taxrate");
        boolean istaxinclusive = goodsInfo.getBoolean("isinclusive");
        goodsInfo.set("prices", (Object)GoodsUtil.calcPrices((BigDecimal)price, (String)taxRate, (boolean)istaxinclusive));
    }
}

