/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.goodsinfoctrlstrategy.op.validator;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.table.GoodsInfoConstant;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.formplugin.goodsinfo.message.GoodsInfoItemMessage;

public class GoodsInfoItemValidator
extends AbstractValidator {
    private static final Log LOGGER = LogFactory.getLog(GoodsInfoItemValidator.class);

    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.dataEntities) {
            DynamicObject goodsInfo = dataEntity.getDataEntity();
            try {
                this.checkItems(goodsInfo);
            }
            catch (KDBizException e) {
                this.addErrorMessage(dataEntity, e.getMessage());
            }
        }
    }

    private void checkItems(DynamicObject goodsInfo) {
        DynamicObjectCollection items = goodsInfo.getDynamicObjectCollection("bdm_goods_info_item");
        if (CollectionUtils.isEmpty((Collection)items)) {
            return;
        }
        this.checkRestoreRow((List<DynamicObject>)items);
        long id = goodsInfo.getLong("id");
        Long priority = goodsInfo.getLong("priority");
        int loopTime = items.size() / 200 + (items.size() % 200 > 0 ? 1 : 0);
        for (int i = 0; i < loopTime; ++i) {
            ArrayList messageList = Lists.newArrayListWithExpectedSize((int)items.size());
            QFilter itemFilter = this.getItemFilterAndSetMessages((List<DynamicObject>)items, messageList, i);
            QFilter filter = new QFilter("org", "=", (Object)DynamicObjectUtil.getDynamicObjectLongValue((Object)goodsInfo.get("org")));
            filter.and("priority", "=", (Object)priority);
            if (id != 0L) {
                filter.and("id", "!=", (Object)id);
            }
            filter.and(itemFilter);
            String selectProperties = "id,bdm_goods_info_item.sourcetype,bdm_goods_info_item.material_name,bdm_goods_info_item.materialtype,bdm_goods_info_item.material_no,bdm_goods_info_item.material_modelnum,bdm_goods_info_item.modelnum_code,expenseitem";
            DynamicObject[] infos = BusinessDataServiceHelper.load((String)"bdm_goods_info", (String)selectProperties, (QFilter[])filter.toArray());
            if (infos.length <= 0) continue;
            this.showErrorTip(messageList, infos);
        }
    }

    private void showErrorTip(List<GoodsInfoItemMessage> messageList, DynamicObject[] infos) {
        HashSet messageSet = Sets.newHashSet();
        StringBuilder sb = new StringBuilder();
        for (DynamicObject info : infos) {
            DynamicObjectCollection infoItems = info.getDynamicObjectCollection("bdm_goods_info_item");
            for (DynamicObject infoItem : infoItems) {
                if ("0".equals(infoItem.getString("sourcetype")) || StringUtils.isBlank((CharSequence)infoItem.getString("sourcetype"))) {
                    messageSet.add(new GoodsInfoItemMessage(infoItem.getString("sourcetype"), infoItem.getString("material_name"), infoItem.getString("material_modelnum")));
                    continue;
                }
                if ("1".equals(infoItem.getString("sourcetype"))) {
                    messageSet.add(new GoodsInfoItemMessage(infoItem.getString("sourcetype"), infoItem.getDynamicObject("materialtype").getString("name")));
                    continue;
                }
                if ("2".equals(infoItem.getString("sourcetype"))) {
                    messageSet.add(new GoodsInfoItemMessage(infoItem.getString("sourcetype"), infoItem.getString("material_name"), infoItem.getString("material_modelnum")));
                    String modelCode = infoItem.getString("modelnum_code");
                    if (!StringUtils.isNotBlank((CharSequence)modelCode)) continue;
                    messageSet.add(new GoodsInfoItemMessage(infoItem.getString("sourcetype"), "", "", modelCode));
                    continue;
                }
                if (!"5".equals(infoItem.getString("sourcetype"))) continue;
                messageSet.add(new GoodsInfoItemMessage(infoItem.getString("sourcetype"), infoItem.getString("expenseitem".concat(".name"))));
            }
        }
        for (int i = 0; i < messageList.size(); ++i) {
            String tipMsg;
            GoodsInfoItemMessage message = messageList.get(i);
            String name = message.getName();
            String type = GoodsInfoConstant.SourceTypeEnum.getValueByCode((String)message.getSourceType()).getValue();
            String modelUnit = message.getModelUnit();
            String modelCode = message.getModelCode();
            if (!messageSet.contains(message)) continue;
            if (StringUtils.isNotBlank((CharSequence)modelCode)) {
                tipMsg = ResManager.loadKDString((String)"\u5546\u54c1\u7f16\u7801:", (String)"GoodsInfoItemValidator_13", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
                sb.append(tipMsg).append(modelCode);
            } else {
                sb.append(type).append(':').append(name);
            }
            if (StringUtils.isNotBlank((CharSequence)modelUnit)) {
                tipMsg = String.format(ResManager.loadKDString((String)"%1$s\u89c4\u683c\u578b\u53f7:%2$s", (String)"GoodsInfoItemValidator_14", (String)"imc-bdm-formplugin", (Object[])new Object[0]), ",", modelUnit);
                sb.append(tipMsg);
            }
            if (i < messageList.size() - 1) {
                sb.append('\uff0c');
            }
            LOGGER.info(message.toString());
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\"%s\"\u4f18\u5148\u7ea7\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u63d0\u4ea4\u3002", (String)"GoodsInfoItemValidator_3", (String)"imc-bdm-formplugin", (Object[])new Object[0]), sb));
    }

    private void checkRestoreRow(List<DynamicObject> items) {
        HashSet messagesSet = Sets.newHashSetWithExpectedSize((int)items.size());
        for (DynamicObject item : items) {
            GoodsInfoConstant.SourceTypeEnum sourceType = GoodsInfoConstant.SourceTypeEnum.getValueByCode((String)item.getString("sourcetype"));
            String modelnumRate = item.getString("modelnum_rate");
            if (StringUtils.isNotBlank((CharSequence)modelnumRate)) {
                try {
                    BigDecimal bigDecimal = new BigDecimal(modelnumRate);
                    if (BigDecimalUtil.lessZero((BigDecimal)bigDecimal)) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u5355\u4f4d\u8f6c\u6362\u7387\uff1a\u53ea\u586b\u586b\u5199\u6b63\u6570\u6570\u5b57", (String)"GoodsInfoItemValidator_4", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
                    }
                }
                catch (Exception e) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5355\u4f4d\u8f6c\u6362\u7387\uff1a\u53ea\u586b\u586b\u5199\u6b63\u6570\u6570\u5b57", (String)"GoodsInfoItemValidator_4", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
                }
            }
            switch (sourceType) {
                case MATERIAL: {
                    break;
                }
                case MATERIAL_TYPE: {
                    String materialTypeName = item.getString("materialtype".concat(".name")) + ":" + item.getString("materialtype".concat(".number"));
                    GoodsInfoItemMessage message = new GoodsInfoItemMessage(item.getString("sourcetype"), materialTypeName);
                    if (messagesSet.contains(message)) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7269\u6599\u5206\u7c7b:%s \u5df2\u91cd\u590d", (String)"GoodsInfoItemValidator_5", (String)"imc-bdm-formplugin", (Object[])new Object[0]), message.getName()));
                    }
                    messagesSet.add(message);
                    break;
                }
                case GOODS_NAME: {
                    GoodsInfoItemMessage message = new GoodsInfoItemMessage(item.getString("sourcetype"), item.getString("material_name"), item.getString("material_modelnum"));
                    if (messagesSet.contains(message)) {
                        StringBuilder tip = new StringBuilder(ResManager.loadKDString((String)"\u5546\u54c1\u540d\u79f0:", (String)"GoodsInfoItemValidator_6", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
                        tip.append(message.getName());
                        this.appendModelUnit(message.getModelUnit(), tip);
                        tip.append(ResManager.loadKDString((String)" \u5df2\u91cd\u590d", (String)"GoodsInfoItemValidator_7", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
                        throw new KDBizException(tip.toString());
                    }
                    messagesSet.add(message);
                    String modelnumCode = item.getString("modelnum_code");
                    if (!StringUtils.isNotBlank((CharSequence)modelnumCode)) break;
                    message = new GoodsInfoItemMessage(item.getString("sourcetype"), "", "", modelnumCode);
                    if (messagesSet.contains(message)) {
                        StringBuilder tip = new StringBuilder(ResManager.loadKDString((String)"\u5546\u54c1\u7f16\u7801:", (String)"GoodsInfoItemValidator_1", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
                        tip.append(message.getModelCode());
                        tip.append(ResManager.loadKDString((String)" \u5df2\u91cd\u590d", (String)"GoodsInfoItemValidator_7", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
                        throw new KDBizException(tip.toString());
                    }
                    messagesSet.add(message);
                    break;
                }
                case EXPENSE_ITEM: {
                    String name = item.getString("expenseitem".concat(".number")) + "_" + item.getString("expenseitem".concat(".name"));
                    GoodsInfoItemMessage message = new GoodsInfoItemMessage(item.getString("sourcetype"), name);
                    if (messagesSet.contains(message)) {
                        StringBuilder tip = new StringBuilder(ResManager.loadKDString((String)"\u8d39\u7528\u9879\u76ee:", (String)"GoodsInfoItemValidator_8", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
                        tip.append(message.getName());
                        tip.append(ResManager.loadKDString((String)" \u5df2\u91cd\u590d", (String)"GoodsInfoItemValidator_7", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
                        throw new KDBizException(tip.toString());
                    }
                    messagesSet.add(message);
                }
            }
        }
    }

    private void appendModelUnit(String modelUnit, StringBuilder tip) {
        if (StringUtils.isNotBlank((CharSequence)modelUnit)) {
            tip.append(",").append(ResManager.loadKDString((String)"\u89c4\u683c\u578b\u53f7:", (String)"GoodsInfoItemValidator_2", (String)"imc-bdm-formplugin", (Object[])new Object[0])).append(modelUnit);
        }
    }

    private QFilter getItemFilterAndSetMessages(List<DynamicObject> items, List<GoodsInfoItemMessage> messageList, int seq) {
        ArrayList materialTypePks = Lists.newArrayListWithCapacity((int)items.size());
        QFilter materialFilter = null;
        QFilter goodsNameFilter = null;
        QFilter modelCodeFilter = null;
        QFilter expenseFilter = null;
        QFilter itemFilter = new QFilter("id", "=", null);
        int start = 200 * seq;
        int count = 0;
        block6: for (int i = start; i < items.size(); ++i) {
            DynamicObject item = items.get(i);
            if (count >= 200) {
                LOGGER.info("getItemFilterAndSetMessages:" + seq);
                break;
            }
            ++count;
            String sourceTypeCode = item.getString("sourcetype");
            GoodsInfoConstant.SourceTypeEnum sourceTypeEnum = GoodsInfoConstant.SourceTypeEnum.getValueByCode((String)sourceTypeCode);
            switch (sourceTypeEnum) {
                case MATERIAL: {
                    if (StringUtils.isBlank((Object)item.get("material_no"))) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u6765\u6e90\u7c7b\u578b\u4e3a\"\u7269\u6599\"\u65f6\uff0c\u7269\u6599\u4e0d\u80fd\u4e3a\u7a7a", (String)"GoodsInfoItemValidator_9", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
                    }
                    materialFilter = this.getMaterialFilter(materialFilter, item);
                    messageList.add(new GoodsInfoItemMessage(item.getString("sourcetype"), item.getString("material_name"), item.getString("material_modelnum")));
                    continue block6;
                }
                case MATERIAL_TYPE: {
                    if (Objects.isNull(item.get("materialtype")) || StringUtils.isBlank((Object)item.get("sourcetype"))) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u6765\u6e90\u7c7b\u578b\u4e3a\"\u7269\u6599\u5206\u7c7b\"\u65f6\u2019\uff0c\u7269\u6599\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a", (String)"GoodsInfoItemValidator_10", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
                    }
                    materialTypePks.add(Long.parseLong(String.valueOf(item.getDynamicObject("materialtype").getPkValue())));
                    messageList.add(new GoodsInfoItemMessage(item.getString("sourcetype"), item.getDynamicObject("materialtype").getString("name")));
                    continue block6;
                }
                case GOODS_NAME: {
                    if (Objects.isNull(item.get("material_name")) || StringUtils.isBlank((Object)item.get("material_name"))) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u6765\u6e90\u7c7b\u578b\u4e3a\"\u5546\u54c1\"\u65f6,\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (String)"GoodsInfoItemValidator_11", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
                    }
                    goodsNameFilter = this.getGoodsNameFilter(goodsNameFilter, item);
                    messageList.add(new GoodsInfoItemMessage(item.getString("sourcetype"), item.getString("material_name"), item.getString("material_modelnum")));
                    if (!StringUtils.isNotBlank((Object)item.get("modelnum_code"))) continue block6;
                    modelCodeFilter = this.getModelCodeFilter(modelCodeFilter, item);
                    messageList.add(new GoodsInfoItemMessage(item.getString("sourcetype"), "", "", item.getString("modelnum_code")));
                    continue block6;
                }
                case EXPENSE_ITEM: {
                    if (Objects.isNull(item.get("expenseitem")) || StringUtils.isBlank((Object)item.get("expenseitem"))) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u6765\u6e90\u7c7b\u578b\u4e3a\"\u8d39\u7528\u9879\u76ee\"\u65f6,\u8d39\u7528\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a", (String)"GoodsInfoItemValidator_12", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
                    }
                    expenseFilter = this.getExpenseFilter(expenseFilter, item);
                    messageList.add(new GoodsInfoItemMessage(item.getString("sourcetype"), item.getString("expenseitem".concat(".name"))));
                }
            }
        }
        if (materialFilter != null) {
            itemFilter.or(materialFilter);
        }
        if (!CollectionUtils.isEmpty((Collection)materialTypePks)) {
            QFilter materialTypeFilter = new QFilter("bdm_goods_info_item.materialtype", "in", (Object)materialTypePks);
            itemFilter.or(materialTypeFilter);
        }
        if (null != goodsNameFilter) {
            itemFilter.or(goodsNameFilter);
            if (modelCodeFilter != null) {
                itemFilter.or(modelCodeFilter);
            }
        }
        if (null != expenseFilter) {
            itemFilter.or(expenseFilter);
        }
        return itemFilter;
    }

    private QFilter getMaterialFilter(QFilter materialFilter, DynamicObject item) {
        if (null == materialFilter) {
            materialFilter = new QFilter("bdm_goods_info_item.material_no", "=", (Object)item.getDynamicObject("material_no").getLong("id"));
            materialFilter.and("bdm_goods_info_item.sourcetype", "=", (Object)"0");
            this.setModelNumFilter(item, materialFilter);
        } else {
            QFilter qFilter = new QFilter("bdm_goods_info_item.material_no", "=", (Object)item.getDynamicObject("material_no").getLong("id"));
            qFilter.and("bdm_goods_info_item.sourcetype", "=", (Object)"0");
            this.setModelNumFilter(item, qFilter);
            materialFilter.or(qFilter);
        }
        return materialFilter;
    }

    private QFilter getGoodsNameFilter(QFilter goodsNameFilter, DynamicObject item) {
        if (null == goodsNameFilter) {
            goodsNameFilter = new QFilter("bdm_goods_info_item.material_name", "=", item.get("material_name"));
            goodsNameFilter.and("bdm_goods_info_item.sourcetype", "=", (Object)"2");
            this.setModelNumFilter(item, goodsNameFilter);
        } else {
            QFilter qFilter = new QFilter("bdm_goods_info_item.material_name", "=", item.get("material_name"));
            qFilter.and("bdm_goods_info_item.sourcetype", "=", (Object)"2");
            this.setModelNumFilter(item, qFilter);
            goodsNameFilter.or(qFilter);
        }
        return goodsNameFilter;
    }

    private QFilter getModelCodeFilter(QFilter modelCodeFilter, DynamicObject item) {
        if (null == modelCodeFilter) {
            modelCodeFilter = new QFilter("bdm_goods_info_item.modelnum_code", "=", item.get("modelnum_code"));
            modelCodeFilter.and("bdm_goods_info_item.sourcetype", "=", (Object)"2");
            this.setModelNumFilter(item, modelCodeFilter);
        } else {
            QFilter qFilter = new QFilter("bdm_goods_info_item.modelnum_code", "=", item.get("modelnum_code"));
            qFilter.and("bdm_goods_info_item.sourcetype", "=", (Object)"2");
            this.setModelNumFilter(item, qFilter);
            modelCodeFilter.or(qFilter);
        }
        return modelCodeFilter;
    }

    private QFilter getExpenseFilter(QFilter expenseFilter, DynamicObject item) {
        if (null == expenseFilter) {
            expenseFilter = new QFilter("bdm_goods_info_item.expenseitem", "=", (Object)item.getDynamicObject("expenseitem").getLong("id"));
            expenseFilter.and("bdm_goods_info_item.sourcetype", "=", (Object)"5");
        } else {
            QFilter qFilter = new QFilter("bdm_goods_info_item.expenseitem", "=", (Object)item.getDynamicObject("expenseitem").getLong("id"));
            qFilter.and("bdm_goods_info_item.sourcetype", "=", (Object)"5");
            expenseFilter.or(qFilter);
        }
        return expenseFilter;
    }

    private void setModelNumFilter(DynamicObject item, QFilter qFilter) {
        String modelNum = item.getString("material_modelnum");
        if (StringUtils.isNotBlank((CharSequence)modelNum)) {
            qFilter.and("bdm_goods_info_item.material_modelnum", "=", (Object)modelNum);
        }
    }
}

