/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.issuesetting;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.constant.ImcPermItemEnum;
import kd.imc.bdm.common.helper.PermissionHelper;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.ViewUtil;

public class AddQrcodePlugin
extends AbstractFormPlugin
implements AfterF7SelectListener,
BeforeF7SelectListener {
    private static final String QRCODESTATUS_TRUE = "1";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
        BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl("orgnumber");
        basedataEdit.addAfterF7SelectListener((AfterF7SelectListener)this);
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams != null && customParams.containsKey("tableName")) {
            this.initAddQrCodeViewMethod(customParams);
        }
    }

    private void initAddQrCodeViewMethod(Map<String, Object> customParams) {
        DynamicObject staticQrCodeObject;
        Long pkId = (Long)customParams.get("pkId");
        if (StringUtils.isNotBlank((Object)pkId) && (staticQrCodeObject = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"bdm_static_qrcode_setting")) != null) {
            DynamicObject orgObject = staticQrCodeObject.getDynamicObject("org");
            this.getModel().setValue("orgnumber", (Object)orgObject);
            this.getView().setEnable(Boolean.FALSE, new String[]{"orgnumber"});
            if (orgObject != null) {
                this.getModel().setValue("orgname", (Object)orgObject.getString("name"));
                this.getView().setEnable(Boolean.FALSE, new String[]{"orgname"});
                this.getModel().setValue("orgid", (Object)orgObject.getLong("id"));
            }
            this.getModel().setValue("eptaxno", (Object)staticQrCodeObject.getString("taxno"));
            this.getView().setEnable(Boolean.FALSE, new String[]{"eptaxno"});
            DynamicObject epInfoObject = staticQrCodeObject.getDynamicObject("epinfo");
            if (epInfoObject != null) {
                this.getModel().setValue("epname", (Object)epInfoObject.getString("name"));
                this.getView().setEnable(Boolean.FALSE, new String[]{"epname"});
            }
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("btnok".equals(key)) {
            PermissionHelper.checkPermission((String)"bdm", (String)"bdm_business_setting", (ImcPermItemEnum)ImcPermItemEnum.CREATE_QRCODE);
            Object orgid = this.getView().getModel().getValue("orgid");
            if (StringUtils.isBlank((Object)orgid)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u751f\u6210\u4e8c\u7ef4\u7801\u7684\u90e8\u95e8", (String)"AddQrcodePlugin_0", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
                return;
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            if (customParams != null && customParams.containsKey("tableName")) {
                map.put("orgName", this.getModel().getValue("orgname"));
                map.put("epName", this.getModel().getValue("epname"));
                map.put("rowIndex", QRCODESTATUS_TRUE);
                DynamicObject orgObject = (DynamicObject)this.getModel().getValue("orgnumber");
                if (orgObject == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u751f\u6210\u4e8c\u7ef4\u7801\u7684\u90e8\u95e8", (String)"AddQrcodePlugin_0", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
                    return;
                }
                map.put("orgNumber", orgObject.getString("number"));
                map.put("tableName", customParams.get("tableName"));
                map.put("pkId", customParams.get("pkId"));
                Long pkId = (Long)customParams.get("pkId");
                DynamicObject staticQrCodeObject = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"bdm_static_qrcode_setting");
                staticQrCodeObject.set("qrcodestatus", (Object)QRCODESTATUS_TRUE);
                SaveServiceHelper.update((DynamicObject)staticQrCodeObject);
            } else {
                DynamicObject org = BusinessDataServiceHelper.loadSingle((Object)orgid, (String)"bdm_org");
                String orgName = org.getString("name");
                String epName = org.getString("epinfo.name");
                String number = org.getString("number");
                if (null == epName) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u7ed9\u9009\u4e2d\u7ec4\u7ec7\u7ed1\u5b9a\u4f01\u4e1a\u4fe1\u606f\uff0c\u518d\u521b\u5efa\u4e8c\u7ef4\u7801", (String)"AddQrcodePlugin_1", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
                }
                map.put("orgName", orgName);
                map.put("epName", epName);
                map.put("rowIndex", QRCODESTATUS_TRUE);
                map.put("orgNumber", number);
                org.set("qrcodestatus", (Object)QRCODESTATUS_TRUE);
                SaveServiceHelper.update((DynamicObject)org);
            }
            ViewUtil.openDialog((AbstractFormPlugin)this, null, map, (String)"bdm_createqrcode", (String)"bdm_createqrcode");
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId = e.getActionId();
        if ("bdm_createqrcode".equals(actionId)) {
            this.getView().returnDataToParent((Object)actionId);
            this.getView().close();
        }
    }

    public void afterF7Select(AfterF7SelectEvent afterF7SelectEvent) {
        QFilter orgFilter = new QFilter("id", "in", afterF7SelectEvent.getListSelectedRow().getPrimaryKeyValue());
        DynamicObject org = BusinessDataServiceHelper.loadSingle((String)"bdm_org", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_org"), (QFilter[])orgFilter.toArray());
        if (org != null) {
            this.getView().getModel().setValue("orgid", org.getPkValue());
            this.getView().getModel().setValue("orgname", (Object)org.getString("name"));
            DynamicObject epinfo = org.getDynamicObject("epinfo");
            if (epinfo != null) {
                this.getView().getModel().setValue("eptaxno", (Object)epinfo.getString("number"));
                this.getView().getModel().setValue("epname", (Object)epinfo.getString("name"));
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        Control source = (Control)evt.getSource();
        if ("orgnumber".equals(source.getKey())) {
            ArrayList list = Lists.newArrayList();
            list.add(new QFilter("epinfo", ">", (Object)0));
            list.add(new QFilter("qrcodestatus", "!=", (Object)QRCODESTATUS_TRUE));
            evt.setCustomQFilters((List)list);
        }
    }
}

