/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.issuesetting;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.imc.bdm.common.constant.ImcPermItemEnum;
import kd.imc.bdm.common.helper.ImcBaseDataHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.OrgHelper;
import kd.imc.bdm.common.helper.PermissionHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.model.MsgResponse;
import kd.imc.bdm.common.message.send.SendMsg2Imac;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.bdm.formplugin.issuesetting.scan.ScanQrkeyVo;
import org.apache.commons.lang3.RandomStringUtils;

public class DynamicQRCodeSettingPlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final String BUTTON_SCANVOICE_SETTING_SAVE = "gsave";
    private static final String BUTTON_SCANVOICE_SETTING_SAVE2 = "gsave2";
    private static final String BUTTON_SYNC_TO_ISMC = "synctoimac";
    private static final String INVSM_GOODSINFO_SETTING = "invsm_goodsinfo_setting";
    private static final String INVSM_GOODSINFO_SETTING2 = "invsm_goodsinfo_setting2";

    public void preOpenForm(PreOpenFormEventArgs e) {
        OrgHelper.checkOrgIsImport((PreOpenFormEventArgs)e);
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"goodstool", "goodstool2", "drtool"});
        this.addClickListeners(new String[]{"eqinfono", "goodsname", "systemcode"});
    }

    public void afterCreateNewData(EventObject e) {
        String taxNo = TaxUtils.getCurrentOrgTaxNo();
        this.getModel().setValue("taxno", (Object)taxNo);
        this.initDefaultGoodsInfo();
        this.loadBillCenterConfig();
    }

    private void initDefaultGoodsInfo() {
        QFilter filter = new QFilter("eqinfotaxno", "=", this.getModel().getValue("taxno"));
        DynamicObjectCollection qrKeyList = QueryServiceHelper.query((String)"bdm_scaninvoice_setting", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_scaninvoice_setting"), (QFilter[])filter.toArray());
        if (CollectionUtils.isEmpty((Collection)qrKeyList)) {
            return;
        }
        this.getModel().batchCreateNewEntryRow(INVSM_GOODSINFO_SETTING, qrKeyList.size());
        for (int i = 0; i < qrKeyList.size(); ++i) {
            this.setCheckBoxEnable(((DynamicObject)qrKeyList.get(i)).getString("phonedisplayflag"), i, "phonerequiredflag");
            this.setCheckBoxEnable(((DynamicObject)qrKeyList.get(i)).getString("emaildisplayflag"), i, "emailrequiredflag");
            this.setInputEnable(((DynamicObject)qrKeyList.get(i)).getString("remarkdisplayflag"), i, "remarktips");
            this.setModelValue((DynamicObject)qrKeyList.get(i), i, "number", "invoicetype", "eqinfono", "eqinfotaxno", "goodsname", "goodscode", "price", "taxrate", "defaultgoods", "scantype", "qrcodevalidity", "systemcode", "phonedisplayflag", "phonerequiredflag", "emaildisplayflag", "emailrequiredflag", "remarkdisplayflag", "remarktips", "buyerinfoabled");
        }
    }

    private void loadBillCenterConfig() {
        QFilter filter = new QFilter("scantype", "=", (Object)"2");
        DynamicObjectCollection qrKeyList = QueryServiceHelper.query((String)"bdm_scaninvoice_setting", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_scaninvoice_setting"), (QFilter[])filter.toArray());
        for (DynamicObject obj : qrKeyList) {
            int index = this.getModel().createNewEntryRow(INVSM_GOODSINFO_SETTING2);
            this.getModel().setValue("invoicetype2", (Object)obj.getString("invoicetype"), index);
            this.getModel().setValue("phonedisplayflag2", (Object)obj.getString("phonedisplayflag"), index);
            this.getModel().setValue("phonerequiredflag2", (Object)obj.getString("phonerequiredflag"), index);
            this.getModel().setValue("emaildisplayflag2", (Object)obj.getString("emaildisplayflag"), index);
            this.getModel().setValue("emailrequiredflag2", (Object)obj.getString("emailrequiredflag"), index);
            this.getModel().setValue("remarkdisplayflag2", (Object)obj.getString("remarkdisplayflag"), index);
            this.getModel().setValue("remarktips2", (Object)obj.getString("remarktips"), index);
        }
    }

    private void setModelValue(DynamicObject qrKey, int i, String ... keys) {
        for (String key : keys) {
            this.getModel().setValue(key, qrKey.get(key), i);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey()) {
            case "gsave2": {
                PermissionHelper.checkPermission((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.ITEM_SAVE);
                this.saveBillCenterConfig(true);
                break;
            }
            case "gsave": {
                PermissionHelper.checkPermission((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.ITEM_SAVE);
                this.saveDefaultGoods(true);
                break;
            }
            case "synctoimac": {
                PermissionHelper.checkPermission((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.ITEM_SAVE);
                this.sync2IMAC();
            }
        }
    }

    private void saveBillCenterConfig(boolean isSave) {
        DynamicObjectCollection qrKeyList = this.getModel().getEntryEntity(INVSM_GOODSINFO_SETTING2);
        ArrayList goodsInfo = Lists.newArrayListWithCapacity((int)qrKeyList.size());
        for (int i = 0; i < qrKeyList.size(); ++i) {
            DynamicObject qrKeyDynamicObject = (DynamicObject)qrKeyList.get(i);
            DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"bdm_scaninvoice_setting");
            obj.set("scantype", (Object)"2");
            obj.set("invoicetype", (Object)qrKeyDynamicObject.getString("invoicetype2"));
            obj.set("phonedisplayflag", qrKeyDynamicObject.get("phonedisplayflag2"));
            obj.set("phonerequiredflag", qrKeyDynamicObject.get("phonerequiredflag2"));
            obj.set("emaildisplayflag", qrKeyDynamicObject.get("emaildisplayflag2"));
            obj.set("emailrequiredflag", qrKeyDynamicObject.get("emailrequiredflag2"));
            obj.set("remarkdisplayflag", qrKeyDynamicObject.get("remarkdisplayflag2"));
            obj.set("remarktips", qrKeyDynamicObject.get("remarktips2"));
            obj.set("updatedate", (Object)new Date());
            obj.set("extendflag", (Object)Boolean.TRUE);
            goodsInfo.add(obj);
        }
        QFilter filter = new QFilter("scantype", "=", (Object)"2");
        DeleteServiceHelper.delete((String)"bdm_scaninvoice_setting", (QFilter[])filter.toArray());
        if (qrKeyList.size() > 0) {
            ImcSaveServiceHelper.save((List)goodsInfo);
        }
        this.getView().invokeOperation("refresh");
        if (isSave) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u626b\u7801\u5f00\u7968\u9879\u6210\u529f\uff01", (String)"DynamicQRCodeSettingPlugin_1", (String)"imc-bdm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
        }
    }

    private void sync2IMAC() {
        DynamicObjectCollection qrKeyList = this.getModel().getEntryEntity(INVSM_GOODSINFO_SETTING);
        if (qrKeyList.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u4f53\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5148\u65b0\u589e\u4e00\u6761\u5206\u5f55", (String)"DynamicQRCodeSettingPlugin_0", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.saveDefaultGoods(false);
        JSONArray jsonArray = new JSONArray();
        for (int i = 0; i < qrKeyList.size(); ++i) {
            this.checkItems(i, (DynamicObject)qrKeyList.get(i));
            ScanQrkeyVo scanQrkeyVo = (ScanQrkeyVo)DynamicObjectUtil.dynamicObject2Bean(ScanQrkeyVo.class, (DynamicObject)((DynamicObject)qrKeyList.get(i)));
            Object o = JSONObject.toJSON((Object)scanQrkeyVo);
            jsonArray.add(o);
        }
        MsgResponse msgResponse = SendMsg2Imac.syncQrKey((Object)jsonArray);
        if (ErrorType.SUCCESS.getCode().equals(msgResponse.getErrorCode())) {
            this.getView().showSuccessNotification(msgResponse.getErrorMsg());
        } else {
            this.getView().showErrorNotification(msgResponse.getErrorMsg());
        }
    }

    private void saveDefaultGoods(boolean isSave) {
        DynamicObjectCollection qrKeyList = this.getModel().getEntryEntity(INVSM_GOODSINFO_SETTING);
        ArrayList goodsInfo = Lists.newArrayListWithCapacity((int)qrKeyList.size());
        for (int i = 0; i < qrKeyList.size(); ++i) {
            DynamicObject qrKeyDynamicObject = (DynamicObject)qrKeyList.get(i);
            this.checkItems(i, qrKeyDynamicObject);
            DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"bdm_scaninvoice_setting");
            DynamicObjectUtil.copyDynamicObject((DynamicObject)qrKeyDynamicObject, (DynamicObject)obj);
            obj.set("updatedate", (Object)new Date());
            obj.set("extendflag", (Object)Boolean.TRUE);
            goodsInfo.add(obj);
        }
        QFilter filter = new QFilter("eqinfotaxno", "=", this.getModel().getValue("taxno"));
        DeleteServiceHelper.delete((String)"bdm_scaninvoice_setting", (QFilter[])filter.toArray());
        if (qrKeyList.size() > 0) {
            ImcSaveServiceHelper.save((List)goodsInfo);
        }
        this.getView().invokeOperation("refresh");
        if (isSave) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u626b\u7801\u5f00\u7968\u9879\u6210\u529f\uff01", (String)"DynamicQRCodeSettingPlugin_1", (String)"imc-bdm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
        }
    }

    private void checkItems(int i, DynamicObject qrKeyDynamicObject) {
        int index = i + 1;
        String invoiceTypes = qrKeyDynamicObject.getString("invoicetype");
        if (StringUtils.isBlank((CharSequence)invoiceTypes)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\u53d1\u7968\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"DynamicQRCodeSettingPlugin_2", (String)"imc-bdm-formplugin", (Object[])new Object[0]), index));
        }
        if (StringUtils.isBlank((CharSequence)qrKeyDynamicObject.getString("goodsname")) && qrKeyDynamicObject.getBoolean("defaultgoods")) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\u5546\u54c1\u540d\u79f0\u4e3a\u7a7a\u65f6\uff0c\u9ed8\u8ba4\u5f00\u7968\u9879\u4e0d\u53ef\u5f00\u542f\uff01", (String)"DynamicQRCodeSettingPlugin_3", (String)"imc-bdm-formplugin", (Object[])new Object[0]), index));
        }
        if (StringUtils.isBlank((CharSequence)qrKeyDynamicObject.getString("systemcode"))) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\u4e1a\u52a1\u7cfb\u7edf\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"DynamicQRCodeSettingPlugin_4", (String)"imc-bdm-formplugin", (Object[])new Object[0]), index));
        }
        if (!"1".equals(qrKeyDynamicObject.get("scantype"))) {
            return;
        }
        List invoiceArray = Splitter.on((String)",").trimResults().omitEmptyStrings().splitToList((CharSequence)invoiceTypes);
        if (StringUtils.isBlank((CharSequence)qrKeyDynamicObject.getString("eqinfono")) && !InvoiceUtils.getAllEInvoiceType().containsAll(invoiceArray)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\u626b\u7801\u7c7b\u578b\u4e3a\u626b\u7801\u5f00\u7968\u65f6\u4e14\u53d1\u7968\u79cd\u7c7b\u5305\u542b\u975e\u6570\u7535\u7968\u65f6\uff0c\u8bbe\u5907\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"DynamicQRCodeSettingPlugin_5", (String)"imc-bdm-formplugin", (Object[])new Object[0]), index));
        }
        if (!qrKeyDynamicObject.getBoolean("phonedisplayflag") && qrKeyDynamicObject.getBoolean("phonerequiredflag")) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\u624b\u673a\u53f7\u7801\u4e0d\u663e\u793a\u65f6\uff0c\u624b\u673a\u53f7\u7801\u4e0d\u80fd\u8bbe\u7f6e\u4e3a\u5fc5\u586b\uff01", (String)"DynamicQRCodeSettingPlugin_6", (String)"imc-bdm-formplugin", (Object[])new Object[0]), index));
        }
        if (!qrKeyDynamicObject.getBoolean("emaildisplayflag") && qrKeyDynamicObject.getBoolean("emailrequiredflag")) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\u7535\u5b50\u90ae\u7bb1\u4e0d\u663e\u793a\u65f6\uff0c\u7535\u5b50\u90ae\u7bb1\u4e0d\u80fd\u8bbe\u7f6e\u4e3a\u5fc5\u586b\uff01", (String)"DynamicQRCodeSettingPlugin_7", (String)"imc-bdm-formplugin", (Object[])new Object[0]), index));
        }
        if (!qrKeyDynamicObject.getBoolean("remarkdisplayflag") && StringUtils.isNotBlank((CharSequence)qrKeyDynamicObject.getString("remarktips"))) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\u5907\u6ce8\u4e0d\u663e\u793a\u65f6\uff0c\u5907\u6ce8\u63d0\u793a\u4e0d\u9700\u8981\u586b\u5199\uff01", (String)"DynamicQRCodeSettingPlugin_8", (String)"imc-bdm-formplugin", (Object[])new Object[0]), index));
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        switch (control.getKey()) {
            case "eqinfono": {
                Object[] devNos;
                QFilter filter = new QFilter("epinfo.number", "=", this.getModel().getValue("taxno")).and("authstatus", "=", (Object)"1").and("disen", "=", (Object)"1");
                DynamicObjectCollection goods = this.getModel().getEntryEntity(INVSM_GOODSINFO_SETTING);
                if (null != goods && (devNos = goods.stream().map(good -> good.getString("eqinfono")).filter(StringUtils::isNotBlank).toArray()).length != 0) {
                    filter.and("equipmentno", "not in", (Object)devNos);
                }
                ViewUtil.openListPage((AbstractFormPlugin)this, (QFilter)filter, (String)"bdm_tax_equipment", (String)"eqinfono");
                break;
            }
            case "goodsname": {
                ViewUtil.openListPage((AbstractFormPlugin)this, (QFilter)ImcBaseDataHelper.getGoodsInfoFilter((Object)RequestContext.get().getOrgId()), (String)"bdm_goods_listmodal", (String)"goodsname");
                break;
            }
            case "systemcode": {
                ViewUtil.openListPage((AbstractFormPlugin)this, null, (String)"invsm_app_access_config", (String)"systemcode");
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData = closedCallBackEvent.getReturnData();
        String actionId = closedCallBackEvent.getActionId();
        if (null != returnData) {
            Object sid = ((ListSelectedRowCollection)returnData).get(0).getPrimaryKeyValue();
            switch (actionId) {
                case "eqinfono": {
                    DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)sid, (String)"bdm_tax_equipment");
                    this.getModel().setValue("eqinfono", obj.get("equipmentno"));
                    break;
                }
                case "goodsname": {
                    DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)sid, (String)"bdm_goods_info");
                    this.getModel().setValue("goodsname", obj.get("name"));
                    this.getModel().setValue("goodscode", obj.get("number"));
                    this.getModel().setValue("taxrate", obj.get("taxrate"));
                    String price = obj.get("price") + "";
                    String prices = obj.get("prices") + "";
                    this.getModel().setValue("price", (Object)Math.max(StringUtils.isEmpty((CharSequence)price) ? 0.0 : Double.parseDouble(price), StringUtils.isEmpty((CharSequence)prices) ? 0.0 : Double.parseDouble(prices)));
                    break;
                }
                case "systemcode": {
                    DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)sid, (String)"invsm_app_access_config");
                    this.getModel().setValue("systemcode", obj.get("code"));
                }
            }
        }
    }

    public void beforePropertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        ChangeData[] cs = e.getChangeSet();
        if (cs == null || cs.length == 0) {
            return;
        }
        String newValue = String.valueOf(cs[0].getNewValue());
        if ("goodsname".equals(key) && StringUtils.isEmpty((CharSequence)newValue)) {
            this.getModel().setValue("goodscode", (Object)"");
            this.getModel().setValue("taxrate", (Object)"");
            this.getModel().setValue("price", (Object)"");
        }
        if ("phonedisplayflag".equals(key)) {
            this.setCheckBoxEnable(newValue, cs[0].getRowIndex(), "phonerequiredflag");
        }
        if ("emaildisplayflag".equals(key)) {
            this.setCheckBoxEnable(newValue, cs[0].getRowIndex(), "emailrequiredflag");
        }
        if ("remarkdisplayflag".equals(key)) {
            if (!newValue.equals("true")) {
                this.getModel().setValue("remarktips", null);
                this.getView().setEnable(Boolean.FALSE, cs[0].getRowIndex(), new String[]{"remarktips"});
            } else {
                this.getView().setEnable(Boolean.TRUE, cs[0].getRowIndex(), new String[]{"remarktips"});
            }
            this.setInputEnable(newValue, cs[0].getRowIndex(), "remarktips");
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        EntryProp pro = e.getEntryProp();
        if (INVSM_GOODSINFO_SETTING.equals(pro.getName())) {
            DynamicObjectCollection goods = this.getModel().getEntryEntity(INVSM_GOODSINFO_SETTING);
            this.getModel().setValue("eqinfotaxno", this.getView().getModel().getValue("taxno"), goods.size() - 1);
            this.getModel().setValue("number", (Object)RandomStringUtils.randomAlphanumeric((int)10), goods.size() - 1);
        }
    }

    private void setCheckBoxEnable(String flag, int rowindex, String labelname) {
        if (StringUtils.isEmpty((CharSequence)flag) || !flag.equals("true")) {
            this.getModel().setValue(labelname, (Object)Boolean.FALSE, rowindex);
            this.getView().setEnable(Boolean.FALSE, rowindex, new String[]{labelname});
        } else {
            this.getView().setEnable(Boolean.TRUE, rowindex, new String[]{labelname});
        }
    }

    private void setInputEnable(String remarkdisplayflag, int rowindex, String labelname) {
        if (StringUtils.isEmpty((CharSequence)remarkdisplayflag) || !remarkdisplayflag.equals("true")) {
            this.getModel().setValue(labelname, null, rowindex);
            this.getView().setEnable(Boolean.FALSE, rowindex, new String[]{labelname});
        } else {
            this.getView().setEnable(Boolean.TRUE, rowindex, new String[]{labelname});
        }
    }
}

