/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.issuesetting;

import java.util.Collection;
import java.util.HashMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.imc.bdm.common.constant.ImcPermItemEnum;
import kd.imc.bdm.common.helper.OrgHelper;
import kd.imc.bdm.common.helper.PermissionHelper;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.ViewUtil;

public class QrCodeListPlugin
extends AbstractListPlugin {
    private static final String QRCODESTATUS_TRUE = "1";

    public void setFilter(SetFilterEvent e) {
        QFilter qFilter = new QFilter("qrcodestatus", "=", (Object)QRCODESTATUS_TRUE);
        HasPermOrgResult userHasPermOrgs = PermissionServiceHelper.getUserHasPermOrgs((long)Long.parseLong(RequestContext.get().getUserId()));
        if (!userHasPermOrgs.hasAllOrgPerm()) {
            qFilter.and(OrgHelper.getIdFilter((Collection)userHasPermOrgs.getHasPermOrgs()));
        }
        e.getCustomQFilters().add(qFilter);
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("addqrcode".equals(itemKey)) {
            PermissionHelper.checkPermission((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.CREATE_QRCODE);
            String baseUrl = ImcConfigUtil.getValue((String)"bdm_ismc_config_move", (String)"bdm_ismc_config_move_cloud_url");
            if (StringUtils.isEmpty((CharSequence)baseUrl)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u521d\u59cb\u5316\u79fb\u52a8\u4e91\uff0c\u8bf7\u524d\u5f80\u53d1\u7968\u4e91->\u7cfb\u7edf\u7ba1\u7406->\u4e91\u5e94\u7528\u53c2\u6570\u914d\u7f6e-\u79fb\u52a8\u4e91\u53c2\u6570\u914d\u7f6e \u8fdb\u884c\u521d\u59cb\u5316", (String)"QrCodeListPlugin_0", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
                return;
            }
            ViewUtil.openDialog((AbstractFormPlugin)this, null, null, (String)"bdm_add_qrcode", (String)"bdm_add_qrcode");
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRow row = billList.getCurrentSelectedRowInfo();
        if ("qrcodestatus".equals(args.getFieldName())) {
            Object primaryKeyValue = row.getPrimaryKeyValue();
            DynamicObject org = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"bdm_org", (String)String.join((CharSequence)",", "name", "number", "epinfo"));
            if (null == org.get("epinfo")) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u7ed9\u9009\u4e2d\u7ec4\u7ec7\u7ed1\u5b9a\u4f01\u4e1a\u4fe1\u606f\uff0c\u518d\u521b\u5efa\u4e8c\u7ef4\u7801", (String)"QrCodeListPlugin_1", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("orgName", org.get("name"));
            map.put("epName", org.getDynamicObject("epinfo").get("name"));
            map.put("rowIndex", QRCODESTATUS_TRUE);
            map.put("orgNumber", org.get("number"));
            ViewUtil.openDialog((AbstractFormPlugin)this, null, map, (String)"bdm_createqrcode", (String)"bdm_previewqrcode");
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if (closedCallBackEvent.getActionId().equals("bdm_add_qrcode")) {
            this.getView().invokeOperation("refresh");
        }
    }
}

