/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.issuesetting;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Base64;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.constant.FileType;
import kd.imc.bdm.common.helper.QrCodeUtil;
import kd.imc.bdm.common.helper.UnitTestHelper;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.ViewUtil;

public class QrcodeCreatePlugin
extends AbstractFormPlugin {
    private static final String CUSTOM_CONTROL_QRIMAGE = "qrcodeimage";
    private static final Log LOGGER = LogFactory.getLog(QrcodeCreatePlugin.class);

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        switch (itemKey = evt.getItemKey()) {
            case "exist": {
                this.getView().returnDataToParent((Object)"clodse");
                this.getView().close();
                break;
            }
            case "btn_download": {
                this.downloadQrcode();
            }
        }
    }

    private void downloadQrcode() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("eventKey", "download");
        ViewUtil.bindDataToHtml((AbstractFormPlugin)this, params, (String)CUSTOM_CONTROL_QRIMAGE);
    }

    public void afterCreateNewData(EventObject e) {
        String tableQrCode;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        String orgName = (String)customParams.get("orgName");
        String epName = (String)customParams.get("epName");
        this.getPageCache().put("rowIndex", String.valueOf(customParams.get("rowIndex")));
        String orgNumber = (String)customParams.get("orgNumber");
        this.getPageCache().put("orgNumber", orgNumber);
        DynamicObject[] orgArray = BusinessDataServiceHelper.load((String)"bdm_org", (String)"id", (QFilter[])new QFilter("number", "=", (Object)orgNumber).toArray());
        if (null == orgArray || orgArray.length == 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u7ec4\u7ec7\u7f16\u53f7\u4e3a%s\u5bf9\u5e94\u7684\u7ec4\u7ec7\u4fe1\u606f", (String)"QrcodeCreatePlugin_5", (String)"imc-bdm-formplugin", (Object[])new Object[0]), orgNumber));
        }
        String orgId = String.valueOf(orgArray[0].get("id"));
        HashMap<String, String> params = new HashMap<String, String>();
        String baseUrl = UnitTestHelper.isUnitTest() ? "http://cosmic-demo.piaozone.com/demo" : ImcConfigUtil.getValue((String)"bdm_ismc_config_move", (String)"bdm_ismc_config_move_cloud_url");
        if (StringUtils.isBlank((CharSequence)baseUrl)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u521d\u59cb\u5316\u79fb\u52a8\u4e91", (String)"QrcodeCreatePlugin_2", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            return;
        }
        baseUrl = baseUrl.substring(baseUrl.indexOf("//") + 2);
        baseUrl = "https://" + baseUrl.substring(0, baseUrl.indexOf(47));
        try {
            tableQrCode = QrCodeUtil.generateCodeAsBase64Str((String)baseUrl, (String)"2", (String)orgId);
        }
        catch (Exception e1) {
            LOGGER.error(e1.getMessage(), (Throwable)e1);
            throw new KDBizException(ResManager.loadKDString((String)"\u751f\u6210\u4e8c\u7ef4\u7801\u5931\u8d25", (String)"QrcodeCreatePlugin_3", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
        }
        params.put("qrCode", "data:image/png;base64," + tableQrCode);
        String fileName = epName + "-" + orgName;
        this.getPageCache().put("qrcodeName", fileName);
        params.put("orgName", fileName);
        ViewUtil.bindDataToHtml((AbstractFormPlugin)this, params, (String)CUSTOM_CONTROL_QRIMAGE);
        DynamicObject[] array = BusinessDataServiceHelper.load((String)"bdm_org", (String)"qrcodestatus", (QFilter[])new QFilter("number", "=", (Object)orgNumber).toArray());
        if (array.length > 0) {
            array[0].set("qrcodestatus", (Object)"1");
            SaveServiceHelper.update((DynamicObject)array[0]);
        }
        this.getPageCache().put("STATUS", "SUCCESS");
        if (customParams.containsKey("pkId")) {
            Long pkId = (Long)customParams.get("pkId");
            DynamicObject staticQrCodeObject = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"bdm_static_qrcode_setting");
            staticQrCodeObject.set("qrcodestatus", (Object)"1");
            SaveServiceHelper.update((DynamicObject)staticQrCodeObject);
        }
    }

    public void customEvent(CustomEventArgs e) {
        String key = e.getEventName();
        if ("download".equals(key)) {
            String imageBase64Str = e.getEventArgs().replace("data:image/png;base64,", "");
            byte[] decode = Base64.getDecoder().decode(imageBase64Str);
            ByteArrayInputStream in = new ByteArrayInputStream(decode);
            String qrcodeName = this.getPageCache().get("qrcodeName");
            String tipMsg = ResManager.loadKDString((String)"\u5f00\u7968\u4e8c\u7ef4\u7801", (String)"QrCodeCreatePlugin_0", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
            String downloadName = qrcodeName + tipMsg;
            String urls = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(downloadName + "." + FileType.PNG.getFileExtension(), (InputStream)in, 5000);
            this.getView().openUrl(urls);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        if ("SUCCESS".equals(this.getPageCache().get("STATUS"))) {
            this.getView().returnDataToParent((Object)this.getPageCache().get("rowIndex"));
        }
    }
}

