/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.issuesetting.control;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.bill.HSAmountSplitHelper;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.bdm.formplugin.issuesetting.InvoiceSettingTabPlugin;
import org.apache.commons.beanutils.ConvertUtils;

public class HSAmountConfigControl {
    public static final String CALLBACK_ALLOCATION_ORG = "callbackallocationorg";
    public static final String CALLBACK_HS_RULE_SETTING = "callbackhsrulesetting";
    public static final String AMOUNT_CONFIG_ENTRY_ENTITY = "amountconfig";
    public static final String OPERATION_KEY_ORGS = "amountconfigorgs";
    public static final String OPERATION_KEY_HS_SPLIT_RULE = "hssplitrule";
    public static final String PAGE_CACHE_ALLOCATION_ORG_SELECT_ROW = "amount_config_select_row";
    public static final String PAGE_CACHE_HS_RULE_SELECT_ROW = "hs_rule_select_row";
    private static final Log LOGGER = LogFactory.getLog(HSAmountConfigControl.class);

    public static void initHSAmountSplit(AbstractFormPlugin plugin) {
        DynamicObject[] hsConfigDynamicObjectList = HSAmountSplitHelper.getHSConfigDynamicObjectList();
        if (hsConfigDynamicObjectList == null || hsConfigDynamicObjectList.length < 1) {
            return;
        }
        plugin.getView().getModel().deleteEntryData(AMOUNT_CONFIG_ENTRY_ENTITY);
        for (int i = 0; i < hsConfigDynamicObjectList.length; ++i) {
            DynamicObject hsConfigDO = hsConfigDynamicObjectList[i];
            HSAmountConfigControl.addRow(plugin);
            plugin.getView().getModel().setValue("hsrowid", hsConfigDO.getPkValue(), i);
            plugin.getView().getModel().setValue("normalpaperlimit", hsConfigDO.get("normalpaperlimit"), i);
            plugin.getView().getModel().setValue("specialpaperlimit", hsConfigDO.get("specialpaperlimit"), i);
            plugin.getView().getModel().setValue("normalelectroniclimit", hsConfigDO.get("normalelectroniclimit"), i);
            plugin.getView().getModel().setValue("specialelectroniclimit", hsConfigDO.get("specialelectroniclimit"), i);
            plugin.getView().getModel().setValue("normalallelimit", hsConfigDO.get("normalallelimit"), i);
            plugin.getView().getModel().setValue("specialallelimit", hsConfigDO.get("specialallelimit"), i);
            plugin.getView().getModel().setValue("adjusttax", hsConfigDO.get("adjusttax"), i);
            plugin.getView().getModel().setValue("taxcalculatetype", hsConfigDO.get("taxcalculatetype"), i);
            plugin.getView().getModel().setValue("splitrule", hsConfigDO.get("splitrule"), i);
            plugin.getView().getModel().setValue("orgs_tag", hsConfigDO.get("orgs_tag"), i);
            plugin.getView().getModel().setValue("numberdigit", hsConfigDO.get("numberdigit"), i);
            plugin.getView().getModel().setValue("numberdigitrule", hsConfigDO.get("numberdigitrule"), i);
            plugin.getView().getModel().setValue("splitpricefixednum", hsConfigDO.get("splitpricefixednum"), i);
        }
    }

    public static void handleItemClickSplitAmountSave(InvoiceSettingTabPlugin plugin, IFormView view) {
        EntryGrid grid = (EntryGrid)plugin.getControl(AMOUNT_CONFIG_ENTRY_ENTITY);
        DynamicObject[] items = grid.getEntryData().getDataEntitys();
        try (TXHandle tx = TX.required((String)"handleItemClickSplitAmountSave");){
            try {
                HSAmountConfigControl.delete();
                for (int i = 0; i < items.length; ++i) {
                    HSAmountConfigControl.saveDynamicObject(plugin, i, items[i]);
                }
                view.showSuccessNotification(ResManager.loadKDString((String)"\u542b\u7a0e\u91d1\u989d\u62c6\u5206\u8bbe\u7f6e\u4fdd\u5b58\u6210\u529f", (String)"HSAmountConfigControl_0", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
                HSAmountConfigControl.initHSAmountSplit(plugin);
            }
            catch (Exception e) {
                tx.markRollback();
                LOGGER.error("\u542b\u7a0e\u91d1\u989d\u62c6\u5206\u8bbe\u7f6e\u4fdd\u5b58\u5931\u8d25\uff0c\u89e6\u53d1\u4e8b\u52a1\u56de\u6eda", (Throwable)e);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25 %s", (String)"HSAmountConfigControl_4", (String)"imc-bdm-formplugin", (Object[])new Object[0]), e.getMessage()));
            }
        }
    }

    private static void delete() {
        QFilter qFilter = new QFilter("hssplitamountenable", "=", (Object)"1");
        DeleteServiceHelper.delete((String)"bdm_split_hs_config", (QFilter[])qFilter.toArray());
    }

    public static void saveDynamicObject(InvoiceSettingTabPlugin plugin, int index, DynamicObject item) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"bdm_split_hs_config");
        dynamicObject.set("hssplitamountenable", (Object)Boolean.TRUE);
        dynamicObject.set("normalpaperlimit", item.get("normalpaperlimit"));
        dynamicObject.set("specialpaperlimit", item.get("specialpaperlimit"));
        dynamicObject.set("normalelectroniclimit", item.get("normalelectroniclimit"));
        dynamicObject.set("specialelectroniclimit", item.get("specialelectroniclimit"));
        dynamicObject.set("specialallelimit", item.get("specialallelimit"));
        dynamicObject.set("normalallelimit", item.get("normalallelimit"));
        dynamicObject.set("adjusttax", item.get("adjusttax"));
        dynamicObject.set("taxcalculatetype", item.get("taxcalculatetype"));
        if (!StringUtils.isEmpty((CharSequence)item.getString("splitrule"))) {
            dynamicObject.set("splitrule", item.get("splitrule"));
            dynamicObject.set("numberdigit", item.get("numberdigit"));
            dynamicObject.set("numberdigitrule", item.get("numberdigitrule"));
        } else {
            dynamicObject.set("splitrule", (Object)"1");
            dynamicObject.set("numberdigit", (Object)10);
            dynamicObject.set("numberdigitrule", (Object)"1");
        }
        dynamicObject.set("orgs_tag", item.get("orgs_tag"));
        dynamicObject.set("splitpricefixednum", item.get("splitpricefixednum"));
        ImcSaveServiceHelper.save((DynamicObject)dynamicObject);
        plugin.getView().getModel().setValue("hsrowid", dynamicObject.getPkValue(), index);
    }

    public static void selectAllocationOrg(AbstractFormPlugin plugin, int selectRowIndex) {
        String orgTags = (String)plugin.getView().getModel().getValue("orgs_tag", selectRowIndex);
        List<Long> orgList = HSAmountConfigControl.getNotInOrgList(plugin, selectRowIndex);
        QFilter qFilter = null;
        if (!orgList.isEmpty()) {
            qFilter = new QFilter("id", "not in", (Object)orgList.toArray());
        }
        if (!StringUtils.isEmpty((CharSequence)orgTags)) {
            ViewUtil.openListPage((AbstractFormPlugin)plugin, (QFilter)qFilter, (String)"bdm_allocation_org", (String)CALLBACK_ALLOCATION_ORG, (boolean)true, (boolean)true, (Object[])HSAmountSplitHelper.getOrgList((String)orgTags).toArray());
        } else {
            ViewUtil.openListPage((AbstractFormPlugin)plugin, (QFilter)qFilter, (String)"bdm_allocation_org", (String)CALLBACK_ALLOCATION_ORG, (boolean)true, (boolean)true, null, null, null);
        }
    }

    public static void chooseOrgCloseCallBack(ClosedCallBackEvent event, AbstractFormPlugin plugin) {
        if (event.getReturnData() == null) {
            return;
        }
        ListSelectedRowCollection listSelectedRows = (ListSelectedRowCollection)event.getReturnData();
        if (listSelectedRows != null && !listSelectedRows.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (ListSelectedRow listSelectedRow : listSelectedRows) {
                sb.append(listSelectedRow.getPrimaryKeyValue()).append(',');
            }
            sb.delete(sb.length() - 1, sb.length());
            String selectRow = plugin.getPageCache().get(PAGE_CACHE_ALLOCATION_ORG_SELECT_ROW);
            plugin.getView().getModel().setValue("orgs_tag", (Object)sb.toString(), Integer.parseInt(selectRow));
        }
    }

    private static List<Long> getNotInOrgList(AbstractFormPlugin plugin, int selectRow) {
        ArrayList<Long> orgList = new ArrayList<Long>();
        EntryGrid grid = (EntryGrid)plugin.getControl(AMOUNT_CONFIG_ENTRY_ENTITY);
        DynamicObject[] items = grid.getEntryData().getDataEntitys();
        for (int i = 0; i < items.length; ++i) {
            String orgListStr;
            if (i == selectRow || !StringUtils.isNotBlank((CharSequence)(orgListStr = (String)plugin.getView().getModel().getValue("orgs_tag", i)))) continue;
            orgList.addAll(Arrays.asList((Long[])ConvertUtils.convert((String[])orgListStr.split(","), Long.class)));
        }
        return orgList;
    }

    public static void addRow(AbstractFormPlugin plugin) {
        plugin.getView().getModel().createNewEntryRow(AMOUNT_CONFIG_ENTRY_ENTITY);
    }

    public static void deleteRow(InvoiceSettingTabPlugin plugin) {
        EntryGrid grid = (EntryGrid)plugin.getControl(AMOUNT_CONFIG_ENTRY_ENTITY);
        int[] selectRows = grid.getSelectRows();
        if (selectRows.length == 0) {
            plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u8bb0\u5f55\u518d\u8fdb\u884c\u64cd\u4f5c!", (String)"HSAmountConfigControl_3", (String)"imc-bdm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        plugin.getView().getModel().deleteEntryRows(AMOUNT_CONFIG_ENTRY_ENTITY, selectRows);
    }
}

