/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.issuesetting.matchgoods.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.basedata.AssignQueryResponse;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.api.HasPermOrgResultImpl;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.imc.bdm.common.helper.OrgHelper;
import kd.imc.bdm.common.util.DynamicObjectUtil;

public class CtrlStrategyHelper {
    private static final Log LOGGER = LogFactory.getLog(CtrlStrategyHelper.class);

    public static HasPermOrgResultImpl queryAllUseOrg(DynamicObject goodsInfo) {
        long createOrgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)goodsInfo.getDynamicObject("createorg"));
        ArrayList<Long> defaultPerOrgs = new ArrayList<Long>();
        defaultPerOrgs.add(createOrgId);
        try {
            String ctrlStrategy = goodsInfo.getString("ctrlstrategy");
            if ("5".equals(ctrlStrategy)) {
                new HasPermOrgResultImpl(true, null);
            }
            if ("7".equals(ctrlStrategy)) {
                return new HasPermOrgResultImpl(false, defaultPerOrgs);
            }
            if ("6".equals(ctrlStrategy)) {
                List allOrgs = OrgHelper.getChildrenOrgIds((long)createOrgId, (boolean)true);
                return new HasPermOrgResultImpl(false, allOrgs);
            }
            ArrayList<Long> pks = new ArrayList<Long>();
            long goodsPk = goodsInfo.getLong("id");
            pks.add(goodsPk);
            AssignQueryResponse response = BaseDataServiceHelper.assignQueryByData(pks, (String)"bdm_manual_set_goods", (Long)createOrgId, (String)"sim");
            if (!response.isSuccess()) {
                throw new KDBizException(response.getErrorMsg());
            }
            Map data = response.getData();
            List queriedOrgPks = (List)data.get(goodsPk);
            return new HasPermOrgResultImpl(false, queriedOrgPks);
        }
        catch (KDBizException e) {
            throw e;
        }
        catch (Throwable t) {
            LOGGER.error(t.getMessage(), t);
            return new HasPermOrgResultImpl(false, defaultPerOrgs);
        }
    }
}

