/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.issuesetting.matchgoods.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResultImpl;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.constant.TaxRate;
import kd.imc.bdm.formplugin.issuesetting.matchgoods.helper.CtrlStrategyHelper;

public class GoodsInfoSaveValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.dataEntities;
        String lockKey = "ImcSimManualSetGoodsInfoGoodsInfoSaveValidator";
        try (DLock lock = DLock.create((String)lockKey);){
            String fields;
            DynamicObject[] dbGoodsInfos;
            List filteredDbGoodsInfos;
            List<Object> listManualGoods;
            String key;
            String zzstsgl;
            if (!lock.tryLock(500L)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6709\u5176\u4ed6\u7ea0\u504f\u4fe1\u606f\u5728\u4fdd\u5b58\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"GoodsInfoSaveValidator_0", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            }
            HashMap<String, List<Object>> infoKeyMap = new HashMap<String, List<Object>>();
            boolean isBaseCheckFail = false;
            HashSet<String> goodsCodeSet = new HashSet<String>();
            HashSet<Long> idSet = new HashSet<Long>();
            for (ExtendedDataEntity manualGoods : dataEntities) {
                DynamicObject dynamicObject = manualGoods.getDataEntity();
                if (this.checkFieldMustNeed(manualGoods, dynamicObject)) {
                    isBaseCheckFail = true;
                }
                if (this.checkZZSTSGL(manualGoods, dynamicObject)) {
                    isBaseCheckFail = true;
                }
                zzstsgl = null == dynamicObject.getString("zzstsgl") ? "" : dynamicObject.getString("zzstsgl");
                goodsCodeSet.add(dynamicObject.getString("goodscode"));
                idSet.add(dynamicObject.getLong("id"));
                key = dynamicObject.getString("goodscode") + dynamicObject.getString("name") + dynamicObject.getDynamicObject("taxclasscode").getString("mergecode") + dynamicObject.getString("taxrate") + zzstsgl;
                listManualGoods = (ArrayList<ExtendedDataEntity>)infoKeyMap.get(key);
                if (null == listManualGoods) {
                    listManualGoods = new ArrayList<ExtendedDataEntity>();
                    infoKeyMap.put(key, listManualGoods);
                } else if (this.checkRepeat(listManualGoods, manualGoods)) {
                    isBaseCheckFail = true;
                }
                listManualGoods.add(manualGoods);
            }
            if (!isBaseCheckFail && (filteredDbGoodsInfos = Arrays.stream(dbGoodsInfos = BusinessDataServiceHelper.load((String)"bdm_manual_set_goods", (String)(fields = "name,goodscode,taxclasscode,taxrate,taxpremark,zzstsgl,isallepinfo,items.epinfo,createorg"), (QFilter[])new QFilter("goodscode", "in", goodsCodeSet).toArray())).filter(o -> !idSet.contains(o.getLong("id"))).collect(Collectors.toList())).size() > 0) {
                for (DynamicObject filteredDbGoodsInfo : filteredDbGoodsInfos) {
                    String string = zzstsgl = null == filteredDbGoodsInfo.getString("zzstsgl") ? "" : filteredDbGoodsInfo.getString("zzstsgl");
                    key = filteredDbGoodsInfo.getString("goodscode") + filteredDbGoodsInfo.getString("name") + filteredDbGoodsInfo.getDynamicObject("taxclasscode").getString("mergecode") + filteredDbGoodsInfo.getString("taxrate") + zzstsgl;
                    listManualGoods = (List)infoKeyMap.get(key);
                    if (null == listManualGoods) continue;
                    this.checkDbRepeat(listManualGoods, filteredDbGoodsInfo);
                }
            }
        }
    }

    private boolean checkDbRepeat(List<ExtendedDataEntity> listManualGoods, DynamicObject dbGoodsInfo) {
        HasPermOrgResultImpl dbResult = CtrlStrategyHelper.queryAllUseOrg(dbGoodsInfo);
        List dbHasPerOrgs = dbResult.getHasPermOrgs();
        if (dbResult.hasAllOrgPerm()) {
            this.addErrorMessage(listManualGoods.get(0), ResManager.loadKDString((String)"[\u5546\u54c1\u7f16\u7801+\u5546\u54c1\u540d\u79f0+\u7a0e\u6536\u5206\u7c7b\u7f16\u7801+\u7a0e\u7387+\u4f18\u60e0\u653f\u7b56\u5185\u5bb9+\u4f01\u4e1a]\u552f\u4e00\u6027\u6821\u9a8c\u5931\u8d25\uff0c\u4e0e\u6570\u636e\u5e93\u4e2d\u5176\u4ed6\u91cd\u590d\u6570\u636e\u5b58\u5728\u91cd\u590d", (String)"GoodsInfoSaveValidator_1", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            return true;
        }
        ExtendedDataEntity extendedDataEntity = listManualGoods.get(0);
        DynamicObject saveGoodsInfo = extendedDataEntity.getDataEntity();
        HasPermOrgResultImpl saveResult = CtrlStrategyHelper.queryAllUseOrg(saveGoodsInfo);
        List saveHasPermOrgs = saveResult.getHasPermOrgs();
        for (Long dbHasPerOrg : dbHasPerOrgs) {
            if (!saveHasPermOrgs.contains(dbHasPerOrg)) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"[\u5546\u54c1\u7f16\u7801+\u5546\u54c1\u540d\u79f0+\u7a0e\u6536\u5206\u7c7b\u7f16\u7801+\u7a0e\u7387+\u4f18\u60e0\u653f\u7b56\u5185\u5bb9+\u4f01\u4e1a]\u552f\u4e00\u6027\u6821\u9a8c\u5931\u8d25\uff0c\u4e0e\u6570\u636e\u5e93\u4e2d\u5176\u4ed6\u91cd\u590d\u6570\u636e\u5b58\u5728\u91cd\u590d", (String)"GoodsInfoSaveValidator_1", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private boolean checkRepeat(List<ExtendedDataEntity> listManualGoods, ExtendedDataEntity manualGoods) {
        this.addErrorMessage(manualGoods, ResManager.loadKDString((String)"[\u5546\u54c1\u7f16\u7801+\u5546\u54c1\u540d\u79f0+\u7a0e\u6536\u5206\u7c7b\u7f16\u7801+\u7a0e\u7387+\u4f18\u60e0\u653f\u7b56\u5185\u5bb9+\u4f01\u4e1a]\u552f\u4e00\u6027\u6821\u9a8c\u5931\u8d25\uff0c\u5b58\u5728\u91cd\u590d\u6570\u636e", (String)"GoodsInfoSaveValidator_2", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
        return true;
    }

    private boolean checkFieldMustNeed(ExtendedDataEntity manualGoods, DynamicObject obj) {
        DynamicObject matchTaxClassCode;
        String name = obj.getString("name");
        String spbm = obj.getString("goodscode");
        DynamicObject taxClassCode = obj.getDynamicObject("taxclasscode");
        String taxRate = obj.getString("taxrate");
        String taxPremark = obj.getString("taxpremark");
        boolean isAllEPINFO = obj.getBoolean("isallepinfo");
        DynamicObjectCollection items = obj.getDynamicObjectCollection("items");
        if (StringUtils.isBlank((CharSequence)name)) {
            this.addErrorMessage(manualGoods, ResManager.loadKDString((String)"\u5546\u54c1\u540d\u79f0\u5fc5\u586b", (String)"GoodsInfoSaveValidator_3", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            return true;
        }
        if (name.length() > 100) {
            this.addErrorMessage(manualGoods, ApiErrCodeEnum.INVOICE_OPEN_GOODNAMELENGTH.getMsg());
            return true;
        }
        if (StringUtils.isBlank((CharSequence)spbm)) {
            this.addErrorMessage(manualGoods, ResManager.loadKDString((String)"\u5546\u54c1\u7f16\u7801\u5fc5\u586b", (String)"GoodsInfoSaveValidator_4", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            return true;
        }
        if (null == taxClassCode) {
            this.addErrorMessage(manualGoods, ResManager.loadKDString((String)"\u7ea0\u504f\u540e\u7a0e\u7f16\u5fc5\u586b", (String)"GoodsInfoSaveValidator_5", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            return true;
        }
        if (StringUtils.isBlank((CharSequence)taxRate)) {
            this.addErrorMessage(manualGoods, ResManager.loadKDString((String)"\u7ea0\u504f\u540e\u7a0e\u7387\u5fc5\u586b", (String)"GoodsInfoSaveValidator_6", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            return true;
        }
        if (StringUtils.isBlank((CharSequence)taxPremark)) {
            this.addErrorMessage(manualGoods, ResManager.loadKDString((String)"\u662f\u5426\u4eab\u53d7\u4f18\u60e0\u653f\u7b56\u5fc5\u586b", (String)"GoodsInfoSaveValidator_7", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            return true;
        }
        String sumItem = taxClassCode.getString("sumitem");
        if ("true".equals(sumItem)) {
            this.addErrorMessage(manualGoods, ResManager.loadKDString((String)"\u7ea0\u504f\u540e\u7a0e\u7f16\u4e0d\u80fd\u9009\u62e9\u4e3a\u6c47\u603b\u9879\u7684\u7a0e\u6536\u5206\u7c7b\u7f16\u7801", (String)"GoodsInfoSaveValidator_10", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
        }
        if (null != (matchTaxClassCode = obj.getDynamicObject("matchclasscode")) && "true".equals(sumItem = matchTaxClassCode.getString("sumitem"))) {
            this.addErrorMessage(manualGoods, ResManager.loadKDString((String)"\u667a\u80fd\u5339\u914d\u7a0e\u7f16\u4e0d\u80fd\u9009\u62e9\u4e3a\u6c47\u603b\u9879\u7684\u7a0e\u6536\u5206\u7c7b\u7f16\u7801", (String)"GoodsInfoSaveValidator_11", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
        }
        return false;
    }

    private boolean checkZZSTSGL(ExtendedDataEntity manualGoods, DynamicObject obj) {
        String taxPremark = obj.getString("taxpremark");
        String zzstsgl = obj.getString("zzstsgl");
        String taxRate = obj.getString("taxrate");
        if ("1".equals(taxPremark) && StringUtils.isBlank((CharSequence)zzstsgl)) {
            this.addErrorMessage(manualGoods, ResManager.loadKDString((String)"\u662f\u5426\u4eab\u53d7\u4f18\u60e0\u653f\u7b56\u4e3a\u4eab\u53d7\u65f6\uff0c\u4f18\u60e0\u653f\u7b56\u5185\u5bb9\u5fc5\u586b", (String)"GoodsInfoSaveValidator_8", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            return true;
        }
        if (("\u514d\u7a0e".equals(zzstsgl) || "\u4e0d\u5f81\u7a0e".equals(zzstsgl)) && !TaxRate.ZERO_PERCENT.getRateValue().equals(taxRate)) {
            this.addErrorMessage(manualGoods, ResManager.loadKDString((String)"\u4f18\u60e0\u653f\u7b56\u5185\u5bb9\u4e3a\u514d\u7a0e\u6216\u4e0d\u5f81\u7a0e\u65f6\uff0c\u7a0e\u7387\u5fc5\u987b\u4e3a0%", (String)"GoodsInfoSaveValidator_9", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }
}

