/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.org;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.bdm.common.helper.EquipmentHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.OrgHelper;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.bdm.common.util.TreeUtils;
import org.apache.commons.collections.CollectionUtils;

public class OrgBindEquipmentTreePlugin
extends AbstractFormPlugin
implements TreeNodeCheckListener {
    private static final String VIEW_TREE = "treeviewap";
    private static final String VIEW_BILL_LIST = "billlistap";
    private static final String EQUIPMENT_ID = "equipmentid";
    private static final String DEV_NO = "devNo";
    private static final String TERMINAL_NO = "terminalNo";
    private static final String ORG_ID = "orgId";
    private static final String PAGE_CACHE_CHECK_ORG_IDS = "checkOrgIds";

    public void registerListener(EventObject e) {
        TreeView treeView = (TreeView)this.getView().getControl(VIEW_TREE);
        treeView.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object equipmentId = customParams.get(EQUIPMENT_ID);
        Object orgEditPluginOrgId = customParams.get(ORG_ID);
        String devNo = (String)customParams.get(DEV_NO);
        String terminalNo = (String)customParams.get(TERMINAL_NO);
        this.getPageCache().put(EQUIPMENT_ID, String.valueOf(equipmentId));
        this.getPageCache().put(DEV_NO, devNo);
        this.getPageCache().put(TERMINAL_NO, terminalNo);
        this.getPageCache().put(ORG_ID, String.valueOf(orgEditPluginOrgId));
        this.loadTree(String.valueOf(equipmentId), String.valueOf(orgEditPluginOrgId), null);
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("auth".equals(itemKey)) {
            this.auth(0);
        } else if ("unauth".equals(itemKey)) {
            this.auth(1);
        }
    }

    private void auth(int authType) {
        String devNo = this.getPageCache().get(DEV_NO);
        String equipmentId = this.getPageCache().get(EQUIPMENT_ID);
        String terminalNo = this.getPageCache().get(TERMINAL_NO);
        String editMainOrgId = this.getPageCache().get(ORG_ID);
        DynamicObject enterpriseDynamicObject = TaxUtils.getEnterpriseDynamicObjectByOrg((Long)Long.parseLong(editMainOrgId));
        String cacheCheckOrgIds = this.getPageCache().get(PAGE_CACHE_CHECK_ORG_IDS);
        JSONArray jsonArray = JSONObject.parseArray((String)cacheCheckOrgIds);
        List<Long> checkOrgLongIds = new ArrayList();
        if (!jsonArray.isEmpty()) {
            DynamicObject[] checkOrgDynamicList;
            if (jsonArray.get(0) instanceof String) {
                for (Object o : jsonArray) {
                    checkOrgLongIds.add(Long.parseLong((String)o));
                }
            } else {
                checkOrgLongIds = jsonArray.toJavaList(Long.class);
            }
            checkOrgLongIds.remove(Long.parseLong(editMainOrgId));
            QFilter qFilter = new QFilter("id", "in", checkOrgLongIds);
            for (DynamicObject checkOrgDynamicObject : checkOrgDynamicList = BusinessDataServiceHelper.load((String)"bdm_org", (String)"id,number,name,parent,longnumber,enterprisemainorg,defaultdev,devlist_tag,epinfo,defaultterminal", (QFilter[])qFilter.toArray())) {
                String devList = checkOrgDynamicObject.getString("devlist_tag");
                if (authType == 0) {
                    if (StringUtils.isEmpty((CharSequence)devList)) {
                        checkOrgDynamicObject.set("devlist_tag", (Object)equipmentId);
                        checkOrgDynamicObject.set("defaultdev", (Object)devNo);
                        checkOrgDynamicObject.set("defaultterminal", (Object)terminalNo);
                    } else if (!devList.contains(equipmentId)) {
                        checkOrgDynamicObject.set("devlist_tag", (Object)(devList + "," + equipmentId));
                    }
                    checkOrgDynamicObject.set("epinfo", (Object)enterpriseDynamicObject);
                    continue;
                }
                this.unAuth(devNo, equipmentId, checkOrgDynamicObject, devList);
            }
            ImcSaveServiceHelper.save((DynamicObject[])checkOrgDynamicList);
            EquipmentHelper.asyncRefreshEuipmentRelateOrg((Object[])new Object[]{devNo});
            this.getView().returnDataToParent((Object)"success");
            if (authType == 0) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6388\u6743\u6210\u529f", (String)"OrgBindEquipmentTreePlugin_0", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64a4\u9500\u6388\u6743\u6210\u529f", (String)"OrgBindEquipmentTreePlugin_1", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            }
            this.loadTree(equipmentId, editMainOrgId, null);
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u4e2d\u4e00\u4e2a\u7ec4\u7ec7\u8fdb\u884c\u6388\u6743", (String)"OrgBindEquipmentTreePlugin_2", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
        }
    }

    private void unAuth(String devNo, String equipmentId, DynamicObject checkOrgDynamicObject, String devList) {
        if (StringUtils.isEmpty((CharSequence)devList)) {
            return;
        }
        List devs = Arrays.stream(devList.split(",")).collect(Collectors.toList());
        devs.remove(equipmentId);
        if (checkOrgDynamicObject.getString("defaultdev").equals(devNo)) {
            checkOrgDynamicObject.set("defaultdev", (Object)"");
        }
        if (devs.size() == 0) {
            checkOrgDynamicObject.set("epinfo", null);
            checkOrgDynamicObject.set("devlist_tag", (Object)"");
        } else {
            checkOrgDynamicObject.set("devlist_tag", (Object)String.join((CharSequence)",", devs));
        }
    }

    private void loadTree(String equipmentId, String orgEditPluginOrgId, List<Long> childrenOrgIds) {
        TreeView treeView = (TreeView)this.getView().getControl(VIEW_TREE);
        HashSet orgIds = new HashSet(16);
        DynamicObject orgObj = QueryServiceHelper.queryOne((String)"bdm_org", (String)String.join((CharSequence)",", "parent", "epinfo"), (QFilter[])new QFilter("id", "=", (Object)Long.parseLong(orgEditPluginOrgId)).toArray());
        orgIds.addAll(OrgHelper.getChildrenOrgIdsNotBindEnterprise((Long)Long.parseLong(orgEditPluginOrgId), (boolean)true));
        if (orgObj != null) {
            DynamicObjectCollection orgs = QueryServiceHelper.query((String)"bdm_org", (String)"id", (QFilter[])new QFilter("parent", "=", (Object)String.valueOf(orgObj.getLong("parent"))).and("epinfo", "=", (Object)0L).toArray());
            for (DynamicObject org : orgs) {
                orgIds.addAll(OrgHelper.getChildrenOrgIdsNotBindEnterprise((Long)org.getLong("id"), (boolean)true));
            }
            DynamicObjectCollection authOrgs = QueryServiceHelper.query((String)"bdm_org", (String)"id", (QFilter[])new QFilter("epinfo", "=", (Object)orgObj.getLong("epinfo")).toArray());
            orgIds.addAll(authOrgs.stream().map(authOrg -> authOrg.getLong("id")).collect(Collectors.toList()));
        }
        QFilter qFilter = new QFilter("id", "in", orgIds);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"bdm_org", (String)"id,number,name,parent,longnumber,enterprisemainorg,devlist_tag", (QFilter[])qFilter.toArray());
        ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>(collection.size());
        ArrayList<TreeNode> checkTreeNodeList = new ArrayList<TreeNode>(collection.size());
        ArrayList<Long> checkOrgLongIds = new ArrayList<Long>(collection.size());
        if (CollectionUtils.isNotEmpty((Collection)collection)) {
            treeView.deleteAllNodes();
            for (DynamicObject orgDynamicObject : collection) {
                if ("1".equals(orgDynamicObject.getString("enterprisemainorg")) && Long.parseLong(orgEditPluginOrgId) != orgDynamicObject.getLong("id")) continue;
                String parentId = orgDynamicObject.getString("parent");
                String id = orgDynamicObject.getString("id");
                String name = orgDynamicObject.getString("name");
                TreeNode node = new TreeNode();
                node.setId(id);
                node.setText(name);
                node.setIsOpened(true);
                node.setCheckable(true);
                node.setParentid(parentId);
                if (childrenOrgIds != null) {
                    for (Long childrenOrgId : childrenOrgIds) {
                        if (childrenOrgId.longValue() != orgDynamicObject.getLong("id") || checkOrgLongIds.contains(childrenOrgId)) continue;
                        checkTreeNodeList.add(node);
                        checkOrgLongIds.add(Long.parseLong(id));
                    }
                } else if (orgDynamicObject.getString("devlist_tag") != null && Long.parseLong(orgEditPluginOrgId) != orgDynamicObject.getLong("id") && orgDynamicObject.getString("devlist_tag").contains(equipmentId)) {
                    checkTreeNodeList.add(node);
                    checkOrgLongIds.add(Long.parseLong(id));
                }
                HashMap<String, String> data = new HashMap<String, String>(4);
                data.put("longnumber", orgDynamicObject.getString("longnumber"));
                node.setData(data);
                nodeList.add(node);
            }
            TreeUtils.build((TreeView)treeView, nodeList, (IPageCache)this.getPageCache(), (boolean)false);
        }
        treeView.checkNodes(checkTreeNodeList);
        this.refreshRightBillListViewByClickTreeNode(checkOrgLongIds);
    }

    private void refreshRightBillListViewByClickTreeNode(List<Long> checkOrgLongIds) {
        BillList billList = (BillList)this.getView().getControl(VIEW_BILL_LIST);
        billList.clearSelection();
        QFilter orgFilter = new QFilter("id", "in", checkOrgLongIds);
        orgFilter.and("enterprisemainorg", "=", (Object)"0");
        FilterParameter fp = new FilterParameter();
        fp.setFilter(orgFilter);
        fp.setOrderBy("longnumber");
        billList.setFilterParameter(fp);
        billList.refreshData();
        this.getPageCache().put(PAGE_CACHE_CHECK_ORG_IDS, JSON.toJSONString(checkOrgLongIds));
    }

    public void treeNodeCheck(TreeNodeCheckEvent treeNodeCheckEvent) {
        TreeView treeView = (TreeView)this.getView().getControl(VIEW_TREE);
        TreeNode root = TreeUtils.getCache((IPageCache)this.getPageCache(), (String)treeView.getKey());
        TreeNode currentNode = root.getTreeNode((String)treeNodeCheckEvent.getNodeId(), 20);
        boolean isContainsChild = (Boolean)this.getView().getModel().getValue("iscontainschild");
        ArrayList<TreeNode> allNodes = new ArrayList<TreeNode>(4);
        if (isContainsChild) {
            this.findAllIds(currentNode, allNodes);
        } else {
            allNodes.add(currentNode);
        }
        List removeNodes = allNodes.stream().map(TreeNode::getId).collect(Collectors.toList());
        List checkedNodeStringIds = treeView.getTreeState().getCheckedNodeIds();
        if (!treeNodeCheckEvent.getChecked().booleanValue()) {
            checkedNodeStringIds.removeAll(removeNodes);
            treeView.uncheckNodes(removeNodes);
        } else {
            treeView.checkNodes(allNodes);
            checkedNodeStringIds.addAll(removeNodes);
        }
        this.refreshRightBillListViewByClickTreeNode(checkedNodeStringIds.stream().map(Long::parseLong).collect(Collectors.toList()));
    }

    private void findAllIds(TreeNode node, List<TreeNode> allIds) {
        allIds.add(node);
        List children = node.getChildren();
        if (children != null) {
            for (TreeNode child : node.getChildren()) {
                this.findAllIds(child, allIds);
            }
        }
    }
}

