/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.org;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.model.LevelTreeNode;
import kd.imc.bdm.common.util.EquipmentUtil;
import kd.imc.bdm.common.util.TreeUtils;
import kd.imc.bdm.formplugin.org.OrgImportPlugin;
import kd.imc.bdm.formplugin.org.OrgTreeEditPlugin;

public class OrgTreeController {
    private static final String LEFT_TREE = "left_tree";
    private static final String RIGHT_TREE = "right_tree";

    public static void initTree(AbstractFormPlugin than, String tree) {
        TreeNode rootNode = TreeUtils.getROOT();
        TreeView treeRight = (TreeView)than.getView().getControl(tree);
        Map orgMap = BusinessDataServiceHelper.loadFromCache((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bdm_org"), null);
        ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>(orgMap.size());
        Set entries = orgMap.entrySet();
        for (Map.Entry ent : entries) {
            nodeList.add(OrgTreeController.buildTreeNode((DynamicObject)ent.getValue()));
        }
        List roots = TreeUtils.findRoot(nodeList);
        for (TreeNode root : roots) {
            TreeUtils.findChildren((TreeNode)root, nodeList);
            rootNode.addChild(root);
        }
        treeRight.addNode(rootNode);
        rootNode.setIsOpened(true);
        rootNode.setId("-1");
        TreeUtils.putCache((IPageCache)than.getPageCache(), (String)tree, (Object)rootNode);
    }

    public static List<TreeNode> getLeftSelectNode(AbstractFormPlugin than, String rightFocusId) {
        TreeView leftTreeView = (TreeView)than.getView().getControl(LEFT_TREE);
        TreeNode leftRoot = TreeUtils.getCache((IPageCache)than.getPageCache(), (String)LEFT_TREE);
        TreeNode rightRoot = TreeUtils.getCache((IPageCache)than.getPageCache(), (String)RIGHT_TREE);
        List selectIds = leftTreeView.getTreeState().getSelectedNodeId();
        HashSet idSet = Sets.newHashSet((Iterable)selectIds);
        ArrayList<TreeNode> treeNodeList = new ArrayList<TreeNode>(8);
        HashMap parentIdMap = Maps.newHashMap();
        for (String nodeId : idSet) {
            boolean isMove;
            TreeNode treeNode = leftRoot.getTreeNode(nodeId, 20);
            if ("gray".equals(treeNode.getColor()) && !(isMove = OrgTreeController.isMove(treeNode, idSet, leftRoot))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u88ab\u79fb\u52a8", (String)"OrgTreeController_5", (String)"imc-bdm-formplugin", (Object[])new Object[0]), treeNode.getText()));
            }
            parentIdMap.put(nodeId, StringUtils.isBlank((CharSequence)treeNode.getParentid()) ? "" : treeNode.getParentid());
            treeNodeList.add(TreeUtils.copyNode((TreeNode)treeNode));
            if (!nodeId.equals("move_right_tree".concat(nodeId))) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u5df2\u7ecf\u5de6\u79fb\uff0c\u4e0d\u80fd\u91cd\u590d\u64cd\u4f5c\uff0c\u6216\u8005\u91cd\u7f6e\u540e\u79fb\u52a8", (String)"OrgTreeController_6", (String)"imc-bdm-formplugin", (Object[])new Object[0]), treeNode.getText()));
        }
        TreeNode rightSelectNode = rightRoot.getTreeNode(rightFocusId, 20);
        List treeNodes = TreeUtils.getTreeNodes((TreeNode)rightSelectNode, treeNodeList, (Map)parentIdMap);
        HashSet nodeSet = Sets.newHashSetWithExpectedSize((int)8);
        for (TreeNode treeNode : treeNodes) {
            TreeNode treeMode = leftRoot.getTreeNode(treeNode.getId(), 20);
            nodeSet.add(treeNode);
            OrgTreeEditPlugin.findChildrenSize(nodeSet, treeMode);
        }
        if (Sets.newHashSet((Iterable)selectIds).size() != nodeSet.size()) {
            if (0 == nodeSet.size()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u7ed1\u5b9a\u8bbe\u5907\u7ec4\u7ec7\u4e0d\u80fd\u5355\u72ec\u79fb\u52a8", (String)"OrgTreeController_2", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u52fe\u9009\u7236\u8282\u70b9\u65f6\uff0c\u5b50\u8282\u70b9\u5fc5\u987b\u5168\u90e8\u52fe\u9009\uff0c \u8bf7\u68c0\u67e5\u8282\u70b9\u540e\u518d\u64cd\u4f5c", (String)"OrgTreeController_3", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
        }
        if (idSet.contains(rightFocusId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u80fd\u79fb\u5230\u76f8\u540c\u4f4d\u7f6e\u6216\u8005\u76f8\u540c\u4f4d\u7f6e\u5b50\u8282\u70b9", (String)"OrgTreeController_4", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
        }
        for (String nodeId : idSet) {
            TreeUtils.putCache((IPageCache)than.getPageCache(), (String)"move_right_tree".concat(nodeId), (Object)nodeId);
        }
        return treeNodes;
    }

    private static boolean isMove(TreeNode treeNode, Set<String> selectNoId, TreeNode leftRoot) {
        String parentId = treeNode.getParentid();
        if (selectNoId.contains(parentId)) {
            TreeNode parentNode = leftRoot.getTreeNode(parentId, 20);
            if (!"gray".equals(parentNode.getColor())) {
                return true;
            }
            return OrgTreeController.isMove(parentNode, selectNoId, leftRoot);
        }
        return false;
    }

    private static TreeNode buildTreeNode(DynamicObject org) {
        TreeNode node = new TreeNode();
        String number = org.getString("number");
        String name = org.getString("name");
        String enterpriseMainOrg = org.getString("enterprisemainorg");
        String taxNo = org.getString("epinfo.number");
        boolean isEdit = false;
        DynamicObject[] equipments = EquipmentUtil.getEquipmentDynamicObjectsByOrg((DynamicObject)org);
        if ("1".equals(enterpriseMainOrg)) {
            isEdit = true;
        } else if (null == taxNo && equipments.length < 1) {
            isEdit = true;
        }
        node.setId(org.getString("id"));
        if (org.get("parent") instanceof DynamicObject) {
            node.setParentid(org.getDynamicObject("parent").getString("id"));
        } else {
            node.setParentid(org.getString("parent"));
        }
        node.setText(number + "_" + name);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("id", node.getId());
        data.put("number", number);
        data.put("name", name);
        data.put("status", org.getString("status"));
        data.put("enterprisemainorg", enterpriseMainOrg);
        data.put("taxNo", taxNo);
        data.put("isEdit", enterpriseMainOrg);
        if (!isEdit) {
            node.setColor("gray");
        }
        data.put("color", node.getColor());
        node.setData(data);
        return node;
    }

    public static Map<String, DynamicObject> queryExistsOrg() {
        try (DataSet ds = ORM.create().queryDataSet("BusinessDataServiceHelper.load", "bdm_org_tree_list", "id", null);){
            ArrayList idList = new ArrayList();
            ds.forEach(row -> idList.add(row.get(0)));
            DynamicObject[] orgList = BusinessDataServiceHelper.load((Object[])idList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bdm_org_tree_list"));
            Map<String, DynamicObject> map = Stream.of(orgList).collect(Collectors.toMap(k -> k.getString("id"), v -> v, (v1, v2) -> v2));
            return map;
        }
    }

    public static void submitClick(AbstractFormPlugin than) {
        TreeNode rightRoot = TreeUtils.getCache((IPageCache)than.getPageCache(), (String)RIGHT_TREE);
        List rightNodeIds = TreeUtils.getNodeIdList((TreeNode)rightRoot);
        Map<String, DynamicObject> existsOrgMap = OrgTreeController.queryExistsOrg();
        ArrayList<String> existOrgIds = new ArrayList<String>(existsOrgMap.keySet());
        List deleteOrgIds = existOrgIds.stream().filter(o -> !rightNodeIds.contains(o)).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(deleteOrgIds)) {
            DeleteServiceHelper.delete((String)"bdm_org_tree_list", (QFilter[])new QFilter("id", "in", (Object)deleteOrgIds.stream().map(Long::parseLong).toArray()).toArray());
        }
        ArrayList<DynamicObject> insertList = new ArrayList<DynamicObject>();
        LevelTreeNode levelTreeNode = new LevelTreeNode(Long.valueOf(0L), rightRoot);
        OrgImportPlugin.parseSaveData(insertList, levelTreeNode, null, existsOrgMap, "");
        if (insertList.size() != 0) {
            ImcSaveServiceHelper.save(insertList);
        }
        than.getView().returnDataToParent((Object)"refresh");
        than.getView().close();
    }

    private static void deleteShareInfo(List<String> orgIds) {
    }
}

