/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.org;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.imc.bdm.common.constant.CommonConstant;
import kd.imc.bdm.common.constant.ConfirmationEnum;
import kd.imc.bdm.common.constant.EnterpriseConstant;
import kd.imc.bdm.common.constant.EnterpriseQualificationEnum;
import kd.imc.bdm.common.constant.EquipmentType;
import kd.imc.bdm.common.constant.ImcPermItemEnum;
import kd.imc.bdm.common.constant.table.EnterPriseBaseInfoConstant;
import kd.imc.bdm.common.helper.ExcelHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.PermissionHelper;
import kd.imc.bdm.common.message.model.MsgResponse;
import kd.imc.bdm.common.model.FileField;
import kd.imc.bdm.common.plugin.AbstractImportPlugin;
import kd.imc.bdm.common.service.CAService;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.EquipmentUtil;
import kd.imc.bdm.common.util.GBKUtils;
import kd.imc.bdm.common.util.InputPermissionUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.TaxUtils;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;

public class OrgUpdateImportPlugin
extends AbstractImportPlugin {
    private static final String TEMPLATE_DIR = "templates";
    private static final String TEMPLATE_JSON_NAME = "orgImport.json";
    public static final String TEMPLATE_NAME = "\u4f01\u4e1a\u4fe1\u606f\u5bfc\u5165\u6a21\u677f.xlsx";
    private static final Log LOGGER = LogFactory.getLog(OrgUpdateImportPlugin.class);
    public static final String REGEX = "\\w{15}$|\\w{17}$|\\w{18}$|\\w{20}$";
    public static final String CACHE_KEY_FILE = "bdm.org.import.file.name.";
    public static final String CACHE_KEY_TAX_NO = "bdm.org.import.epinfo.taxno";

    public static final String getNULL_DATA_TIS() {
        return ResManager.loadKDString((String)"\u8bf7\u586b\u5145\u6570\u636e\u518d\u5f15\u5165", (String)"OrgUpdateImportPlugin_0", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"filepanel"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void uploadFile(String filepath, InputStream inputStream, Workbook workbook) {
        File file = new File(filepath);
        String fileName = file.getName();
        DLock fileLock = this.checkDoing(CACHE_KEY_FILE + fileName);
        LOGGER.info("\u3010\u4f01\u4e1a\u6279\u91cf\u5bfc\u5165\u3011\u63a5\u6536\u5230\u6587\u4ef6\u3010{}\u3011\u7684\u8bf7\u6c42\uff0c\u5f00\u59cb\u5904\u7406", (Object)fileName);
        if (fileLock == null) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u76f8\u540c\u540d\u79f0\u7684\u6587\u4ef6\u3010%s\u3011\u6b63\u5728\u5904\u7406\uff0c\u8bf7\u7a0d\u5019\u518d\u8bd5", (String)"OrgUpdateImportPlugin_30", (String)"imc-bdm-formplugin", (Object[])new Object[0]), fileName), CommonConstant.SHOW_TIPNOTIFICATION_TIME);
            return;
        }
        PermissionHelper.checkPermission((String)"bdm", (String)"bdm_org", (ImcPermItemEnum)ImcPermItemEnum.BDM_ORG_BATCH_IMPORT);
        String suffix = filepath.substring(filepath.lastIndexOf(46));
        String errFileName = ExcelHelper.getErrorExcelFileName((String)filepath, (String)suffix);
        try {
            if (ExcelHelper.isExcelFile((String)suffix)) {
                int startRow = 2;
                int dataNum = workbook.getSheetAt(0).getLastRowNum() - startRow + 1;
                if (dataNum < 1) {
                    this.getView().showTipNotification(OrgUpdateImportPlugin.getNULL_DATA_TIS(), CommonConstant.SHOW_TIPNOTIFICATION_TIME);
                    return;
                }
                if (dataNum > 5000) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e00\u6b21\u6700\u591a\u5f15\u51655000\u4e2a\u4f01\u4e1a\u4fe1\u606f", (String)"OrgUpdateImportPlugin_16", (String)"imc-bdm-formplugin", (Object[])new Object[0]), CommonConstant.SHOW_TIPNOTIFICATION_TIME);
                    return;
                }
                List fileFields = ExcelHelper.getFileFields((Row)workbook.getSheetAt(0).getRow(startRow - 1), (List)ExcelHelper.readTemplate((String)TEMPLATE_DIR, (String)TEMPLATE_JSON_NAME));
                Map<String, FileField> fieldMap = fileFields.stream().collect(Collectors.toMap(FileField::getFieldCode, t -> t, (v1, v2) -> v1));
                ConcurrentHashMap<String, String> errMap = new ConcurrentHashMap<String, String>(dataNum >> 1);
                List list = ExcelHelper.doParse((Workbook)workbook, (List)fileFields, (int)startRow, (boolean)true, errMap);
                if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)list)) {
                    this.getView().showTipNotification(OrgUpdateImportPlugin.getNULL_DATA_TIS(), CommonConstant.SHOW_TIPNOTIFICATION_TIME);
                    return;
                }
                this.fillInData(list);
                Map<String, Object> returnMap = this.checkOriginalBill(list, fieldMap, errMap);
                int successSize = Integer.parseInt(returnMap.get("successSize").toString());
                if (successSize != list.size() || !CollectionUtils.isEmpty(errMap)) {
                    ExcelHelper.showErrorResult((Workbook)workbook, (int)list.size(), (int)successSize, errMap, (String)errFileName, (AbstractFormPlugin)this, (String)"sim_original_bill_import", (String)"sim_inv_import_result");
                } else {
                    super.resetFile();
                    this.getView().returnDataToParent((Object)"refresh");
                    this.getView().close();
                }
            }
        }
        catch (Exception e) {
            this.getView().showErrorNotification(StringUtils.isBlank((CharSequence)e.getMessage()) ? e.toString() : e.getMessage());
            LOGGER.error("\u3010\u4f01\u4e1a\u6279\u91cf\u5bfc\u5165\u3011\u7ec4\u7ec7\u5bfc\u5165\u51fa\u9519", (Throwable)e);
        }
        finally {
            LOGGER.info("\u3010\u4f01\u4e1a\u6279\u91cf\u5bfc\u5165\u3011\u6587\u4ef6\u3010{}\u3011\u5904\u7406\u7ed3\u675f", (Object)fileName);
            fileLock.unlock();
        }
    }

    private DLock checkDoing(String key) {
        DLock lock = DLock.create((String)key);
        if (!lock.tryLock(1000L)) {
            lock = null;
            LOGGER.info("\u3010\u4f01\u4e1a\u6279\u91cf\u5bfc\u5165\u3011\u6570\u636e\u3010{}\u3011\u6b63\u5728\u5904\u7406\uff0c\u8bf7\u7a0d\u5019\u518d\u8bd5", (Object)key);
        }
        return lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> checkOriginalBill(List<Map<String, Object>> list, Map<String, FileField> fieldMap, Map<String, String> errMap) {
        Map orgListMap = list.stream().collect(Collectors.groupingBy(map -> (String)map.get("number"), LinkedHashMap::new, Collectors.toList()));
        Map<String, DynamicObject> orgMap = this.loadOrg(list);
        Set entries = orgListMap.entrySet();
        AtomicLong successSize = new AtomicLong(0L);
        int rowIndex = 3;
        int execIndex = 1;
        int totalNum = entries.size();
        for (Map.Entry orgs : entries) {
            HashMap orgMapTemp = Maps.newHashMap();
            String taxNo = (String)((Map)((List)orgs.getValue()).get(0)).get("epinfo.number");
            LOGGER.info("\u3010\u4f01\u4e1a\u6279\u91cf\u5bfc\u5165\u3011\u5904\u7406\u8fdb\u5ea6: \u603b\u6570{},\u5f53\u524d\u5904\u7406\u7b2c{}\u6761\uff0c\u7a0e\u53f7{}", new Object[]{totalNum, execIndex, taxNo});
            for (Map org : (List)orgs.getValue()) {
                boolean checkFlag = true;
                this.checkNull(orgMapTemp, org, fieldMap.get("name"));
                this.checkNull(orgMapTemp, org, fieldMap.get("number"));
                this.checkNull(orgMapTemp, org, fieldMap.get("epinfo.name"));
                this.checkNull(orgMapTemp, org, fieldMap.get("epinfo.number"));
                this.checkNull(orgMapTemp, org, fieldMap.get("epinfo.addr"));
                this.checkNull(orgMapTemp, org, fieldMap.get("epinfo.openuserbank"));
                String currTaxNo = (String)org.get("epinfo.number");
                DLock dataLock = this.checkDoing(CACHE_KEY_TAX_NO + taxNo);
                try {
                    String publicPerson;
                    String currOrgName;
                    String number;
                    if (dataLock == null) {
                        checkFlag = false;
                        String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u6b63\u5728\u5904\u7406\uff0c\u8bf7\u7a0d\u5019\u518d\u8bd5", (String)"OrgUpdateImportPlugin_1", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
                        ExcelHelper.setErrorMessage((Row)((Row)org.get("row")), (FileField)fieldMap.get("epinfo.number"), (String)errorMsg, (Map)orgMapTemp);
                    }
                    if (StringUtils.isBlank((CharSequence)(number = (String)org.get("number")))) {
                        checkFlag = false;
                        ExcelHelper.setErrorMessage((Row)((Row)org.get("row")), (FileField)fieldMap.get("number"), (String)ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (String)"OrgUpdateImportPlugin_18", (String)"imc-bdm-formplugin", (Object[])new Object[0]), (Map)orgMapTemp);
                    }
                    DynamicObject currOrg = orgMap.get(number);
                    if (!Pattern.matches(REGEX, taxNo)) {
                        checkFlag = false;
                    }
                    if (!taxNo.equals(currTaxNo)) {
                        checkFlag = false;
                        ExcelHelper.setErrorMessage((Row)((Row)org.get("row")), (FileField)fieldMap.get("epinfo.number"), (String)ResManager.loadKDString((String)"\u76f8\u540c\u7ec4\u7ec7\u7f16\u53f7\uff0c\u7a0e\u53f7\u5fc5\u987b\u76f8\u540c", (String)"OrgUpdateImportPlugin_19", (String)"imc-bdm-formplugin", (Object[])new Object[0]), (Map)orgMapTemp);
                    }
                    if (null == currOrg && StringUtils.isNotBlank((CharSequence)number)) {
                        checkFlag = false;
                        ExcelHelper.setErrorMessage((Row)((Row)org.get("row")), (FileField)fieldMap.get("number"), (String)String.format(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u7f16\u53f7[%s]\u672a\u5f15\u5165\u5230\u53d1\u7968\u4e91\u4f01\u4e1a\u4fe1\u606f\u8868\u4e2d\uff0c\u8bf7\u5148\u524d\u5f80\u53d1\u7968\u4e91\uff0c\u57fa\u7840\u8d44\u6599\uff0c\u4f01\u4e1a\u7ba1\u7406\u5f15\u5165\u7ec4\u7ec7\u3002", (String)"OrgUpdateImportPlugin_20", (String)"imc-bdm-formplugin", (Object[])new Object[0]), org.get("number")), (Map)orgMapTemp);
                    }
                    String name = (String)org.get("name");
                    if (currOrg != null && !name.equals(currOrgName = currOrg.getString("name"))) {
                        checkFlag = false;
                        ExcelHelper.setErrorMessage((Row)((Row)org.get("row")), (FileField)fieldMap.get("name"), (String)String.format(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u540d\u79f0[%s]\u4e0e\u7cfb\u7edf\u7684\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"OrgUpdateImportPlugin_32", (String)"imc-bdm-formplugin", (Object[])new Object[0]), org.get("name")), (Map)orgMapTemp);
                    }
                    if (currOrg != null && checkFlag) {
                        boolean bl = checkFlag = !this.checkRepeat(currOrg, org, fieldMap, orgMapTemp);
                    }
                    if (GBKUtils.getGBKLength((String)(publicPerson = (String)org.get("publicperson"))) > 16) {
                        checkFlag = false;
                        ExcelHelper.setErrorMessage((Row)((Row)org.get("row")), (FileField)fieldMap.get("publicperson"), (String)String.format(ResManager.loadKDString((String)"\u6cd5\u4eba\u540d\u79f0[%s]\u957f\u5ea6\u8d85\u957f,\u4e0d\u80fd\u8d85\u8fc716\u4e2a\u5b57", (String)"OrgUpdateImportPlugin_33", (String)"imc-bdm-formplugin", (Object[])new Object[0]), org.get("publicperson")), (Map)orgMapTemp);
                    }
                    String specifications = (String)org.get("specifications");
                    if (EnterpriseQualificationEnum.TOBACCO_PRODUCE.getCode().equals(specifications) || EnterpriseQualificationEnum.TOBACCO_WHOLESALE.getCode().equals(specifications)) {
                        Object startTime = org.get("tobaccoexpirestarttime");
                        Object endTime = org.get("tobaccoexpireendtime");
                        if (StringUtils.isBlank(startTime)) {
                            checkFlag = false;
                            ExcelHelper.setErrorMessage((Row)((Row)org.get("row")), (FileField)fieldMap.get("tobaccoexpirestarttime"), (String)ResManager.loadKDString((String)"\u4f01\u4e1a\u8d44\u8d28\u4e3a\u5377\u70df\u4f01\u4e1a\u65f6\uff0c\u4f01\u4e1a\u5f00\u59cb\u65f6\u95f4\u5fc5\u586b", (String)"OrgUpdateImportPlugin_35", (String)"imc-bdm-formplugin", (Object[])new Object[0]), (Map)orgMapTemp);
                        }
                        if (StringUtils.isBlank(endTime)) {
                            checkFlag = false;
                            ExcelHelper.setErrorMessage((Row)((Row)org.get("row")), (FileField)fieldMap.get("tobaccoexpireendtime"), (String)ResManager.loadKDString((String)"\u4f01\u4e1a\u8d44\u8d28\u4e3a\u5377\u70df\u4f01\u4e1a\u65f6\uff0c\u4f01\u4e1a\u7ed3\u675f\u65f6\u95f4\u5fc5\u586b", (String)"OrgUpdateImportPlugin_36", (String)"imc-bdm-formplugin", (Object[])new Object[0]), (Map)orgMapTemp);
                        }
                    }
                    String issueChannel = (String)org.get("issuechannel");
                    String authType = (String)org.get("authtype");
                    if (EnterpriseConstant.IssueChannelEnum.NATURAL_SYSTEM_AUTH.getCode().equals(issueChannel) || EnterpriseConstant.AuthTypeEnum.NATURAL_SYSTEM_AUTH.getCode().equals(authType)) {
                        DynamicObject epInfo;
                        QFilter qFilter;
                        String leqiId = (String)org.get("leqiid");
                        String enterpriseRole = (String)org.get("enterpriserole");
                        if (StringUtils.isEmpty((CharSequence)enterpriseRole)) {
                            checkFlag = false;
                            ExcelHelper.setErrorMessage((Row)((Row)org.get("row")), (FileField)fieldMap.get("enterpriserole"), (String)ResManager.loadKDString((String)"\u6570\u7535\u5f00\u7968\u6e20\u9053\u6216\u8005\u6536\u7968\u901a\u9053\u4e3a\u4e50\u4f01\u5e73\u53f0\u65f6\uff0c\u4f01\u4e1a\u89d2\u8272\u5fc5\u586b", (String)"OrgUpdateImportPlugin_37", (String)"imc-bdm-formplugin", (Object[])new Object[0]), (Map)orgMapTemp);
                        }
                        if (StringUtils.isEmpty((CharSequence)leqiId)) {
                            checkFlag = false;
                            ExcelHelper.setErrorMessage((Row)((Row)org.get("row")), (FileField)fieldMap.get("leqiid"), (String)ResManager.loadKDString((String)"\u6570\u7535\u5f00\u7968\u6e20\u9053\u6216\u8005\u6536\u7968\u901a\u9053\u4e3a\u4e50\u4f01\u5e73\u53f0\u65f6\uff0c\u4e50\u4f01ID\u5fc5\u586b", (String)"OrgUpdateImportPlugin_38", (String)"imc-bdm-formplugin", (Object[])new Object[0]), (Map)orgMapTemp);
                        }
                        if (EnterpriseConstant.EnterpriseRoleEnum.USER_UNIT.getCode().equals(enterpriseRole)) {
                            String accessTaxNo = (String)org.get("accesstaxno");
                            if (StringUtils.isEmpty((CharSequence)accessTaxNo)) {
                                checkFlag = false;
                                ExcelHelper.setErrorMessage((Row)((Row)org.get("row")), (FileField)fieldMap.get("accesstaxno"), (String)ResManager.loadKDString((String)"\u4f01\u4e1a\u89d2\u8272\u4e3a\u4f7f\u7528\u5355\u4f4d\u65f6\uff0c\u63a5\u5165\u5355\u4f4d\u7a0e\u53f7\u5fc5\u586b", (String)"OrgUpdateImportPlugin_39", (String)"imc-bdm-formplugin", (Object[])new Object[0]), (Map)orgMapTemp);
                            } else {
                                qFilter = new QFilter("number", "=", (Object)accessTaxNo).and("enterpriserole", "=", (Object)"1");
                                epInfo = BusinessDataServiceHelper.loadSingle((String)"bdm_enterprise_baseinfo", (String)"number", (QFilter[])qFilter.toArray());
                                if (epInfo == null) {
                                    checkFlag = false;
                                    ExcelHelper.setErrorMessage((Row)((Row)org.get("row")), (FileField)fieldMap.get("accesstaxno"), (String)ResManager.loadKDString((String)"\u8be5\u5bf9\u5e94\u63a5\u5165\u5355\u4f4d\u7a0e\u53f7\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165", (String)"OrgUpdateImportPlugin_40", (String)"imc-bdm-formplugin", (Object[])new Object[0]), (Map)orgMapTemp);
                                } else {
                                    org.put("accessepinfo", epInfo.getPkValue());
                                    org.put("leqisecret", "");
                                }
                            }
                        } else if (EnterpriseConstant.EnterpriseRoleEnum.ACCESS_UNIT.getCode().equals(enterpriseRole)) {
                            String leiqiSecret = (String)org.get("leqisecret");
                            if (StringUtils.isEmpty((CharSequence)leiqiSecret)) {
                                checkFlag = false;
                                ExcelHelper.setErrorMessage((Row)((Row)org.get("row")), (FileField)fieldMap.get("leqisecret"), (String)ResManager.loadKDString((String)"\u4f01\u4e1a\u89d2\u8272\u4e3a\u63a5\u5165\u5355\u4f4d\u65f6\uff0c\u4e50\u4f01\u79d8\u94a5\u5fc5\u586b", (String)"OrgUpdateImportPlugin_41", (String)"imc-bdm-formplugin", (Object[])new Object[0]), (Map)orgMapTemp);
                            } else {
                                qFilter = new QFilter("leqiid", "=", (Object)leqiId).and("enterpriserole", "=", (Object)"1");
                                epInfo = BusinessDataServiceHelper.loadSingle((String)"bdm_enterprise_baseinfo", (String)"number", (QFilter[])qFilter.toArray());
                                if (epInfo != null && !epInfo.getString("number").equals(taxNo)) {
                                    checkFlag = false;
                                    ExcelHelper.setErrorMessage((Row)((Row)org.get("row")), (FileField)fieldMap.get("leqiid"), (String)ResManager.loadKDString((String)"\u8be5\u4e50\u4f01id\u5df2\u5b58\u5728\u5bf9\u5e94\u63a5\u5165\u4f01\u4e1a\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165", (String)"OrgUpdateImportPlugin_42", (String)"imc-bdm-formplugin", (Object[])new Object[0]), (Map)orgMapTemp);
                                } else {
                                    org.put("accessepinfo", 0);
                                }
                            }
                        }
                    }
                    if (!kd.bos.entity.plugin.support.util.CollectionUtils.isEmpty((Map)orgMapTemp)) {
                        checkFlag = false;
                        errMap.putAll(orgMapTemp);
                    }
                    if (checkFlag) {
                        try {
                            DynamicObject orgDB = orgMap.get(number);
                            this.updateOrg(currOrg, org);
                            this.updateTitle(org);
                            InputPermissionUtils.savePermission((Long)orgDB.getLong("id"));
                            successSize.getAndAdd(1L);
                        }
                        catch (KDBizException e) {
                            errMap.put(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c", (String)"OrgUpdateImportPlugin_28", (String)"imc-bdm-formplugin", (Object[])new Object[0]), rowIndex), e.getMessage());
                        }
                    }
                    LOGGER.info("\u3010\u4f01\u4e1a\u6279\u91cf\u5bfc\u5165\u3011\u5904\u7406\u8fdb\u5ea6: \u603b\u6570{},\u7b2c{}\u6761\uff0c\u7a0e\u53f7{}\u5904\u7406\u7ed3\u675f\uff0c\u51c6\u5907\u5904\u7406\u4e0b\u4e00\u6761", new Object[]{totalNum, execIndex, taxNo});
                }
                finally {
                    if (dataLock != null) {
                        dataLock.unlock();
                    }
                }
                ++rowIndex;
            }
            ++execIndex;
        }
        HashMap returnMap = Maps.newHashMapWithExpectedSize((int)2);
        returnMap.put("successSize", successSize.intValue());
        return returnMap;
    }

    private void updateTitle(Map<String, Object> org) {
        Object taxNo = org.get("epinfo.number");
        Object addr = org.get("epinfo.addr");
        Object bank = org.get("epinfo.openuserbank");
        QFilter qFilter = new QFilter("taxno", "=", taxNo).and(new QFilter("invoiceaddr", "=", addr)).and(new QFilter("openuserbank", "=", bank));
        DynamicObject[] invoiceSettings = BusinessDataServiceHelper.load((String)"sim_invoice_setting", (String)"invoiceaddr,openuserbank", (QFilter[])qFilter.toArray());
        if (null == invoiceSettings || invoiceSettings.length == 0) {
            DynamicObject titleSetting = this.createTitleSetting(taxNo, addr, bank);
            ImcSaveServiceHelper.save((DynamicObject)titleSetting);
        }
    }

    private DynamicObject createTitleSetting(Object taxNo, Object addrtel, Object bankaccount) {
        DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"sim_invoice_setting");
        obj.set("invoiceaddr", addrtel);
        obj.set("openuserbank", bankaccount);
        obj.set("taxno", taxNo);
        obj.set("ischeck", (Object)"0");
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateOrg(DynamicObject orgDb, Map<String, Object> orgMap) {
        DynamicObject equipment;
        String companyProperty;
        QFilter qFilter;
        DynamicObject taxCityObject;
        String taxCity;
        QFilter qFilter2;
        DynamicObject countryAreaObject;
        long globalLongId;
        DynamicObject epBaseInfo = (DynamicObject)orgDb.get("epinfo");
        DynamicObject epInfo = TaxUtils.getEpInfoByOrg((DynamicObject)orgDb);
        if (Objects.isNull(epBaseInfo)) {
            epBaseInfo = BusinessDataServiceHelper.newDynamicObject((String)"bdm_enterprise_baseinfo");
            globalLongId = DBServiceHelper.genGlobalLongId();
            epBaseInfo.set("id", (Object)globalLongId);
            orgDb.set("epinfo", (Object)epBaseInfo);
            orgDb.set("enterprisemainorg", (Object)"1");
        } else {
            epBaseInfo = BusinessDataServiceHelper.loadSingle((Object)DynamicObjectUtil.getDynamicObjectLongValue((Object)epBaseInfo), (String)"bdm_enterprise_baseinfo");
        }
        if (Objects.isNull(epInfo)) {
            globalLongId = DBServiceHelper.genGlobalLongId();
            epInfo = BusinessDataServiceHelper.newDynamicObject((String)"bdm_enterprise_info");
            epInfo.set("id", (Object)globalLongId);
            epInfo.set("epinfo", (Object)epBaseInfo);
        }
        if (!this.checkIsPermission(epBaseInfo)) {
            epBaseInfo.set("number", orgMap.get("epinfo.number"));
            epBaseInfo.set("name", orgMap.get("epinfo.name"));
        }
        epBaseInfo.set("isvoucher", orgMap.get("isvoucher"));
        epBaseInfo.set("check_type", orgMap.get("check_type"));
        epBaseInfo.set("authtype", orgMap.get("authtype"));
        epBaseInfo.set("issuechannel", orgMap.get("issuechannel"));
        epBaseInfo.set("enterpriserole", orgMap.get("enterpriserole"));
        epBaseInfo.set("leqiid", orgMap.get("leqiid"));
        epBaseInfo.set("leqisecret", orgMap.get("leqisecret"));
        epBaseInfo.set("publicperson", orgMap.get("publicperson"));
        epBaseInfo.set("accessepinfo", orgMap.get("accessepinfo"));
        String countryArea = (String)orgMap.get("country_area");
        if (StringUtils.isNotBlank((CharSequence)countryArea) && (countryAreaObject = BusinessDataServiceHelper.loadSingle((String)"bd_country", (QFilter[])(qFilter2 = new QFilter("name", "=", (Object)countryArea)).toArray())) != null) {
            epBaseInfo.set("country_area", (Object)countryAreaObject);
        }
        if (StringUtils.isNotBlank((CharSequence)(taxCity = (String)orgMap.get("tax_city"))) && (taxCityObject = BusinessDataServiceHelper.loadSingle((String)"bdm_tax_city_info", (QFilter[])(qFilter = new QFilter("name", "=", (Object)taxCity)).toArray())) != null) {
            epBaseInfo.set("tax_city", (Object)taxCityObject);
        }
        if (StringUtils.isNotBlank((CharSequence)(companyProperty = (String)orgMap.get("company_property")))) {
            int propertyCode = EnterPriseBaseInfoConstant.CompanyProperty.getPropertyCodeMethod((String)companyProperty);
            epBaseInfo.set("company_property", (Object)propertyCode);
        }
        try {
            epBaseInfo.set("org", orgDb.getPkValue());
        }
        catch (Exception propertyCode) {
            // empty catch block
        }
        epInfo.set("tobaccoexpirestarttime", (Object)DateUtils.stringToDate((String)((String)orgMap.get("tobaccoexpirestarttime"))));
        epInfo.set("tobaccoexpireendtime", (Object)DateUtils.stringToDate((String)((String)orgMap.get("tobaccoexpireendtime"))));
        String devNo = (String)orgMap.get("defaultdev");
        if (StringUtils.isNotBlank((CharSequence)devNo) && (equipment = EquipmentUtil.getEquipmentDynamicObjectByDevNo((String)devNo, (String)epBaseInfo.getString("number"))) != null) {
            orgDb.set("defaultdev", equipment.getPkValue());
        }
        String specifications = (String)orgMap.get("specifications");
        epInfo.set("tobaccomark", (Object)specifications);
        boolean success = true;
        try (TXHandle tx = TX.required();){
            ImcSaveServiceHelper.save((DynamicObject)epBaseInfo);
            ImcSaveServiceHelper.save((DynamicObject)epInfo);
            ImcSaveServiceHelper.save((DynamicObject)orgDb);
        }
        if (success) {
            this.createCA(epBaseInfo);
        }
    }

    private void createCA(DynamicObject epBaseInfo) {
        try {
            String caStatus = epBaseInfo.getString("castatus");
            String publicPerson = epBaseInfo.getString("publicperson");
            if (!"1".equals(caStatus) && StringUtils.isNotBlank((CharSequence)publicPerson)) {
                String taxNo = epBaseInfo.getString("number");
                String epName = epBaseInfo.getString("name");
                MsgResponse response = CAService.caApply((String)epName, (String)taxNo, (String)publicPerson);
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("\u3010\u4f01\u4e1a\u6279\u91cf\u5bfc\u5165\u3011CA\u7533\u8bf7\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)response));
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("\u3010\u4f01\u4e1a\u6279\u91cf\u5bfc\u5165\u3011\u7533\u8bf7CA\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
    }

    private boolean checkIsPermission(DynamicObject baseEp) {
        if (baseEp == null) {
            return false;
        }
        QFilter qFilter = new QFilter("epinfo", "=", baseEp.getPkValue());
        DynamicObject permission = BusinessDataServiceHelper.loadSingle((String)"bdm_invoice_permission", (String)"authstate", (QFilter[])qFilter.toArray());
        return permission != null && "1".equals(permission.getString("authstate"));
    }

    private boolean checkIsEdit(DynamicObject dynamicObject) {
        DynamicObject[] equipmentDynamicObjectList = EquipmentUtil.getEquipmentDynamicObjectsByOrg((DynamicObject)dynamicObject);
        if (equipmentDynamicObjectList != null && equipmentDynamicObjectList.length > 0) {
            for (DynamicObject equipment : equipmentDynamicObjectList) {
                String equipmentAuth = equipment.getString("authstatus");
                if (!"1".equals(equipmentAuth)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean checkRepeat(DynamicObject currOrg, Map<String, Object> org, Map<String, FileField> fieldMap, Map<String, String> orgMapTemp) {
        DynamicObject otherEp;
        boolean baseInfoChange;
        String epName = (String)org.get("epinfo.name");
        String taxNo = (String)org.get("epinfo.number");
        String orgEpName = currOrg.getString("epinfo.name");
        String orgTaxNo = currOrg.getString("epinfo.number");
        String number = (String)org.get("number");
        boolean bl = baseInfoChange = epName.equals(orgEpName) && taxNo.equals(orgTaxNo);
        if (!baseInfoChange && (otherEp = this.checkBindOtherEp(number, taxNo, epName)) != null) {
            FileField epNameField = fieldMap.get("epinfo.name");
            FileField taxNoField = fieldMap.get("epinfo.number");
            ExcelHelper.setEpRepeatErrorMessage((Row)((Row)org.get("row")), (String)String.format(ResManager.loadKDString((String)"\u4f01\u4e1a\u7684\u540d\u79f0\u6216\u8005\u7a0e\u53f7\u5df2\u7ed1\u5b9a\u7ec4\u7ec7[%s]\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u5bfc\u5165", (String)"OrgUpdateImportPlugin_43", (String)"imc-bdm-formplugin", (Object[])new Object[0]), otherEp.getString("name")), orgMapTemp, (int)(epNameField.getColIndex() - 1), (int)(taxNoField.getColIndex() - 1), (String)(epNameField.getFieldOrder() + "|" + taxNoField.getFieldOrder()));
            return true;
        }
        if (StringUtils.isNotEmpty((CharSequence)orgEpName) && StringUtils.isNotEmpty((CharSequence)orgTaxNo) && this.checkIsPermission(currOrg.getDynamicObject("epinfo"))) {
            if (!taxNo.equals(orgTaxNo)) {
                ExcelHelper.setErrorMessage((Row)((Row)org.get("row")), (FileField)fieldMap.get("epinfo.number"), (String)String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u5df2\u7ed1\u5b9a\u7a0e\u53f7[%s]\u3002", (String)"OrgUpdateImportPlugin_44", (String)"imc-bdm-formplugin", (Object[])new Object[0]), org.get("epinfo.number")), orgMapTemp);
                return true;
            }
            if (!epName.equals(orgEpName)) {
                ExcelHelper.setErrorMessage((Row)((Row)org.get("row")), (FileField)fieldMap.get("epinfo.name"), (String)String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u5df2\u7ed1\u5b9a\u4f01\u4e1a[%s]\u3002", (String)"OrgUpdateImportPlugin_45", (String)"imc-bdm-formplugin", (Object[])new Object[0]), org.get("epinfo.name")), orgMapTemp);
                return true;
            }
        }
        return false;
    }

    private DynamicObject checkBindOtherEp(String number, String taxNo, String epName) {
        QFilter qFilter = new QFilter("epinfo.number", "=", (Object)taxNo);
        qFilter.or("epinfo.name", "=", (Object)epName);
        QFilter nFilter = new QFilter("number", "!=", (Object)number);
        return BusinessDataServiceHelper.loadSingle((String)"bdm_org", (String)"name", (QFilter[])new QFilter[]{qFilter, nFilter});
    }

    private Map<String, DynamicObject> loadOrg(List<Map<String, Object>> list) {
        HashSet numberSet = Sets.newHashSetWithExpectedSize((int)list.size());
        for (Map<String, Object> map : list) {
            String number = (String)map.get("number");
            numberSet.add(number);
        }
        QFilter qFilter = new QFilter("number", "in", (Object)numberSet);
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"bdm_org", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_org", (boolean)true), (QFilter[])qFilter.toArray());
        if (load.length == 0) {
            return Maps.newHashMap();
        }
        return Arrays.stream(load).collect(Collectors.toMap(k -> k.getString("number"), v -> v, (v1, v2) -> v2));
    }

    private void fillInData(List<Map<String, Object>> list) {
        for (Map<String, Object> map : list) {
            String specifications;
            EnterpriseQualificationEnum enterpriseQualification;
            String equipmenttype = (String)map.get("equipmenttype");
            if (StringUtils.isNotBlank((CharSequence)equipmenttype)) {
                equipmenttype = EquipmentType.getCodeByName((String)equipmenttype);
                map.put("equipmenttype", equipmenttype);
                if (StringUtils.isBlank((CharSequence)equipmenttype)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bbe\u5907\u7c7b\u578b\u4e0d\u6b63\u786e", (String)"OrgUpdateImportPlugin_27", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
                }
            }
            map.put("specifications", Objects.isNull(enterpriseQualification = EnterpriseQualificationEnum.getByName((String)(specifications = (String)map.get("specifications")))) ? "0" : enterpriseQualification.getCode());
            String isVoucher = (String)map.get("isvoucher");
            ConfirmationEnum confirmationEnum = ConfirmationEnum.getByDesc((String)isVoucher);
            map.put("isvoucher", Objects.isNull(confirmationEnum) ? ConfirmationEnum.NO.getValue() : confirmationEnum.getValue());
            String checkType = (String)map.get("check_type");
            EnterpriseConstant.CheckTypeEnum checkTypEnum = EnterpriseConstant.CheckTypeEnum.getByName((String)checkType);
            map.put("check_type", Objects.isNull(checkTypEnum) ? ConfirmationEnum.YES.getValue() : checkTypEnum.getCode());
            String authType = (String)map.get("authtype");
            EnterpriseConstant.AuthTypeEnum authTypeEnum = EnterpriseConstant.AuthTypeEnum.getByName((String)authType);
            map.put("authtype", Objects.isNull(authTypeEnum) ? "" : authTypeEnum.getCode());
            String issueChannel = (String)map.get("issuechannel");
            EnterpriseConstant.IssueChannelEnum issueChannelEnum = EnterpriseConstant.IssueChannelEnum.getByName((String)issueChannel);
            map.put("issuechannel", Objects.isNull(issueChannelEnum) ? "" : issueChannelEnum.getCode());
            String enterpriseRole = (String)map.get("enterpriserole");
            EnterpriseConstant.EnterpriseRoleEnum enterpriseRoleEnum = EnterpriseConstant.EnterpriseRoleEnum.getByName((String)enterpriseRole);
            map.put("enterpriserole", Objects.isNull(enterpriseRoleEnum) ? "" : enterpriseRoleEnum.getCode());
        }
    }

    protected void downloadTemplate() {
        ExcelHelper.downloadTemplate((AbstractFormPlugin)this, (String)TEMPLATE_DIR, (String)TEMPLATE_NAME);
    }
}

