/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.org.control;

import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.table.EnterPriseBaseInfoConstant;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.model.CompanyInfo;
import kd.imc.bdm.common.service.OpenInvoiceService;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.GBKUtils;
import kd.imc.bdm.formplugin.enterpriseinfo.EnterpriseInfoBindPlugin;
import kd.imc.bdm.lqpt.model.LqEpConfig;
import kd.imc.bdm.lqpt.service.TaxpayerService;

public class OrgEditControl {
    private static final Log log = LogFactory.getLog(OrgEditControl.class);
    private static final String CUSTOM_EVENT = "eventkey";
    public static final String EVENT_QUERY_TITLE = "queryTitle";
    public static final String CUSTOM_VIEW_KEY_QUERY_TITLE = "epnamequery";
    private static final String GBK_LEN_ERR_MSG_TEMPLATE = OrgEditControl.GBK_LEN_ERR_MSG_TEMPLATE();
    public static final String INPUT_NAME = "epname";
    public static final String ELE_SCHEDULE = "eleschedule";
    private static final String CACHE_COMPANY = "cache_company";
    public static final String CURRENT_TAX_NAME = "currentTaxName";
    public static final String CURRENT_TAX_NO = "currentTaxNo";
    public static final String LEQI_ACCESS_TAXNO = "accesstaxno";
    public static final String ACCESS_LEQI_ID = "accessleqiid";

    private static final String GBK_LEN_ERR_MSG_TEMPLATE() {
        return ResManager.loadKDString((String)"%1$s\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7%2$s\uff08\u4e00\u4e2a\u6c49\u5b572\u4e2a\u5b57\u7b26\u957f\u5ea6\uff09", (String)"OrgEditControl_14", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
    }

    public static void sendToCustomViewQueryTitle(AbstractFormPlugin formPlugin, String ars) {
        HashMap<String, Object> showDataMap = new HashMap<String, Object>(4);
        showDataMap.put(CUSTOM_EVENT, EVENT_QUERY_TITLE);
        formPlugin.getPageCache().put(INPUT_NAME, ars);
        OpenInvoiceService openInvoiceService = new OpenInvoiceService();
        List companyInfos = openInvoiceService.queryCompany(ars);
        showDataMap.put("companyInfos", companyInfos);
        HashMap<String, CompanyInfo> map = new HashMap<String, CompanyInfo>(companyInfos.size());
        for (CompanyInfo company : companyInfos) {
            map.put(company.getTaxNo(), company);
        }
        formPlugin.getPageCache().put(CACHE_COMPANY, SerializationUtils.toJsonString(map));
        CustomControl control = (CustomControl)formPlugin.getControl(CUSTOM_VIEW_KEY_QUERY_TITLE);
        showDataMap.put("time", System.currentTimeMillis());
        showDataMap.put("pageId", formPlugin.getView().getPageId());
        control.setData(showDataMap);
    }

    public static void sendToCustomViewDisableView(AbstractFormPlugin formPlugin, boolean enable) {
        if ("0".equals(formPlugin.getPageCache().get("hasAuth"))) {
            CustomControl control = (CustomControl)formPlugin.getControl(CUSTOM_VIEW_KEY_QUERY_TITLE);
            HashMap<String, Object> showDataMap = new HashMap<String, Object>(4);
            showDataMap.put(CUSTOM_EVENT, enable ? "enable_title" : "disable_title");
            showDataMap.put("time", System.currentTimeMillis());
            showDataMap.put("buyername", formPlugin.getPageCache().get(INPUT_NAME));
            showDataMap.put("pageId", formPlugin.getView().getPageId());
            control.setData(showDataMap);
        }
    }

    public static void checkGbkLen(String fieldValue, Integer maxLen, String msg) {
        if (StringUtils.isNotEmpty((CharSequence)fieldValue) && GBKUtils.getGBKLength((String)fieldValue) > maxLen) {
            throw new KDBizException(msg);
        }
    }

    public static void checkTaxName(AbstractFormPlugin formPlugin, String enterPriseName) {
        QFilter nameFilter;
        DynamicObject[] ids;
        if (StringUtils.isBlank((CharSequence)enterPriseName)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5165\u4f01\u4e1a\u540d\u79f0", (String)"OrgEditControl_1", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
        }
        OrgEditControl.checkGbkLen(enterPriseName, 100, String.format(GBK_LEN_ERR_MSG_TEMPLATE, ResManager.loadKDString((String)"\u4f01\u4e1a\u540d\u79f0", (String)"OrgEditControl_2", (String)"imc-bdm-formplugin", (Object[])new Object[0]), 100));
        String currentTaxName = formPlugin.getPageCache().get(CURRENT_TAX_NAME);
        if (!enterPriseName.equals(currentTaxName) && null != (ids = BusinessDataServiceHelper.load((String)"bdm_enterprise_baseinfo", (String)"id", (QFilter[])(nameFilter = new QFilter("name", "=", (Object)enterPriseName)).toArray())) && ids.length > 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u5df2\u88ab\u5176\u4ed6\u7ec4\u7ec7\u7ed1\u5b9a\uff0c\u8bf7\u8f93\u5165\u65b0\u7684\u4f01\u4e1a", (String)"OrgEditControl_15", (String)"imc-bdm-formplugin", (Object[])new Object[0]), enterPriseName));
        }
    }

    public static void checkTaxNo(AbstractFormPlugin formPlugin, String taxNo) {
        QFilter filter;
        DynamicObject[] ids;
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5165\u4f01\u4e1a\u7a0e\u53f7", (String)"OrgEditControl_4", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
        }
        int length = taxNo.length();
        if (length != 15 && length != 16 && length != 17 && length != 18 && length != 20) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7a0e\u53f7\u957f\u5ea6\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165(\u7a0e\u53f7\u957f\u5ea6\u9650\u5236\u4e3a15,17,18,20\u4f4d)", (String)"OrgEditControl_5", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
        }
        String currentTaxNo = formPlugin.getPageCache().get(CURRENT_TAX_NO);
        if (!taxNo.equals(currentTaxNo) && (ids = BusinessDataServiceHelper.load((String)"bdm_org", (String)"id", (QFilter[])(filter = new QFilter("epinfo.number", "=", (Object)taxNo)).toArray())).length > 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u7a0e\u53f7\u5df2\u88ab\u5176\u4ed6\u4f01\u4e1a\u7ed1\u5b9a\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165", (String)"OrgEditControl_6", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
        }
    }

    public static void checkAllEleIssueChannle(AbstractFormPlugin that, DynamicObject enInfoDynamicObject) {
        DynamicObject epInfo;
        QFilter qFilter;
        String alleleissuetype = (String)that.getView().getModel().getValue("issuechannel");
        if (!(EnterPriseBaseInfoConstant.LQPT_CHANNEL.contains((Object)alleleissuetype) || "5".equals(that.getView().getModel().getValue("authtype")) || "7".equals(that.getView().getModel().getValue("authtype")))) {
            return;
        }
        String accessLeQiId = (String)that.getView().getModel().getValue(ACCESS_LEQI_ID);
        boolean isLeqiLianYong = "3".equals(alleleissuetype) || "7".equals(that.getView().getModel().getValue("authtype"));
        boolean isLeqi = "2".equals(alleleissuetype) || "5".equals(that.getView().getModel().getValue("authtype"));
        String enterpriseRole = (String)that.getView().getModel().getValue("enterpriserole");
        if (isLeqi && StringUtils.isBlank((CharSequence)enterpriseRole)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f00(\u6536)\u7968\u6e20\u9053\u4e3a\u4e50\u4f01\u65f6\uff0c\u4f01\u4e1a\u89d2\u8272\u5fc5\u586b", (String)"OrgEditControl_7", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
        }
        String leqiId = (String)that.getView().getModel().getValue("leqiid");
        if (isLeqi && StringUtils.isBlank((CharSequence)leqiId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f00(\u6536)\u7968\u6e20\u9053\u4e3a\u4e50\u4f01\u65f6\uff0c\u4e50\u4f01ID\u5fc5\u586b", (String)"OrgEditControl_8", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
        }
        String leqiSecret = (String)that.getView().getModel().getValue("leqisecret");
        if (isLeqi && "1".equals(enterpriseRole) && StringUtils.isBlank((CharSequence)leqiSecret)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f00(\u6536)\u7968\u6e20\u9053\u4e3a\u4e50\u4f01\u4f01\u4e1a\u89d2\u8272\u4e3a\u63a5\u5165\u5355\u4f4d\u65f6\uff0c\u4e50\u4f01\u5bc6\u94a5\u5fc5\u586b", (String)"OrgEditControl_9", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
        }
        String accessTaxNo = (String)that.getView().getModel().getValue(LEQI_ACCESS_TAXNO);
        if (isLeqi && "2".equals(enterpriseRole) && StringUtils.isBlank((CharSequence)accessTaxNo)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f00(\u6536)\u7968\u6e20\u9053\u4e3a\u4e50\u4f01\u4f01\u4e1a\u89d2\u8272\u4e3a\u4f7f\u7528\u5355\u4f4d\u65f6\uff0c\u5bf9\u5e94\u63a5\u5165\u5355\u4f4d\u7a0e\u53f7\u5fc5\u586b", (String)"OrgEditControl_10", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
        }
        if (isLeqiLianYong) {
            if (StringUtils.isBlank((CharSequence)accessLeQiId)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f00(\u6536)\u7968\u901a\u9053\u4e3a\u4e50\u4f01\u8054\u7528\u65f6\uff0c\u8054\u7528\u5bf9\u5e94\u63a5\u5165\u5355\u4f4d\u4e50\u4f01id\u5fc5\u586b", (String)"OrgEditControl_36", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            }
            if (StringUtils.isBlank((CharSequence)leqiId)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f00(\u6536)\u7968\u901a\u9053\u4e3a\u4e50\u4f01\u8054\u7528\u65f6\uff0c\u8054\u7528\u5bf9\u5e94\u4f7f\u7528\u5355\u4f4d\u4e50\u4f01id\u5fc5\u586b", (String)"OrgEditControl_37", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            }
        }
        String taxNo = (String)that.getView().getModel().getValue("taxno");
        if (isLeqi && "1".equals(enterpriseRole)) {
            qFilter = new QFilter("leqiid", "=", (Object)leqiId).and("enterpriserole", "=", (Object)"1");
            epInfo = BusinessDataServiceHelper.loadSingle((String)"bdm_enterprise_baseinfo", (String)"number", (QFilter[])qFilter.toArray());
            if (epInfo != null && !epInfo.getString("number").equals(taxNo)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u4e50\u4f01id\u5df2\u5b58\u5728\u5bf9\u5e94\u63a5\u5165\u4f01\u4e1a", (String)"OrgEditControl_11", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            }
            enInfoDynamicObject.set("accessepinfo", (Object)0);
        } else if (isLeqi && "2".equals(enterpriseRole)) {
            qFilter = new QFilter("number", "=", (Object)accessTaxNo).and("enterpriserole", "=", (Object)"1");
            epInfo = BusinessDataServiceHelper.loadSingle((String)"bdm_enterprise_baseinfo", (String)"number", (QFilter[])qFilter.toArray());
            if (epInfo == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u5bf9\u5e94\u63a5\u5165\u5355\u4f4d\u7a0e\u53f7\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165", (String)"OrgEditControl_12", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            }
            enInfoDynamicObject.set("accessepinfo", epInfo.getPkValue());
            leqiSecret = "";
        } else if (isLeqi) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f01\u4e1a\u89d2\u8272\u9519\u8bef", (String)"OrgEditControl_13", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
        }
        enInfoDynamicObject.set("enterpriserole", (Object)enterpriseRole);
        enInfoDynamicObject.set("leqiid", (Object)leqiId);
        enInfoDynamicObject.set("leqisecret", (Object)leqiSecret);
        enInfoDynamicObject.set(ACCESS_LEQI_ID, (Object)accessLeQiId);
        String leqiUrl = (String)that.getView().getModel().getValue("leqiurl");
        enInfoDynamicObject.set("leqiurl", (Object)leqiUrl);
        if (isLeqi) {
            TaxpayerService taxpayerService = new TaxpayerService();
            try {
                LqEpConfig lqEpConfig = new LqEpConfig();
                lqEpConfig.setNsrsbh(taxNo);
                lqEpConfig.setJrdwptbh(leqiId);
                lqEpConfig.setSydwptbh(leqiId);
                lqEpConfig.setLqSecret(leqiSecret);
                lqEpConfig.setBaseUrl(leqiUrl);
                lqEpConfig.setIssueChannel(alleleissuetype);
                taxpayerService.requestTest(lqEpConfig, Long.valueOf(DynamicObjectUtil.getDynamicObjectLongValue((Object)enInfoDynamicObject.get("accessepinfo"))));
            }
            catch (KDException e) {
                String message = e.getMessage();
                String tipMsg = ResManager.loadKDString((String)"\u8f93\u5165\u7684\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7/\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0e\u767b\u5f55\u7684\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7/\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0d\u4e00\u81f4", (String)"OrgEditControl_0", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
                if (StringUtils.isNotBlank((CharSequence)message) && message.contains(tipMsg)) {
                    message = ResManager.loadKDString((String)"\u5f53\u524d\u586b\u5199\u7684\u4e50\u4f01ID\u4e0d\u5c5e\u4e8e\u5f53\u524d\u7a0e\u53f7\uff0c\u8bf7\u586b\u5199\u6b63\u786e\u7684\u4e50\u4f01ID\u4fe1\u606f", (String)"OrgEditControl_16", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
                }
                if (StringUtils.isBlank((CharSequence)message)) {
                    message = ResManager.loadKDString((String)"\u8bf7\u6c42\u4e50\u4f01\u8fd4\u56de\u4e3a\u7a7a", (String)"OrgEditControl_17", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
                }
                throw new KDBizException(message);
            }
        }
        if (isLeqiLianYong) {
            // empty if block
        }
    }

    public static void initLqptInfo(String taxNo, String enterpriseRole) {
        new TaxpayerService().init(taxNo, enterpriseRole);
        CacheHelper.remove((String)("creditQuota_" + taxNo));
        CacheHelper.remove((String)("totalCreditQuota_" + taxNo));
    }

    public static void updateOrgNameAndNumber(AbstractFormPlugin that, Object orgId) {
        try {
            DynamicObject bosOrg = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org_structure", (String)"org.name, org.number", (QFilter[])new QFilter("org.id", "=", orgId).toArray());
            if (bosOrg == null) {
                return;
            }
            String bosOrgName = bosOrg.getString("org.name");
            String bosOrgNumber = bosOrg.getString("org.number");
            String bdmOrgName = (String)that.getView().getModel().getValue(that instanceof EnterpriseInfoBindPlugin ? "orgname" : "name");
            String bdmOrgNumber = (String)that.getView().getModel().getValue(that instanceof EnterpriseInfoBindPlugin ? "orgcode" : "number");
            if (bdmOrgName.equals(bosOrgName) && bosOrgNumber.equals(bdmOrgNumber)) {
                return;
            }
            if (that instanceof EnterpriseInfoBindPlugin) {
                that.getView().getModel().setValue("orgname", (Object)bosOrgName);
                that.getView().getModel().setValue("orgcode", (Object)bosOrgNumber);
            } else {
                that.getView().getModel().setValue("name", (Object)bosOrgName);
                that.getView().getModel().setValue("number", (Object)bosOrgNumber);
            }
            DynamicObject bdmOrg = BusinessDataServiceHelper.loadSingle((String)"bdm_org", (String)String.join((CharSequence)",", "number", "name"), (QFilter[])new QFilter("id", "=", orgId).toArray());
            bdmOrg.set("name", (Object)bosOrgName);
            bdmOrg.set("number", (Object)bosOrgNumber);
            ImcSaveServiceHelper.update((DynamicObject)bdmOrg);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u7ec4\u7ec7\u540d\u79f0\u9519\u8bef", (Throwable)e);
        }
    }
}

