/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.riskcontrolconfig;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.Control;
import kd.bos.form.control.TransferContainer;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.transfer.TransferNode;
import kd.imc.bdm.common.constant.table.RiskControlConfigConstant;
import org.apache.commons.collections.CollectionUtils;

public class RiskControlFieldConfigFormPlugin
extends AbstractFormPlugin {
    private static ImmutableSet<String> FIELD_SIM_ORIGINAL_BILL = new ImmutableSet.Builder().add((Object[])new String[]{"orgid", "invoicetype", "invoiceremark"}).add((Object[])new String[]{"invoiceamount", "totaltax", "drawer", "payee", "reviewer"}).add((Object[])new String[]{"systemsource", "buyerphone", "buyeremail", "itemcount"}).add((Object[])new String[]{"textfield1", "textfield2", "textfield3", "textfield4", "textfield5"}).build();
    private static ImmutableSet<String> FIELD_SIM_ORIGINAL_BILL_ITEM = new ImmutableSet.Builder().add((Object[])new String[]{"goodsid", "amount", "tax"}).add((Object[])new String[]{"unitprice", "num", "specification", "unit"}).add((Object[])new String[]{"policylogo", "policycontants"}).add((Object[])new String[]{"extrafield", "extrafield2", "extrafield3", "extrafield4", "extrafield5"}).build();
    private static ImmutableSet<String> FIELD_SIM_INVOICE_WAIT = new ImmutableSet.Builder().add((Object[])new String[]{"orgid", "invoicetype", "remark"}).add((Object[])new String[]{"totaltax", "invoiceamount"}).add((Object[])new String[]{"drawer", "payee", "reviewer"}).add((Object[])new String[]{"systemsource", "buyerphone", "buyeremail"}).build();
    private static ImmutableSet<String> FIELD_SIM_INVOICE_WAIT_ITEM = new ImmutableSet.Builder().add((Object)"goodsid").add((Object[])new String[]{"unitprice", "num"}).add((Object[])new String[]{"specification", "unit"}).add((Object[])new String[]{"amount", "tax"}).add((Object[])new String[]{"taxpremark", "zzstsgl"}).build();
    private static ImmutableSet<String> FORM_ID_SIM_VAT_INVOICE = new ImmutableSet.Builder().add((Object[])new String[]{"orgid", "invoicetype", "remark"}).add((Object[])new String[]{"totaltax", "invoiceamount"}).add((Object[])new String[]{"drawer", "payee", "reviewer"}).add((Object[])new String[]{"systemsource", "buyerphone", "buyeremail"}).build();
    private static ImmutableSet<String> FORM_ID_SIM_VAT_INVOICE_ITEM = new ImmutableSet.Builder().add((Object)"goodsid").add((Object[])new String[]{"unitprice", "num"}).add((Object[])new String[]{"specification", "unit"}).add((Object[])new String[]{"amount", "tax"}).add((Object[])new String[]{"taxpremark", "zzstsgl"}).build();

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok", "buttonap"});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String formId = (String)formShowParameter.getCustomParam("formId");
        String itemId = (String)formShowParameter.getCustomParam("itemId");
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)formId);
        DataEntityPropertyCollection propertiesCollection = entityType.getProperties();
        boolean itemFlag = false;
        if (itemId != null) {
            itemFlag = true;
            IDataEntityProperty items = (IDataEntityProperty)propertiesCollection.get((Object)itemId);
            propertiesCollection = ((EntryProp)items).getItemType().getProperties();
        }
        ImmutableSet<String> fieldFilter = RiskControlFieldConfigFormPlugin.getFieldFilter(formId, itemFlag);
        List properties = propertiesCollection.stream().filter(property -> fieldFilter.contains((Object)property.getName())).collect(Collectors.toList());
        ArrayList<TransferNode> transferNodeListData = new ArrayList<TransferNode>(100);
        for (IDataEntityProperty property2 : properties) {
            String displayName = property2.getDisplayName() != null ? property2.getDisplayName().getLocaleValue() : property2.getName();
            String field = property2.getName();
            RiskControlConfigConstant.SelectFieldEnum selectFieldEnum = RiskControlConfigConstant.SelectFieldEnum.getSelectFieldEnumByCode((String)field);
            if (selectFieldEnum != null) {
                displayName = selectFieldEnum.getName();
            }
            transferNodeListData.add(new TransferNode(field, displayName, Boolean.FALSE));
        }
        TransferContainer transfer = (TransferContainer)this.getControl("transfercontainerap");
        String selectFields = StringUtils.trimToEmpty((String)((String)this.getView().getFormShowParameter().getCustomParam("selectKeysValue")));
        transfer.setTransferListData(transferNodeListData, Arrays.asList(selectFields.split(",")));
    }

    private static ImmutableSet<String> getFieldFilter(String formId, boolean itemFlag) {
        ImmutableSet<String> filterSet = null;
        switch (formId) {
            case "sim_original_bill": {
                filterSet = itemFlag ? FIELD_SIM_ORIGINAL_BILL_ITEM : FIELD_SIM_ORIGINAL_BILL;
                break;
            }
            case "sim_invoice_wait": {
                filterSet = itemFlag ? FIELD_SIM_INVOICE_WAIT_ITEM : FIELD_SIM_INVOICE_WAIT;
                break;
            }
            case "sim_vatinvoice": {
                filterSet = itemFlag ? FORM_ID_SIM_VAT_INVOICE_ITEM : FORM_ID_SIM_VAT_INVOICE;
            }
        }
        return filterSet;
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        if ("btnok".equals(control.getKey())) {
            TransferContainer transfer = (TransferContainer)this.getControl("transfercontainerap");
            List selectedData = transfer.getSelectedData();
            if (CollectionUtils.isEmpty((Collection)selectedData)) {
                IClientViewProxy service = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                Object transferContainerApStatus = service.getViewState("transfercontainerap");
                if (transferContainerApStatus != null) {
                    Map<String, Object> customParam = this.getSelectResultMap("", "");
                    this.getView().returnDataToParent(customParam);
                }
                this.getView().close();
                return;
            }
            ArrayList<String> selectKeysList = new ArrayList<String>(selectedData.size());
            ArrayList<String> selectNamesList = new ArrayList<String>(selectedData.size());
            for (Object selectedDatum : selectedData) {
                Map selectData = (Map)selectedDatum;
                selectKeysList.add((String)selectData.get("id"));
                selectNamesList.add((String)selectData.get("text"));
            }
            Map<String, Object> customParam = this.getSelectResultMap(String.join((CharSequence)",", selectKeysList), String.join((CharSequence)"_", selectNamesList));
            this.getView().returnDataToParent((Object)customParam);
            this.getView().close();
        }
    }

    private Map<String, Object> getSelectResultMap(String displaySelectKeys, String displaySelectNames) {
        String itemId = (String)this.getView().getFormShowParameter().getCustomParam("itemId");
        String defaultKey = StringUtils.isEmpty((CharSequence)itemId) ? "salertaxno,buyertaxno,totalamount" : "goodsname,goodscode,taxrate,taxamount";
        HashMap<String, Object> customParam = new HashMap<String, Object>();
        customParam.put("selectKeys", this.getView().getFormShowParameter().getCustomParam("selectKeys"));
        customParam.put("selectNames", this.getView().getFormShowParameter().getCustomParam("selectNames"));
        customParam.put("displaySelectKeys", defaultKey + "," + displaySelectKeys);
        customParam.put("displaySelectNames", displaySelectNames);
        return customParam;
    }
}

