/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.taxratecode;

import java.util.EventObject;
import java.util.List;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;

public class TaxClassCodeTreeListPlugin
extends AbstractTreeListPlugin {
    private static final Log log = LogFactory.getLog(TaxClassCodeTreeListPlugin.class);
    private static final String KEY_BILL_LIST = "billlistap";

    public void afterCreateNewData(EventObject e) {
        this.setTobaccoPageCache();
        this.setOilPageCache();
    }

    private void setOilPageCache() {
        Object oilLable = this.getView().getFormShowParameter().getCustomParam("OIL_LABLE");
        if (log.isInfoEnabled()) {
            log.info(String.format("\u52a0\u8f7d\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u6811\u5f62\u57fa\u7840\u8d44\u6599\u5217\u8868\u65f6\uff0c\u662f\u5426\u6210\u54c1\u6cb9\u4f01\u4e1a\uff1a%s", oilLable));
        }
        if ("0".equals(oilLable)) {
            this.getPageCache().put("OIL_LABLE", "0");
        } else if ("1".equals(oilLable)) {
            this.getPageCache().put("OIL_LABLE", "1");
        } else if ("2".equals(oilLable)) {
            this.getPageCache().put("OIL_LABLE", "2");
        }
    }

    private void setTobaccoPageCache() {
        Object tobaccoLable = this.getView().getFormShowParameter().getCustomParam("TOBACCO_LABEL");
        if (log.isInfoEnabled()) {
            log.info(String.format("\u52a0\u8f7d\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u6811\u5f62\u57fa\u7840\u8d44\u6599\u5217\u8868\u65f6\uff0c\u662f\u5426\u5377\u70df\u4f01\u4e1a\uff1a%s", tobaccoLable));
        }
        if ("0".equals(tobaccoLable)) {
            this.getPageCache().put("TOBACCO_LABEL", "0");
        } else if ("1".equals(tobaccoLable)) {
            this.getPageCache().put("TOBACCO_LABEL", "1");
        } else if ("2".equals(tobaccoLable)) {
            this.getPageCache().put("TOBACCO_LABEL", "2");
        }
    }

    public void setFilter(SetFilterEvent e) {
        this.setTobaccoFilter(e.getQFilters());
        this.setOilFilter(e.getQFilters());
    }

    private void setTobaccoFilter(List<QFilter> filters) {
        if ("0".equals(this.getPageCache().get("TOBACCO_LABEL"))) {
            filters.add(new QFilter("mergecode", "not like", (Object)"1030402%"));
        } else if ("2".equals(this.getPageCache().get("TOBACCO_LABEL"))) {
            filters.add(new QFilter("mergecode", "like", (Object)"1030402%"));
        }
    }

    private void setOilFilter(List<QFilter> filters) {
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        if ("0".equals(this.getPageCache().get("TOBACCO_LABEL"))) {
            QFilter qFilter = new QFilter("mergecode", "not like", (Object)"1030402%");
            this.getTreeModel().getTreeFilter().add(qFilter);
        } else if ("2".equals(this.getPageCache().get("TOBACCO_LABEL"))) {
            QFilter qFilter = new QFilter("mergecode", "like", (Object)"1030402%");
            qFilter.or("id", "in", (Object)new Long[]{1L, 103L, 10304L, 1030402L});
            this.getTreeModel().getTreeFilter().add(qFilter);
        }
        this.setOilFilter(this.getTreeModel().getTreeFilter());
    }

    public void beforeBindData(EventObject e) {
        String clear = this.getPageCache().get("clear");
        BillList billlist = (BillList)this.getControl(KEY_BILL_LIST);
        if (!StringUtils.isEmpty((String)clear)) {
            billlist.getFilterParameter().getQFilters().clear();
            this.getPageCache().put("treeNodeClick", "");
        }
    }

    public void treeNodeClick(TreeNodeEvent e) {
        super.treeNodeClick(e);
        BillList billlist = (BillList)this.getControl(KEY_BILL_LIST);
        List qFilters = billlist.getFilterParameter().getQFilters();
        qFilters.clear();
        billlist.refreshData();
        this.getPageCache().put("clear", "clear");
    }

    public void afterBindData(EventObject e) {
        this.getPageCache().put("clear", "clear");
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"_toolbar_"});
    }
}

