/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.invsm.formplugin.config;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.bdm.common.constant.ApiConfig;
import kd.imc.bdm.common.constant.ImcPermItemEnum;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.PermissionHelper;
import kd.imc.bdm.common.util.PropertieUtil;

public class InvsmConfigPlugin
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        this.loadApiConfig();
    }

    private void loadApiConfig() {
        QFilter filter = new QFilter("id", "=", (Object)1);
        DynamicObject apiConfig = QueryServiceHelper.queryOne((String)"invsm_apiconfig_setting", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"invsm_apiconfig_setting"), (QFilter[])filter.toArray());
        if (null != apiConfig) {
            this.getModel().setValue("disposelimit", apiConfig.get("disposelimit"));
            this.getModel().setValue("detaillimit", apiConfig.get("detaillimit"));
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if ("apisave".equals(key)) {
            PermissionHelper.checkPermission((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.ITEM_SAVE);
            this.apiConfigSave();
        }
    }

    private synchronized void apiConfigSave() {
        String disposelimit = this.getModel().getValue("disposelimit") + "";
        String detaillimit = this.getModel().getValue("detaillimit") + "";
        int disposeLimit = StringUtils.isBlank((CharSequence)disposelimit) ? 500 : Integer.parseInt(disposelimit);
        int detailLimit = StringUtils.isBlank((CharSequence)detaillimit) ? 50000 : Integer.parseInt(detaillimit);
        QFilter filter = new QFilter("id", "=", (Object)1);
        DynamicObject apiConfig = QueryServiceHelper.queryOne((String)"invsm_apiconfig_setting", (String)"id", (QFilter[])filter.toArray());
        if (null == apiConfig) {
            apiConfig = BusinessDataServiceHelper.newDynamicObject((String)"invsm_apiconfig_setting");
            apiConfig.set("id", (Object)1);
        } else {
            apiConfig = BusinessDataServiceHelper.loadSingle((Object)apiConfig.get("id"), (String)"invsm_apiconfig_setting");
        }
        try (TXHandle tx = TX.required();){
            try {
                apiConfig.set("disposelimit", (Object)disposeLimit);
                apiConfig.set("detaillimit", (Object)detailLimit);
                ImcSaveServiceHelper.save((DynamicObject)apiConfig);
                ApiConfig.setApiConfigLimit((int)disposeLimit, (int)detailLimit);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"InvsmConfigPlugin_0", (String)"imc-invsm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            }
            catch (Throwable e) {
                tx.markRollback();
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25,\u7cfb\u7edf\u5f02\u5e38,\u8bf7\u91cd\u8bd5\uff01", (String)"InvsmConfigPlugin_1", (String)"imc-invsm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"apiconfigtool"});
    }
}

