/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.invsm.common.helper;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.message.model.MsgRequest;
import kd.imc.bdm.common.message.model.MsgResponse;
import kd.imc.bdm.common.message.send.SendMsg2Imac;
import kd.imc.bdm.common.message.util.IsmcToken;
import kd.imc.bdm.common.util.AES128;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.EncrypteUtil;
import kd.imc.bdm.common.util.HttpUtil;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.UUID;
import kd.imc.bdm.common.util.ViewUtil;

public class ParamConfigHelper {
    private static Log logger = LogFactory.getLog(ParamConfigHelper.class);
    private static final String P_D = "imc123456";

    public static void serverAuthWithoutDataBaseSource(DynamicObject authObj, Map<String, String> paramMap) throws Exception {
        String data;
        String deploy = paramMap.get("bdm_ismc_config_deploy");
        String msgId = UUID.next();
        String sign = EncrypteUtil.enc2Hex((String)(RequestContext.get().getTenantId() + DateUtils.format((Date)new Date()) + "md5Hex" + msgId.substring(16)));
        Map<String, String> params = ParamConfigHelper.createRequestMap(authObj, sign);
        params.put("msgId", msgId);
        if ("imc_deploy_private".equals(deploy)) {
            data = (String)DispatchServiceHelper.invokeBizService((String)"ismc", (String)"dim", (String)"TenantRegister", (String)"tenantRegister", (Object[])new Object[]{params});
        } else {
            String ismcUrl = paramMap.get("bdm_ismc_config_url");
            String proxy = paramMap.get("bdm_ismc_config_url_proxy");
            String accessToken = IsmcToken.login((String)ismcUrl, (String)proxy, (String)"register", (String)"register!@123ABC", (String)paramMap.get("bdm_ismc_config_accountid"), (String)"register");
            String json = SerializationUtils.toJsonString(params);
            logger.info("\u7a0e\u63a7\u7cfb\u7edf\u4e91\u521d\u59cb\u5316\u8bf7\u6c42:{},{}", (Object)proxy, (Object)json);
            data = HttpUtil.doPostJson((String)(ismcUrl + "/kapi/app/dim/register?access_token=" + accessToken), (String)proxy, null, (String)json);
            logger.info("\u7a0e\u63a7\u7cfb\u7edf\u4e91\u521d\u59cb\u5316\u7ed3\u679c:{}", (Object)data);
        }
        JSONObject jsonData = JSONObject.parseObject((String)data);
        paramMap.put("sign", sign);
        ParamConfigHelper.handlerResponse(jsonData, authObj, paramMap);
    }

    private static Map<String, String> createRequestMap(DynamicObject authObj, String sign) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("tenantId", RequestContext.get().getTenantId());
        params.put("tenantName", RequestContext.get().getTenantInfo().getName());
        params.put("sign", sign);
        params.put("imcAccountId", RequestContext.get().getAccountId());
        params.put("imctenantId", authObj.getString("imcappid"));
        params.put("imcappid", authObj.getString("imcappid"));
        params.put("imcsecret", authObj.getString("imcsecret"));
        params.put("user", "disanfangfapiaoshangchuan");
        params.put("userpd", P_D);
        params.put("usertype", "UserName");
        params.put("logintype", "2");
        params.put("requesturl", authObj.getString("requesturl"));
        return params;
    }

    private static void handlerResponse(JSONObject jsonData, DynamicObject authObj, Map<String, String> paramMap) {
        block16: {
            try (TXHandle tx = TX.required();){
                try {
                    if ("0000".equals(jsonData.getString("errorCode"))) {
                        String respData = jsonData.getString("data");
                        respData = AES128.decrypt((String)respData, (String)paramMap.get("sign").substring(0, 16));
                        JSONObject json = JSONObject.parseObject((String)respData);
                        if (logger.isInfoEnabled()) {
                            logger.info("\u6388\u6743\u4fe1\u606f\u6570\u636e === " + json.toJSONString());
                        }
                        authObj.set("imscappid", (Object)json.getString("appid"));
                        authObj.set("imscsecret", (Object)json.getString("appsecuret"));
                        ParamConfigHelper.removeIsmcConfig();
                        List<DynamicObject> list = ParamConfigHelper.createParamConfigObjs(json, paramMap);
                        ImcSaveServiceHelper.save(list);
                        break block16;
                    }
                    throw new Exception(jsonData.getString("message"));
                }
                catch (Exception e) {
                    tx.markRollback();
                    logger.error("serverAuth\u5931\u8d25", (Throwable)e);
                    throw new MsgException((Throwable)e, e.getMessage());
                }
            }
        }
    }

    private static List<DynamicObject> createParamConfigObjs(JSONObject json, Map<String, String> paramMap) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(8);
        DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)"invsm_param_configuration");
        object.set("config_type", (Object)"bdm_ismc_config");
        object.set("config_key", (Object)"bdm_ismc_config_url");
        object.set("config_value", (Object)paramMap.get("bdm_ismc_config_url"));
        list.add(object);
        DynamicObject account = BusinessDataServiceHelper.newDynamicObject((String)"invsm_param_configuration");
        account.set("config_type", (Object)"bdm_ismc_config");
        account.set("config_key", (Object)"bdm_ismc_config_accountid");
        account.set("config_value", (Object)paramMap.get("bdm_ismc_config_accountid"));
        list.add(account);
        DynamicObject deploy = BusinessDataServiceHelper.newDynamicObject((String)"invsm_param_configuration");
        deploy.set("config_type", (Object)"bdm_ismc_config");
        deploy.set("config_key", (Object)"bdm_ismc_config_deploy");
        deploy.set("config_value", (Object)paramMap.get("bdm_ismc_config_deploy"));
        list.add(deploy);
        json.forEach((key, value) -> {
            String configKey = "bdm_ismc_config_" + key;
            if (!"bdm_ismc_config_accountid".equals(configKey) && !"bdm_ismc_config_url".equals(configKey)) {
                DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"invsm_param_configuration");
                obj.set("config_type", (Object)"bdm_ismc_config");
                obj.set("config_key", (Object)configKey);
                obj.set("config_value", value);
                list.add(obj);
            }
        });
        return list;
    }

    public static void initIsmcAuthInfo(Map<String, String> paramMap) throws Exception {
        QFilter filter = new QFilter("validstatus", "=", (Object)"0").and("imcappid", "=", (Object)RequestContext.get().getTenantId());
        DynamicObject authObj = BusinessDataServiceHelper.loadSingle((String)"bdm_premission_info", (String)"fileurl,imscappid,imcappid,imcsecret,imscsecret,requesturl", (QFilter[])filter.toArray());
        if (authObj == null) {
            authObj = BusinessDataServiceHelper.newDynamicObject((String)"bdm_premission_info");
            authObj.set("validstatus", (Object)"0");
        }
        if (StringUtils.isBlank((CharSequence)authObj.getString("imcappid")) || StringUtils.isBlank((CharSequence)authObj.getString("imcsecret"))) {
            authObj.set("imcappid", (Object)RequestContext.get().getTenantId());
            authObj.set("imcsecret", (Object)UUID.next());
            authObj.set("requesturl", (Object)RequestContext.get().getClientFullContextPath());
        }
        if (StringUtils.isBlank((CharSequence)authObj.getString("imscappid")) || StringUtils.isBlank((CharSequence)authObj.getString("imscsecret"))) {
            ParamConfigHelper.serverAuthWithoutDataBaseSource(authObj, paramMap);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{authObj});
    }

    public static boolean unInit(AbstractFormPlugin that) {
        String data;
        Map ismcParams = ImcConfigUtil.getValue((String)"bdm_ismc_config");
        String msgId = UUID.next();
        String sign = EncrypteUtil.enc2Hex((String)(RequestContext.get().getTenantId() + DateUtils.format((Date)new Date()) + "md5Hex" + msgId.substring(16)));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("tenantId", RequestContext.get().getTenantId());
        params.put("imcAccountId", RequestContext.get().getAccountId());
        params.put("tenantName", RequestContext.get().getTenantInfo().getName());
        params.put("msgId", msgId);
        params.put("sign", sign);
        params.put("oprType", "unInit");
        if ("imc_deploy_private".equals(ismcParams.get("bdm_ismc_config_deploy"))) {
            data = (String)DispatchServiceHelper.invokeBizService((String)"ismc", (String)"dim", (String)"TenantRegister", (String)"tenantRegister", (Object[])new Object[]{params});
        } else {
            String accessToken = null;
            String proxy = (String)ismcParams.get("bdm_ismc_config_url_proxy");
            try {
                accessToken = IsmcToken.login((String)((String)ismcParams.get("bdm_ismc_config_url")), (String)proxy, (String)"register", (String)"register!@123ABC", (String)((String)ismcParams.get("bdm_ismc_config_accountid")), (String)"register");
            }
            catch (Exception e) {
                ViewUtil.openNormalConfirm((AbstractFormPlugin)that, (String)ResManager.loadKDString((String)"\u5f53\u524d\u65e0\u6cd5\u8fde\u63a5\u5230\u7a0e\u63a7\u7cfb\u7edf\u4e91\uff0c\u662f\u5426\u5f3a\u5236\u521d\u59cb\u5316\uff1f", (String)"ParamConfigHelper_0", (String)"imc-invsm-common", (Object[])new Object[0]), (String)"forceUninit");
                return false;
            }
            try {
                String json = SerializationUtils.toJsonString(params);
                logger.info("\u7a0e\u63a7\u7cfb\u7edf\u4e91\u53cd\u521d\u59cb\u5316\u8bf7\u6c42\u53c2\u6570:{},{}", (Object)proxy, (Object)json);
                data = HttpUtil.doPostJson((String)((String)ismcParams.get("bdm_ismc_config_url") + "/kapi/app/dim/register?access_token=" + accessToken), (String)proxy, null, (String)json);
                logger.info("\u7a0e\u63a7\u7cfb\u7edf\u4e91\u53cd\u521d\u59cb\u5316\u8bf7\u6c42\u7ed3\u679c:{}", (Object)data);
            }
            catch (Exception e) {
                logger.error("\u53cd\u521d\u59cb\u5316\u5931\u8d25", (Throwable)e);
                throw new MsgException((Throwable)e, ResManager.loadKDString((String)"\u53cd\u521d\u59cb\u5316\u5931\u8d25", (String)"ParamConfigHelper_1", (String)"imc-invsm-common", (Object[])new Object[0]));
            }
        }
        JSONObject jsonData = JSONObject.parseObject((String)data);
        ParamConfigHelper.handlerUnInitResponse(jsonData);
        return true;
    }

    private static void handlerUnInitResponse(JSONObject jsonData) {
        block15: {
            try (TXHandle tx = TX.required();){
                try {
                    if ("0000".equals(jsonData.getString("errorCode"))) {
                        ParamConfigHelper.removeIsmcSetup();
                        break block15;
                    }
                    throw new MsgException(jsonData.getString("message"));
                }
                catch (Exception e) {
                    tx.markRollback();
                    logger.error("serverAuth\u5931\u8d25", (Throwable)e);
                    throw e;
                }
            }
        }
    }

    public static void removeIsmcSetup() {
        ParamConfigHelper.removeIsmcConfig();
        DeleteServiceHelper.delete((String)"bdm_premission_info", (QFilter[])new QFilter("1", "=", (Object)1).toArray());
    }

    private static void removeIsmcConfig() {
        DeleteServiceHelper.delete((String)"invsm_param_configuration", (QFilter[])new QFilter("config_type", "=", (Object)"bdm_ismc_config").toArray());
        ImcConfigUtil.removeCache((String)"bdm_ismc_config");
        CacheHelper.remove((String)"dim_sync_config");
        CacheHelper.remove((String)"cache_component_request_url");
        IsmcToken token = new IsmcToken();
        token.removeCache();
    }

    public static boolean unInitMove(AbstractFormPlugin that) {
        try {
            SendMsg2Imac.loginImac();
        }
        catch (Exception e) {
            ViewUtil.openNormalConfirm((AbstractFormPlugin)that, (String)ResManager.loadKDString((String)"\u5f53\u524d\u65e0\u6cd5\u8fde\u63a5\u5230\u79fb\u52a8\u4e91\uff0c\u662f\u5426\u5f3a\u5236\u521d\u59cb\u5316\uff1f", (String)"ParamConfigHelper_2", (String)"imc-invsm-common", (Object[])new Object[0]), (String)"forceUninitMove");
            return false;
        }
        MsgRequest request = new MsgRequest();
        request.setIdentifytype("imacImasmFromImc");
        request.setMsgType("uninit");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("tenantId", RequestContext.get().getTenantId());
        params.put("imcAccountId", RequestContext.get().getAccountId());
        params.put("tenantName", RequestContext.get().getTenantInfo().getName());
        params.put("oprType", "unInit");
        request.setReqData(params);
        MsgResponse msgResponse = SendMsg2Imac.send((MsgRequest)request, (String)"/kapi/app/imasm/imacWebService".concat("?access_token="));
        if (!ErrorType.SUCCESS.getCode().equalsIgnoreCase(msgResponse.getErrorCode())) {
            throw new MsgException(msgResponse.getErrorMsg());
        }
        ParamConfigHelper.removeImacSetUp();
        return true;
    }

    public static void removeImacSetUp() {
        DeleteServiceHelper.delete((String)"invsm_param_configuration", (QFilter[])new QFilter("config_type", "=", (Object)"bdm_ismc_config_move").toArray());
        ImcConfigUtil.removeCache((String)"bdm_ismc_config_move");
    }
}

