/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.invsm.mservice;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.interfaceservice.IOpenInterfaceService;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.invsm.helper.JsonKeyToLowerOrUpper;

public class SycnCallBackAddrService
implements IOpenInterfaceService {
    private static final Log LOGGER = LogFactory.getLog(SycnCallBackAddrService.class);
    private static final String INVSM_CALLBACK_ADDR = "invsm_callback_addr";
    private static final String ACCESSTOKEN_CACHE_KEY = "accesstoken_cache_key";

    public String doBusiness(String requestData) {
        CacheHelper.remove((String)ACCESSTOKEN_CACHE_KEY);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("\u5e94\u6536\u540c\u6b65\u81f3\u53d1\u7968\u4e91\u8bf7\u6c42\u53c2\u6570\uff1a" + requestData);
        }
        if (StringUtils.isBlank((CharSequence)requestData)) {
            return SerializationUtils.toJsonString((Object)ApiResult.fail((String)ErrorType.EMPTY_PARAM.getName(), (String)ErrorType.EMPTY_PARAM.getCode()));
        }
        ApiResult response = new ApiResult();
        try {
            JSONObject reqData = JsonKeyToLowerOrUpper.keyTransToLowerObject(requestData);
            JSONArray clientInfo = reqData.getJSONArray("clientinfo");
            for (Object obj : clientInfo) {
                JSONObject clientObj = JsonKeyToLowerOrUpper.keyTransToLowerObject(obj.toString());
                DynamicObject dObject = BusinessDataServiceHelper.newDynamicObject((String)INVSM_CALLBACK_ADDR);
                DynamicObjectUtil.json2DynamicObjectContainItems((JSONObject)reqData, (DynamicObject)dObject);
                this.doData(dObject, clientObj);
            }
            response.setErrorCode(ErrorType.SUCCESS.getCode());
            response.setMessage(ErrorType.SUCCESS.getName());
        }
        catch (RuntimeException e) {
            LOGGER.error("\u56de\u8c03\u914d\u7f6e\u540c\u6b65\u81f3\u53d1\u7968\u4e91\u5931\u8d25\uff1a", (Throwable)e);
            response.setErrorCode(ErrorType.FAIL.getCode());
            response.setMessage(ErrorType.FAIL.getName());
        }
        return SerializationUtils.toJsonString((Object)response);
    }

    private void doData(DynamicObject dObject, JSONObject clientObj) {
        String clientid = clientObj.getString("clientid");
        String revenuenumber = clientObj.getString("revenuenumber");
        dObject.set("clientid", (Object)clientid);
        dObject.set("revenuenumber", (Object)revenuenumber);
        DeleteServiceHelper.delete((String)INVSM_CALLBACK_ADDR, (QFilter[])new QFilter("revenuenumber", "=", (Object)revenuenumber).toArray());
        ImcSaveServiceHelper.save((DynamicObject)dObject);
    }
}

