/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.constant;

import kd.imc.rim.common.constant.ExpenseStatusEnum;
import kd.imc.rim.common.model.MultiLangEnumBridge;

public enum BussinSysBillStatusEnum {
    BILL_TEMPORARILY_STORED("01", new MultiLangEnumBridge("\u5355\u636e\u6682\u5b58", "BussinSysBillStatusEnum_0", "imc-rim-common")),
    BILL_SUBMITTED("11", new MultiLangEnumBridge("\u5355\u636e\u63d0\u4ea4\u5ba1\u6838", "BussinSysBillStatusEnum_1", "imc-rim-common")),
    BILL_SUBMITTED_WITH_ELEC_INVOICES("12", new MultiLangEnumBridge("\u5355\u636e\u63d0\u4ea4\u5ba1\u6838\uff08\u5168\u7535\u5b50\u53d1\u7968\u548c\u7535\u5b50\u9644\u4ef6\uff09", "BussinSysBillStatusEnum_2", "imc-rim-common")),
    BILL_SUBMITTED_WITH_PAPER_INVOICES_NOT_SIGN("13", new MultiLangEnumBridge("\u5355\u636e\u63d0\u4ea4\u5ba1\u6838\uff08\u542b\u7eb8\u8d28\u53d1\u7968\u6216\u7eb8\u8d28\u9644\u4ef6\uff0c\u5f85\u7b7e\u6536\uff09", "BussinSysBillStatusEnum_3", "imc-rim-common")),
    BILL_SUBMITTED_WITH_PAPER_INVOICES_SIGNED("14", new MultiLangEnumBridge("\u5355\u636e\u63d0\u4ea4\u5ba1\u6838\uff08\u542b\u7eb8\u8d28\u53d1\u7968\u6216\u7eb8\u8d28\u9644\u4ef6\uff0c\u5df2\u7b7e\u6536\uff09", "BussinSysBillStatusEnum_4", "imc-rim-common")),
    BILL_REVIEW_NOT_PASSED("21", new MultiLangEnumBridge("\u5355\u636e\u5ba1\u6838\u672a\u901a\u8fc7", "BussinSysBillStatusEnum_5", "imc-rim-common")),
    BILL_REVIEW_PASSED_EXPENSE_TAMOUNT_LARGEEQUALS_INVAMOUNT("22", new MultiLangEnumBridge("\u5355\u636e\u5ba1\u6838\u901a\u8fc7\uff08\u6838\u5b9a\u62a5\u8d26\u91d1\u989d\u5927\u4e8e\u6216\u7b49\u4e8e\u53d1\u7968\u91d1\u989d\uff09", "BussinSysBillStatusEnum_6", "imc-rim-common")),
    BILL_REVIEW_PASSED_EXPENSE_TAMOUNT_LESSTHAN_INVAMOUNT("23", new MultiLangEnumBridge("\u5355\u636e\u5ba1\u6838\u901a\u8fc7\uff08\u6838\u5b9a\u62a5\u8d26\u91d1\u989d\u5c0f\u4e8e\u53d1\u7968\u91d1\u989d\uff09", "BussinSysBillStatusEnum_7", "imc-rim-common")),
    BILL_POSTED_TO_ACCOUNTS("31", new MultiLangEnumBridge("\u5355\u636e\u5165\u8d26", "BussinSysBillStatusEnum_8", "imc-rim-common")),
    BILL_FULLY_PAID("41", new MultiLangEnumBridge("\u5355\u636e\u5168\u90e8\u4ed8\u6b3e", "BussinSysBillStatusEnum_9", "imc-rim-common")),
    BILL_PARTIALLY_PAID("42", new MultiLangEnumBridge("\u5355\u636e\u90e8\u5206\u4ed8\u6b3e", "BussinSysBillStatusEnum_10", "imc-rim-common")),
    BILL_DISCARDED("43", new MultiLangEnumBridge("\u5355\u636e\u5e9f\u5f03", "BussinSysBillStatusEnum_11", "imc-rim-common")),
    BILL_ARCHIVED("51", new MultiLangEnumBridge("\u5355\u636e\u5f52\u6863", "BussinSysBillStatusEnum_12", "imc-rim-common")),
    BILL_DELETED("61", new MultiLangEnumBridge("\u5355\u636e\u5220\u9664", "BussinSysBillStatusEnum_13", "imc-rim-common"));

    private String code;
    private MultiLangEnumBridge bridge;

    private BussinSysBillStatusEnum(String code, MultiLangEnumBridge bridge) {
        this.code = code;
        this.bridge = bridge;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.bridge.loadKDString();
    }

    public static boolean isBillCreateStatus(String bussinSysBillStatus) {
        return BussinSysBillStatusEnum.BILL_TEMPORARILY_STORED.code.equals(bussinSysBillStatus) || BussinSysBillStatusEnum.BILL_SUBMITTED.code.equals(bussinSysBillStatus) || BussinSysBillStatusEnum.BILL_SUBMITTED_WITH_ELEC_INVOICES.code.equals(bussinSysBillStatus) || BussinSysBillStatusEnum.BILL_SUBMITTED_WITH_PAPER_INVOICES_NOT_SIGN.code.equals(bussinSysBillStatus) || BussinSysBillStatusEnum.BILL_SUBMITTED_WITH_PAPER_INVOICES_SIGNED.code.equals(bussinSysBillStatus);
    }

    public static boolean isBillStatusUpdateStatus(String bussinSysBillStatus) {
        return BussinSysBillStatusEnum.BILL_REVIEW_NOT_PASSED.code.equals(bussinSysBillStatus) || BussinSysBillStatusEnum.BILL_REVIEW_PASSED_EXPENSE_TAMOUNT_LARGEEQUALS_INVAMOUNT.code.equals(bussinSysBillStatus) || BussinSysBillStatusEnum.BILL_POSTED_TO_ACCOUNTS.code.equals(bussinSysBillStatus) || BussinSysBillStatusEnum.BILL_DISCARDED.code.equals(bussinSysBillStatus) || BussinSysBillStatusEnum.BILL_DELETED.code.equals(bussinSysBillStatus);
    }

    public static boolean isDeleteVoucherStatus(String bussinSysBillStatus) {
        return BussinSysBillStatusEnum.BILL_REVIEW_NOT_PASSED.code.equals(bussinSysBillStatus) || BussinSysBillStatusEnum.BILL_REVIEW_PASSED_EXPENSE_TAMOUNT_LARGEEQUALS_INVAMOUNT.code.equals(bussinSysBillStatus) || BussinSysBillStatusEnum.BILL_REVIEW_PASSED_EXPENSE_TAMOUNT_LESSTHAN_INVAMOUNT.code.equals(bussinSysBillStatus) || BussinSysBillStatusEnum.BILL_DISCARDED.code.equals(bussinSysBillStatus) || BussinSysBillStatusEnum.BILL_DELETED.code.equals(bussinSysBillStatus);
    }

    public static String convertExpenseStatus(String bussinSysBillStatus) {
        if (BussinSysBillStatusEnum.BILL_TEMPORARILY_STORED.code.equals(bussinSysBillStatus) || BussinSysBillStatusEnum.BILL_DELETED.code.equals(bussinSysBillStatus) || BussinSysBillStatusEnum.BILL_REVIEW_NOT_PASSED.code.equals(bussinSysBillStatus) || BussinSysBillStatusEnum.BILL_DISCARDED.code.equals(bussinSysBillStatus)) {
            return ExpenseStatusEnum.NOT_REIMBURSED.getCode();
        }
        if (BussinSysBillStatusEnum.BILL_SUBMITTED.code.equals(bussinSysBillStatus) || BussinSysBillStatusEnum.BILL_SUBMITTED_WITH_ELEC_INVOICES.code.equals(bussinSysBillStatus) || BussinSysBillStatusEnum.BILL_SUBMITTED_WITH_PAPER_INVOICES_NOT_SIGN.code.equals(bussinSysBillStatus) || BussinSysBillStatusEnum.BILL_SUBMITTED_WITH_PAPER_INVOICES_SIGNED.code.equals(bussinSysBillStatus)) {
            return ExpenseStatusEnum.UNDER_REVIEW.getCode();
        }
        if (BussinSysBillStatusEnum.BILL_REVIEW_PASSED_EXPENSE_TAMOUNT_LARGEEQUALS_INVAMOUNT.code.equals(bussinSysBillStatus) || BussinSysBillStatusEnum.BILL_REVIEW_PASSED_EXPENSE_TAMOUNT_LESSTHAN_INVAMOUNT.code.equals(bussinSysBillStatus)) {
            return ExpenseStatusEnum.REIMBURSED.getCode();
        }
        if (BussinSysBillStatusEnum.BILL_POSTED_TO_ACCOUNTS.code.equals(bussinSysBillStatus) || BussinSysBillStatusEnum.BILL_FULLY_PAID.code.equals(bussinSysBillStatus) || BussinSysBillStatusEnum.BILL_PARTIALLY_PAID.code.equals(bussinSysBillStatus) || BussinSysBillStatusEnum.BILL_ARCHIVED.code.equals(bussinSysBillStatus)) {
            return ExpenseStatusEnum.REIMBURSED.getCode();
        }
        return "";
    }
}

