/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.constant;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.utils.ImcConfigUtil;
import kd.imc.rim.common.utils.RimConfigUtils;

public class InvoiceDownloadConstant {
    private static final Log LOGGER = LogFactory.getLog(InvoiceDownloadConstant.class);
    public static final String SHOW_TIPS1 = InvoiceDownloadConstant.getSHOW_TIPS1();
    public static final String TAXPAYERNAME = "tax_name";
    public static final String TAXPAYERNO = "tax_no";
    public static final String DATA_TYPE_INPUT = "1";
    public static final String DATA_TYPE_OUTPUT = "2";
    public static final String DATA_TYPE_HEADER = "3";
    public static final String DATA_TYPE_INPUT_INCREMENT = "4";
    public static final String DATA_TYPE_OUTPUT_INCREMENT = "5";
    public static final String DATA_TYPE_INPUT_INIT = "6";
    public static final String DATA_TYPE_INPUT_DOWN_FILE = "7";
    public static final String DATA_TYPE_OUTPUT_DOWN_FILE = "8";
    public static final String DATA_TYPE_INPUT_DOWN_AGRIC = "9";
    public static final Set<String> OUTPUT_TYPE_LIST = Sets.newHashSet((Object[])new String[]{"2", "8"});
    public static final String DATA_TYPE_INPUTTABLE = "3";
    public static final String SYNC_STATUS_YES = "1";
    public static final String SYNC_STATUS_NO = "2";
    public static final String SYNC_STATUS_FAIL = "0";
    public static final String DATA_TYPE_HEAD = "1";
    public static final String DATA_TYPE_LACK = "2";
    public static final String DATA_TYPE_COMPLETE = "3";
    public static final String DATA_TYPE_FILE = "4";
    public static final String INVOICE_HEAD_CACHE_KEY = "invoice_head_down_cache";
    public static final String INVOICE_FULL_CACHE_KEY = "invoice_full_down_cache";
    public static final String INVOICE_FULL_RPA_CACHE_KEY = "invoice_full_down_rpa_cache";
    public static final String INVOICE_FULL_INIT_CACHE_KEY = "invoice_down_init_cache";
    public static final String ASYNC_DEDUCT_CACHE_KEY = "list_async_deduct_cache";
    public static final String INVOICE_INCREMENT_CACHE_KEY = "invoice_increment_down_cache";
    public static final String DOWN_BATCH_PREFIX = "DOWN";
    public static final String DOWN_TYPE_HEAD = "head";
    public static final String DOWN_TYPE_TAXPERIOD = "taxperiod";
    public static final String DOWN_TYPE_INOUTPUT = "in_output";
    public static final String DOWN_TYPE_INPUT_INIT_APPLY = "input_init_apply";
    public static final String DOWN_TYPE_INPUT_INIT = "input_init_down";
    public static final String DOWN_TYPE_INVOICE_FILE_DOWN = "invoice_file_down";
    public static final String DOWN_TYPE_AGRIC_INVOICE_DOWN = "agric_invoice_down";
    public static final String DEFAULT_DOWN_FREQUENCY = "5;10;15;20;26";
    public static final String DOWN_CHECK_CONFIG_KEY = "down_check_config_key";
    public static final String DOWN_CONFIG_ORG_TAXNO_KEY = "down_org_taxno_key";
    public static final String DOWN_FILE_TAXNO_KEY = "down_file_taxno_key";
    public static final String DOWN_INVOICE_LOCK = "rim.collectinvoicedata-";
    public static final String APPLY_INVOICE_LOCK = "InvoiceDownApplyLock-";
    public static final String RPA_ACCOUNT_LOCK = "rim.account-";
    public static final String DOWN_LOGIN_LOCK = "e_down_login_";
    public static final String HANDLE_STATUS_SUCC = "1";
    public static final String HANDLE_STATUS_UNCHECK = "2";
    public static final String HANDLE_STATUS_OVERDUE = "3";
    public static final String HANDLE_STATUS_LESS_DEDUCT = "4";
    public static final String HANDLE_STATUS_INOUT_DOWN = "5";
    public static final String HANDLE_STATUS_CHECK_FAIL = "6";
    public static final String HANDLE_STATUS_INVOICE_FILE_DOWN = "7";
    public static final String HANDLE_STATUS_INVOICE_FILE_DOWN_FAIL = "11";
    public static final String GOV_STATUS_SUCC = "1";
    public static final String GOV_STATUS_INOUT_UNFINISH = "2";
    public static final String GOV_STATUS_HEADER_SUCC = "3";
    public static final String GOV_STATUS_INOUT_FAIL = "5";
    public static final String GOV_STATUS_INOUT_HANDLING = "6";
    public static final String GOV_STATUS_INOUT_APPLY_FAIL = "7";
    public static final String GOV_STATUS_INOUT_DOWNLOAD = "8";
    public static final String GOV_STATUS_INOUT_NON_INVOICE = "9";
    public static final String[] UPDATE_STATUS = new String[]{"2", "3", "8"};
    public static final String[] ALLOW_DOWN_STATUS = new String[]{"2", "6"};

    private static String getSHOW_TIPS1() {
        return ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u6ca1\u6709\u914d\u7f6e\u5bf9\u5e94\u7684\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u6216\u540d\u79f0", (String)"InvoiceDownloadConstant_0", (String)"imc-rim-common", (Object[])new Object[0]);
    }

    public static boolean isAllowDownStatus(String status) {
        List<String> list = Arrays.asList(ALLOW_DOWN_STATUS);
        return list.contains(status);
    }

    public static int getPageSizeFromConfig(int initPage, String configKey) {
        return RimConfigUtils.getPageSizeFromConfig(initPage, "rim_deduction", configKey);
    }

    public static long getInvoiceTypeByAwsType(String awsType) {
        if ("85".equals(awsType)) {
            return InputInvoiceTypeEnum.SPECIAL_PAPER.getCode();
        }
        if ("86".equals(awsType)) {
            return InputInvoiceTypeEnum.ORDINARY_PAPER.getCode();
        }
        if ("87".equals(awsType)) {
            return InputInvoiceTypeEnum.MOTOR_INVOICE.getCode();
        }
        if ("88".equals(awsType)) {
            return InputInvoiceTypeEnum.USEDCAR_INVOICE.getCode();
        }
        return InputInvoiceTypeEnum.getInvoiceTypeByAwsType(awsType);
    }

    public static boolean isElectricPaper(String awsType) {
        return "85".equals(awsType) || "86".equals(awsType) || "87".equals(awsType) || "88".equals(awsType);
    }

    public static String getLqTypeByAwsType(String awsType) {
        if (InvoiceDownloadConstant.isElectricPaper(awsType)) {
            return awsType;
        }
        return InputInvoiceTypeEnum.getLqInvoiceType(awsType);
    }

    public static boolean isSyncDown(String taxNo) {
        Map<String, String> downAsyncMap = ImcConfigUtil.getValue("rim_down_sync");
        if (ObjectUtils.isEmpty(downAsyncMap) || ObjectUtils.isEmpty((Object)taxNo)) {
            return false;
        }
        String allAsync = downAsyncMap.get("all_taxno");
        String taxNoAsync = downAsyncMap.get(taxNo);
        String batchTaxNos = downAsyncMap.get("taxnos");
        return StringUtils.contains((CharSequence)batchTaxNos, (CharSequence)taxNo) || "1".equals(allAsync) || "1".equals(taxNoAsync);
    }

    public static boolean isNotQueryLqStatus(String taxNo) {
        Map<String, String> downAsyncMap = ImcConfigUtil.getValue("rim_lq_not_status");
        if (ObjectUtils.isEmpty(downAsyncMap) || ObjectUtils.isEmpty((Object)taxNo)) {
            return false;
        }
        String allAsync = downAsyncMap.get("all_taxno");
        String taxNoAsync = downAsyncMap.get(taxNo);
        String batchTaxNos = downAsyncMap.get("taxnos");
        return StringUtils.contains((CharSequence)batchTaxNos, (CharSequence)taxNo) || "1".equals(allAsync) || "1".equals(taxNoAsync);
    }

    public static String convertLqCollect(String taxNo, String dkType) {
        if ("5".equals(dkType) || ObjectUtils.isEmpty((Object)taxNo) || ObjectUtils.isEmpty((Object)dkType)) {
            return dkType;
        }
        Map<String, String> downAsyncMap = ImcConfigUtil.getValue("rim_leqi_collect");
        if (ObjectUtils.isEmpty(downAsyncMap)) {
            return dkType;
        }
        if ("1".equals(downAsyncMap.get(taxNo))) {
            return "5";
        }
        String batchTaxNos = downAsyncMap.get("taxnos_" + dkType);
        if (StringUtils.isEmpty((CharSequence)batchTaxNos)) {
            return dkType;
        }
        if ("alltaxnos".equals(batchTaxNos) || batchTaxNos.contains(taxNo)) {
            return "5";
        }
        return dkType;
    }

    public static String lqTaxNoConvertRpa(String taxNo, String dkType) {
        if (!"5".equals(dkType) || ObjectUtils.isEmpty((Object)taxNo) || ObjectUtils.isEmpty((Object)dkType)) {
            return dkType;
        }
        Map<String, String> downAsyncMap = ImcConfigUtil.getValue("rim_leqi_rpa");
        if (ObjectUtils.isEmpty(downAsyncMap)) {
            return dkType;
        }
        String allAsync = downAsyncMap.get("all_taxno");
        String taxNoAsync = downAsyncMap.get(taxNo);
        String batchTaxNos = downAsyncMap.get("taxnos");
        boolean isConvertRpa = StringUtils.contains((CharSequence)batchTaxNos, (CharSequence)taxNo) || "1".equals(allAsync) || "1".equals(taxNoAsync);
        return isConvertRpa ? "4" : dkType;
    }
}

