/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.ek;

import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.rim.common.ek.model.EkServiceConfig;
import kd.imc.rim.common.ek.service.InvoiceQueryEkService;
import kd.imc.rim.common.ek.service.InvoiceSaveEkService;
import kd.imc.rim.common.ek.service.InvoiceSelectService;
import kd.imc.rim.common.ek.service.impl.InvoiceQueryEkServiceImpl;
import kd.imc.rim.common.ek.service.impl.InvoiceSaveEkServiceImpl;
import kd.imc.rim.common.ek.service.impl.InvoiceSelectServiceImpl;
import kd.imc.rim.common.utils.ImcConfigUtil;
import org.apache.commons.lang3.StringUtils;

public class EkServiceFactory {
    private static Log logger = LogFactory.getLog(EkServiceFactory.class);

    public static InvoiceSelectService getInvoiceSelectService() {
        EkServiceConfig config = EkServiceFactory.getConfig();
        if (StringUtils.isNotEmpty((CharSequence)config.getAfterSelect())) {
            try {
                return (InvoiceSelectService)Class.forName(config.getAfterSelect()).newInstance();
            }
            catch (Exception t) {
                logger.error("init class " + config.getAfterSelect() + " error:", (Throwable)t);
            }
        }
        return new InvoiceSelectServiceImpl();
    }

    public static InvoiceQueryEkService getInvoiceQueryEkService() {
        EkServiceConfig config = EkServiceFactory.getConfig();
        if (StringUtils.isNotEmpty((CharSequence)config.getInvoiceQuery())) {
            try {
                return (InvoiceQueryEkService)Class.forName(config.getInvoiceQuery()).newInstance();
            }
            catch (Exception t) {
                logger.error("init class " + config.getInvoiceQuery() + " error:", (Throwable)t);
            }
        }
        return new InvoiceQueryEkServiceImpl();
    }

    public static InvoiceSaveEkService getInvoiceSaveEkService() {
        EkServiceConfig config = EkServiceFactory.getConfig();
        if (StringUtils.isNotEmpty((CharSequence)config.getInvoiceSave())) {
            try {
                return (InvoiceSaveEkService)Class.forName(config.getInvoiceSave()).newInstance();
            }
            catch (Exception t) {
                logger.error("init class " + config.getInvoiceSave() + " error:", (Throwable)t);
            }
        }
        return new InvoiceSaveEkServiceImpl();
    }

    private static EkServiceConfig getConfig() {
        Map<String, String> map = ImcConfigUtil.getValue("rim_ek");
        EkServiceConfig config = new EkServiceConfig();
        config.setAfterSelect(StringUtils.trimToEmpty((String)map.get("after_select")));
        config.setInvoiceQuery(StringUtils.trimToEmpty((String)map.get("invoice_query")));
        config.setInvoiceSave(StringUtils.trimToEmpty((String)map.get("invoice_save")));
        return config;
    }
}

