/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.expense.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.imc.rim.common.utils.RimConfigUtils;
import org.apache.commons.lang3.StringUtils;

public class ExpenseCallBackService {
    private static Log LOGGER = LogFactory.getLog(ExpenseCallBackService.class);

    public static void signInvoice(String serialNo, String originalState) {
        ThreadPools.executeOnceIncludeRequestContext((String)"ExpenseCallBackService.signFile", () -> {
            LOGGER.info("\u6587\u4ef6\u7b7e\u6536\u5f02\u6b65\u53cd\u5199\u4e1a\u52a1\u5355\u636e" + serialNo);
            ArrayList<String> list = new ArrayList<String>(1);
            list.add(serialNo);
            ExpenseCallBackService.signInvoice(list);
        });
    }

    private static void unSignInvoice(List<String> serialNo) {
        String[] configVal;
        String configId = "callback_unSignfile_";
        String config = RimConfigUtils.getConfig(configId);
        if (StringUtils.isEmpty((CharSequence)config)) {
            config = RimConfigUtils.getConfig("callback_unSignfile");
        }
        LOGGER.info("\u6587\u4ef6\u53cd\u7b7e\u6536\u5f02\u6b65\u53cd\u5199\u4e1a\u52a1\u5355\u636econfig" + config);
        if (null != config && (configVal = config.split(",")).length >= 4) {
            HashMap<String, List<String>> map = new HashMap<String, List<String>>(1);
            map.put("serialNo", serialNo);
            DispatchServiceHelper.invokeService((String)configVal[0], (String)configVal[1], (String)configVal[2], (String)configVal[3], (Object[])new Object[]{map});
        }
    }

    private static void signInvoice(List<String> serialNo) {
        String signFileConfig = "callback_signfile_";
        String config = RimConfigUtils.getConfig(signFileConfig);
        if (StringUtils.isEmpty((CharSequence)config)) {
            config = RimConfigUtils.getConfig("callback_signfile");
        }
        if (null != config) {
            LOGGER.info("\u6587\u4ef6\u7b7e\u6536\u5f02\u6b65\u53cd\u5199\u4e1a\u52a1\u5355\u636econfig" + config);
            String[] configVal = config.split(",");
            if (configVal.length >= 4) {
                HashMap<String, List<String>> map = new HashMap<String, List<String>>(1);
                map.put("serialNo", serialNo);
                DispatchServiceHelper.invokeService((String)configVal[0], (String)configVal[1], (String)configVal[2], (String)configVal[3], (Object[])new Object[]{map});
            }
        }
    }

    public static void unSignInvoiceBatch(List<String> serialNo) {
        ThreadPools.executeOnceIncludeRequestContext((String)"ExpenseCallBackService.unSignInvoiceBatch", () -> {
            LOGGER.info("\u6587\u4ef6\u53cd\u7b7e\u6536\u5f02\u6b65\u53cd\u5199\u4e1a\u52a1\u5355\u636eunSignInvoiceBatch" + serialNo);
            if (!CollectionUtils.isEmpty((Collection)serialNo)) {
                ExpenseCallBackService.unSignInvoice(serialNo);
            } else {
                LOGGER.info("\u6587\u4ef6\u53cd\u7b7e\u6536\u5f02\u6b65\u53cd\u5199\u4e1a\u52a1\u5355\u636e\u6ca1\u6709\u5173\u8054\u5355\u636e" + serialNo);
            }
        });
    }

    public static void signInvoiceBatch(List<String> serialNo, String originalState) {
        ThreadPools.executeOnceIncludeRequestContext((String)"ExpenseCallBackService.signInvoiceBatch", () -> {
            LOGGER.info("\u6587\u4ef6\u7b7e\u6536\u5f02\u6b65\u53cd\u5199\u4e1a\u52a1\u5355\u636esignInvoiceBatch" + serialNo);
            if (!CollectionUtils.isEmpty((Collection)serialNo)) {
                ExpenseCallBackService.signInvoice(serialNo);
            } else {
                LOGGER.info("\u6587\u4ef6\u7b7e\u6536\u5f02\u6b65\u53cd\u5199\u4e1a\u52a1\u5355\u636e\u6ca1\u6709\u5173\u8054\u5355\u636e" + serialNo);
            }
        });
    }

    public static void saveVoucher(Map<String, Object> param) {
        ThreadPools.executeOnceIncludeRequestContext((String)"ExpenseCallBackService.saveVoucher", () -> {
            String configId;
            String config;
            String[] configVal;
            LOGGER.info("\u63a5\u6536\u5916\u90e8\u7cfb\u7edf\u51ed\u8bc1\u53cd\u5199\u4e1a\u52a1\u7cfb\u7edf" + param);
            if (!CollectionUtils.isEmpty((Map)param) && (configVal = (config = RimConfigUtils.getConfig(configId = "callback_voucher")).split(",")).length >= 4) {
                DispatchServiceHelper.invokeService((String)configVal[0], (String)configVal[1], (String)configVal[2], (String)configVal[3], (Object[])new Object[]{param});
            }
        });
    }

    public static void saveVoucher(Map<String, Object> param, String configId) {
        ThreadPools.executeOnceIncludeRequestContext((String)"ExpenseCallBackService.saveVoucher", () -> {
            String config;
            String[] configVal;
            LOGGER.info("\u63a5\u6536\u5916\u90e8\u7cfb\u7edf\u51ed\u8bc1\u53cd\u5199\u4e1a\u52a1\u7cfb\u7edf" + param);
            if (!CollectionUtils.isEmpty((Map)param) && (configVal = (config = RimConfigUtils.getConfig(configId)).split(",")).length >= 4) {
                DispatchServiceHelper.invokeService((String)configVal[0], (String)configVal[1], (String)configVal[2], (String)configVal[3], (Object[])new Object[]{param});
            }
        });
    }
}

