/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.expense.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.AttachConstant;
import kd.imc.rim.common.constant.BussinSysBillStatusEnum;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.InvoiceSaveConstant;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.constant.UpdateInvoiceAndAttachTypeEnum;
import kd.imc.rim.common.ek.EkServiceFactory;
import kd.imc.rim.common.ek.service.InvoiceSaveEkService;
import kd.imc.rim.common.expense.domain.ExpenseAttachDTO;
import kd.imc.rim.common.expense.domain.ExpenseCoverDTO;
import kd.imc.rim.common.expense.domain.ExpenseDTO;
import kd.imc.rim.common.expense.domain.ExpenseInvoiceDTO;
import kd.imc.rim.common.expense.domain.ExpenseVoucherDTO;
import kd.imc.rim.common.expense.service.InvoiceImageNotifyService;
import kd.imc.rim.common.expense.service.VoucherService;
import kd.imc.rim.common.invoice.file.FileConvertService;
import kd.imc.rim.common.invoice.fpzs.FpzsMainService;
import kd.imc.rim.common.invoice.query.AttachQueryService;
import kd.imc.rim.common.invoice.query.InvoiceQueryService;
import kd.imc.rim.common.invoice.save.InvoiceSaveService;
import kd.imc.rim.common.invoice.verify.VerifyService;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.service.InvoiceLog;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.CurrencyUtils;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DeductionUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.FileUploadUtils;
import kd.imc.rim.common.utils.FileUtils;
import kd.imc.rim.common.utils.ImcConfigUtil;
import kd.imc.rim.common.utils.ListUtils;
import kd.imc.rim.common.utils.MetadataUtil;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.common.utils.SysParamUtil;
import kd.imc.rim.common.utils.TenantUtils;
import kd.imc.rim.common.utils.UUID;
import kd.imc.rim.file.utils.FileConvertUtils;
import org.apache.commons.lang.StringUtils;

public class ExpenseService {
    private static Log LOGGER = LogFactory.getLog(ExpenseService.class);
    private static final String CACHE_INVOICE_ATTACH = "CACHE_INVOICE_ATTACH";

    public void billCreate(ExpenseDTO param) {
        if (param.getResource() == null) {
            param.setResource(" ");
        }
        String status = param.getStatus();
        String bussinSysBillStatus = param.getBussinSysBillStatus();
        if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)bussinSysBillStatus)) {
            this.save(param);
            return;
        }
        if (!BussinSysBillStatusEnum.isBillCreateStatus(bussinSysBillStatus)) {
            throw new MsgException(ErrorType.PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u53c2\u6570\u7cfb\u7edf\u5355\u636e\u72b6\u6001\u6570\u636e\u9519\u8bef\u3002", (String)"ExpenseService_13", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        QFilter idfilter = this.getExpenseRelationQFilter(param, "expense_id", "entityid", "resource");
        DynamicObject expenseObject = QueryServiceHelper.queryOne((String)"rim_expense", (String)"id,status,bussinsysbillstatus", (QFilter[])new QFilter[]{idfilter});
        if (expenseObject != null && !BussinSysBillStatusEnum.isBillCreateStatus(expenseObject.getString("bussinsysbillstatus"))) {
            throw new MsgException(ErrorType.PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u539f\u5355\u636e\u7cfb\u7edf\u5355\u636e\u72b6\u6001\u4e0d\u5141\u8bb8\u66f4\u65b0\uff0c\u8bf7\u4f7f\u7528\u5355\u636e\u53d1\u7968\u6216\u9644\u4ef6\u66f4\u65b0\u63a5\u53e3\uff08\u5168\u91cf\u8986\u76d6\u4e0e\u589e\u5220\uff09\u6216\u66f4\u65b0\u5355\u636e\u72b6\u6001\u63a5\u53e3\u3002", (String)"ExpenseService_14", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        status = BussinSysBillStatusEnum.convertExpenseStatus(bussinSysBillStatus);
        param.setStatus(status);
        this.save(param);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void billUpdate(ExpenseDTO param) {
        idfilter = this.getExpenseRelationQFilter(param, "expense_id", "entityid", "resource");
        list = QueryServiceHelper.queryPrimaryKeys((String)"rim_expense", (QFilter[])new QFilter[]{idfilter}, (String)"id", (int)5);
        if (CollectionUtils.isEmpty((Collection)list)) {
            throw new MsgException(ErrorType.PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u5355\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5bf9\u540e\u518d\u63d0\u4ea4\u3002", (String)"ExpenseService_15", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        expenseObject = BusinessDataServiceHelper.loadSingle(list.get(0), (String)"rim_expense");
        param.setOrgId(DynamicObjectUtil.getDynamicObjectLongValue(expenseObject.get("orgid")));
        param.setStatus(expenseObject.getString("status"));
        param.setBussinSysBillStatus(expenseObject.getString("bussinsysbillstatus"));
        expenseId = param.getExpenseId();
        h = TX.requiresNew();
        var7_7 = null;
        try {
            if (UpdateInvoiceAndAttachTypeEnum.ATTACHMENT_UPDATE_TYPE_COVER.getCode().equals(param.getAttachmentUpdateType())) {
                this.updateAttachV2(param);
            }
            this.saveCoverRelation(param);
            saveRelationRtn = null;
            if (!UpdateInvoiceAndAttachTypeEnum.INVOICE_UPDATE_TYPE_COVER.getCode().equals(param.getInvoiceUpdateType())) ** GOTO lbl90
            invoiceList = param.getInvoiceList();
            delteSerialList = null;
            if (CollectionUtils.isEmpty(invoiceList)) {
                delteSerialList = this.deleteExpense(param, false);
                if (!CollectionUtils.isEmpty(delteSerialList)) {
                    this.deleteBillVoucher(param, delteSerialList);
                }
                expenseObject.set("billupdatetime", (Object)param.getUpdateTime());
                expenseObject.set("update_time", (Object)new Date());
                this.updateExpenseAmount(param, expenseObject, saveRelationRtn);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{expenseObject});
                this.updateInvoiceMain(delteSerialList, null);
                this.saveCallBack("save", param, null, delteSerialList);
                InvoiceImageNotifyService.imageNotify(param);
                return;
            }
            try {
                serialList = new ArrayList<String>(invoiceList.size());
                invoiceDtoMap = new HashMap<String, ExpenseInvoiceDTO>(invoiceList.size());
                serialRepeatMap = new HashMap<String, Boolean>(invoiceList.size());
                for (ExpenseInvoiceDTO invoiceDto : invoiceList) {
                    serialList.add(invoiceDto.getSerialNo());
                    invoiceDtoMap.put(invoiceDto.getSerialNo(), invoiceDto);
                    serialRepeatMap.put(invoiceDto.getSerialNo(), invoiceDto.isAllowRepeat());
                }
                verifyParam = new HashMap<String, Object>(4);
                verifyParam.put("orgId", param.getOrgId());
                verifyParam.put("billType", param.getExpenseType());
                allowRepeat = Boolean.FALSE;
                allowRepeat = param.isAllowRepeat() != false ? Boolean.TRUE : Boolean.valueOf("0".equals((verifyConfig = VerifyService.getVerfifyConfig(verifyParam)).getString("repeat_expense")) == false);
                deleteExpenseId = new ArrayList<String>(8);
                filter = new QFilter("serial_no", "in", serialList);
                collection = QueryServiceHelper.query((String)"rim_expense_relation", (String)"id,expense_num,expense_id,status,resource,entityid,serial_no,use_type,expense_amount", (QFilter[])new QFilter[]{filter});
                invoiceInfoMap = this.getMainDynamicObjectMap(serialList);
                savedSerialNo /* !! */  = Lists.newArrayList();
                if (CollectionUtils.isEmpty((Collection)collection) || "1".equals(param.getStatus())) {
                    delteSerialList = this.deleteExpense(param, false);
                    if (!CollectionUtils.isEmpty(delteSerialList)) {
                        this.deleteBillVoucher(param, delteSerialList);
                    }
                    saveRelationRtn = this.newExpenseRelation(param, serialList, invoiceInfoMap);
                } else {
                    this.verifyRepeat(param, invoiceList, serialRepeatMap, allowRepeat, deleteExpenseId, collection, invoiceInfoMap);
                    delteSerialList = this.deleteExpense(param, false);
                    if (!CollectionUtils.isEmpty(delteSerialList)) {
                        this.deleteBillVoucher(param, delteSerialList);
                    }
                    saveRelationRtn = this.newExpenseRelation(param, serialList, invoiceInfoMap);
                }
                this.setOriginalState(invoiceInfoMap, expenseObject);
                this.deleteAwsBill(deleteExpenseId);
                if (saveRelationRtn != null) {
                    savedSerialNo /* !! */  = ListUtils.parseList(saveRelationRtn.getJSONArray("savedSerialNos"), String.class);
                }
                addSerialList = new ArrayList<String>(serialList);
                delSerialList = null;
                if (!CollectionUtils.isEmpty(delteSerialList)) {
                    delSerialList = new ArrayList<String>(delteSerialList);
                    delSerialList.removeAll(serialList);
                    serialList.addAll(delteSerialList);
                }
                this.updateInvoiceMain(serialList, invoiceDtoMap);
                if (delSerialList != null) {
                    delSerialList.removeAll(serialList);
                    this.deleteInvoiceAttach(delSerialList, expenseId);
                }
                this.bindBillVoucher2NewInvoice(param, savedSerialNo /* !! */ );
                this.saveCallBack("save", param, addSerialList, delSerialList);
                this.updateInvoiceOrg(param);
                FpzsMainService.cacheFpzsPushInvoices(expenseId, param.getEntityId(), param.getResource(), null);
lbl90:
                // 2 sources

                expenseObject.set("billupdatetime", (Object)param.getUpdateTime());
                expenseObject.set("update_time", (Object)new Date());
                this.updateExpenseAmount(param, expenseObject, saveRelationRtn);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{expenseObject});
                InvoiceImageNotifyService.imageNotify(param);
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
        finally {
            if (h != null) {
                if (var7_7 != null) {
                    try {
                        h.close();
                    }
                    catch (Throwable var11_14) {
                        var7_7.addSuppressed(var11_14);
                    }
                } else {
                    h.close();
                }
            }
        }
    }

    public void saveSingle(ExpenseDTO param) {
        List<ExpenseInvoiceDTO> invoiceList;
        if (param.getResource() == null) {
            param.setResource(" ");
        }
        if (CollectionUtils.isEmpty(invoiceList = param.getInvoiceList())) {
            this.saveBillNotInvoice(param);
            return;
        }
        this.saveBillHasInvoice(param, invoiceList);
    }

    private void updateAttachV2(ExpenseDTO param) {
        String expenseId = param.getExpenseId();
        QFilter billFilter = new QFilter("expense_id", "=", (Object)expenseId);
        DeleteServiceHelper.delete((String)"rim_attach_relation", (QFilter[])billFilter.toArray());
        List<ExpenseAttachDTO> attachDTOList = param.getAttachDTOList();
        if (!CollectionUtils.isEmpty(attachDTOList)) {
            HashMap<String, ExpenseAttachDTO> attachDTOMap = new HashMap<String, ExpenseAttachDTO>(attachDTOList.size());
            ArrayList<String> attachNos = new ArrayList<String>(attachDTOList.size());
            for (ExpenseAttachDTO expenseAttachDTO : attachDTOList) {
                String attachNo = expenseAttachDTO.getAttachNo();
                if (!CollectionUtils.isEmpty(attachNos) && attachNos.contains(attachNo)) continue;
                attachNos.add(attachNo);
                attachDTOMap.put(attachNo, expenseAttachDTO);
            }
            AttachQueryService attachQueryService = new AttachQueryService();
            QFilter attNosFilter = new QFilter("attach_no", "in", attachNos);
            Object[] attachObjs = attachQueryService.loadByFilterOrderBy(attNosFilter, null);
            if (!ObjectUtils.isEmpty((Object[])attachObjs)) {
                ArrayList<DynamicObject> attachRelationList = new ArrayList<DynamicObject>(attachObjs.length);
                ArrayList<Object> updateAttach = new ArrayList<Object>(attachObjs.length);
                for (Object attachObj : attachObjs) {
                    boolean update = false;
                    String attachNo = attachObj.getString("attach_no");
                    ExpenseAttachDTO attachDTO = (ExpenseAttachDTO)attachDTOMap.get(attachNo);
                    if (attachDTO == null) continue;
                    DynamicObject item = BusinessDataServiceHelper.newDynamicObject((String)"rim_attach_relation");
                    String serialNo = attachDTO.getSerialNo();
                    item.set("relation_type", (Object)1);
                    if (!kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)serialNo)) {
                        item.set("relation_type", (Object)2);
                    }
                    item.set("attach_id", (Object)String.valueOf(attachObj.getLong("id")));
                    item.set("expense_id", (Object)expenseId);
                    item.set("relation_id", (Object)serialNo);
                    attachRelationList.add(item);
                    if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)attachDTO.getAttachName())) {
                        attachObj.set("attach_name", (Object)attachDTO.getAttachName());
                        update = true;
                    }
                    if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)attachDTO.getAttachRemark())) {
                        attachObj.set("remark", (Object)attachDTO.getAttachRemark());
                        update = true;
                    }
                    if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)attachDTO.getAttachUrl())) {
                        attachObj.set("attach_url", (Object)attachDTO.getAttachUrl());
                        update = true;
                    }
                    if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)attachDTO.getAttachType())) {
                        attachObj.set("attach_type", (Object)attachDTO.getAttachType());
                        update = true;
                    }
                    if (!update) continue;
                    attachObj.set("update_time", (Object)new Date());
                    updateAttach.add(attachObj);
                }
                if (!CollectionUtils.isEmpty(updateAttach)) {
                    SaveServiceHelper.save((DynamicObject[])updateAttach.toArray(new DynamicObject[updateAttach.size()]));
                }
                if (!CollectionUtils.isEmpty(attachRelationList)) {
                    SaveServiceHelper.save((DynamicObject[])attachRelationList.toArray(new DynamicObject[attachRelationList.size()]));
                }
                attachQueryService.cacheFpzsAttach(param.getExpenseId(), param.getEntityId(), param.getResource(), null);
            }
        }
    }

    private void deleteAwsBill(List<String> deleteExpenseId) {
        if (!CollectionUtils.isEmpty(deleteExpenseId)) {
            QFilter expenseIdfilter = new QFilter("expense_id", "in", deleteExpenseId);
            QFilter resourcefilter = new QFilter("resource", "=", (Object)"aws");
            DeleteServiceHelper.delete((String)"rim_expense_relation", (QFilter[])new QFilter[]{expenseIdfilter, resourcefilter});
        }
    }

    public void statusUpdate(ExpenseDTO param) {
        String bussinSysBillStatus = param.getBussinSysBillStatus();
        if (!BussinSysBillStatusEnum.isBillStatusUpdateStatus(bussinSysBillStatus)) {
            throw new MsgException(ErrorType.PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u53c2\u6570\u7cfb\u7edf\u5355\u636e\u72b6\u6001\u6570\u636e\u9519\u8bef\u3002", (String)"ExpenseService_13", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        String status = BussinSysBillStatusEnum.convertExpenseStatus(bussinSysBillStatus);
        if (BussinSysBillStatusEnum.BILL_POSTED_TO_ACCOUNTS.getCode().equals(bussinSysBillStatus) && CollectionUtils.isEmpty(param.getVoucherList())) {
            throw new MsgException(ErrorType.PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u5355\u636e\u5165\u8d26\uff0c\u51ed\u8bc1\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ExpenseService_16", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        param.setStatus(status);
        QFilter idfilter = this.getExpenseRelationQFilter(param, "expense_id", "entityid", "resource");
        List list = QueryServiceHelper.queryPrimaryKeys((String)"rim_expense", (QFilter[])new QFilter[]{idfilter}, (String)"id", (int)5);
        if (CollectionUtils.isEmpty((Collection)list)) {
            throw new MsgException(ErrorType.PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u5355\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5bf9\u540e\u518d\u63d0\u4ea4\u3002", (String)"ExpenseService_15", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        Throwable throwable = null;
        try (TXHandle h = TX.requiresNew();){
            if (BussinSysBillStatusEnum.BILL_DELETED.getCode().equals(bussinSysBillStatus)) {
                this.deleteBillVoucherRelation(param);
                this.deleteExpense(param, true);
                return;
            }
            try {
                DynamicObject expenseObject = BusinessDataServiceHelper.loadSingle(list.get(0), (String)"rim_expense");
                param.setOrgId(DynamicObjectUtil.getDynamicObjectLongValue(expenseObject.get("orgid")));
                expenseObject.set("billupdatetime", (Object)param.getUpdateTime());
                expenseObject.set("status", (Object)param.getStatus());
                expenseObject.set("bussinsysbillstatus", (Object)bussinSysBillStatus);
                expenseObject.set("update_time", (Object)new Date());
                DynamicObjectCollection relations = QueryServiceHelper.query((String)"rim_expense_relation", (String)"id,serial_no", (QFilter[])new QFilter[]{idfilter});
                List<ExpenseInvoiceDTO> invoiceList = param.getInvoiceList();
                ArrayList<String> serialList = new ArrayList<String>(8);
                if (!CollectionUtils.isEmpty((Collection)relations)) {
                    DynamicObject[] relationObjs;
                    JSONObject verifyConfig;
                    HashMap<String, ExpenseInvoiceDTO> invoiceDTOMap = new HashMap<String, ExpenseInvoiceDTO>(8);
                    HashSet<String> savedSerialNo = new HashSet<String>(8);
                    HashMap<String, Boolean> serialRepeatMap = new HashMap<String, Boolean>(8);
                    if (invoiceList != null) {
                        for (ExpenseInvoiceDTO invoiceDto : invoiceList) {
                            if (!CollectionUtils.isEmpty(savedSerialNo) && savedSerialNo.contains(invoiceDto.getSerialNo())) continue;
                            savedSerialNo.add(invoiceDto.getSerialNo());
                            invoiceDTOMap.put(invoiceDto.getSerialNo(), invoiceDto);
                            serialRepeatMap.put(invoiceDto.getSerialNo(), invoiceDto.isAllowRepeat());
                        }
                    }
                    Object[] ids = relations.stream().map(s -> s.get("id")).toArray();
                    Set<String> serialNos = relations.stream().map(s -> s.getString("serial_no")).collect(Collectors.toSet());
                    HashMap<String, Object> verifyParam = new HashMap<String, Object>(4);
                    verifyParam.put("orgId", param.getOrgId());
                    verifyParam.put("billType", param.getExpenseType());
                    Boolean allowRepeat = Boolean.FALSE;
                    allowRepeat = param.isAllowRepeat() ? Boolean.TRUE : Boolean.valueOf(!"0".equals((verifyConfig = VerifyService.getVerfifyConfig(verifyParam)).getString("repeat_expense")));
                    ArrayList<String> deleteExpenseId = new ArrayList<String>(8);
                    QFilter filter = new QFilter("serial_no", "in", serialNos);
                    DynamicObjectCollection collection = QueryServiceHelper.query((String)"rim_expense_relation", (String)"id,expense_num,expense_id,status,resource,entityid,serial_no", (QFilter[])new QFilter[]{filter});
                    ArrayList<ExpenseInvoiceDTO> invoiceListVerify = new ArrayList<ExpenseInvoiceDTO>(relations.size());
                    for (String serialNo : serialNos) {
                        ExpenseInvoiceDTO invoiceDTO = (ExpenseInvoiceDTO)invoiceDTOMap.get(serialNo);
                        if (invoiceDTO == null) {
                            invoiceDTO = new ExpenseInvoiceDTO();
                            invoiceDTO.setSerialNo(serialNo);
                        }
                        invoiceListVerify.add(invoiceDTO);
                    }
                    Map<String, Map<String, Object>> invoiceInfoMap = this.getMainDynamicObjectMap(serialList);
                    this.verifyRepeat(param, invoiceListVerify, serialRepeatMap, allowRepeat, deleteExpenseId, collection, invoiceInfoMap);
                    this.deleteAwsBill(deleteExpenseId);
                    Map<String, Map<String, Object>> serialMainMap = this.getMainDynamicObjectMap(serialNos);
                    for (DynamicObject dynamicObject : relationObjs = BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"rim_expense_relation"))) {
                        String serialNo = dynamicObject.getString("serial_no");
                        Map<String, Object> mainObj = serialMainMap.get(serialNo);
                        ExpenseInvoiceDTO invoiceDTO = (ExpenseInvoiceDTO)invoiceDTOMap.get(serialNo);
                        if (mainObj == null) continue;
                        if (invoiceDTO != null) {
                            this.updateReletionBussinValue(param, invoiceDTO, mainObj, dynamicObject);
                        } else {
                            dynamicObject.set("status", (Object)param.getStatus());
                            dynamicObject.set("bussinsysbillstatus", (Object)param.getBussinSysBillStatus());
                            if ("01".equals(param.getFullPayFlag())) {
                                dynamicObject.set("expense_amount", mainObj.get("total_amount"));
                            }
                        }
                        dynamicObject.set("update_time", (Object)new Date());
                    }
                    this.saveInvoiceReimEntry(serialNos, param);
                    SaveServiceHelper.save((DynamicObject[])relationObjs);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{expenseObject});
                    serialList = new ArrayList<String>(serialNos);
                    this.updateInvoiceMain(serialList, null);
                    this.updateInvoiceOrg(param);
                }
                this.saveBillVoucher(param);
                this.deleteBillVoucherRelation(param);
                this.saveCallBack("save", param, serialList, Lists.newArrayList());
                FpzsMainService.cacheFpzsPushInvoices(param.getExpenseId(), param.getEntityId(), param.getResource(), null);
                InvoiceImageNotifyService.imageNotify(param);
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
    }

    private void deleteBillVoucher(ExpenseDTO param, List<String> serialNos) {
        DynamicObjectCollection collect = this.getBillVouchers(param);
        if (!CollectionUtils.isEmpty((Collection)collect)) {
            VoucherService voucherService = new VoucherService();
            HashMap<String, Object> voucherParam = new HashMap<String, Object>(8);
            voucherParam.put("resource", param.getResource());
            voucherParam.put("serialNoArray", serialNos);
            for (DynamicObject dynamicObject : collect) {
                voucherParam.put("vouchId", dynamicObject.getString("vouchid"));
                voucherService.deleteVoucherContent(voucherParam);
            }
        }
    }

    private void deleteBillVoucherRelation(ExpenseDTO param) {
        if (BussinSysBillStatusEnum.isDeleteVoucherStatus(param.getBussinSysBillStatus())) {
            this.deleteBillVoucher(param, null);
        }
    }

    private void bindBillVoucher2NewInvoice(ExpenseDTO param, List<String> serialNoList) {
        if (BussinSysBillStatusEnum.BILL_POSTED_TO_ACCOUNTS.getCode().equals(param.getBussinSysBillStatus())) {
            if (CollectionUtils.isEmpty(serialNoList)) {
                return;
            }
            DynamicObjectCollection collect = this.getBillVouchers(param);
            if (CollectionUtils.isEmpty((Collection)collect)) {
                return;
            }
            VoucherService voucherService = new VoucherService();
            for (DynamicObject dynamicObject : collect) {
                HashMap<String, Object> voucherParam = new HashMap<String, Object>(8);
                JSONObject voucherInfo = new JSONObject();
                voucherInfo.put("vouchId", (Object)dynamicObject.getString("vouchid"));
                voucherInfo.put("vouchNo", (Object)dynamicObject.getString("vouch_no"));
                voucherInfo.put("resource", (Object)dynamicObject.getString("resource"));
                voucherInfo.put("accountDate", (Object)DynamicObjectUtil.fieldToString(dynamicObject.get("account_date"), "yyyy-MM-dd"));
                voucherInfo.put("accountTime", (Object)dynamicObject.getDate("account_time"));
                voucherParam.put("voucherInfo", voucherInfo);
                voucherParam.put("serialNoArray", serialNoList);
                voucherService.saveVoucherContent(voucherParam);
            }
        }
    }

    private DynamicObjectCollection getBillVouchers(ExpenseDTO param) {
        QFilter idFilter = new QFilter("billid", "=", (Object)param.getExpenseId()).and("bill_type", "=", (Object)"1");
        QFilter resourceFilter = new QFilter("resource", "=", (Object)param.getResource());
        return QueryServiceHelper.query((String)"rim_vouch_relation", (String)"id,bill_type,billid,vouchid,account_time,vouch_no,resource,account_date", (QFilter[])new QFilter[]{idFilter, resourceFilter});
    }

    private void saveBillVoucher(ExpenseDTO param) {
        List<ExpenseVoucherDTO> voucherList;
        if (BussinSysBillStatusEnum.BILL_POSTED_TO_ACCOUNTS.getCode().equals(param.getBussinSysBillStatus()) && (voucherList = param.getVoucherList()) != null) {
            VoucherService voucherService = new VoucherService();
            for (ExpenseVoucherDTO voucherDTO : voucherList) {
                HashMap<String, Object> voucherParam = new HashMap<String, Object>(8);
                String json = SerializationUtils.toJsonString((Object)voucherDTO);
                JSONObject voucherInfo = JSONObject.parseObject((String)json);
                JSONArray expenseIdArray = new JSONArray();
                expenseIdArray.add((Object)param.getExpenseId());
                voucherParam.put("voucherInfo", voucherInfo);
                voucherParam.put("expenseIdArray", expenseIdArray);
                voucherService.saveVoucherContent(voucherParam);
            }
        }
    }

    public Map<String, Map<String, Object>> getMainDynamicObjectMap(Collection<String> serialNos) {
        QFilter tenantFilter = new QFilter("tenant_no", "=", (Object)TenantUtils.getTenantNo());
        QFilter serialFilter = new QFilter("serial_no", "in", serialNos);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"rim_invoice", (String)"id,invoice_code,invoice_type.id as invoice_type,invoice_no,check_status,total_amount,total_tax_amount,serial_no,original_state,currencyid", (QFilter[])new QFilter[]{tenantFilter, serialFilter});
        HashMap<String, Map<String, Object>> serialMap = new HashMap<String, Map<String, Object>>(collection.size());
        for (DynamicObject dynamicObject : collection) {
            Map<String, Object> dynamicObjectMap = DynamicObjectUtil.dynamicObject2Map(dynamicObject);
            serialMap.put(dynamicObject.getString("serial_no"), dynamicObjectMap);
            Long invoiceType = dynamicObject.getLong("invoice_type");
            if (!InputInvoiceTypeEnum.containCurrencyId(invoiceType)) continue;
            long currencyId = DynamicObjectUtil.getDynamicObjectLongValue(dynamicObject.get("currencyid"));
            int precision = CurrencyUtils.getAmtPrecision(currencyId);
            String format = CurrencyUtils.getFormatByPrecision(precision);
            Object totalAmount = dynamicObjectMap.get("total_amount");
            String totalAmountStr = DynamicObjectUtil.fieldToString(totalAmount, format);
            dynamicObjectMap.put("total_amount", BigDecimalUtil.transDecimal(totalAmountStr));
            Object totalTaxAmount = dynamicObjectMap.get("total_tax_amount");
            String totalTaxAmountStr = DynamicObjectUtil.fieldToString(totalTaxAmount, format);
            dynamicObjectMap.put("total_tax_amount", BigDecimalUtil.transDecimal(totalTaxAmountStr));
        }
        return serialMap;
    }

    public void save(ExpenseDTO param) {
        List<ExpenseInvoiceDTO> invoiceList;
        if (param.getResource() == null) {
            param.setResource(" ");
        }
        if (CollectionUtils.isEmpty(invoiceList = param.getInvoiceList())) {
            try (TXHandle h = TX.requiresNew();){
                try {
                    this.saveBillNotInvoice(param);
                }
                catch (Throwable e) {
                    h.markRollback();
                    throw e;
                }
            }
            return;
        }
        this.saveBillHasInvoice(param, invoiceList);
    }

    private void saveBillHasInvoice(ExpenseDTO param, List<ExpenseInvoiceDTO> invoiceList) {
        JSONObject verifyConfig;
        ArrayList<String> serialList = new ArrayList<String>(invoiceList.size());
        HashMap<String, ExpenseInvoiceDTO> invoiceDtoMap = new HashMap<String, ExpenseInvoiceDTO>(invoiceList.size());
        HashMap<String, Boolean> serialRepeatMap = new HashMap<String, Boolean>(invoiceList.size());
        Long outerOrgId = this.getOuterOrgId(param);
        for (ExpenseInvoiceDTO invoiceDto : invoiceList) {
            invoiceDto.setOuterOrgId(outerOrgId);
            invoiceDto.setExpenseId(param.getExpenseId());
            invoiceDto.setExpenseNum(param.getExpenseNum());
            serialList.add(invoiceDto.getSerialNo());
            invoiceDtoMap.put(invoiceDto.getSerialNo(), invoiceDto);
            serialRepeatMap.put(invoiceDto.getSerialNo(), invoiceDto.isAllowRepeat());
        }
        HashMap<String, Object> verifyParam = new HashMap<String, Object>(4);
        verifyParam.put("orgId", param.getOrgId());
        verifyParam.put("billType", param.getExpenseType());
        Boolean allowRepeat = Boolean.FALSE;
        allowRepeat = param.isAllowRepeat() ? Boolean.TRUE : Boolean.valueOf(!"0".equals((verifyConfig = VerifyService.getVerfifyConfig(verifyParam)).getString("repeat_expense")));
        List<String> deleteSerialList = null;
        List<String> origSerialList = null;
        ArrayList<String> deleteExpenseId = new ArrayList<String>(8);
        try (TXHandle h = TX.requiresNew();){
            try {
                origSerialList = this.updateInvoiceByOriginalId(param, serialList);
                QFilter filter = new QFilter("serial_no", "in", serialList);
                DynamicObjectCollection collection = QueryServiceHelper.query((String)"rim_expense_relation", (String)"id,expense_num,expense_id,status,resource,entityid,serial_no,use_type,expense_amount", (QFilter[])new QFilter[]{filter});
                Map<String, Map<String, Object>> invoiceInfoMap = this.getMainDynamicObjectMap(serialList);
                if (CollectionUtils.isEmpty((Collection)collection)) {
                    deleteSerialList = this.deleteExpense(param, false);
                    this.newExpense(param, serialList, invoiceInfoMap);
                } else if ("1".equals(param.getStatus())) {
                    deleteSerialList = this.deleteExpense(param, false);
                    this.newExpense(param, serialList, invoiceInfoMap);
                } else {
                    this.verifyRepeat(param, invoiceList, serialRepeatMap, allowRepeat, deleteExpenseId, collection, invoiceInfoMap);
                    deleteSerialList = this.deleteExpense(param, false);
                    this.newExpense(param, serialList, invoiceInfoMap);
                }
                this.deleteAwsBill(deleteExpenseId);
                this.saveCoverRelation(param);
                this.saveAttachmentRelation(param);
                ArrayList<String> addSerialList = new ArrayList<String>(serialList);
                ArrayList<String> delSerialList = null;
                if (!CollectionUtils.isEmpty(deleteSerialList)) {
                    delSerialList = new ArrayList<String>(deleteSerialList);
                    delSerialList.removeAll(serialList);
                    serialList.addAll(deleteSerialList);
                }
                if (!origSerialList.isEmpty()) {
                    serialList.addAll(origSerialList);
                }
                this.updateInvoiceMain(serialList, invoiceDtoMap);
                if (deleteSerialList != null) {
                    deleteSerialList.removeAll(serialList);
                    this.deleteInvoiceAttach(deleteSerialList, param.getExpenseId());
                }
                this.saveCallBack("save", param, addSerialList, delSerialList);
                this.updateInvoiceOrg(param);
                FpzsMainService.cacheFpzsPushInvoices(param.getExpenseId(), param.getEntityId(), param.getResource(), null);
                InvoiceImageNotifyService.imageNotify(param);
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
    }

    private Long getOuterOrgId(ExpenseDTO param) {
        String saveUpdateOrg = ImcConfigUtil.getValue("rim_config", "save_update_org");
        if (!param.isUpdateInvoiceOrg() && !"1".equals(saveUpdateOrg)) {
            return 0L;
        }
        Long orgId = param.getOrgId();
        if (orgId == null || orgId <= 0L) {
            return 0L;
        }
        return orgId;
    }

    private void saveBillNotInvoice(ExpenseDTO param) {
        HashMap<String, Map<String, Object>> invoiceInfoMap = new HashMap<String, Map<String, Object>>(0);
        this.saveAttachmentRelation(param);
        this.saveCoverRelation(param);
        this.newExpense(param, null, invoiceInfoMap);
        List<String> delteSerialList = this.deleteExpense(param, false);
        List<String> origSerialList = this.updateInvoiceByOriginalId(param, null);
        if (delteSerialList != null && !delteSerialList.isEmpty()) {
            origSerialList.addAll(delteSerialList);
        }
        if (!CollectionUtils.isEmpty(origSerialList)) {
            this.updateInvoiceMain(origSerialList, null);
        }
        FpzsMainService.cacheFpzsPushInvoices(param.getExpenseId(), param.getEntityId(), param.getResource(), null);
        this.saveCallBack("save", param, null, delteSerialList);
        InvoiceImageNotifyService.imageNotify(param);
    }

    private void calculationUsedAmount(List<ExpenseInvoiceDTO> invoiceList, Set<String> doubleSet, Map<String, Map<String, BigDecimal>> usedAmountMap) {
        HashSet<String> removeSet = new HashSet<String>(8);
        for (ExpenseInvoiceDTO dto : invoiceList) {
            BigDecimal remainAmount;
            Map<String, BigDecimal> amountMap = usedAmountMap.get(dto.getSerialNo());
            if (amountMap == null) continue;
            BigDecimal expesneAmount = dto.getExpenseAmount();
            if (expesneAmount == null) {
                expesneAmount = amountMap.get("totalAmount");
            }
            if ((remainAmount = amountMap.get("availableAmount")) != null && remainAmount.abs().compareTo(expesneAmount.abs()) < 0) continue;
            removeSet.add(dto.getSerialNo());
        }
        if (!removeSet.isEmpty()) {
            doubleSet.removeAll(removeSet);
        }
    }

    private Map<String, Map<String, BigDecimal>> getInvoiceUsedAmount(DynamicObjectCollection existsExpenCollect, Set<String> equalExpenseSet, Map<String, Map<String, Object>> invoiceInfoMap) {
        HashMap<String, Map<String, BigDecimal>> useAmountMap = new HashMap<String, Map<String, BigDecimal>>(8);
        for (Map.Entry<String, Map<String, Object>> invoice : invoiceInfoMap.entrySet()) {
            Map<String, Object> invoiceInfo = invoice.getValue();
            HashMap<String, BigDecimal> useAmount = new HashMap<String, BigDecimal>(4);
            useAmount.put("totalAmount", BigDecimalUtil.transDecimal(invoiceInfo.get("total_amount")));
            useAmount.put("usedAmount", BigDecimal.ZERO);
            useAmount.put("availableAmount", (BigDecimal)useAmount.get("totalAmount"));
            useAmountMap.put(invoice.getKey(), useAmount);
        }
        for (DynamicObject obj : existsExpenCollect) {
            String uKey;
            if ("1".equals(obj.getString("status")) || equalExpenseSet.contains(uKey = obj.getString("entityid") + obj.getString("expense_id") + obj.getString("resource"))) continue;
            String serialNo = obj.getString("serial_no");
            Map<String, Object> invoiceInfo = invoiceInfoMap.get(serialNo);
            HashMap<String, BigDecimal> useAmount = (HashMap<String, BigDecimal>)useAmountMap.get(serialNo);
            if (useAmount == null) {
                useAmount = new HashMap<String, BigDecimal>(2);
                useAmount.put("usedAmount", BigDecimal.ZERO);
                if (invoiceInfo != null) {
                    useAmount.put("totalAmount", BigDecimalUtil.transDecimal(invoiceInfo.get("total_amount")));
                } else {
                    useAmount.put("totalAmount", BigDecimal.ZERO);
                }
            }
            BigDecimal amount = (BigDecimal)useAmount.get("usedAmount");
            amount = 1 == obj.getInt("use_type") ? amount.add(obj.getBigDecimal("expense_amount")) : amount.add((BigDecimal)useAmount.get("totalAmount"));
            if (amount.abs().compareTo(((BigDecimal)useAmount.get("totalAmount")).abs()) > 0) {
                amount = (BigDecimal)useAmount.get("totalAmount");
            }
            useAmount.put("usedAmount", amount);
            useAmount.put("availableAmount", ((BigDecimal)useAmount.get("totalAmount")).subtract(amount));
            useAmountMap.put(serialNo, useAmount);
        }
        return useAmountMap;
    }

    private void verifyRepeat(ExpenseDTO param, List<ExpenseInvoiceDTO> invoiceList, Map<String, Boolean> serialRepeatMap, Boolean allowRepeat, List<String> deleteExpenseId, DynamicObjectCollection collection, Map<String, Map<String, Object>> invoiceInfoMap) {
        HashSet<String> doubleSet = new HashSet<String>();
        this.loadBillLinkByMainTenant(param);
        HashSet<String> equalExpenseSet = new HashSet<String>(8);
        for (DynamicObject obj : collection) {
            Boolean isAllowRepeat;
            String status = obj.getString("status");
            String serialNo = obj.getString("serial_no");
            boolean idEqual = this.isEqual(param.getEntityId(), param.getExpenseId(), param.getResource(), obj.getString("entityid"), obj.getString("expense_id"), obj.getString("resource"), param.getBotpBillList());
            if (idEqual) {
                equalExpenseSet.add(obj.getString("entityid") + obj.getString("expense_id") + obj.getString("resource"));
            }
            if (idEqual && "aws".equals(obj.getString("resource"))) {
                deleteExpenseId.add(obj.getString("expense_id"));
            }
            if (idEqual || !kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)status) || "1".equals(obj.getString("status")) || (isAllowRepeat = serialRepeatMap.get(serialNo)) != null && isAllowRepeat.booleanValue()) continue;
            doubleSet.add(serialNo);
        }
        if (!allowRepeat.booleanValue()) {
            Iterator iterator;
            Map<String, Map<String, BigDecimal>> usedAmountMap = this.getInvoiceUsedAmount(collection, equalExpenseSet, invoiceInfoMap);
            this.calculationUsedAmount(invoiceList, doubleSet, usedAmountMap);
            if (doubleSet.size() > 0 && (iterator = doubleSet.iterator()).hasNext()) {
                String serialNo = (String)iterator.next();
                Map<String, Object> mainMap = invoiceInfoMap.get(serialNo);
                String partRepeatStr = String.format(ResManager.loadKDString((String)"\u53d1\u7968%1$s\u4f7f\u7528\u91d1\u989d\u8d85\u51fa\u5269\u4f59\u53ef\u7528\u91d1\u989d%2$s\u5143\uff0c\u4fdd\u5b58\u5931\u8d25", (String)"ExpenseService_8", (String)"imc-rim-common", (Object[])new Object[0]), mainMap.get("invoice_no"), DynamicObjectUtil.fieldToString(usedAmountMap.get(serialNo).get("availableAmount")));
                JSONObject data = new JSONObject();
                data.put("invoiceCode", mainMap.get("invoice_code"));
                data.put("invoiceNo", mainMap.get("invoice_no"));
                data.put("serialNo", mainMap.get("serial_no"));
                throw new MsgException(ErrorType.PART_REPEAT.getCode(), partRepeatStr, data);
            }
        }
    }

    private boolean isEqual(String entityId1, String expenseId1, String resource1, String entityId2, String expenseId2, String resource2, List<Map<String, String>> botpBillList) {
        boolean equalResult = this.isEqual(entityId1, expenseId1, resource1, entityId2, expenseId2, resource2);
        if (equalResult || botpBillList == null || botpBillList.isEmpty()) {
            return equalResult;
        }
        for (Map<String, String> botpBill : botpBillList) {
            if (!this.isEqual(botpBill.get("entityId"), botpBill.get("billId"), resource1, entityId2, expenseId2, resource2)) continue;
            return true;
        }
        return false;
    }

    private boolean isEqual(String entityId1, String expenseId1, String resource1, String entityId2, String expenseId2, String resource2) {
        entityId1 = kd.bos.dataentity.utils.StringUtils.trimToEmpty((String)entityId1);
        expenseId1 = kd.bos.dataentity.utils.StringUtils.trimToEmpty((String)expenseId1);
        resource1 = kd.bos.dataentity.utils.StringUtils.trimToEmpty((String)resource1);
        entityId2 = kd.bos.dataentity.utils.StringUtils.trimToEmpty((String)entityId2);
        expenseId2 = kd.bos.dataentity.utils.StringUtils.trimToEmpty((String)expenseId2);
        if ("aws".equals(resource2 = kd.bos.dataentity.utils.StringUtils.trimToEmpty((String)resource2)) && !kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)entityId2)) {
            resource2 = "4";
        }
        if (expenseId1.equals(expenseId2)) {
            if (resource1.equals(resource2)) {
                return true;
            }
            if (!kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)entityId1) && !kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)entityId2)) {
                return entityId1.equals(entityId2);
            }
        }
        if (!kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)entityId1) && !expenseId1.startsWith(entityId1)) {
            expenseId1 = entityId1 + '_' + expenseId1;
        }
        if (!kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)entityId2) && !expenseId1.startsWith(entityId2)) {
            expenseId2 = entityId2 + '_' + expenseId2;
        }
        return expenseId1.equals(expenseId2);
    }

    private List<String> updateInvoiceByOriginalId(ExpenseDTO param, List<String> serialList) {
        ArrayList<String> updateSerialList = new ArrayList<String>(16);
        if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)param.getOriginalId())) {
            MainEntityType mainEntityType;
            QFilter expenseIdfilter = new QFilter("expense_id", "=", (Object)param.getOriginalId());
            QFilter entityfilter = null;
            if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)param.getOriginalType())) {
                entityfilter = new QFilter("entityid", "=", (Object)param.getOriginalType());
            }
            if (entityfilter == null && kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)param.getEntityId())) {
                entityfilter = new QFilter("entityid", "=", (Object)param.getEntityId());
            }
            QFilter resourcefilter = null;
            if (entityfilter == null && kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)param.getResource())) {
                resourcefilter = new QFilter("resource", "=", (Object)param.getResource());
            }
            DynamicObjectCollection collect = QueryServiceHelper.query((String)"rim_expense_relation", (String)"id,serial_no", (QFilter[])new QFilter[]{expenseIdfilter, entityfilter, resourcefilter});
            ArrayList<Long> updateList = new ArrayList<Long>(16);
            ArrayList<Long> deleteList = new ArrayList<Long>(16);
            for (DynamicObject object : collect) {
                if (serialList == null || serialList.isEmpty()) {
                    updateList.add(object.getLong("id"));
                } else {
                    deleteList.add(object.getLong("id"));
                }
                updateSerialList.add(object.getString("serial_no"));
            }
            if (!deleteList.isEmpty()) {
                mainEntityType = EntityMetadataCache.getDataEntityType((String)"rim_expense_relation");
                DeleteServiceHelper.delete((IDataEntityType)mainEntityType, (Object[])deleteList.toArray());
            }
            if (!updateList.isEmpty()) {
                DynamicObject[] objects;
                mainEntityType = EntityMetadataCache.getDataEntityType((String)"rim_expense_relation");
                for (DynamicObject obj : objects = BusinessDataServiceHelper.load((Object[])updateList.toArray(), (DynamicObjectType)mainEntityType)) {
                    obj.set("expense_num", (Object)param.getExpenseNum());
                    obj.set("expense_id", (Object)param.getExpenseId());
                    obj.set("entityid", (Object)param.getEntityId());
                    obj.set("view_page", (Object)param.getViewPage());
                    obj.set("expense_type", (Object)param.getExpenseType());
                    obj.set("status", (Object)param.getStatus());
                    obj.set("resource", (Object)param.getResource());
                }
                SaveServiceHelper.save((DynamicObject[])objects);
            }
        }
        return updateSerialList;
    }

    public void saveCoverAndAttachmentRelation(ExpenseDTO param) {
        if (param.getResource() == null) {
            param.setResource(" ");
        }
        try (TXHandle h = TX.requiresNew();){
            try {
                this.saveAttachmentRelation(param);
                this.saveCoverRelation(param);
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
    }

    private void saveCallBack(String operate, ExpenseDTO param, List<String> addSerialList, List<String> delSerialList) {
        InvoiceSaveEkService ekService = EkServiceFactory.getInvoiceSaveEkService();
        HashMap<String, Object> expenseInfo = new HashMap<String, Object>(8);
        expenseInfo.put("billId", param.getExpenseId());
        expenseInfo.put("billNo", param.getExpenseNum());
        expenseInfo.put("entityId", param.getEntityId());
        expenseInfo.put("resource", param.getResource());
        expenseInfo.put("status", param.getStatus());
        if ("delete".equals(operate)) {
            ekService.afterDelExpense(expenseInfo, delSerialList);
        } else {
            ekService.afterSaveExpense(expenseInfo, addSerialList, delSerialList);
        }
    }

    public void saveInvoiceAndExpenseOfAPI(List<ExpenseDTO> expenseList, String invoiceSerialNo) {
        ArrayList serialList = Lists.newArrayList((Object[])new String[]{invoiceSerialNo});
        QFilter filter = new QFilter("serial_no", "in", (Object)serialList);
        filter.and(new QFilter("resource", "in", (Object)"api"));
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"rim_expense_relation", (String)"id,expense_num,expense_id,status,resource,serial_no", (QFilter[])new QFilter[]{filter});
        Map<String, Map<String, Object>> invoiceInfoMap = this.getMainDynamicObjectMap(serialList);
        try (TXHandle h = TX.requiresNew();){
            try {
                if (collection != null && !collection.isEmpty()) {
                    DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"rim_expense_relation"), (Object[])collection.stream().map(v -> v.get("id")).toArray());
                }
                for (ExpenseDTO param : expenseList) {
                    this.deleteInvoiceReimEntry(serialList, param);
                    this.newExpense(param, serialList, invoiceInfoMap);
                }
                ExpenseInvoiceDTO invoiceDto = new ExpenseInvoiceDTO();
                invoiceDto.setSerialNo(invoiceSerialNo);
                HashMap invoiceDtoMap = Maps.newHashMapWithExpectedSize((int)1);
                invoiceDtoMap.put(invoiceSerialNo, invoiceDto);
                this.updateInvoiceMain(serialList, invoiceDtoMap);
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
    }

    private void deleteInvoiceAttach(List<String> deletedSerials, String expenseId) {
        if (CollectionUtils.isEmpty(deletedSerials) || kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)expenseId)) {
            return;
        }
        ArrayList<String> notNullList = new ArrayList<String>(deletedSerials.size());
        for (String serialNo : deletedSerials) {
            if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)serialNo)) continue;
            notNullList.add(serialNo);
        }
        QFilter filter = new QFilter("relation_id", "in", notNullList).and("expense_id", "=", (Object)expenseId);
        DeleteServiceHelper.delete((String)"rim_attach_relation", (QFilter[])filter.toArray());
    }

    public void updateInvoiceOrg(ExpenseDTO param) {
        String saveUpdateOrg = ImcConfigUtil.getValue("rim_config", "save_update_org");
        if (!param.isUpdateInvoiceOrg() && !"1".equals(saveUpdateOrg)) {
            return;
        }
        List<ExpenseInvoiceDTO> invoiceList = param.getInvoiceList();
        if (invoiceList.isEmpty()) {
            return;
        }
        Long orgId = param.getOrgId();
        if (orgId == null || orgId <= 0L) {
            return;
        }
        List<String> serialList = invoiceList.stream().map(ExpenseInvoiceDTO::getSerialNo).collect(Collectors.toList());
        DynamicObject[] mainInvoiceArr = InvoiceQueryService.queryInvoiceHead("rim_invoice", TenantUtils.getTenantNo(), serialList);
        int mapSize = Math.min(InputInvoiceTypeEnum.values().length, serialList.size());
        HashMap<String, Map> map = new HashMap<String, Map>(mapSize);
        for (DynamicObject mainInvoice : mainInvoiceArr) {
            mainInvoice.set("org_id", (Object)orgId);
            String serialNo = mainInvoice.getString("serial_no");
            Long invoiceType = mainInvoice.getLong("invoice_type.id");
            String entityName = InputInvoiceTypeEnum.getEntity(invoiceType);
            Map temp = map.getOrDefault(entityName, new HashMap(1));
            Long taxOrgId = 0L;
            taxOrgId = InputInvoiceTypeEnum.needCheck(invoiceType) != false ? TenantUtils.getTaxOrgId(orgId, mainInvoice.getString("buyer_tax_no")) : TenantUtils.getTaxOrgId(orgId);
            mainInvoice.set("tax_org", (Object)taxOrgId);
            temp.put(serialNo, taxOrgId);
            map.put(entityName, temp);
        }
        SaveServiceHelper.save((DynamicObject[])mainInvoiceArr);
        for (Map.Entry entry : map.entrySet()) {
            DynamicObject[] invoiceObjects;
            String entityName = (String)entry.getKey();
            Map entryValue = (Map)entry.getValue();
            ArrayList<String> serialNos = new ArrayList<String>(entryValue.keySet());
            for (DynamicObject invoiceObject : invoiceObjects = InvoiceQueryService.queryInvoiceHead(entityName, TenantUtils.getTenantNo(), serialNos)) {
                String serialNo = invoiceObject.getString("serial_no");
                invoiceObject.set("tax_org", (Object)entryValue.getOrDefault(serialNo, 0L));
            }
            SaveServiceHelper.save((DynamicObject[])invoiceObjects);
        }
    }

    public void updateInvoiceMain(List<String> serialList, Map<String, ExpenseInvoiceDTO> invoiceDtoMap) {
        this.updateInvoiceMain(serialList, invoiceDtoMap, "");
    }

    public void updateInvoiceMain(List<String> serialList, Map<String, ExpenseInvoiceDTO> invoiceDtoMap, String from) {
        QFilter tenantFilter = new QFilter("tenant_no", "=", (Object)TenantUtils.getTenantNo());
        QFilter serialFilter = new QFilter("serial_no", "in", serialList);
        DynamicObjectCollection relationList = QueryServiceHelper.query((String)"rim_expense_relation", (String)"id,serial_no,status,expense_num,preset_deduction_purpose,create_time,deduction_flag,deduction_amount,output_reason,output_amount,effective_tax_amount, not_deductible_type", (QFilter[])new QFilter[]{serialFilter}, (String)"status desc,create_time");
        HashMap<String, Map<String, Object>> statusMap = new HashMap<String, Map<String, Object>>(serialList.size());
        VoucherService voucherService = new VoucherService();
        DynamicObjectCollection vouchCollection = voucherService.queryVouchRelationBySerialNos(serialList);
        if (!CollectionUtils.isEmpty((Collection)vouchCollection)) {
            for (Iterator obj : vouchCollection) {
                String billid = obj.getString("billid");
                HashMap<String, Object> statusValueMap = (HashMap<String, Object>)statusMap.get(billid);
                if (statusValueMap == null) {
                    statusValueMap = new HashMap<String, Object>(8);
                    statusValueMap.put("deduction_amount", BigDecimal.ZERO);
                    statusValueMap.put("output_amount", BigDecimal.ZERO);
                    statusValueMap.put("output_reason", "");
                }
                String vouch_no = obj.getString("vouch_no");
                HashSet<String> set = (HashSet<String>)statusValueMap.get("vouchNo");
                if (set == null) {
                    set = new HashSet<String>(4);
                }
                set.add(vouch_no);
                statusValueMap.put("vouchNo", set);
                Date accountDate1 = (Date)statusValueMap.get("accountDate");
                Date accountDate2 = obj.getDate("account_date");
                if (accountDate1 == null || accountDate2 != null && accountDate2.compareTo(accountDate1) > 0) {
                    statusValueMap.put("accountDate", accountDate2);
                    statusValueMap.put("accountTime", obj.getDate("account_time"));
                }
                statusValueMap.put("status", 65);
                statusMap.put(billid, statusValueMap);
            }
        }
        HashMap<String, Set<String>> expenNoMap = new HashMap<String, Set<String>>(serialList.size());
        for (DynamicObject obj : relationList) {
            Date time;
            Date createDate;
            String notDeductibleType;
            String preset_deduction_purpose;
            String expense_num;
            HashSet<String> set;
            Integer status2;
            Integer status = this.getStausInteger(obj.getString("status"));
            String serailNo = obj.getString("serial_no");
            HashMap<String, Object> statusValueMap = (HashMap<String, Object>)statusMap.get(serailNo);
            if (statusValueMap == null) {
                statusValueMap = new HashMap<String, Object>(8);
                statusValueMap.put("deduction_amount", BigDecimal.ZERO);
                statusValueMap.put("output_amount", BigDecimal.ZERO);
                statusValueMap.put("output_reason", "");
            }
            if ((status2 = (Integer)statusValueMap.get("status")) == null || status > status2) {
                statusValueMap.put("status", status);
            }
            if ((set = (HashSet<String>)expenNoMap.get(serailNo)) == null) {
                set = new HashSet<String>();
            }
            if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)(expense_num = obj.getString("expense_num")))) {
                set.add(obj.getString("expense_num"));
            }
            expenNoMap.put(serailNo, set);
            String deductionFlag = obj.getString("deduction_flag");
            BigDecimal deductionAmount = obj.getBigDecimal("deduction_amount");
            BigDecimal effectiveTaxAmount = obj.getBigDecimal("effective_tax_amount");
            String outputReason = obj.getString("output_reason");
            BigDecimal outputAmount = obj.getBigDecimal("output_amount");
            if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)deductionFlag)) {
                String flag = (String)statusValueMap.get("deduction_flag");
                if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)flag)) {
                    statusValueMap.put("deduction_flag", deductionFlag);
                } else if (!"0".equals(flag)) {
                    statusValueMap.put("deduction_flag", deductionFlag);
                }
            }
            if (deductionAmount != null && deductionAmount.compareTo(BigDecimal.ZERO) > 0) {
                statusValueMap.put("deduction_amount", deductionAmount);
            }
            if (effectiveTaxAmount != null && effectiveTaxAmount.compareTo(BigDecimal.ZERO) > 0) {
                statusValueMap.put("effective_tax_amount", effectiveTaxAmount);
            }
            if (!kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)(preset_deduction_purpose = obj.getString("preset_deduction_purpose")))) {
                statusValueMap.put("preset_deduction_purpose", preset_deduction_purpose);
            }
            if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)(notDeductibleType = obj.getString("not_deductible_type")))) {
                statusValueMap.put("not_deductible_type", notDeductibleType);
            }
            if (outputAmount != null && outputAmount.compareTo(BigDecimal.ZERO) > 0) {
                statusValueMap.put("output_amount", outputAmount);
                statusValueMap.put("output_reason", outputReason);
            }
            if (null != (createDate = obj.getDate("create_time")) && ((time = (Date)statusValueMap.get("create_time")) == null || createDate.compareTo(time) > 0)) {
                statusValueMap.put("create_time", createDate);
            }
            statusMap.put(serailNo, statusValueMap);
        }
        if (!CollectionUtils.isEmpty(serialList)) {
            long start = System.currentTimeMillis();
            this.updateMainExpense(invoiceDtoMap, statusMap, expenNoMap, serialList, from);
        }
        DynamicObjectCollection uncheckList = QueryServiceHelper.query((String)"rim_invoice_uncheck", (String)"id,serial_no,expense_status,expense_num", (QFilter[])new QFilter[]{tenantFilter, serialFilter});
        ArrayList<Object> uncheckPkList = new ArrayList<Object>(uncheckList.size());
        for (DynamicObject obj : uncheckList) {
            uncheckPkList.add(obj.get("id"));
        }
        if (!CollectionUtils.isEmpty(uncheckPkList)) {
            this.updateUncheckExpense(invoiceDtoMap, statusMap, expenNoMap, uncheckPkList);
        }
    }

    private void updateUncheckExpense(Map<String, ExpenseInvoiceDTO> invoiceDtoMap, Map<String, Map<String, Object>> statusMap, Map<String, Set<String>> expenNoMap, List<Object> pkList) {
        DynamicObject[] mainDynamicObjectsTemp;
        for (DynamicObject obj : mainDynamicObjectsTemp = BusinessDataServiceHelper.load((Object[])pkList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"rim_invoice_uncheck"))) {
            ExpenseInvoiceDTO dto;
            Set<String> set;
            String serailNo = obj.getString("serial_no");
            String expense_status = obj.getString("expense_status");
            if (!"65".equals(expense_status)) {
                Integer status2 = (Integer)((Map)statusMap.getOrDefault(serailNo, new HashMap(1))).get("status");
                if (status2 != null) {
                    obj.set("expense_status", (Object)status2.toString());
                } else {
                    obj.set("expense_status", (Object)"1");
                }
            }
            if ((set = expenNoMap.get(serailNo)) == null || set.isEmpty()) {
                obj.set("expense_num", (Object)"");
            } else {
                String num = String.join((CharSequence)",", set);
                if (num.length() > 450) {
                    obj.set("expense_num", (Object)num.substring(0, 450));
                } else {
                    obj.set("expense_num", (Object)String.join((CharSequence)",", set));
                }
            }
            if (invoiceDtoMap != null && (dto = invoiceDtoMap.get(serailNo)) != null && dto.getOrgId() != null && dto.getOrgId() > 0L) {
                obj.set("org", (Object)dto.getOrgId());
            }
            obj.set("expense_time", (Object)new Date());
            obj.set("update_time", (Object)new Date());
        }
        SaveServiceHelper.save((DynamicObject[])mainDynamicObjectsTemp);
    }

    private void updateMainExpense(Map<String, ExpenseInvoiceDTO> invoiceDtoMap, Map<String, Map<String, Object>> statusMap, Map<String, Set<String>> expenNoMap, List<String> serialList) {
        this.updateMainExpense(invoiceDtoMap, statusMap, expenNoMap, serialList, "");
    }

    private void updateMainExpense(Map<String, ExpenseInvoiceDTO> invoiceDtoMap, Map<String, Map<String, Object>> statusMap, Map<String, Set<String>> expenNoMap, List<String> serialList, String from) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"rim_invoice");
        Map fields = mainEntityType.getFields();
        DynamicObject[] mainDynamicObjectsTemp = InvoiceQueryService.queryInvoiceHead("rim_invoice", TenantUtils.getTenantNo(), serialList);
        Boolean deleteUnused = "1".equals(RimConfigUtils.getConfig("delete_unused"));
        String unusedUpdateFields = RimConfigUtils.getConfig("unused_fields");
        InvoiceSaveService service = new InvoiceSaveService();
        HashMap<String, ArrayList<Object>> typeMap = new HashMap<String, ArrayList<Object>>(8);
        HashSet<String> loadDetailSet = new HashSet<String>(4);
        HashMap<String, Long> invoiceOrgMap = new HashMap<String, Long>(8);
        for (DynamicObject obj : mainDynamicObjectsTemp) {
            ArrayList<DynamicObject[]> invoiceList;
            String extInfo;
            DynamicObject[] serailNo = obj.getString("serial_no");
            Long invoiceType = DynamicObjectUtil.getDynamicObjectLongValue(obj.get("invoice_type"));
            String entity = InputInvoiceTypeEnum.getEntity(invoiceType);
            if (InputInvoiceTypeEnum.canTransportDeduction(invoiceType).booleanValue() && ((extInfo = obj.getString("ext_info")) == null || extInfo.indexOf(InvoiceSaveConstant.EXT_DEDUCTION_FLAG) < 0)) {
                loadDetailSet.add(entity);
            }
            if ((invoiceList = (ArrayList<DynamicObject[]>)typeMap.get(entity)) == null) {
                invoiceList = new ArrayList<DynamicObject[]>(4);
            }
            invoiceList.add(serailNo);
            typeMap.put(entity, invoiceList);
            invoiceOrgMap.put((String)serailNo, obj.getLong("org_id"));
        }
        HashMap<String, DynamicObject> detailMap = new HashMap<String, DynamicObject>(serialList.size());
        for (Map.Entry entry : typeMap.entrySet()) {
            DynamicObject[] invoiceBodys = null;
            invoiceBodys = loadDetailSet.contains(entry.getKey()) ? InvoiceQueryService.loadBySerialNo((String)entry.getKey(), " ", (List)entry.getValue()) : InvoiceQueryService.queryInvoiceHead((String)entry.getKey(), " ", (List)entry.getValue());
            for (DynamicObject obj : invoiceBodys) {
                detailMap.put(obj.getString("serial_no"), obj);
            }
        }
        this.updateInvoiceDetailAccountDate(detailMap, statusMap);
        for (DynamicObject obj : mainDynamicObjectsTemp) {
            String entity;
            ArrayList<String> invoiceList;
            ExpenseInvoiceDTO dto;
            String delete;
            Integer expenseStatus;
            String serailNo = obj.getString("serial_no");
            String original_state = obj.getString("original_state");
            Map<String, Object> statusValueMap = statusMap.get(serailNo);
            if (statusValueMap == null) {
                statusValueMap = new HashMap<String, Object>(4);
            }
            if ((expenseStatus = (Integer)statusValueMap.get("status")) == null) {
                expenseStatus = 1;
                statusValueMap.put("status", expenseStatus);
            }
            obj.set("expense_status", (Object)expenseStatus.toString());
            if (expenseStatus < 65) {
                obj.set("vouch_no", (Object)"");
                obj.set("account_time", null);
                obj.set("account_date", null);
            } else {
                Set vouchNoSet = (Set)statusValueMap.get("vouchNo");
                obj.set("vouch_no", (Object)this.getString(vouchNoSet));
                obj.set("account_time", statusValueMap.get("accountTime"));
                obj.set("account_date", statusValueMap.get("accountDate"));
            }
            String deductionFlag = (String)statusValueMap.get("deduction_flag");
            String fpyDeductionFlag = DeductionConstant.getDeductionFlag(obj, (DynamicObject)detailMap.get(serailNo));
            BigDecimal deductionAmount = (BigDecimal)statusValueMap.get("deduction_amount");
            BigDecimal outputAmount = (BigDecimal)statusValueMap.get("output_amount");
            BigDecimal effectiveTaxAmount = (BigDecimal)statusValueMap.get("effective_tax_amount");
            Long invoiceType = DynamicObjectUtil.getDynamicObjectLongValue(obj.get("invoice_type"));
            String authenticateFlag = obj.getString("authenticate_flag");
            String transportDeduction1 = obj.getString("transport_deduction");
            boolean isTransportTypes = Arrays.asList(InputInvoiceTypeEnum.getTransportTypes()).contains(invoiceType);
            boolean modifyDeductionFlag = true;
            if (isTransportTypes && kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)transportDeduction1) && !"0".equals(transportDeduction1)) {
                modifyDeductionFlag = false;
            } else if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)authenticateFlag) && !"0".equals(authenticateFlag)) {
                modifyDeductionFlag = false;
            }
            if (!modifyDeductionFlag) {
                String failReason = ResManager.loadKDString((String)"\u5df2\u52fe\u9009\u3001\u5df2\u62b5\u6263\u3001\u9884\u52fe\u9009\u53d1\u7968\u4e0d\u53d8\u66f4\u62b5\u6263\u6807\u5fd7", (String)"ExpenseServiceDF_0", (String)"imc-rim-common", (Object[])new Object[0]);
                this.saveExpenseDFLog(invoiceDtoMap, fpyDeductionFlag, deductionFlag, failReason, serailNo);
            } else {
                Long targetOrg = this.getTargetOrgId(invoiceDtoMap, invoiceOrgMap, serailNo);
                String failReason = this.setInvoiceDeductionFlagByBill(targetOrg, deductionFlag, fpyDeductionFlag, obj);
                if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)failReason)) {
                    this.saveExpenseDFLog(invoiceDtoMap, fpyDeductionFlag, deductionFlag, failReason, serailNo);
                }
                if (isTransportTypes && "0".equals(obj.getString("deduction_flag"))) {
                    obj.set("effective_tax_amount", (Object)BigDecimal.ZERO);
                }
                if ("1".equals(obj.getString("deduction_flag")) && BigDecimalUtil.transDecimal(obj.get("effective_tax_amount")).compareTo(BigDecimal.ZERO) == 0) {
                    BigDecimal amount = DeductionUtils.recalculateEffectiveTaxAmount(obj, (DynamicObject)detailMap.get(obj.getString("serial_no")));
                    if (amount != null) {
                        obj.set("effective_tax_amount", (Object)amount);
                    }
                    if (isTransportTypes) {
                        boolean isAgric = false;
                        if (InputInvoiceTypeEnum.ORDINARY_ELECTRON.getCode().equals(invoiceType) || InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getCode().equals(invoiceType)) {
                            isAgric = kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)obj.getString("agric_handle_status"));
                        }
                        if (!isAgric) {
                            obj.set("transport_deduction", (Object)"0");
                        } else {
                            obj.set("authenticate_flag", (Object)"0");
                        }
                        if (effectiveTaxAmount != null && effectiveTaxAmount.compareTo(BigDecimal.ZERO) > 0) {
                            obj.set("effective_tax_amount", (Object)effectiveTaxAmount);
                        }
                    }
                }
            }
            if (deductionAmount != null) {
                obj.set("entry_amount", (Object)deductionAmount);
            }
            if (outputAmount != null && "1".equals(fpyDeductionFlag) && outputAmount.compareTo(BigDecimal.ZERO) > 0) {
                obj.set("output_amount", (Object)outputAmount);
                obj.set("output_reason", statusValueMap.get("output_reason"));
            } else {
                obj.set("output_amount", (Object)BigDecimal.ZERO);
                obj.set("output_reason", (Object)"");
            }
            Date create_time = (Date)statusValueMap.get("create_time");
            obj.set("expense_time", (Object)create_time);
            Set<String> set = expenNoMap.get(serailNo);
            String string = delete = InvoiceSaveConstant.INVOICE_SAVE_FROM_VALUE.equals(from) ? obj.getString("delete") : "1";
            if (set == null || set.isEmpty()) {
                obj.set("expense_num", (Object)"");
                if (deleteUnused.booleanValue() && expenseStatus <= 1 && kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)obj.getString("resource"))) {
                    delete = "3";
                }
            } else {
                obj.set("expense_num", (Object)this.getString(set));
            }
            obj.set("delete", (Object)delete);
            statusValueMap.put("delete", delete);
            if (invoiceDtoMap != null && (dto = invoiceDtoMap.get(serailNo)) != null) {
                if (!"1".equals(original_state) && "1".equals(dto.getOriginalState())) {
                    obj.set("original_state", (Object)"1");
                    obj.set("original_time", (Object)new Date());
                }
                if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)dto.getInvoiceResource())) {
                    InvoiceSaveService.setExtInfo(obj, InvoiceSaveConstant.EXT_INVOICE_RESOURCE, dto.getInvoiceResource());
                }
                Long orgId = DynamicObjectUtil.getDynamicObjectLongValue(obj.get("org"));
                if (dto.getOrgId() != null && dto.getOrgId() > 0L && !dto.getOrgId().equals(orgId)) {
                    obj.set("org", (Object)dto.getOrgId());
                    statusValueMap.put("org", dto.getOrgId());
                    if (!InputInvoiceTypeEnum.needCheck(invoiceType).booleanValue()) {
                        Long taxOrg = TenantUtils.getTaxOrgId(dto.getOrgId());
                        statusValueMap.put("tax_org", taxOrg);
                        obj.set("tax_org", (Object)taxOrg);
                    }
                }
                JSONObject extInfo = dto.getExtInfo();
                this.setExtInfo(fields, obj, extInfo);
            }
            if ((invoiceList = (ArrayList<String>)typeMap.get(entity = InputInvoiceTypeEnum.getEntity(invoiceType))) == null) {
                invoiceList = new ArrayList<String>(4);
            }
            invoiceList.add(serailNo);
            typeMap.put(entity, invoiceList);
            if ("1".equals(fpyDeductionFlag)) {
                String authenticate_flag = obj.getString("authenticate_flag");
                String preset_deduction_purpose = (String)statusValueMap.get("preset_deduction_purpose");
                if (preset_deduction_purpose == null) {
                    preset_deduction_purpose = "";
                }
                String transportDeduction = obj.getString("transport_deduction");
                if (isTransportTypes && "0".equals(transportDeduction)) {
                    if (effectiveTaxAmount != null && effectiveTaxAmount.compareTo(BigDecimal.ZERO) > 0 && isTransportTypes) {
                        obj.set("effective_tax_amount", (Object)effectiveTaxAmount);
                    }
                } else if ("0".equals(authenticate_flag)) {
                    obj.set("deduction_purpose", (Object)preset_deduction_purpose);
                    if (effectiveTaxAmount != null && effectiveTaxAmount.compareTo(BigDecimal.ZERO) > 0 && isTransportTypes) {
                        obj.set("effective_tax_amount", (Object)effectiveTaxAmount);
                    }
                    if ("2".equals(preset_deduction_purpose) && statusValueMap.containsKey("not_deductible_type")) {
                        obj.set("not_deductible_type", (Object)((String)statusValueMap.get("not_deductible_type")));
                    }
                }
                obj.set("preset_deduction_purpose", (Object)preset_deduction_purpose);
            }
            statusMap.put(serailNo, statusValueMap);
            obj.set("modifytime", (Object)new Date());
            this.setUnusedField(unusedUpdateFields, expenseStatus.toString(), obj);
            service.setMainInvoiceInfo(obj);
        }
        Map mainMap = Arrays.stream(mainDynamicObjectsTemp).collect(Collectors.toMap(dy -> dy.getString("serial_no"), Function.identity(), (a, b) -> a));
        for (Map.Entry entry : typeMap.entrySet()) {
            List bodySerials = (List)entry.getValue();
            ArrayList<DynamicObject> invoiceBodys = new ArrayList<DynamicObject>(bodySerials.size());
            boolean i = false;
            HashMap<String, IDataEntityProperty> bodyFields = null;
            for (String serailNo : bodySerials) {
                DynamicObject main;
                ExpenseInvoiceDTO dto;
                Object taxOrg;
                Map<String, Object> statusValueMap;
                Object org;
                DynamicObject body = (DynamicObject)detailMap.get(serailNo);
                if (body == null) continue;
                if (bodyFields == null) {
                    bodyFields = new HashMap<String, IDataEntityProperty>(16);
                    DataEntityPropertyCollection mainPros = body.getDataEntityType().getProperties();
                    for (IDataEntityProperty property : mainPros) {
                        bodyFields.put(property.getName(), property);
                    }
                }
                if ((org = (statusValueMap = statusMap.get(serailNo)).get("org")) != null) {
                    body.set("org", statusValueMap.get("org"));
                }
                if ((taxOrg = statusValueMap.get("tax_org")) != null) {
                    body.set("tax_org", taxOrg);
                }
                body.set("delete", statusValueMap.get("delete"));
                if (invoiceDtoMap != null && (dto = invoiceDtoMap.get(serailNo)) != null) {
                    this.setExtInfo(bodyFields, body, dto.getExtInfo());
                }
                body.set("modifytime", (Object)new Date());
                Object status = statusValueMap.get("status");
                if (status != null) {
                    body.set("expense_status", status);
                    this.setUnusedField(unusedUpdateFields, status.toString(), body);
                }
                if ((main = (DynamicObject)mainMap.get(serailNo)) != null) {
                    long invoiceType = DynamicObjectUtil.getDynamicObjectLongValue(body.get("invoice_type"));
                    BigDecimal effectiveTaxAmount = main.getBigDecimal("effective_tax_amount");
                    String notDeductibleType = main.getString("not_deductible_type");
                    String deductionFlag = main.getString("deduction_flag");
                    if (InputInvoiceTypeEnum.canDeduction(invoiceType).booleanValue()) {
                        body.set("effective_tax_amount", (Object)effectiveTaxAmount);
                        body.set("not_deductible_type", (Object)notDeductibleType);
                        body.set("deduction_flag", (Object)deductionFlag);
                    } else if (InputInvoiceTypeEnum.canTransportDeduction(invoiceType).booleanValue()) {
                        body.set("effective_tax_amount", (Object)effectiveTaxAmount);
                        body.set("deduction_flag", (Object)deductionFlag);
                    }
                }
                invoiceBodys.add(body);
            }
            if (invoiceBodys.size() <= 0) continue;
            if (loadDetailSet.contains(entry.getKey())) {
                SaveServiceHelper.save((DynamicObject[])invoiceBodys.toArray(new DynamicObject[0]));
                continue;
            }
            SaveServiceHelper.update((DynamicObject[])invoiceBodys.toArray(new DynamicObject[0]));
        }
        SaveServiceHelper.update((DynamicObject[])mainDynamicObjectsTemp);
    }

    private void saveExpenseDFLog(Map<String, ExpenseInvoiceDTO> invoiceDtoMap, String fpyDeductionFlag, String expenseDeductionFlag, String failReason, String serialNo) {
        if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)serialNo) || invoiceDtoMap == null) {
            return;
        }
        ExpenseInvoiceDTO dto = invoiceDtoMap.get(serialNo);
        if (dto == null) {
            return;
        }
        DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)"rim_expense_df_log");
        object.set("expense_id", (Object)dto.getExpenseId());
        object.set("expense_num", (Object)dto.getExpenseNum());
        object.set("create_time", (Object)new Date());
        object.set("fpy_deduction_flag", (Object)fpyDeductionFlag);
        object.set("expense_deduction_flag", (Object)expenseDeductionFlag);
        object.set("fail_reason", (Object)failReason);
        object.set("serial_no", (Object)serialNo);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
    }

    private void updateInvoiceDetailAccountDate(Map<String, DynamicObject> detailMap, Map<String, Map<String, Object>> statusMap) {
        for (Map.Entry<String, DynamicObject> entry : detailMap.entrySet()) {
            Map<String, Object> statusValueMap = statusMap.get(entry.getKey());
            DynamicObject invoiceObj = entry.getValue();
            if (statusValueMap == null) {
                statusValueMap = new HashMap<String, Object>(4);
            }
            try {
                Integer expenseStatus = (Integer)statusValueMap.get("status");
                if (expenseStatus == null) {
                    expenseStatus = 1;
                    statusValueMap.put("status", expenseStatus);
                }
                invoiceObj.set("expense_status", (Object)expenseStatus.toString());
                if (expenseStatus < 65) {
                    invoiceObj.set("account_date", null);
                } else {
                    invoiceObj.set("account_date", statusValueMap.get("accountDate"));
                }
            }
            catch (Exception ignore) {
                LOGGER.info("\u66f4\u65b0\u53d1\u7968\u5b50\u8868\u4f1a\u8ba1\u5c5e\u671f\u5b57\u6bb5\u5931\u8d25,{}", (Object)ignore);
                continue;
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{invoiceObj});
        }
    }

    private Long getTargetOrgId(Map<String, ExpenseInvoiceDTO> invoiceDtoMap, Map<String, Long> invoiceOrgMap, String serailNo) {
        ExpenseInvoiceDTO dto;
        Long targetOrgId = 0L;
        if (invoiceDtoMap != null && (dto = invoiceDtoMap.get(serailNo)) != null) {
            if (dto.getOuterOrgId() != null && dto.getOuterOrgId() > 0L) {
                targetOrgId = dto.getOuterOrgId();
            } else if (dto.getOrgId() != null && dto.getOrgId() > 0L) {
                targetOrgId = dto.getOrgId();
            }
        }
        if (!invoiceOrgMap.isEmpty() && targetOrgId == 0L) {
            targetOrgId = invoiceOrgMap.get(serailNo);
        }
        if (targetOrgId == 0L) {
            LOGGER.info("\u4e0a\u4e0b\u6587\u7ec4\u7ec7..");
            targetOrgId = RequestContext.get().getOrgId();
        }
        return targetOrgId;
    }

    private String setInvoiceDeductionFlagByBill(Long targetOrgId, String deductionFlag, String fpyDeductionFlag, DynamicObject obj) {
        boolean smallScaleTaxpayer = TenantUtils.isSmallScaleTaxpayer(TenantUtils.getTaxNoByOrgId(targetOrgId));
        if (smallScaleTaxpayer) {
            LOGGER.info("\u5c0f\u89c4\u6a21\u7eb3\u7a0e\u4eba\u4e0d\u5141\u8bb8\u4fee\u6539\u62b5\u6263\u6807\u5fd7..");
            return String.format(ResManager.loadKDString((String)"\u5c0f\u89c4\u6a21\u7eb3\u7a0e\u4eba\u4e0d\u5141\u8bb8\u4fee\u6539\u62b5\u6263\u6807\u5fd7:%1$s", (String)"ExpenseServiceDF_1", (String)"imc-rim-common", (Object[])new Object[0]), targetOrgId);
        }
        String billModifyDeduct = SysParamUtil.getParamValue(targetOrgId, "bill_modify_deduct") + "";
        if ("0".equals(billModifyDeduct)) {
            obj.set("deduction_flag", (Object)fpyDeductionFlag);
            return String.format(ResManager.loadKDString((String)"\u76ee\u6807\u7ec4\u7ec7\u4e0d\u5141\u8bb8\u4fee\u6539\u62b5\u6263\u6807\u5fd7:%1$s", (String)"ExpenseServiceDF_2", (String)"imc-rim-common", (Object[])new Object[0]), targetOrgId);
        }
        if ("2".equals(billModifyDeduct)) {
            if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)deductionFlag)) {
                obj.set("deduction_flag", (Object)deductionFlag);
                InvoiceSaveService.setExtInfo(obj, InvoiceSaveConstant.EXT_BILL_DEDUCTION_FLAG, deductionFlag);
            } else {
                obj.set("deduction_flag", (Object)fpyDeductionFlag);
            }
        } else if ("1".equals(fpyDeductionFlag) && kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)deductionFlag)) {
            obj.set("deduction_flag", (Object)deductionFlag);
            InvoiceSaveService.setExtInfo(obj, InvoiceSaveConstant.EXT_BILL_DEDUCTION_FLAG, deductionFlag);
        } else {
            obj.set("deduction_flag", (Object)fpyDeductionFlag);
            return String.format(ResManager.loadKDString((String)"\u76ee\u6807\u7ec4\u7ec7\u90e8\u5206\u5141\u8bb8\u4fee\u6539\u62b5\u6263\u6807\u5fd7,\u4e0d\u53ef\u5c06\u53d1\u7968\u4e91\u7684\u4e0d\u53ef\u62b5\u6263\u6539\u6210\u53ef\u62b5\u6263:%1$s", (String)"ExpenseServiceDF_3", (String)"imc-rim-common", (Object[])new Object[0]), targetOrgId);
        }
        return "";
    }

    private void setUnusedField(String fieldsConfig, String expenseStatus, DynamicObject obj) {
        if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)fieldsConfig) || obj == null || !"1".equals(expenseStatus)) {
            return;
        }
        JSONObject json = JSONObject.parseObject((String)fieldsConfig);
        DynamicObjectType type = obj.getDynamicObjectType();
        for (Map.Entry entry : json.entrySet()) {
            try {
                DynamicProperty property;
                String field = (String)entry.getKey();
                String val = json.getString(field);
                if (val == null || "null".equals(val)) {
                    val = "";
                }
                if ((property = type.getProperty(field)) instanceof DecimalProp) {
                    obj.set(field, (Object)BigDecimalUtil.transDecimal(val));
                    continue;
                }
                if (property instanceof ComboProp) {
                    obj.set(field, (Object)val);
                    continue;
                }
                if (property instanceof BooleanProp) {
                    if (Boolean.TRUE.toString().equals(val)) {
                        obj.set(field, (Object)Boolean.TRUE);
                        continue;
                    }
                    obj.set(field, (Object)Boolean.FALSE);
                    continue;
                }
                if (property instanceof BasedataProp) {
                    obj.set(field, (Object)BigDecimalUtil.transDecimal(val).longValue());
                    continue;
                }
                if (property instanceof DateTimeProp) {
                    if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)val)) {
                        obj.set(field, null);
                        continue;
                    }
                    Date date = json.getDate(field);
                    obj.set(field, (Object)date);
                    continue;
                }
                obj.set(field, (Object)val);
            }
            catch (Exception exception) {}
        }
    }

    private void setExtInfo(Map<String, IDataEntityProperty> fields, DynamicObject obj, JSONObject extInfo) {
        if (extInfo != null) {
            Set keySet = extInfo.keySet();
            for (String key : keySet) {
                IDataEntityProperty property = fields.get(key);
                if (property == null) continue;
                if (property instanceof BasedataProp) {
                    obj.set(key, (Object)extInfo.getLong(key));
                    continue;
                }
                if (property instanceof DecimalProp) {
                    obj.set(key, (Object)extInfo.getBigDecimal(key));
                    continue;
                }
                if (property instanceof DateTimeProp) {
                    obj.set(key, (Object)extInfo.getDate(key));
                    continue;
                }
                obj.set(key, (Object)extInfo.getString(key));
            }
        }
    }

    private String getString(Set<String> set) {
        if (set == null) {
            return "";
        }
        String num = String.join((CharSequence)",", set);
        if (num.length() > 450) {
            return num.substring(0, 450);
        }
        return num;
    }

    public void delete(ExpenseDTO param) {
        List<String> delteSerialList = this.deleteExpense(param, true);
        if (!CollectionUtils.isEmpty(delteSerialList)) {
            this.updateInvoiceMain(delteSerialList, null);
        }
        this.saveCallBack("delete", param, null, delteSerialList);
    }

    private Integer getStausInteger(String status) {
        if (status == null || "".equals(status.trim())) {
            return Integer.parseInt("1");
        }
        return Integer.parseInt(status.trim());
    }

    private void newExpense(ExpenseDTO param, List<String> serialList, Map<String, Map<String, Object>> invoiceInfoMap) {
        QFilter idfilter = new QFilter("expense_id", "=", (Object)param.getExpenseId());
        if (!kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)param.getEntityId())) {
            idfilter = idfilter.and(new QFilter("entityid", "=", (Object)param.getEntityId()));
        } else if (!kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)param.getResource())) {
            idfilter = idfilter.and(new QFilter("resource", "=", (Object)param.getResource()));
        }
        List list = QueryServiceHelper.queryPrimaryKeys((String)"rim_expense", (QFilter[])new QFilter[]{idfilter}, (String)"id", (int)5);
        DynamicObject expenseObject = null;
        if (!CollectionUtils.isEmpty((Collection)list)) {
            Object pk = list.get(0);
            if (list.size() > 1) {
                QFilter pkfilter = new QFilter("id", "!=", pk);
                DeleteServiceHelper.delete((String)"rim_expense", (QFilter[])new QFilter[]{idfilter, pkfilter});
            }
            expenseObject = BusinessDataServiceHelper.loadSingle(pk, (String)"rim_expense");
            expenseObject.set("update_time", (Object)new Date());
        } else {
            expenseObject = BusinessDataServiceHelper.newDynamicObject((String)"rim_expense");
            expenseObject.set("create_time", (Object)new Date());
            expenseObject.set("update_time", (Object)new Date());
        }
        expenseObject.set("expense_num", (Object)param.getExpenseNum());
        expenseObject.set("expense_id", (Object)param.getExpenseId());
        expenseObject.set("expense_type", (Object)param.getExpenseType());
        expenseObject.set("status", (Object)param.getStatus());
        expenseObject.set("resource", (Object)param.getResource());
        expenseObject.set("entityid", (Object)param.getEntityId());
        expenseObject.set("view_page", (Object)param.getViewPage());
        expenseObject.set("creator_id", (Object)param.getBillUser());
        expenseObject.set("creator_name", (Object)param.getCreatorName());
        expenseObject.set("remark", (Object)param.getRemark());
        expenseObject.set("expense_time", (Object)param.getExpenseTime());
        expenseObject.set("orgid", (Object)param.getOrgId());
        expenseObject.set("batch", (Object)param.getBatch());
        expenseObject.set("bussinsysbillstatus", (Object)param.getBussinSysBillStatus());
        expenseObject.set("applyorgid", (Object)param.getApplyOrgId());
        expenseObject.set("bussinsysorgcode", (Object)param.getBussinSysOrgCode());
        expenseObject.set("bussinsysbillorgcode", (Object)param.getBussinSysBillOrgCode());
        expenseObject.set("country", (Object)param.getCountry());
        expenseObject.set("paymentterms", (Object)param.getPaymentTerms());
        expenseObject.set("paymentmethod", (Object)param.getPaymentMethod());
        expenseObject.set("duedate", (Object)param.getDueDate());
        expenseObject.set("bussinsysuserid", (Object)param.getBussinSysUserId());
        expenseObject.set("userloginid", (Object)param.getUserLoginId());
        expenseObject.set("billupdatetime", (Object)param.getUpdateTime());
        expenseObject.set("currencyid", (Object)param.getCurrencyId());
        JSONObject saveRelationRtn = null;
        if (serialList != null && serialList.size() > 0) {
            saveRelationRtn = this.newExpenseRelation(param, serialList, invoiceInfoMap);
        }
        this.updateExpenseAmount(param, expenseObject, saveRelationRtn);
        this.setOriginalState(invoiceInfoMap, expenseObject);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{expenseObject});
    }

    private void setOriginalState(Map<String, Map<String, Object>> invoiceInfoMap, DynamicObject expenseObject) {
        expenseObject.set("invoice_count", (Object)invoiceInfoMap.size());
        int sign_count = 0;
        for (Map.Entry<String, Map<String, Object>> entry : invoiceInfoMap.entrySet()) {
            Map<String, Object> val = entry.getValue();
            if (val == null || !"1".equals(val.get("original_state"))) continue;
            ++sign_count;
        }
        if (sign_count == invoiceInfoMap.size()) {
            expenseObject.set("original_state", (Object)"1");
        } else if (sign_count > 0 && sign_count < invoiceInfoMap.size()) {
            expenseObject.set("original_state", (Object)"2");
        } else {
            expenseObject.set("original_state", (Object)"0");
        }
        expenseObject.set("sign_count", (Object)sign_count);
    }

    private void updateExpenseAmount(ExpenseDTO param, DynamicObject expenseObject, JSONObject saveRelationRtn) {
        if (saveRelationRtn == null) {
            expenseObject.set("expense_amount", (Object)param.getBillTotalAmount());
            expenseObject.set("billtotaltaxamount", (Object)param.getBillTotalTaxAmount());
            return;
        }
        if (param.getBillTotalAmount() != null) {
            expenseObject.set("expense_amount", (Object)param.getBillTotalAmount());
        } else {
            expenseObject.set("expense_amount", (Object)saveRelationRtn.getBigDecimal("totalExpenseAmount"));
        }
        if (param.getBillTotalTaxAmount() != null) {
            expenseObject.set("billtotaltaxamount", (Object)param.getBillTotalTaxAmount());
        } else {
            expenseObject.set("billtotaltaxamount", (Object)saveRelationRtn.getBigDecimal("totalTaxAmount"));
        }
    }

    private JSONObject newExpenseRelation(ExpenseDTO param, List<String> serialList, Map<String, Map<String, Object>> invoiceInfoMap) {
        JSONObject result = new JSONObject();
        BigDecimal totalExpenseAmount = BigDecimal.ZERO;
        BigDecimal totalTaxAmount = BigDecimal.ZERO;
        List<ExpenseInvoiceDTO> invoiceList = param.getInvoiceList();
        ArrayList<DynamicObject> relaitonList = new ArrayList<DynamicObject>(invoiceList.size());
        HashSet<String> savedSerialNo = new HashSet<String>(invoiceList.size());
        for (ExpenseInvoiceDTO invoiceDto : invoiceList) {
            Map<String, Object> dynamicObject;
            if (!CollectionUtils.isEmpty(savedSerialNo) && savedSerialNo.contains(invoiceDto.getSerialNo()) || (dynamicObject = invoiceInfoMap.get(invoiceDto.getSerialNo())) == null) continue;
            DynamicObject relationObject = BusinessDataServiceHelper.newDynamicObject((String)"rim_expense_relation");
            relationObject.set("serial_no", (Object)invoiceDto.getSerialNo());
            relationObject.set("expense_num", (Object)param.getExpenseNum());
            relationObject.set("expense_id", (Object)param.getExpenseId());
            relationObject.set("entityid", (Object)param.getEntityId());
            relationObject.set("view_page", (Object)param.getViewPage());
            relationObject.set("expense_type", (Object)param.getExpenseType());
            relationObject.set("resource", (Object)param.getResource());
            relationObject.set("create_time", (Object)new Date());
            relationObject.set("use_type", (Object)1);
            this.updateReletionBussinValue(param, invoiceDto, dynamicObject, relationObject);
            relaitonList.add(relationObject);
            savedSerialNo.add(invoiceDto.getSerialNo());
            totalExpenseAmount = totalExpenseAmount.add(relationObject.getBigDecimal("expense_amount"));
            totalTaxAmount = totalTaxAmount.add(relationObject.getBigDecimal("billtaxamount"));
        }
        this.saveInvoiceReimEntry(savedSerialNo, param);
        SaveServiceHelper.save((DynamicObject[])relaitonList.toArray(new DynamicObject[relaitonList.size()]));
        result.put("savedSerialNos", savedSerialNo);
        result.put("totalExpenseAmount", (Object)totalExpenseAmount);
        result.put("totalTaxAmount", (Object)totalTaxAmount);
        return result;
    }

    private void updateReletionBussinValue(ExpenseDTO param, ExpenseInvoiceDTO invoiceDto, Map<String, Object> mainObj, DynamicObject relationObject) {
        relationObject.set("status", (Object)param.getStatus());
        relationObject.set("entry_id", (Object)invoiceDto.getEntryId());
        relationObject.set("output_amount", (Object)invoiceDto.getOutputAmount());
        relationObject.set("output_reason", (Object)invoiceDto.getRemark());
        relationObject.set("deduction_flag", (Object)invoiceDto.getDeductionFlag());
        relationObject.set("deduction_amount", (Object)BigDecimal.ZERO);
        relationObject.set("effective_tax_amount", (Object)BigDecimal.ZERO);
        relationObject.set("reimbursingid", (Object)param.getReimbursingId());
        relationObject.set("preset_deduction_purpose", (Object)invoiceDto.getDeductionPurpose());
        relationObject.set("not_deductible_type", (Object)invoiceDto.getNotDeductibleType());
        if (invoiceDto.getDeductionAmount() != null) {
            relationObject.set("deduction_amount", (Object)invoiceDto.getDeductionAmount());
        } else {
            relationObject.set("deduction_amount", mainObj.get("total_tax_amount"));
        }
        if (invoiceDto.getEffectiveTaxAmount() != null) {
            relationObject.set("effective_tax_amount", (Object)invoiceDto.getEffectiveTaxAmount());
        }
        if (invoiceDto.getExpenseAmount() != null) {
            relationObject.set("expense_amount", (Object)invoiceDto.getExpenseAmount());
        } else {
            relationObject.set("expense_amount", mainObj.get("total_amount"));
        }
        if (invoiceDto.getBillTaxAmount() != null) {
            relationObject.set("billtaxamount", (Object)invoiceDto.getBillTaxAmount());
        } else {
            relationObject.set("billtaxamount", mainObj.get("total_tax_amount"));
        }
        BigDecimal expenseAmount = null;
        BigDecimal totalAmount = BigDecimalUtil.transDecimal(mainObj.get("total_amount"));
        if ("01".equals(param.getFullPayFlag())) {
            expenseAmount = totalAmount;
        } else if (invoiceDto.getExpenseAmount() != null) {
            boolean expenseAmountRight = false;
            if (totalAmount.compareTo(BigDecimal.ZERO) < 0) {
                if (invoiceDto.getExpenseAmount().compareTo(BigDecimal.ZERO) <= 0 && invoiceDto.getExpenseAmount().compareTo(totalAmount) >= 0) {
                    expenseAmountRight = true;
                } else if (invoiceDto.getExpenseAmount().compareTo(BigDecimal.ZERO) > 0) {
                    throw new MsgException(ErrorType.ALL_REPEAT.getCode(), String.format(ResManager.loadKDString((String)"\u8d1f\u6570\u53d1\u7968%1$s\u4f7f\u7528\u91d1\u989d\u9700\u5c0f\u4e8e\u7b49\u4e8e0\uff0c\u4fdd\u5b58\u5931\u8d25", (String)"ExpenseService_10", (String)"imc-rim-common", (Object[])new Object[0]), mainObj.get("invoice_no")));
                }
            } else if (invoiceDto.getExpenseAmount().compareTo(BigDecimal.ZERO) >= 0 && invoiceDto.getExpenseAmount().compareTo(totalAmount) <= 0) {
                expenseAmountRight = true;
            } else if (invoiceDto.getExpenseAmount().compareTo(BigDecimal.ZERO) < 0) {
                throw new MsgException(ErrorType.ALL_REPEAT.getCode(), String.format(ResManager.loadKDString((String)"\u6b63\u6570\u53d1\u7968%1$s\u4f7f\u7528\u91d1\u989d\u9700\u5927\u4e8e\u7b49\u4e8e0\uff0c\u4fdd\u5b58\u5931\u8d25", (String)"ExpenseService_11", (String)"imc-rim-common", (Object[])new Object[0]), mainObj.get("invoice_no")));
            }
            if (expenseAmountRight) {
                expenseAmount = invoiceDto.getExpenseAmount();
            } else {
                throw new MsgException(ErrorType.ALL_REPEAT.getCode(), String.format(ResManager.loadKDString((String)"\u53d1\u7968%1$s\u4f7f\u7528\u91d1\u989d\u8d85\u51fa\u53d1\u7968\u91d1\u989d%2$s\u5143\uff0c\u4fdd\u5b58\u5931\u8d25", (String)"ExpenseService_9", (String)"imc-rim-common", (Object[])new Object[0]), mainObj.get("invoice_no"), DynamicObjectUtil.fieldToString(totalAmount)));
            }
        }
        if (expenseAmount != null) {
            relationObject.set("expense_amount", (Object)expenseAmount);
        } else {
            relationObject.set("expense_amount", (Object)totalAmount);
        }
        relationObject.set("bussinsysbillstatus", (Object)param.getBussinSysBillStatus());
        relationObject.set("invfolderno", (Object)invoiceDto.getInvFolderNo());
        relationObject.set("initialinvamount", (Object)invoiceDto.getInitialInvAmount());
        relationObject.set("finalinvamount", (Object)invoiceDto.getFinalInvAmount());
        relationObject.set("availabilityremainamount", (Object)invoiceDto.getAvailabilityRemainAmount());
        relationObject.set("rollouttaxamount", (Object)invoiceDto.getRolloutTaxAmount());
        relationObject.set("rolloutreason", (Object)invoiceDto.getRolloutReason());
        relationObject.set("accountitemcode", (Object)invoiceDto.getAccountItemCode());
        relationObject.set("accountitemdescript", (Object)invoiceDto.getAccountItemDescript());
        relationObject.set("check_status", mainObj.get("check_status"));
        relationObject.set("use_type", (Object)1);
    }

    public List<String> deleteExpense(ExpenseDTO param, boolean deleteAll) {
        QFilter idfilter = this.getExpenseRelationQFilter(param, "expense_id", "entityid", "resource");
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"rim_expense_relation", (String)"id,expense_num,expense_id,status,resource,serial_no", (QFilter[])new QFilter[]{idfilter});
        ArrayList<String> delteSerialList = new ArrayList<String>(collection.size());
        ArrayList<Object> pkList = new ArrayList<Object>(collection.size());
        for (DynamicObject obj : collection) {
            DynamicObject[] serialNo = obj.getString("serial_no");
            pkList.add(obj.get("id"));
            delteSerialList.add((String)serialNo);
        }
        String expenseId = param.getExpenseId();
        if (pkList != null && !pkList.isEmpty()) {
            DynamicObject[] mainObjects = BusinessDataServiceHelper.load((String)"rim_invoice", (String)"ext_info", (QFilter[])new QFilter[]{new QFilter("serial_no", "in", delteSerialList)});
            if (mainObjects.length > 0) {
                for (DynamicObject main : mainObjects) {
                    InvoiceSaveService.setExtInfo(main, InvoiceSaveConstant.EXT_BILL_DEDUCTION_FLAG, "");
                }
                SaveServiceHelper.update((DynamicObject[])mainObjects);
            }
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"rim_expense_relation"), (Object[])pkList.toArray());
            this.deleteInvoiceReimEntry(delteSerialList, param);
        }
        if (deleteAll) {
            this.deleteInvoiceAttach(delteSerialList, expenseId);
            DeleteServiceHelper.delete((String)"rim_expense", (QFilter[])idfilter.toArray());
            LOGGER.info("\u5f00\u59cb\u5220\u9664\u539f\u6709\u5355\u636e\u6240\u6709\u9644\u4ef6\u5173\u7cfb\u3002[{}]", (Object)expenseId);
            QFilter billFilter = new QFilter("expense_id", "=", (Object)expenseId);
            DeleteServiceHelper.delete((String)"rim_attach_relation", (QFilter[])billFilter.toArray());
            AttachQueryService attachQueryService = new AttachQueryService();
            attachQueryService.cacheFpzsAttach(expenseId, param.getEntityId(), param.getResource(), null);
            LOGGER.info("\u5f00\u59cb\u5220\u9664\u5355\u636e\u6240\u6709\u5c01\u9762\u5173\u7cfb\u3002[{}]", (Object)expenseId);
            QFilter coverFilter = new QFilter("expense_id", "=", (Object)expenseId);
            DynamicObjectCollection coverRelationObjs = QueryServiceHelper.query((String)"rim_cover_relation", (String)"cover_id", (QFilter[])coverFilter.toArray());
            if (!CollectionUtils.isEmpty((Collection)coverRelationObjs)) {
                ArrayList<Long> coverIds = new ArrayList<Long>();
                for (DynamicObject dynamicObject : coverRelationObjs) {
                    if (ObjectUtils.isEmpty((Object)dynamicObject)) continue;
                    coverIds.add(dynamicObject.getLong("cover_id"));
                }
                if (!CollectionUtils.isEmpty(coverIds)) {
                    this.deleteCover(coverIds);
                }
                this.deleteCoverRelation(expenseId);
            }
        }
        return delteSerialList;
    }

    private void saveAttachmentRelation(ExpenseDTO param) {
        List<ExpenseAttachDTO> attachDTOList;
        AttachQueryService attachQueryService = new AttachQueryService();
        if (param == null) {
            LOGGER.info("\u8bf7\u6c42\u53c2\u6570param\u4e3a\u7a7a");
            return;
        }
        if (StringUtils.equals((String)param.isUpdateAttachRelation(), (String)"2")) {
            this.updateAttachmentRelationCover(param);
            return;
        }
        if (StringUtils.equals((String)param.isUpdateAttachRelation(), (String)"1")) {
            this.updateAttachmentRelation(param);
            return;
        }
        String expenseId = param.getExpenseId();
        JSONArray invoiceAttachObj = attachQueryService.queryFpzsAttach(param.getExpenseId(), param.getEntityId(), param.getResource(), false);
        boolean useOriginal = false;
        if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)param.getOriginalId()) && (invoiceAttachObj == null || invoiceAttachObj.isEmpty())) {
            invoiceAttachObj = attachQueryService.queryFpzsAttach(param.getOriginalId(), param.getOriginalType(), param.getResource(), false);
            useOriginal = true;
        }
        if (invoiceAttachObj != null) {
            InvoiceLog.insertExpenseLog(ResManager.loadKDString((String)"\u9644\u4ef6\u7f13\u5b58", (String)"ExpenseService_3", (String)"imc-rim-common", (Object[])new Object[0]), param.getExpenseId(), param.getExpenseNum(), invoiceAttachObj.toJSONString());
        }
        if (param.isDeleteAttachRelation()) {
            LOGGER.info("\u5f00\u59cb\u5220\u9664\u539f\u6709\u5355\u636e\u6240\u6709\u9644\u4ef6\u5173\u7cfb\u3002[{}]", (Object)expenseId);
            QFilter billFilter = new QFilter("expense_id", "=", (Object)expenseId);
            DeleteServiceHelper.delete((String)"rim_attach_relation", (QFilter[])billFilter.toArray());
        }
        if ((invoiceAttachObj == null || invoiceAttachObj.isEmpty()) && ((invoiceAttachObj = this.dealAttachParam(attachDTOList = param.getAttachDTOList())) == null || invoiceAttachObj.isEmpty())) {
            return;
        }
        LOGGER.info("\u5f00\u59cb\u5220\u9664\u62a5\u9500\u5355\u548c\u9644\u4ef6\u7684\u5173\u8054\u5173\u7cfb...,\u62a5\u9500\u5355id" + expenseId);
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>(8);
        ArrayList<String> attachIdList = new ArrayList<String>(8);
        for (int i = 0; i < invoiceAttachObj.size(); ++i) {
            JSONObject attach = invoiceAttachObj.getJSONObject(i);
            DynamicObject item = BusinessDataServiceHelper.newDynamicObject((String)"rim_attach_relation");
            String serialNo = attach.getString("serialNo");
            String attachId = attach.getString("attachId");
            attachIdList.add(attachId);
            item.set("relation_type", (Object)1);
            if (!kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)serialNo)) {
                item.set("relation_type", (Object)2);
            }
            item.set("attach_id", (Object)attachId);
            item.set("expense_id", (Object)expenseId);
            item.set("relation_id", (Object)serialNo);
            dynamicObjects.add(item);
        }
        QFilter billFilter = new QFilter("expense_id", "=", (Object)expenseId);
        QFilter idFilter = new QFilter("attach_id", "in", attachIdList);
        DeleteServiceHelper.delete((String)"rim_attach_relation", (QFilter[])new QFilter[]{billFilter, idFilter});
        if (!CollectionUtils.isEmpty(dynamicObjects)) {
            SaveServiceHelper.save((DynamicObject[])dynamicObjects.toArray(new DynamicObject[dynamicObjects.size()]));
        }
        LOGGER.info("\u4fdd\u5b58\u6210\u529f\u5f00\u59cb\u5220\u9664\u9644\u4ef6\u6570\u636e\u7f13\u5b58\uff1aCACHE_INVOICE_ATTACH" + expenseId);
        attachQueryService.cacheFpzsAttach(param.getExpenseId(), param.getEntityId(), param.getResource(), null);
        if (useOriginal) {
            attachQueryService.cacheFpzsAttach(param.getOriginalId(), param.getOriginalType(), param.getResource(), null);
        }
    }

    private void updateAttachmentRelationCover(ExpenseDTO param) {
        if (param == null || kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)param.getExpenseId())) {
            return;
        }
        String expenseId = param.getExpenseId();
        LOGGER.info("\u5f00\u59cb\u5220\u9664\u539f\u6709\u5355\u636e\u6240\u6709\u9644\u4ef6\u5173\u7cfb\u3002[{}]", (Object)expenseId);
        QFilter billFilter = new QFilter("expense_id", "=", (Object)expenseId);
        DeleteServiceHelper.delete((String)"rim_attach_relation", (QFilter[])billFilter.toArray());
        List<ExpenseAttachDTO> attachDTOList = param.getAttachDTOList();
        if (org.apache.commons.collections.CollectionUtils.isEmpty(attachDTOList)) {
            return;
        }
        JSONArray invoiceAttachObj = this.dealAttachParam(attachDTOList);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)invoiceAttachObj)) {
            return;
        }
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>(8);
        for (int i = 0; i < invoiceAttachObj.size(); ++i) {
            JSONObject attach = invoiceAttachObj.getJSONObject(i);
            DynamicObject item = BusinessDataServiceHelper.newDynamicObject((String)"rim_attach_relation");
            String serialNo = attach.getString("serialNo");
            String attachId = attach.getString("attachId");
            item.set("relation_type", (Object)1);
            if (!kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)serialNo)) {
                item.set("relation_type", (Object)2);
            }
            item.set("attach_id", (Object)attachId);
            item.set("expense_id", (Object)expenseId);
            item.set("relation_id", (Object)serialNo);
            dynamicObjects.add(item);
        }
        if (!CollectionUtils.isEmpty(dynamicObjects)) {
            SaveServiceHelper.save((DynamicObject[])dynamicObjects.toArray(new DynamicObject[dynamicObjects.size()]));
        }
        AttachQueryService attachQueryService = new AttachQueryService();
        attachQueryService.cacheFpzsAttach(param.getExpenseId(), param.getEntityId(), param.getResource(), null);
    }

    private JSONArray dealAttachParam(List<ExpenseAttachDTO> attachDTOList) {
        JSONArray invoiceAttachObj = new JSONArray();
        if (!CollectionUtils.isEmpty(attachDTOList)) {
            HashSet<String> attachNoList = new HashSet<String>(8);
            for (ExpenseAttachDTO attDto : attachDTOList) {
                attachNoList.add(attDto.getAttachNo());
            }
            if (!attachNoList.isEmpty()) {
                DynamicObjectCollection collect = QueryServiceHelper.query((String)"rim_attach", (String)"id, attach_no", (QFilter[])new QFilter("attach_no", "in", attachNoList).toArray());
                HashSet<String> existsAttachNos = new HashSet<String>(collect.size());
                for (Object obj : collect) {
                    existsAttachNos.add(obj.getString("attach_no"));
                }
                ArrayList<DynamicObject> newAttachList = new ArrayList<DynamicObject>(attachNoList.size());
                for (ExpenseAttachDTO attachDTO : attachDTOList) {
                    String attachNo = attachDTO.getAttachNo();
                    DynamicObject needSaveAttach = null;
                    if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)attachNo) && existsAttachNos.add(attachNo)) {
                        needSaveAttach = BusinessDataServiceHelper.newDynamicObject((String)"rim_attach");
                    }
                    if (needSaveAttach == null) continue;
                    needSaveAttach.set("attach_no", (Object)attachNo);
                    needSaveAttach.set("attach_url", (Object)attachDTO.getAttachUrl());
                    needSaveAttach.set("attach_name", (Object)attachDTO.getAttachName());
                    needSaveAttach.set("attach_type", (Object)FileUtils.getFileTypeByExtension(attachDTO.getAttachType()));
                    needSaveAttach.set("remark", (Object)attachDTO.getAttachRemark());
                    needSaveAttach.set("snapshot_url", (Object)attachDTO.getSnapshotUrl());
                    needSaveAttach.set("original_name", (Object)attachDTO.getOriginalFileName());
                    String fileExtension = attachDTO.getFileExtension();
                    if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)fileExtension)) {
                        fileExtension = FileUtils.getExtensionByFileType(attachDTO.getAttachType());
                    }
                    needSaveAttach.set("file_extension", (Object)fileExtension);
                    Long category = BigDecimalUtil.transDecimal(attachDTO.getAttachCategory()).longValue();
                    if (category <= 0L) {
                        category = AttachConstant.ATTACH_OTHER_CATEGORY_ID;
                    }
                    needSaveAttach.set("attach_category", (Object)category);
                    needSaveAttach.set("create_time", (Object)new Date());
                    needSaveAttach.set("update_time", (Object)new Date());
                    newAttachList.add(needSaveAttach);
                }
                if (!newAttachList.isEmpty()) {
                    SaveServiceHelper.save((DynamicObject[])newAttachList.toArray(new DynamicObject[0]));
                }
            }
            for (ExpenseAttachDTO dto : attachDTOList) {
                if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)dto.getAttachId()) && kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)dto.getAttachNo())) continue;
                QFilter filter = new QFilter("attach_no", "=", (Object)dto.getAttachNo());
                DynamicObject dy = QueryServiceHelper.queryOne((String)"rim_attach", (String)"id", (QFilter[])new QFilter[]{filter});
                if (dy == null) continue;
                dto.setAttachId(String.valueOf(dy.get("id")));
                JSONObject dataJson = new JSONObject();
                dataJson.put("attachId", (Object)dto.getAttachId());
                dataJson.put("attachUrl", (Object)dto.getAttachUrl());
                dataJson.put("attachType", (Object)dto.getAttachType());
                dataJson.put("attachNo", (Object)dto.getAttachNo());
                dataJson.put("attachName", (Object)dto.getAttachName());
                dataJson.put("remark", (Object)dto.getAttachRemark());
                dataJson.put("serialNo", (Object)dto.getSerialNo());
                invoiceAttachObj.add((Object)dataJson);
            }
        }
        return invoiceAttachObj;
    }

    private void updateAttachmentRelation(ExpenseDTO param) {
        if (param.getAttachDTOList() == null) {
            LOGGER.info("\u9644\u4ef6\u4fe1\u606f\u4e3a\u7a7a");
            return;
        }
        String expenseId = param.getExpenseId();
        AttachQueryService attachQueryService = new AttachQueryService();
        JSONArray attachRelationArray = attachQueryService.queryFpzsAttach(param.getExpenseId(), param.getEntityId(), param.getResource(), true);
        if (attachRelationArray != null) {
            InvoiceLog.insertExpenseLog(ResManager.loadKDString((String)"\u9644\u4ef6\u7f13\u5b58", (String)"ExpenseService_3", (String)"imc-rim-common", (Object[])new Object[0]), param.getExpenseId(), param.getExpenseNum(), attachRelationArray.toJSONString());
        }
        QFilter billFilter = new QFilter("expense_id", "=", (Object)expenseId);
        DeleteServiceHelper.delete((String)"rim_attach_relation", (QFilter[])billFilter.toArray());
        Set attachNoList = param.getAttachDTOList().stream().map(ExpenseAttachDTO::getAttachNo).collect(Collectors.toSet());
        ArrayList<DynamicObject> attachRelationList = new ArrayList<DynamicObject>(8);
        if (attachRelationArray == null) {
            attachRelationArray = new JSONArray();
        }
        for (int i = 0; i < attachRelationArray.size(); ++i) {
            JSONObject attach = attachRelationArray.getJSONObject(i);
            String attachNo = attach.getString("attachNo_1");
            if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)attachNo)) {
                attachNo = attach.getString("attachNo");
            }
            String attachId = attach.getString("attachId");
            if (!attachNoList.contains(attachNo)) continue;
            DynamicObject item = BusinessDataServiceHelper.newDynamicObject((String)"rim_attach_relation");
            String serialNo = attach.getString("serialNo");
            item.set("relation_type", (Object)1);
            if (!kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)serialNo)) {
                item.set("relation_type", (Object)2);
            }
            item.set("attach_id", (Object)attachId);
            item.set("expense_id", (Object)expenseId);
            item.set("relation_id", (Object)serialNo);
            attachRelationList.add(item);
        }
        if (!CollectionUtils.isEmpty(attachRelationList)) {
            SaveServiceHelper.save((DynamicObject[])attachRelationList.toArray(new DynamicObject[attachRelationList.size()]));
        }
        attachQueryService.cacheFpzsAttach(param.getExpenseId(), param.getEntityId(), param.getResource(), null);
    }

    private JSONObject saveCoverRelation(ExpenseDTO billExpense) {
        String expenseId = billExpense.getExpenseId();
        if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)expenseId)) {
            throw new MsgException(ErrorType.PARAM_NULL.getCode(), ErrorType.PARAM_NULL.getName());
        }
        List<ExpenseCoverDTO> coverDTOList = billExpense.getCoverDTOList();
        if (!CollectionUtils.isEmpty(coverDTOList)) {
            QFilter coverFilter = new QFilter("expense_id", "=", (Object)expenseId);
            DynamicObjectCollection coverRelationObjs = QueryServiceHelper.query((String)"rim_cover_relation", (String)"cover_id", (QFilter[])coverFilter.toArray());
            if (CollectionUtils.isEmpty((Collection)coverRelationObjs)) {
                this.newCoverAndRelation(billExpense);
            } else {
                ArrayList<Long> coverIds = new ArrayList<Long>();
                for (DynamicObject dynamicObject : coverRelationObjs) {
                    if (ObjectUtils.isEmpty((Object)dynamicObject)) continue;
                    coverIds.add(dynamicObject.getLong("cover_id"));
                }
                if (!CollectionUtils.isEmpty(coverIds)) {
                    this.deleteCover(coverIds);
                }
                this.deleteCoverRelation(billExpense.getExpenseId());
                this.newCoverAndRelation(billExpense);
            }
        }
        return ResultContant.createSuccessJSONObject();
    }

    private JSONArray newAttach(ExpenseDTO billExpense) {
        DynamicObject[] attachSaveResult;
        JSONArray attachCacheArray = new JSONArray();
        List<ExpenseAttachDTO> attachDTOList = billExpense.getAttachDTOList();
        if (CollectionUtils.isEmpty(attachDTOList)) {
            LOGGER.info("\u5c01\u9762\u6570\u636e\u5185\u5bb9\u4e3a\u7a7a\uff0c\u4e0d\u9700\u8981\u4fdd\u5b58");
            return attachCacheArray;
        }
        Object[] needSaveAttachs = new DynamicObject[attachDTOList.size()];
        Long userId = Long.parseLong(RequestContext.get().getUserId());
        int i = 0;
        for (ExpenseAttachDTO attachDTO : attachDTOList) {
            if (!kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)attachDTO.getAttachNo())) continue;
            DynamicObject needSaveAttach = BusinessDataServiceHelper.newDynamicObject((String)"rim_attach");
            String attachNo = UUID.randomUUID();
            needSaveAttach.set("attach_no", (Object)attachNo);
            needSaveAttach.set("attach_url", (Object)attachDTO.getAttachUrl());
            needSaveAttach.set("attach_name", (Object)attachDTO.getAttachName());
            needSaveAttach.set("attach_type", (Object)attachDTO.getAttachType());
            needSaveAttach.set("remark", (Object)attachDTO.getAttachRemark());
            FileService service = FileServiceFactory.getAttachmentFileService();
            InputStream fileInputStream = service.getInputStream(attachDTO.getAttachUrl());
            String attachHash = FileUtils.getSHA256(fileInputStream);
            needSaveAttach.set("attach_hash_value", (Object)attachHash);
            needSaveAttach.set("user", (Object)userId);
            needSaveAttach.set("create_time", (Object)new Date());
            needSaveAttach.set("update_time", (Object)new Date());
            needSaveAttachs[i++] = needSaveAttach;
        }
        if (ArrayUtils.isEmpty((Object[])needSaveAttachs)) {
            LOGGER.info("\u9644\u4ef6\u6570\u636e\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fdd\u5b58");
            return attachCacheArray;
        }
        for (DynamicObject att : attachSaveResult = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])needSaveAttachs)) {
            JSONObject dataJson = new JSONObject();
            dataJson.put("attachId", att.get("id"));
            dataJson.put("attachUrl", att.get("attach_url"));
            dataJson.put("attachType", att.get("attach_type"));
            dataJson.put("attachNo", att.get("attach_no"));
            dataJson.put("attachName", att.get("attach_name"));
            dataJson.put("remark", att.get("remark"));
            dataJson.put("attachSize", att.get("size"));
            dataJson.put("createTime", (Object)DateUtils.format(att.getDate("create_time"), "yyyy-MM-dd HH:mm:ss"));
            attachCacheArray.add((Object)dataJson);
        }
        return attachCacheArray;
    }

    private void newCoverAndRelation(ExpenseDTO billExpense) {
        List<ExpenseCoverDTO> coverDTOList = billExpense.getCoverDTOList();
        if (CollectionUtils.isEmpty(coverDTOList)) {
            LOGGER.info("\u5c01\u9762\u6570\u636e\u5185\u5bb9\u4e3a\u7a7a\uff0c\u4e0d\u9700\u8981\u4fdd\u5b58");
            return;
        }
        String expenseId = billExpense.getExpenseId();
        boolean i = false;
        ArrayList<DynamicObject> needSaveCovers = new ArrayList<DynamicObject>(coverDTOList.size());
        DynamicObject[] needSaveCoverRelations = new DynamicObject[coverDTOList.size()];
        for (ExpenseCoverDTO coverDTO : coverDTOList) {
            String localUrl = coverDTO.getLocalUrl();
            String savePath = null;
            String snapshotUrl = null;
            String coverNo = coverDTO.getCoverNo();
            if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)coverNo)) {
                LOGGER.info("\u5c01\u9762\u7f16\u7801\u4e3a\u7a7a,\u4e0d\u4fdd\u5b58:{}", (Object)(expenseId + '-'), (Object)billExpense.getExpenseNum());
                continue;
            }
            if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)localUrl)) {
                String storePath;
                if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)coverDTO.getBase64())) {
                    LOGGER.info("\u5c01\u9762\u6587\u4ef6\u4e3a\u7a7a:" + coverNo);
                } else if (1 == coverDTO.getFileType()) {
                    storePath = FileUploadUtils.getInvoiceDir("cover") + UUID.randomUUID() + "/" + coverNo + ".pdf";
                    savePath = this.getUploadCoverPath(storePath, coverNo + ".pdf", coverDTO.getBase64());
                    snapshotUrl = this.getCoverSnapshotUrlByBase64(coverDTO.getBase64(), storePath.replace(".pdf", "snap.jpg"));
                } else {
                    storePath = FileUploadUtils.getInvoiceDir("cover") + UUID.randomUUID() + "/" + coverNo + ".jpg";
                    snapshotUrl = savePath = this.getUploadCoverPath(storePath, coverNo + ".jpg", coverDTO.getBase64());
                }
            } else if (!coverDTO.isInternal()) {
                snapshotUrl = coverDTO.getSnapshotUrl();
                if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)snapshotUrl)) {
                    snapshotUrl = FileUtils.downLoadAndUpload(snapshotUrl, coverNo + "_snap");
                }
                localUrl = FileUtils.downLoadAndUpload(localUrl, coverNo + "_loc");
            }
            DynamicObject needSaveCover = BusinessDataServiceHelper.newDynamicObject((String)"rim_cover");
            needSaveCover.set("cover_no", (Object)coverNo);
            if (!ObjectUtils.isEmpty((Object)coverDTO.getFileType())) {
                needSaveCover.set("cover_type", (Object)coverDTO.getFileType());
            } else {
                needSaveCover.set("cover_type", (Object)"1");
            }
            needSaveCover.set("cover_url", (Object)(kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)localUrl) ? localUrl : savePath));
            needSaveCover.set("create_time", (Object)new Date());
            needSaveCover.set("update_time", (Object)new Date());
            needSaveCover.set("snapshot_url", (Object)snapshotUrl);
            needSaveCover.set("resource", (Object)billExpense.getResource());
            needSaveCovers.add(needSaveCover);
        }
        if (ObjectUtils.isEmpty(needSaveCovers)) {
            LOGGER.info("\u5c01\u9762\u6570\u636e\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fdd\u5b58");
            return;
        }
        Object[] coverSaveResult = SaveServiceHelper.save((DynamicObject[])needSaveCovers.toArray(new DynamicObject[0]));
        if (ArrayUtils.isEmpty((Object[])coverSaveResult)) {
            return;
        }
        int j = 0;
        for (Object obj : coverSaveResult) {
            if (ObjectUtils.isEmpty((Object)obj)) continue;
            DynamicObject needSaveCoverRelation = BusinessDataServiceHelper.newDynamicObject((String)"rim_cover_relation");
            needSaveCoverRelation.set("cover_id", ((DynamicObject)obj).getPkValue());
            needSaveCoverRelation.set("expense_id", (Object)expenseId);
            needSaveCoverRelation.set("resource", (Object)billExpense.getResource());
            needSaveCoverRelation.set("create_time", (Object)new Date());
            needSaveCoverRelations[j++] = needSaveCoverRelation;
        }
        SaveServiceHelper.save((DynamicObject[])needSaveCoverRelations);
    }

    private String getUploadCoverPath(String storePath, String fileName, String base64) {
        String savePath = FileUploadUtils.uploadBase64(storePath, fileName, base64, false);
        return savePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getCoverSnapshotUrl(String coverUrl) {
        InputStream fileInputStream = null;
        String snapshotUrl = "";
        try {
            fileInputStream = FileServiceFactory.getAttachmentFileService().getInputStream(coverUrl);
            byte[] streamByte = FileUtils.getByte(fileInputStream);
            snapshotUrl = FileConvertUtils.pdf2image((byte[])streamByte, (String)"jpg", (float)1.5f);
        }
        catch (Exception e) {
            LOGGER.error("pdf\u5c01\u9762\u751f\u6210\u5feb\u7167\u4fe1\u606f\u9519\u8bef", (Throwable)e);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {
                    LOGGER.error("\u5173\u95ed\u9644\u4ef6\u6d41\u5931\u8d25", (Throwable)e);
                }
            }
        }
        return snapshotUrl;
    }

    private String getCoverSnapshotUrlByBase64(String base64, String fileName) {
        String snapshotUrl = "";
        try {
            FileConvertService service = new FileConvertService();
            byte[] byteArray = Base64.getDecoder().decode(base64);
            return service.pdf2imageByte(byteArray, fileName);
        }
        catch (Exception e) {
            LOGGER.error("pdf\u5c01\u9762\u751f\u6210\u5feb\u7167\u4fe1\u606f\u9519\u8bef", (Throwable)e);
            return snapshotUrl;
        }
    }

    private JSONObject deleteCover(List<Long> coverIds) {
        QFilter coverFilter = new QFilter("id", "in", coverIds);
        int deleteSize = DeleteServiceHelper.delete((String)"rim_cover", (QFilter[])coverFilter.toArray());
        if (deleteSize <= 0) {
            return ResultContant.createJSONObject("1300", ResManager.loadKDString((String)"\u5220\u9664\u9644\u4ef6\u5931\u8d25", (String)"ExpenseService_0", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        return ResultContant.createSuccessJSONObject();
    }

    private JSONObject deleteCoverRelation(String expenseId) {
        QFilter coverFilter = new QFilter("expense_id", "=", (Object)expenseId);
        int billDeleteSize = DeleteServiceHelper.delete((String)"rim_cover_relation", (QFilter[])coverFilter.toArray());
        if (billDeleteSize <= 0) {
            return ResultContant.createJSONObject("1300", ResManager.loadKDString((String)"\u5220\u9664\u62a5\u9500\u5355\u548c\u5c01\u9762\u5173\u8054\u5173\u7cfb\u5931\u8d25", (String)"ExpenseService_1", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        return ResultContant.createSuccessJSONObject();
    }

    public DynamicObjectCollection findByFilter(String mainFields, QFilter qFilter) {
        return QueryServiceHelper.query((String)"rim_expense", (String)mainFields, (QFilter[])new QFilter[]{qFilter});
    }

    public boolean isExitst(QFilter qFilter) {
        return QueryServiceHelper.exists((String)"rim_expense_relation", (QFilter[])new QFilter[]{qFilter});
    }

    private void deleteInvoiceReimEntry(List<String> deletedSerials, ExpenseDTO param) {
        DynamicObject[] invoiceArr;
        if (CollectionUtils.isEmpty(deletedSerials)) {
            return;
        }
        if (!ExpenseService.dealReimEntry()) {
            return;
        }
        String selectClumn = "id,reim_expense_id,vouch_vouchid";
        QFilter invoiceFilter = new QFilter("serial_no", "in", deletedSerials);
        QFilter reimFilter = this.getExpenseRelationQFilter(param, "reimvouchrelation.reim_expense_id", "reimvouchrelation.reim_entityid", "reimvouchrelation.reim_resource");
        for (DynamicObject invoice : invoiceArr = BusinessDataServiceHelper.load((String)"rim_invoice", (String)selectClumn, (QFilter[])new QFilter[]{invoiceFilter, reimFilter})) {
            DynamicObjectCollection relationEntry = invoice.getDynamicObjectCollection("reimvouchrelation");
            relationEntry.removeIf(v -> kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)v.getString("vouch_vouchid")) && kd.bos.dataentity.utils.StringUtils.equals((CharSequence)param.getExpenseId(), (CharSequence)v.getString("reim_expense_id")));
        }
        SaveServiceHelper.save((DynamicObject[])invoiceArr);
    }

    public static boolean dealReimEntry() {
        String config = RimConfigUtils.getConfig("rim_relation", "vouch_reim_invoice");
        return kd.bos.dataentity.utils.StringUtils.equals((CharSequence)config, (CharSequence)"1");
    }

    private void saveInvoiceReimEntry(Set<String> savedSerialNo, ExpenseDTO param) {
        DynamicObject[] invoiceArr;
        if (CollectionUtils.isEmpty(savedSerialNo)) {
            return;
        }
        if (!ExpenseService.dealReimEntry()) {
            return;
        }
        ArrayList listClumn = Lists.newArrayList((Object[])new String[]{"id", "reimvouchrelation.reim_resource", "reimvouchrelation.reim_entityid", "reimvouchrelation.reim_expense_id", "reimvouchrelation.reim_expense_num", "reimvouchrelation.reim_create_time", "reimvouchrelation.reim_status", "reimvouchrelation.reim_expense_type", "reimvouchrelation.vouch_vouchid", "reimvouchrelation.vouch_vouch_no", "reimvouchrelation.vouch_resource", "reimvouchrelation.vouch_account_date", "reimvouchrelation.vouch_account_time"});
        String selectClumn = listClumn.stream().collect(Collectors.joining(","));
        QFilter invoiceFilter = new QFilter("serial_no", "in", savedSerialNo);
        for (DynamicObject invoice : invoiceArr = BusinessDataServiceHelper.load((String)"rim_invoice", (String)selectClumn, (QFilter[])new QFilter[]{invoiceFilter})) {
            DynamicObjectCollection relationEntry = invoice.getDynamicObjectCollection("reimvouchrelation");
            boolean isCurrentExpenseId = false;
            for (DynamicObject relation : relationEntry) {
                if (!this.isCurrentExpenseId(param, relation)) continue;
                relation.set("reim_status", (Object)param.getStatus());
                isCurrentExpenseId = true;
                break;
            }
            if (isCurrentExpenseId) continue;
            DynamicObject newRelation = this.getRelation(relationEntry, param);
            relationEntry.add((Object)newRelation);
        }
        SaveServiceHelper.save((DynamicObject[])invoiceArr);
    }

    private DynamicObject getRelation(DynamicObjectCollection relation, ExpenseDTO param) {
        DynamicObject newRelation = new DynamicObject(relation.getDynamicObjectType());
        newRelation.set("reim_expense_id", (Object)kd.bos.dataentity.utils.StringUtils.defaultIfBlank((CharSequence)param.getExpenseId(), (CharSequence)" "));
        newRelation.set("reim_resource", (Object)kd.bos.dataentity.utils.StringUtils.defaultIfBlank((CharSequence)param.getResource(), (CharSequence)" "));
        newRelation.set("reim_entityid", (Object)kd.bos.dataentity.utils.StringUtils.defaultIfBlank((CharSequence)param.getEntityId(), (CharSequence)" "));
        newRelation.set("reim_expense_num", (Object)kd.bos.dataentity.utils.StringUtils.defaultIfBlank((CharSequence)param.getExpenseNum(), (CharSequence)" "));
        newRelation.set("reim_create_time", (Object)new Date());
        newRelation.set("reim_status", (Object)kd.bos.dataentity.utils.StringUtils.defaultIfBlank((CharSequence)param.getStatus(), (CharSequence)" "));
        newRelation.set("reim_expense_type", (Object)kd.bos.dataentity.utils.StringUtils.defaultIfBlank((CharSequence)param.getExpenseType(), (CharSequence)" "));
        newRelation.set("vouch_vouchid", (Object)" ");
        newRelation.set("vouch_vouch_no", (Object)" ");
        newRelation.set("vouch_resource", (Object)" ");
        newRelation.set("vouch_account_date", null);
        newRelation.set("vouch_account_time", null);
        return newRelation;
    }

    public QFilter getExpenseRelationQFilter(ExpenseDTO param, String expense_idKey, String entityidKey, String resourceKey) {
        QFilter idfilter = new QFilter(expense_idKey, "=", (Object)param.getExpenseId());
        if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)param.getEntityId()) && param.getResource() != null) {
            idfilter = idfilter.and(new QFilter(entityidKey, "=", (Object)param.getEntityId()).or(new QFilter(resourceKey, "=", (Object)param.getResource())));
            return idfilter;
        }
        if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)param.getEntityId())) {
            idfilter = idfilter.and(new QFilter(entityidKey, "=", (Object)param.getEntityId()));
            if (param.getResource() != null) {
                idfilter = idfilter.and(new QFilter(resourceKey, "=", (Object)param.getResource()));
            }
        } else {
            if (param.getResource() == null) {
                param.setResource(" ");
            }
            idfilter = idfilter.and(new QFilter(resourceKey, "=", (Object)param.getResource()));
        }
        return idfilter;
    }

    private boolean isCurrentExpenseId(ExpenseDTO param, DynamicObject relation) {
        String expenseId = relation.getString("reim_expense_id");
        String entityId = relation.getString("reim_entityid");
        String resource = relation.getString("reim_resource");
        if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)param.getExpenseId(), (CharSequence)expenseId)) {
            if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)param.getEntityId())) {
                if (param.getResource() != null) {
                    return kd.bos.dataentity.utils.StringUtils.equals((CharSequence)param.getEntityId(), (CharSequence)entityId) && (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)param.getResource()) && kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)resource) || kd.bos.dataentity.utils.StringUtils.equals((CharSequence)param.getResource(), (CharSequence)resource));
                }
                return kd.bos.dataentity.utils.StringUtils.equals((CharSequence)param.getEntityId(), (CharSequence)entityId);
            }
            if (param.getResource() == null) {
                param.setResource(" ");
            }
            return kd.bos.dataentity.utils.StringUtils.equals((CharSequence)param.getResource(), (CharSequence)resource);
        }
        return false;
    }

    public static List<Object> getBillIds(List<String> serialNos) {
        List<Object> billIds = Lists.newArrayList();
        if (serialNos == null || serialNos.size() == 0) {
            return billIds;
        }
        List nos = serialNos.stream().filter(i -> !i.isEmpty()).collect(Collectors.toList());
        DynamicObjectCollection idCollect = QueryServiceHelper.query((String)"rim_expense_relation", (String)"expense_id", (QFilter[])new QFilter[]{new QFilter("serial_no", "in", nos)});
        billIds = idCollect.stream().map(o -> o.get("expense_id")).distinct().collect(Collectors.toList());
        return billIds;
    }

    private void loadBillLinkByMainTenant(ExpenseDTO param) {
        if (param.getBotpBillList() != null && param.getBotpBillList().size() > 0) {
            return;
        }
        List<Map<String, String>> botpBillList = this.loadBillLinkByMainTenant(param.getEntityId(), param.getExpenseId());
        param.setBotpBillList(botpBillList);
    }

    public List<Map<String, String>> loadBillLinkByMainTenant(String entityId, List<Long> idList) {
        List<Map<String, String>> botpBillList = this.loadBillLinkUpNodes(entityId, idList);
        if (botpBillList == null || botpBillList.isEmpty()) {
            botpBillList = this.loadBillLinkDownNodes(entityId, idList);
        }
        return botpBillList;
    }

    public List<Map<String, String>> loadBillLinkByMainTenant(String entityId, String billId) {
        Long id = BigDecimalUtil.transDecimal(billId).longValue();
        if (id > 0L) {
            ArrayList<Long> idList = new ArrayList<Long>(1);
            idList.add(id);
            return this.loadBillLinkByMainTenant(entityId, idList);
        }
        return new ArrayList<Map<String, String>>(0);
    }

    public List<Map<String, String>> loadBillLinkBySubTenant(String entityId, List<Long> idList) {
        List<Map<String, String>> botpBillList = this.loadBillLinkDownNodes(entityId, idList);
        if (botpBillList == null || botpBillList.isEmpty()) {
            botpBillList = this.loadBillLinkUpNodes(entityId, idList);
        }
        return botpBillList;
    }

    public List<Map<String, String>> loadBillLinkBySubTenant(String entityId, String billId) {
        Long id = BigDecimalUtil.transDecimal(billId).longValue();
        if (id > 0L) {
            ArrayList<Long> idList = new ArrayList<Long>(1);
            idList.add(id);
            return this.loadBillLinkBySubTenant(entityId, idList);
        }
        return new ArrayList<Map<String, String>>(0);
    }

    public List<Map<String, String>> loadBillLinkDownNodes(String entityId, List<Long> billList) {
        ArrayList<Map<String, String>> botpBillList = new ArrayList<Map<String, String>>(4);
        long start = System.currentTimeMillis();
        if (!kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)entityId) && billList != null && !billList.isEmpty() && MetadataUtil.exists(entityId).booleanValue()) {
            try {
                Long[] ids = new Long[]{};
                Class<?> classZzz = Class.forName("kd.bos.service.ctbotp.service.CtBillLkServiceHelper");
                Method method = classZzz.getMethod("loadBillLinkDownNodes", String.class, String.class, String.class, ids.getClass(), Boolean.TYPE);
                RequestContext context = RequestContext.get();
                Object obj = method.invoke(null, context.getTenantId(), context.getAccountId(), entityId, billList.toArray(new Long[0]), true);
                if (obj != null) {
                    String json = SerializationUtils.toJsonString((Object)obj);
                    JSONObject result = JSONObject.parseObject((String)json);
                    for (Map.Entry relationentry : result.entrySet()) {
                        JSONObject tNodes;
                        JSONObject bb = result.getJSONObject((String)relationentry.getKey());
                        if (bb == null || (tNodes = bb.getJSONObject("tnodes")) == null) continue;
                        for (Map.Entry entry : tNodes.entrySet()) {
                            JSONObject rowId;
                            JSONObject rowIdObject = tNodes.getJSONObject((String)entry.getKey());
                            if (rowIdObject == null || rowIdObject.isEmpty() || !entityId.equals((rowId = rowIdObject.getJSONObject("rowId")).getString("mainEntityKey"))) continue;
                            HashMap<String, String> resultMap = new HashMap<String, String>(2);
                            resultMap.put("billId", rowId.getString("billId"));
                            resultMap.put("entityId", rowId.getString("mainEntityKey"));
                            botpBillList.add(resultMap);
                        }
                    }
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                LOGGER.info("\u4e0b\u67e5\u5173\u8054\u5355\u636e\u5931\u8d251:" + e);
            }
            catch (Throwable e) {
                LOGGER.info("\u4e0b\u67e5\u5173\u8054\u5355\u636e\u5931\u8d252:" + e);
            }
        }
        return botpBillList;
    }

    private List<Map<String, String>> loadBillLinkUpNodes(String entityId, List<Long> billIds) {
        long start = System.currentTimeMillis();
        ArrayList<Map<String, String>> botpBillList = new ArrayList<Map<String, String>>(4);
        if (!kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)entityId) && billIds != null && !billIds.isEmpty() && MetadataUtil.exists(entityId).booleanValue()) {
            try {
                Long[] ids = new Long[]{};
                Class<?> classZzz = Class.forName("kd.bos.service.ctbotp.service.CtBillLkServiceHelper");
                Method method = classZzz.getMethod("loadBillLinkUpNodes", String.class, String.class, String.class, ids.getClass(), Boolean.TYPE);
                Object obj = method.invoke(null, RequestContext.get().getTenantId(), RequestContext.get().getAccountId(), entityId, billIds.toArray(new Long[0]), true);
                if (obj != null) {
                    String json = SerializationUtils.toJsonString((Object)obj);
                    JSONObject result = JSONObject.parseObject((String)json);
                    for (Map.Entry relationEntry : result.entrySet()) {
                        JSONObject tNodes;
                        JSONObject bb = result.getJSONObject((String)relationEntry.getKey());
                        if (bb == null || (tNodes = bb.getJSONObject("snodes")) == null) continue;
                        for (Map.Entry entry : tNodes.entrySet()) {
                            JSONObject rowId;
                            JSONObject rowIdObject = tNodes.getJSONObject((String)entry.getKey());
                            if (rowIdObject == null || rowIdObject.isEmpty() || !entityId.equals((rowId = rowIdObject.getJSONObject("rowId")).getString("mainEntityKey"))) continue;
                            HashMap<String, String> resultMap = new HashMap<String, String>(2);
                            resultMap.put("billId", rowId.getString("billId"));
                            resultMap.put("entityId", rowId.getString("mainEntityKey"));
                            botpBillList.add(resultMap);
                        }
                    }
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                LOGGER.info("\u4e0a\u67e5\u5173\u8054\u5355\u636e\u5931\u8d251:" + e);
            }
            catch (Throwable e) {
                LOGGER.info("\u4e0a\u67e5\u5173\u8054\u5355\u636e\u5931\u8d252:" + e);
            }
        }
        return botpBillList;
    }

    private Map<String, String> queryCtsyTenant(Long orgId) {
        HashMap<String, String> resultMap = new HashMap<String, String>(2);
        if (orgId != null && orgId > 0L) {
            try {
                Class<?> classZzz = Class.forName("kd.bos.servicehelper.basedata.CtsyBaseServiceHelper");
                Method method = classZzz.getMethod("getCtsyTenant", Long.class);
                Object obj = method.invoke(null, orgId);
                if (obj != null) {
                    String json = SerializationUtils.toJsonString((Object)obj);
                    JSONObject result = JSONObject.parseObject((String)json);
                    String tenantId = result.getString("tenantId");
                    String accountId = result.getString("accountId");
                    if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)tenantId) && kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)accountId)) {
                        resultMap.put("tenantId", tenantId);
                        resultMap.put("accountId", accountId);
                    }
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                LOGGER.info("\u4e0a\u6e38\u5173\u8054\u5355\u636e\u79df\u6237\u4fe1\u606f\u5931\u8d251:" + e);
            }
            catch (Exception e) {
                LOGGER.info("\u4e0a\u6e38\u5173\u8054\u5355\u636e\u79df\u6237\u4fe1\u606f\u5931\u8d252:" + e);
            }
        }
        return resultMap;
    }
}

