/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.h5;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Vector;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.imc.rim.common.invoice.fpzs.InvoiceClassService;
import kd.imc.rim.common.license.service.FpzsAnonymousUserService;
import kd.imc.rim.common.utils.BigDecimalUtil;
import org.apache.commons.lang3.StringUtils;

public class H5InvoiceListFiterService {
    public static final String OPEN_INVOICE_CLASS_FILTER_ACTION_KEY = "openInvoiceClassFilter";
    public static final String OPEN_INVOICE_FILTER_ACTION_KEY = "openInvoiceFilter";
    private static H5InvoiceListFiterService service;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static H5InvoiceListFiterService getInstance() {
        Class<H5InvoiceListFiterService> clazz = H5InvoiceListFiterService.class;
        synchronized (H5InvoiceListFiterService.class) {
            if (service == null) {
                service = new H5InvoiceListFiterService();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return service;
        }
    }

    public void openInvoiceFilter(AbstractFormPlugin plugin) {
        Vector vector = (Vector)plugin.getView().getControl("vt_invoice_filter");
        vector.setFontClass("kdfont kdfont-guolvxia");
        MobileFormShowParameter mfsp = new MobileFormShowParameter();
        mfsp.setShowTitle(false);
        mfsp.setShowClose(false);
        mfsp.setFormId("rim_inv_collect_filter_mb");
        mfsp.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, OPEN_INVOICE_FILTER_ACTION_KEY));
        mfsp.getOpenStyle().setShowType(ShowType.Floating);
        HashMap customParams = Maps.newHashMapWithExpectedSize((int)2);
        String sort = (String)plugin.getView().getModel().getValue("sort_drop");
        if (StringUtils.isBlank((CharSequence)sort)) {
            sort = "0";
        }
        customParams.put("sort", sort);
        String status = (String)plugin.getView().getModel().getValue("expense_status_muldrop");
        if (StringUtils.isBlank((CharSequence)status)) {
            status = "0";
        }
        customParams.put("status", status);
        String type = (String)plugin.getView().getModel().getValue("invoice_type_muldrop");
        if (StringUtils.isBlank((CharSequence)type) || Arrays.stream(status.split(",")).filter(v -> StringUtils.isNotBlank((CharSequence)v)).collect(Collectors.toList()).isEmpty()) {
            type = ",0,";
        }
        customParams.put("type", type);
        String date = (String)plugin.getView().getModel().getValue("invoice_date_drop");
        if (StringUtils.equals((CharSequence)date, (CharSequence)"7")) {
            Date enddate;
            Date startdate = (Date)plugin.getView().getModel().getValue("startdate");
            if (startdate != null) {
                customParams.put("startdate", startdate.getTime() + "");
            }
            if ((enddate = (Date)plugin.getView().getModel().getValue("enddate")) != null) {
                customParams.put("enddate", enddate.getTime() + "");
            }
        } else if (StringUtils.isBlank((CharSequence)date)) {
            date = "0";
        }
        customParams.put("date", date);
        FpzsAnonymousUserService.addEventCode(customParams, plugin.getView().getPageId());
        mfsp.setCustomParams((Map)customParams);
        plugin.getView().showForm((FormShowParameter)mfsp);
    }

    public void openInvoiceClassFiter(AbstractFormPlugin plugin) {
        JSONArray classInfos;
        Vector vector = (Vector)plugin.getView().getControl("vt_class_filter");
        vector.setFontClass("kdfont kdfont-guolvxia");
        MobileFormShowParameter mfsp = new MobileFormShowParameter();
        mfsp.setShowTitle(false);
        mfsp.setShowClose(false);
        mfsp.setFormId("rim_inv_class_filter_mb");
        mfsp.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, OPEN_INVOICE_CLASS_FILTER_ACTION_KEY));
        mfsp.getOpenStyle().setShowType(ShowType.Floating);
        HashMap customParams = Maps.newHashMapWithExpectedSize((int)2);
        customParams.put("classId", JSONObject.toJSONString(this.getClassIds(plugin)));
        Long rim_user = BigDecimalUtil.transDecimal(plugin.getView().getFormShowParameter().getCustomParam("rim_user")).longValue();
        if (rim_user > 0L) {
            customParams.put("rim_user", rim_user);
        }
        if ((classInfos = InvoiceClassService.getInstance().getUserAllInvoiceUesedClass(customParams)).isEmpty()) {
            plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ed9\u53d1\u7968\u6dfb\u52a0\u6807\u7b7e\u3002", (String)"H5InvoiceListFiterService_0", (String)"imc-rim-common", (Object[])new Object[0]));
            return;
        }
        customParams.put("show_class_infos", classInfos.toJSONString());
        FpzsAnonymousUserService.addEventCode(customParams, plugin.getView().getPageId());
        mfsp.setCustomParams((Map)customParams);
        plugin.getView().showForm((FormShowParameter)mfsp);
    }

    private List<Long> getClassIds(AbstractFormPlugin plugin) {
        DynamicObjectCollection mulClass = (DynamicObjectCollection)plugin.getView().getModel().getValue("mul_class");
        return mulClass.stream().map(v -> v.getLong("fbasedataid_id")).collect(Collectors.toList());
    }

    public void closeCallBack(AbstractFormPlugin plugin, Object returnData) {
        JSONObject backData = JSONObject.parseObject((String)((String)returnData));
        plugin.getView().getModel().beginInit();
        if (backData.get((Object)"classId") != null) {
            List classId = backData.getJSONArray("classId").toJavaList(Long.class);
            plugin.getView().getModel().setValue("mul_class", (Object)classId.toArray());
        }
        if (StringUtils.isNotBlank((CharSequence)backData.getString("all_not"))) {
            plugin.getView().getModel().setValue("sort_drop", (Object)"createtime");
            plugin.getView().getModel().setValue("expense_status_muldrop", (Object)"0");
            plugin.getView().getModel().setValue("invoice_type_muldrop", (Object)"0");
            plugin.getView().getModel().setValue("invoice_date_drop", (Object)"0");
            plugin.getView().getModel().setValue("startdate", null);
            plugin.getView().getModel().setValue("enddate", null);
        } else {
            if (backData.get((Object)"sort") != null) {
                plugin.getView().getModel().setValue("sort_drop", backData.get((Object)"sort"));
            }
            if (backData.get((Object)"status") != null) {
                plugin.getView().getModel().setValue("expense_status_muldrop", backData.get((Object)"status"));
            }
            if (backData.get((Object)"type") != null) {
                plugin.getView().getModel().setValue("invoice_type_muldrop", backData.get((Object)"type"));
            }
            if (backData.get((Object)"date") != null) {
                plugin.getView().getModel().setValue("invoice_date_drop", backData.get((Object)"date"));
                if (backData.get((Object)"startdate") != null) {
                    plugin.getView().getModel().setValue("startdate", (Object)new Date(Long.parseLong((String)backData.get((Object)"startdate"))));
                }
                if (backData.get((Object)"enddate") != null) {
                    plugin.getView().getModel().setValue("enddate", (Object)new Date(Long.parseLong((String)backData.get((Object)"enddate"))));
                }
            }
        }
        plugin.getView().getModel().endInit();
        plugin.getView().updateView("sort_drop");
        plugin.getView().updateView("expense_status_muldrop");
        plugin.getView().updateView("invoice_type_muldrop");
        plugin.getView().updateView("invoice_date_drop");
        plugin.getView().updateView("startdate");
        plugin.getView().updateView("enddate");
        Vector vtClassFilter = (Vector)plugin.getView().getControl("vt_class_filter");
        vtClassFilter.setFontClass("kdfont kdfont-guolvshang");
        Vector vtInvoiceFilter = (Vector)plugin.getView().getControl("vt_invoice_filter");
        vtInvoiceFilter.setFontClass("kdfont kdfont-guolvshang");
    }
}

