/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.helper;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Locale;
import kd.bos.cache.CacheFactory;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;

public class ExcelHelper {
    private static Log LOGGER = LogFactory.getLog(ExcelHelper.class);

    public static void downloadTemplate(AbstractFormPlugin formPlugin, String templateDir, String templateName) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try (InputStream inStream = classLoader.getResourceAsStream(templateDir + File.separator + templateName);){
            String urls = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(templateName, inStream, 5000);
            formPlugin.getView().openUrl(urls);
        }
        catch (IOException e) {
            LOGGER.error((Throwable)e);
        }
    }

    public static String getStringValueFromCell(Cell cell) {
        if (null == cell) {
            return "";
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd", Locale.CHINA);
        CellType cellType = cell.getCellType();
        switch (cellType) {
            case STRING: {
                return cell.getStringCellValue().trim();
            }
            case BOOLEAN: {
                return String.valueOf(cell.getBooleanCellValue()).trim();
            }
            case FORMULA: {
                try {
                    cell.getSheet().getWorkbook().getCreationHelper().createFormulaEvaluator().evaluateFormulaCell(cell);
                    return cell.getStringCellValue().trim();
                }
                catch (IllegalStateException e) {
                    return String.valueOf(cell.getRichStringCellValue()).trim();
                }
            }
            case NUMERIC: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    return sdf.format(cell.getDateCellValue());
                }
                String cellValue = new BigDecimal(String.valueOf(cell.getNumericCellValue())).stripTrailingZeros().toPlainString();
                return cellValue.trim();
            }
        }
        return cell.getStringCellValue().trim();
    }
}

