/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.checknew;

import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.invoice.checknew.model.CheckParam;
import kd.imc.rim.common.invoice.checknew.model.CheckResult;
import kd.imc.rim.common.utils.DateUtils;
import org.apache.commons.lang3.StringUtils;

public interface CheckService {
    public CheckResult checkInvoice(CheckParam var1);

    default public JSONObject getReultFormDb(CheckParam checkParam, String checkType) {
        if (checkParam.isNoCache()) {
            return null;
        }
        if (checkParam.getCacheDate() > 0) {
            String check_result_tag;
            QFilter filter4;
            QFilter filter3;
            QFilter filter2;
            Date lastDate = DateUtils.addDay(new Date(), 0 - checkParam.getCacheDate());
            QFilter filter1 = new QFilter("invoice_code", "=", (Object)checkParam.getInvoiceCode());
            DynamicObject obj = QueryServiceHelper.queryOne((String)"rim_check_result", (String)"check_result_tag", (QFilter[])new QFilter[]{filter1, filter2 = new QFilter("invoice_no", "=", (Object)checkParam.getInvoiceNo()), filter3 = new QFilter("check_time", ">=", (Object)lastDate), filter4 = new QFilter("check_type", "=", (Object)checkType)});
            if (obj != null && !StringUtils.isEmpty((CharSequence)(check_result_tag = obj.getString("check_result_tag")))) {
                JSONObject result = JSONObject.parseObject((String)check_result_tag);
                return result;
            }
        }
        return null;
    }

    default public void saveReultToDb(CheckParam checkParam, JSONObject result, String checkType) {
        try {
            if (result != null) {
                QFilter filter1 = new QFilter("invoice_code", "=", (Object)checkParam.getInvoiceCode());
                QFilter filter2 = new QFilter("invoice_no", "=", (Object)checkParam.getInvoiceNo());
                QFilter filter4 = new QFilter("check_type", "=", (Object)checkType);
                DeleteServiceHelper.delete((String)"rim_check_result", (QFilter[])new QFilter[]{filter1, filter2, filter4});
                DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"rim_check_result");
                obj.set("invoice_code", (Object)checkParam.getInvoiceCode());
                obj.set("invoice_no", (Object)checkParam.getInvoiceNo());
                obj.set("check_type", (Object)checkType);
                obj.set("check_result_tag", (Object)result.toJSONString());
                obj.set("check_time", (Object)new Date());
                obj.set("creater", (Object)RequestContext.get().getUserId());
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    default public boolean compareParam(CheckParam checkParam, CheckParam checkResult) {
        if (!StringUtils.trimToEmpty((String)checkParam.getInvoiceCode()).equals(StringUtils.trimToEmpty((String)checkResult.getInvoiceCode()))) {
            return false;
        }
        if (!StringUtils.trimToEmpty((String)checkParam.getInvoiceNo()).equals(StringUtils.trimToEmpty((String)checkResult.getInvoiceNo()))) {
            return false;
        }
        if (!StringUtils.trimToEmpty((String)checkParam.getInvoiceDate()).equals(StringUtils.trimToEmpty((String)checkResult.getInvoiceDate()))) {
            return false;
        }
        if (InputInvoiceTypeEnum.ORDINARY_ELECTRON.getCode().equals(checkParam.getInvoiceType()) || InputInvoiceTypeEnum.ORDINARY_PAPER.getCode().equals(checkParam.getInvoiceType()) || InputInvoiceTypeEnum.ORDINARY_ROLL.getCode().equals(checkParam.getInvoiceType()) || InputInvoiceTypeEnum.TOLL_ELECTRON.getCode().equals(checkParam.getInvoiceType())) {
            String checkCode1 = StringUtils.trimToEmpty((String)checkParam.getCheckCode());
            String checkCode2 = StringUtils.trimToEmpty((String)checkResult.getCheckCode());
            if (checkCode1.length() > 6) {
                checkCode1 = checkCode1.substring(checkCode1.length() - 6);
            }
            if (checkCode2.length() > 6) {
                checkCode2 = checkCode2.substring(checkCode2.length() - 6);
            }
            if (!checkCode1.equals(checkCode2)) {
                return false;
            }
        } else if (InputInvoiceTypeEnum.SPECIAL_ELECTRON.getCode().equals(checkParam.getInvoiceType()) || InputInvoiceTypeEnum.SPECIAL_PAPER.getCode().equals(checkParam.getInvoiceType()) || InputInvoiceTypeEnum.MOTOR_INVOICE.getCode().equals(checkParam.getInvoiceType()) || InputInvoiceTypeEnum.USEDCAR_INVOICE.getCode().equals(checkParam.getInvoiceType()) ? checkParam.getInvoiceMoney().compareTo(checkResult.getInvoiceMoney()) != 0 : InputInvoiceTypeEnum.isEleInvoice(checkParam.getInvoiceType()) != false && checkParam.getTotalAmount().compareTo(checkResult.getTotalAmount()) != 0) {
            return false;
        }
        return true;
    }
}

