/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.collector;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.CheckContant;
import kd.imc.rim.common.constant.ExpenseConstant;
import kd.imc.rim.common.constant.FpzsConstant;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.helper.ImcSaveServiceHelper;
import kd.imc.rim.common.helper.RecognitionCheckHelper;
import kd.imc.rim.common.invoice.checknew.model.CheckParam;
import kd.imc.rim.common.invoice.checknew.model.CheckResult;
import kd.imc.rim.common.invoice.fpzs.FpzsMainService;
import kd.imc.rim.common.invoice.model.ConvertFieldUtil;
import kd.imc.rim.common.invoice.query.InvoiceQueryService;
import kd.imc.rim.common.invoice.query.convert.InvoiceConvertService;
import kd.imc.rim.common.invoice.save.InvoiceSaveResult;
import kd.imc.rim.common.invoice.save.InvoiceSaveService;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.service.InvoiceLog;
import kd.imc.rim.common.service.SimplyCheckService;
import kd.imc.rim.common.utils.AwsFpyService;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DeductionUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.InvoiceConvertUtils;
import kd.imc.rim.common.utils.MetadataUtil;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.common.utils.SysParamUtil;
import kd.imc.rim.common.utils.TenantUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.tuple.Pair;

public class InvoiceCollectService {
    private static Log logger = LogFactory.getLog(InvoiceCollectService.class);

    public JSONObject saveInvoice(JSONObject invoice, String filePath, String fileHash) {
        if (null != invoice) {
            InvoiceSaveService invoiceSaveService;
            long start = System.currentTimeMillis();
            invoice.put("repeat", (Object)Boolean.FALSE);
            if (kd.bos.util.StringUtils.isNotEmpty((String)invoice.getString("serialNo")) && (invoiceSaveService = InvoiceSaveService.newInstance(invoice.getString("invoiceType"))) != null) {
                boolean repeatFlag = invoiceSaveService.checkInvoiceExists(invoice);
                invoice.put("repeat", (Object)repeatFlag);
                if (!"1".equals(invoice.getString("checkStatus"))) {
                    InvoiceSaveResult saveResult = invoiceSaveService.saveUncheckInvoice(invoice, invoice.getString("resource"));
                    if (saveResult.getReturnDBFlag().booleanValue()) {
                        JSONObject invoiceChild = new JSONObject();
                        invoiceChild = saveResult.getInvoiceJson();
                        invoice.putAll((Map)invoiceChild);
                    }
                    invoice.put("serialNo", (Object)saveResult.getSerialNo());
                    invoice.put("unCheckId", saveResult.getUnCheckId());
                } else {
                    InvoiceSaveResult saveResult = invoiceSaveService.save(invoice);
                    invoice.put("serialNo", (Object)saveResult.getSerialNo());
                    invoice.put("invoice_info", (Object)saveResult.getInvoiceInfo());
                    invoice.put("mainId", saveResult.getMainId());
                    invoice.put("invoiceId", saveResult.getInvoiceId());
                }
            }
            logger.info(invoice.getString("fileName") + "\u7b2c" + invoice.getString("fileIndex") + "\u9875\uff0cInvoiceCollectService.saveInvoice\u53d1\u7968\u5165\u5e93\u7edf\u8ba1\u4fe1\u606f:" + invoice.getString("serialNo") + ",\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
        }
        return invoice;
    }

    public JSONObject checkAndSaveInvoice(JSONObject invoiceData, boolean unChangedFlag) {
        long start = System.currentTimeMillis();
        JSONObject result = new JSONObject();
        boolean saveFlag = false;
        String resource = invoiceData.getString("resource");
        String delete = invoiceData.getString("delete");
        Boolean uncheckListFlag = invoiceData.getBoolean("uncheckListFlag");
        String oldSerialNo = invoiceData.getString("serialNo");
        if (kd.bos.util.StringUtils.isNotEmpty((String)invoiceData.getString("invoiceType"))) {
            Long invoiceType = Long.parseLong(invoiceData.getString("invoiceType"));
            if (invoiceType < 1000L) {
                invoiceData.put("invoiceType", (Object)InputInvoiceTypeEnum.getInvoiceType(String.valueOf(invoiceType)).getCode());
            } else {
                invoiceData.put("invoiceType", (Object)invoiceType);
            }
        }
        Long rimUser = BigDecimalUtil.transDecimal(invoiceData.get((Object)"rim_user")).longValue();
        Long userId = FpzsMainService.getUserId((Map<String, Object>)invoiceData);
        Long org_id = invoiceData.getLong("org_id");
        if (org_id == null || org_id <= 0L) {
            org_id = RequestContext.get().getOrgId();
        }
        result.put("checkStatus", (Object)Boolean.TRUE);
        CheckResult checkResult = new CheckResult();
        if (InputInvoiceTypeEnum.needCheck(invoiceData.getLong("invoiceType")).booleanValue()) {
            JSONArray barcodeArray;
            String totalAmount = invoiceData.getString("totalAmount");
            String invoiceAmount = invoiceData.getString("invoiceAmount");
            String checkAmount = "0";
            if (InputInvoiceTypeEnum.USEDCAR_INVOICE.getCode().equals(invoiceData.getLong("invoiceType")) || InputInvoiceTypeEnum.needReplaceAmountType(invoiceData.getLong("invoiceType"))) {
                checkAmount = totalAmount;
            } else {
                checkAmount = invoiceAmount;
                if (kd.bos.util.StringUtils.isEmpty((String)invoiceAmount)) {
                    checkAmount = totalAmount;
                }
            }
            String invoiceCode = invoiceData.getString("invoiceCode");
            String invoiceNo = invoiceData.getString("invoiceNo");
            Long invoiceType = invoiceData.getLong("invoiceType");
            CheckParam checkParam = new CheckParam(invoiceCode, invoiceNo, invoiceType, invoiceData.getString("invoiceDate"), BigDecimalUtil.transDecimal(checkAmount), invoiceData.getString("checkCode"), null);
            if (InputInvoiceTypeEnum.SPECIAL_PAPER.getCode().equals(invoiceType) || InputInvoiceTypeEnum.ORDINARY_PAPER.getCode().equals(invoiceType) || InputInvoiceTypeEnum.MOTOR_INVOICE.getCode().equals(invoiceType)) {
                checkParam.setEtaxInvoiceNo(this.getEtaxInvoiceNo(invoiceCode, invoiceNo));
            }
            HashMap extMap = Maps.newHashMap();
            extMap.put("orgId", org_id);
            String taxNo = invoiceData.getString("buyerTaxNo");
            if (kd.bos.util.StringUtils.isEmpty((String)taxNo)) {
                taxNo = kd.bos.util.StringUtils.isEmpty((String)invoiceData.getString("tax_no")) ? TenantUtils.getTaxNoByOrgId(org_id) : invoiceData.getString("tax_no");
            }
            extMap.put("taxNo", taxNo);
            extMap.put("eid", RequestContext.get().getUserId());
            checkParam.setExtMap(extMap);
            checkResult = SimplyCheckService.checkInvoice(checkParam, org_id, taxNo);
            String snapshotUrl = invoiceData.getString("snapshotUrl");
            String pdfurl = CommonUtils.getJsonValue((Map<String, Object>)invoiceData, String.class, "pdfurl", "pdfUrl");
            String fileName = invoiceData.getString("fileName");
            String fileType = invoiceData.getString("fileType");
            String fileIndex = invoiceData.getString("fileIndex");
            String kdcloudUrl = invoiceData.getString("kdcloudUrl");
            String imageUrl = invoiceData.getString("imageUrl");
            String downloadUrl = invoiceData.getString("downloadUrl");
            String ofdUrl = invoiceData.getString("ofdUrl");
            String localUrl = invoiceData.getString("localUrl");
            String rotationAngle = invoiceData.getString("rotationAngle");
            String region = invoiceData.getString("region");
            String pixel = invoiceData.getString("pixel");
            Object originalState = invoiceData.get((Object)"originalState");
            Object companySeal = invoiceData.get((Object)"companySeal");
            Object continuousNo = invoiceData.get((Object)"continuousNo");
            String orgId = invoiceData.getString("org_id");
            String sourceArea = invoiceData.getString("sourceArea");
            String destArea = invoiceData.getString("destArea");
            invoiceData.put("errcode", (Object)checkResult.getErrcode());
            String imageType = invoiceData.getString("imageType");
            String barcode = null;
            String expenseNum = null;
            if (InputInvoiceTypeEnum.OTHER_INVOICE.getCode().equals(invoiceData.getLong("invoiceType")) && !CollectionUtils.isEmpty((Collection)(barcodeArray = invoiceData.getJSONArray("barcode")))) {
                barcode = invoiceData.getString("barcode");
                String expenseNumTemp = (String)barcodeArray.get(0);
                if (kd.bos.util.StringUtils.isNotEmpty((String)expenseNumTemp)) {
                    expenseNum = expenseNumTemp;
                }
            }
            if ("0000".equals(checkResult.getErrcode())) {
                String checkStatus;
                String collectType = invoiceData.getString("collect_type");
                Object authenticateFlag = invoiceData.get((Object)"authenticateFlag");
                Object authenticateTime = invoiceData.get((Object)"authenticateTime");
                Object selectTime = invoiceData.get((Object)"selectTime");
                Object taxPeriod = invoiceData.get((Object)"taxPeriod");
                Object deductionPurpose = invoiceData.get((Object)"deductionPurpose");
                Object effectiveTaxAmount = invoiceData.get((Object)"effectiveTaxAmount");
                Object manageStatus = invoiceData.get((Object)"manageStatus");
                String needUserRelation = invoiceData.getString("needUserRelation");
                Object invoiceEntity = checkResult.getData();
                String invoiceCheckStr = JSONObject.toJSONString((Object)invoiceEntity);
                Long checkInvoiceType = invoiceData.getLong("invoiceType");
                if (InputInvoiceTypeEnum.AIR_ELE_INVOICE.getCode().equals(checkInvoiceType) || InputInvoiceTypeEnum.TRAIN_ELE_INVOICE.getCode().equals(checkInvoiceType)) {
                    invoiceData.putAll((Map)JSON.parseObject((String)invoiceCheckStr));
                    if (InputInvoiceTypeEnum.AIR_ELE_INVOICE.getCode().equals(checkInvoiceType)) {
                        invoiceData = this.putDbAirEleInfo(checkInvoiceType, invoiceData);
                    }
                    if (InputInvoiceTypeEnum.TRAIN_ELE_INVOICE.getCode().equals(checkInvoiceType)) {
                        invoiceData = this.putDbTrainEleInfo(checkInvoiceType, invoiceData);
                    }
                } else {
                    invoiceData = JSON.parseObject((String)invoiceCheckStr);
                }
                invoiceData.put("resource", (Object)resource);
                if ("9".equals(resource) || "\u7a0e\u76d8".equals(resource)) {
                    invoiceData.put("allowDeduction", (Object)"1");
                }
                if (kd.bos.util.StringUtils.isEmpty((String)(checkStatus = invoiceData.getString("checkStatus"))) || !"1".equals(checkStatus)) {
                    invoiceData.put("checkStatus", (Object)"1");
                }
                invoiceData.put("collect_type", (Object)collectType);
                invoiceData.put("authenticateFlag", authenticateFlag);
                invoiceData.put("authenticateTime", authenticateTime);
                invoiceData.put("selectTime", selectTime);
                invoiceData.put("taxPeriod", taxPeriod);
                invoiceData.put("deductionPurpose", deductionPurpose);
                invoiceData.put("effectiveTaxAmount", effectiveTaxAmount);
                invoiceData.put("manageStatus", manageStatus);
                invoiceData.put("imageType", (Object)imageType);
                invoiceData.put("barcode", (Object)barcode);
                invoiceData.put("expenseNum", (Object)expenseNum);
                invoiceData.put("fileIndex", (Object)fileIndex);
                invoiceData.put("delete", (Object)delete);
                invoiceData.put("kdcloudUrl", (Object)kdcloudUrl);
                invoiceData.put("fileName", (Object)fileName);
                if (kd.bos.util.StringUtils.isNotEmpty((String)needUserRelation)) {
                    invoiceData.put("needUserRelation", (Object)needUserRelation);
                }
            } else {
                invoiceData.put("description", (Object)checkResult.getDescription());
                invoiceData.put("sourceArea", (Object)sourceArea);
                invoiceData.put("destArea", (Object)destArea);
                result.put("checkStatus", (Object)Boolean.FALSE);
            }
            if (kd.bos.util.StringUtils.isNotEmpty((String)snapshotUrl) || kd.bos.util.StringUtils.isNotEmpty((String)downloadUrl) || kd.bos.util.StringUtils.isNotEmpty((String)pdfurl) || kd.bos.util.StringUtils.isNotEmpty((String)localUrl) || kd.bos.util.StringUtils.isNotEmpty((String)ofdUrl)) {
                invoiceData.put("fileName", (Object)fileName);
                invoiceData.put("fileIndex", (Object)fileIndex);
                invoiceData.put("snapshotUrl", (Object)snapshotUrl);
                invoiceData.put("imageUrl", (Object)imageUrl);
                invoiceData.put("downloadUrl", (Object)downloadUrl);
                invoiceData.put("pdfurl", (Object)pdfurl);
                invoiceData.put("ofdUrl", (Object)ofdUrl);
                invoiceData.put("localUrl", (Object)localUrl);
                invoiceData.put("rotationAngle", (Object)rotationAngle);
                invoiceData.put("region", (Object)region);
                invoiceData.put("pixel", (Object)pixel);
                invoiceData.put("kdcloudUrl", (Object)kdcloudUrl);
                invoiceData.put("fileType", (Object)fileType);
            }
            invoiceData.put("org_id", (Object)orgId);
            if (null != originalState) {
                invoiceData.put("originalState", originalState);
            }
            if (null != companySeal) {
                invoiceData.put("companySeal", companySeal);
            }
            if (null != continuousNo) {
                invoiceData.put("continuousNo", continuousNo);
            }
        } else {
            this.convertUnVatInvoice(invoiceData, true);
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)invoiceData.getString("invoiceType"))) {
            Long invoiceType = Long.parseLong(invoiceData.getString("invoiceType"));
            if (InputInvoiceTypeEnum.HGJKS.getCode().equals(invoiceType)) {
                invoiceData.remove((Object)"totalTaxAmount");
                invoiceData.put("totalTaxAmount", (Object)invoiceData.getBigDecimal("totalAmount"));
            }
        }
        try {
            logger.info("InvoiceCollectService.checkAndSaveInvoice\u67e5\u9a8c\u53d1\u7968\u7edf\u8ba1\u4fe1\u606f\u7ed3\u679c\uff1a" + result + ",\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
            InvoiceSaveService invoiceSaveService = InvoiceSaveService.newInstance(invoiceData.getString("invoiceType"));
            if (invoiceSaveService != null) {
                InvoiceSaveResult saveResult;
                String checkCode;
                invoiceData.put("rim_user", (Object)rimUser);
                boolean repeatFlag = invoiceSaveService.checkInvoiceExists(invoiceData);
                result.put("repeat", (Object)repeatFlag);
                if (!unChangedFlag) {
                    invoiceData.put("isRevise", (Object)"2");
                }
                if (StringUtils.isNotEmpty((CharSequence)(checkCode = invoiceData.getString("checkCode"))) && checkCode.length() > 6) {
                    invoiceData.put("checkCode", (Object)checkCode.substring(checkCode.length() - 6));
                }
                if (uncheckListFlag != null && uncheckListFlag.booleanValue()) {
                    boolean isCollectOwner = SysParamUtil.getSysParamByOrgId(RequestContext.get().getOrgId(), "is_collectowner");
                    if (isCollectOwner) {
                        boolean isHit = SysParamUtil.isHitValue(RequestContext.get().getOrgId(), "collectowner_config", "3");
                        if (!isHit) {
                            invoiceData.put("needUserRelation", (Object)"0");
                        } else {
                            invoiceData.put("oldSerialNo", (Object)oldSerialNo);
                            InvoiceSaveService.notSetUserRelationIfExist(invoiceData);
                        }
                    } else {
                        invoiceData.put("needUserRelation", (Object)"0");
                    }
                }
                if (!"1".equals(invoiceData.getString("checkStatus"))) {
                    saveResult = invoiceSaveService.saveUncheckInvoice(invoiceData, resource);
                    invoiceData.put("mainId", saveResult.getMainId());
                    invoiceData.put("unCheckId", saveResult.getUnCheckId());
                    invoiceData.put("serialNo", (Object)saveResult.getSerialNo());
                    if (!invoiceData.getString("serialNo").equals(oldSerialNo)) {
                        this.deleteUncheckInvoiceBySerialNo(oldSerialNo, invoiceData.getString("checkStatus"));
                    }
                } else {
                    saveResult = invoiceSaveService.save(invoiceData);
                    invoiceData.put("serialNo", (Object)saveResult.getSerialNo());
                    invoiceData.put("invoice_info", (Object)saveResult.getInvoiceInfo());
                    invoiceData.put("mainId", saveResult.getMainId());
                }
                String isSaleListInvoice = invoiceData.getString("isSaleListInvoice");
                if ("1".equals(isSaleListInvoice)) {
                    RecognitionCheckHelper recognitionCheckHelper = new RecognitionCheckHelper();
                    recognitionCheckHelper.dealInvoiceAttachRelation(invoiceData);
                }
                if (kd.bos.util.StringUtils.isNotEmpty((String)oldSerialNo) && !invoiceData.getString("serialNo").equals(oldSerialNo)) {
                    this.delOldInvoice(oldSerialNo, org_id, userId, rimUser);
                    if (!"1".equals(invoiceData.getString("checkStatus"))) {
                        result.put("repeat", (Object)Boolean.FALSE);
                    }
                }
                if ("0000".equals(checkResult.getErrcode())) {
                    this.deleteUncheckInvoiceBySerialNo(oldSerialNo, invoiceData.getString("checkStatus"));
                }
                if (InputInvoiceTypeEnum.AIR_ELE_INVOICE.getCode().equals(invoiceData.getLong("invoiceType"))) {
                    invoiceData.put("invoiceDate", invoiceData.get((Object)"issueDate"));
                }
                result.put("data", (Object)invoiceData);
                saveFlag = true;
            }
        }
        catch (MsgException e) {
            saveFlag = false;
            result.put("saveMsg", (Object)e.getMessage());
        }
        result.put("saveFlag", (Object)saveFlag);
        logger.info("InvoiceCollectService.checkAndSaveInvoice\u67e5\u9a8c\u4fee\u6539\u4fdd\u5b58\u53d1\u7968\u7edf\u8ba1\u4fe1\u606f\u7ed3\u679c\uff1a" + result + ",\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
        return result;
    }

    private String getEtaxInvoiceNo(String invoiceCode, String invoiceNo) {
        QFilter filterCode = new QFilter("invoice_code", "=", (Object)invoiceCode);
        QFilter filterNo = new QFilter("invoice_no", "=", (Object)invoiceNo);
        DynamicObject object = QueryServiceHelper.queryOne((String)"rim_invoice", (String)"electronic_no", (QFilter[])new QFilter[]{filterCode, filterNo});
        if (object != null) {
            return object.getString("electronic_no");
        }
        return null;
    }

    public JSONObject checkInvoice(String invoiceCode, String invoiceNo, Long invoiceType, String date, BigDecimal invoiceAmount, String checkCode) {
        return this.checkInvoice(invoiceCode, invoiceNo, invoiceType, date, invoiceAmount, checkCode, null);
    }

    public JSONObject checkInvoice(String invoiceCode, String invoiceNo, Long invoiceType, String date, BigDecimal invoiceAmount, String checkCode, JSONObject businessParam) {
        JSONObject result = new JSONObject();
        CheckParam checkParam = new CheckParam(invoiceCode, invoiceNo, invoiceType, date, invoiceAmount, checkCode, null);
        HashMap extMap = Maps.newHashMap();
        extMap.put("orgId", RequestContext.get().getOrgId());
        String taxNo = TenantUtils.getTaxNoByOrgId(RequestContext.get().getOrgId());
        extMap.put("taxNo", taxNo);
        extMap.put("eid", RequestContext.get().getUserId());
        checkParam.setExtMap(extMap);
        CheckResult checkResult = SimplyCheckService.checkInvoice(checkParam, RequestContext.get().getOrgId(), taxNo);
        result.put("errcode", (Object)checkResult.getErrcode());
        result.put("description", (Object)checkResult.getDescription());
        try {
            if ("0000".equals(checkResult.getErrcode())) {
                String checkStatus;
                Object invoiceEntity = checkResult.getData();
                String invoiceCheckStr = JSONObject.toJSONString((Object)invoiceEntity);
                JSONObject invoiceData = JSON.parseObject((String)invoiceCheckStr);
                Long checkInvoiceType = invoiceData.getLong("invoiceType");
                if (InputInvoiceTypeEnum.AIR_ELE_INVOICE.getCode().equals(checkInvoiceType)) {
                    invoiceData = this.putDbAirEleInfo(checkInvoiceType, invoiceData);
                }
                if (InputInvoiceTypeEnum.TRAIN_ELE_INVOICE.getCode().equals(checkInvoiceType)) {
                    invoiceData = this.putDbTrainEleInfo(checkInvoiceType, invoiceData);
                }
                if (kd.bos.util.StringUtils.isEmpty((String)(checkStatus = invoiceData.getString("checkStatus"))) || !"1".equals(checkStatus)) {
                    invoiceData.put("checkStatus", (Object)"1");
                }
                ConvertFieldUtil.getStandardInvoice(invoiceData);
                result.put("data", (Object)invoiceData);
                InvoiceSaveService invoiceSaveService = InvoiceSaveService.newInstance(invoiceData.getString("invoiceType"));
                if (invoiceSaveService != null) {
                    String verifySaveFlag;
                    if (null != businessParam) {
                        invoiceData.putAll((Map)businessParam);
                        if (kd.bos.util.StringUtils.isNotEmpty((String)businessParam.getString("isSetUser"))) {
                            InvoiceSaveService.notSetUserRelationIfExist(invoiceData);
                        }
                    }
                    if ("0".equals(verifySaveFlag = RimConfigUtils.getConfig("verify_save"))) {
                        invoiceData.put("delete", (Object)"2");
                    }
                    boolean repeatFlag = invoiceSaveService.checkInvoiceExists(invoiceData);
                    result.put("repeat", (Object)repeatFlag);
                    InvoiceSaveResult saveResult = invoiceSaveService.save(invoiceData);
                    String isSaleListInvoice = invoiceData.getString("isSaleListInvoice");
                    if ("1".equals(isSaleListInvoice)) {
                        RecognitionCheckHelper recognitionCheckHelper = new RecognitionCheckHelper();
                        recognitionCheckHelper.dealInvoiceAttachRelation(invoiceData);
                    }
                    result.put("serialNo", (Object)saveResult.getSerialNo());
                    result.put("mainId", saveResult.getMainId());
                    result.put("invoiceId", saveResult.getInvoiceId());
                    invoiceData.put("serialNo", (Object)saveResult.getSerialNo());
                    invoiceData.put("invoice_info", (Object)saveResult.getInvoiceInfo());
                    this.deleteUncheckInvoice(invoiceCode, invoiceNo);
                }
            }
        }
        catch (MsgException e) {
            result.put("errcode", (Object)e.getErrorCode());
            result.put("description", (Object)e.getMessage());
        }
        return result;
    }

    private JSONObject putDbTrainEleInfo(Long checkInvoiceType, JSONObject invoiceData) {
        QFilter invoiceNoFilter = new QFilter("invoice_no", "=", (Object)invoiceData.getString("invoiceNo"));
        DynamicObject mainObject = QueryServiceHelper.queryOne((String)"rim_invoice", (String)MetadataUtil.getFields("rim_invoice"), (QFilter[])new QFilter[]{invoiceNoFilter});
        if (mainObject != null) {
            InvoiceSaveService saveService = InvoiceSaveService.newInstance(checkInvoiceType + "");
            InvoiceConvertService convertService = InvoiceConvertService.newInstance(checkInvoiceType);
            if (saveService != null) {
                DynamicObject invoiceDynamicObject = saveService.getInvoiceDynamicObject(invoiceData);
                JSONObject convert = convertService.convert(mainObject, invoiceDynamicObject, null);
                convert.putAll((Map)invoiceData);
                convert.put("totalTaxAmount", convert.get((Object)"taxAmount"));
                invoiceData = convert;
            }
        }
        return invoiceData;
    }

    private JSONObject putDbAirEleInfo(Long checkInvoiceType, JSONObject invoiceData) {
        JSONArray items;
        try {
            BigDecimal totalAmount = BigDecimalUtil.transDecimal(invoiceData.get((Object)"totalAmount"));
            BigDecimal taxAmount = CommonUtils.getJsonValue((Map<String, Object>)invoiceData, BigDecimal.class, "taxAmount", "totalTaxAmount");
            BigDecimal invoiceAmount = totalAmount.subtract(taxAmount);
            invoiceData.put("invoiceAmount", (Object)invoiceAmount);
        }
        catch (Exception e) {
            logger.error("\u6570\u7535\u98de\u673a\u7968\uff0c\u8bbe\u7f6e\u4e0d\u542b\u7a0e\u91d1\u989d\u62a5\u9519, \u53d1\u7968\u53f7\u7801\uff1a" + invoiceData.getString("invoiceNo"), (Throwable)e);
        }
        QFilter invoiceNoFilter = new QFilter("invoice_no", "=", (Object)invoiceData.getString("invoiceNo"));
        DynamicObject mainObject = QueryServiceHelper.queryOne((String)"rim_invoice", (String)MetadataUtil.getFields("rim_invoice"), (QFilter[])new QFilter[]{invoiceNoFilter});
        if (mainObject != null) {
            InvoiceSaveService saveService = InvoiceSaveService.newInstance(checkInvoiceType + "");
            InvoiceConvertService convertService = InvoiceConvertService.newInstance(checkInvoiceType);
            if (saveService != null) {
                DynamicObject invoiceDynamicObject = saveService.getInvoiceDynamicObject(invoiceData);
                JSONObject convert = convertService.convert(mainObject, invoiceDynamicObject, null);
                convert.putAll((Map)invoiceData);
                convert.put("totalTaxAmount", convert.get((Object)"taxAmount"));
                invoiceData = convert;
            }
        }
        if ((items = invoiceData.getJSONArray("items")).size() > 0) {
            RecognitionCheckHelper.setFirstItemValue(items.getJSONObject(0), invoiceData);
        }
        return invoiceData;
    }

    public JSONObject checkInvoiceOfWx(String invoiceCode, String invoiceNo, Long invoiceType, String date, BigDecimal invoiceAmount, String checkCode, JSONObject checkInfo, JSONObject businessParam) {
        JSONObject result = new JSONObject();
        CheckParam checkParam = new CheckParam(invoiceCode, invoiceNo, invoiceType, date, invoiceAmount, checkCode, null);
        HashMap extMap = Maps.newHashMap();
        extMap.put("orgId", RequestContext.get().getOrgId());
        String taxNo = TenantUtils.getTaxNoByOrgId(RequestContext.get().getOrgId());
        extMap.put("taxNo", taxNo);
        extMap.put("eid", RequestContext.get().getUserId());
        checkParam.setExtMap(extMap);
        CheckResult checkResult = SimplyCheckService.checkInvoice(checkParam, RequestContext.get().getOrgId(), taxNo);
        result.put("errcode", (Object)checkResult.getErrcode());
        result.put("description", (Object)checkResult.getDescription());
        try {
            if ("0000".equals(checkResult.getErrcode())) {
                Object invoiceEntity = checkResult.getData();
                String invoiceCheckStr = JSONObject.toJSONString((Object)invoiceEntity);
                JSONObject invoiceData = JSON.parseObject((String)invoiceCheckStr);
                String checkStatus = invoiceData.getString("checkStatus");
                if (StringUtils.isEmpty((CharSequence)checkStatus)) {
                    invoiceData.put("checkStatus", (Object)"1");
                }
                ConvertFieldUtil.getStandardInvoice(invoiceData);
                result.put("data", (Object)invoiceData);
                InvoiceSaveService invoiceSaveService = InvoiceSaveService.newInstance(invoiceData.getString("invoiceType"));
                if (invoiceSaveService != null) {
                    if (null != businessParam) {
                        invoiceData.putAll((Map)businessParam);
                    }
                    boolean repeatFlag = invoiceSaveService.checkInvoiceExists(invoiceData);
                    invoiceData.put("pdfUrl", (Object)checkInfo.getString("pdfUrl"));
                    invoiceData.put("imageUrl", (Object)checkInfo.getString("imageUrl"));
                    invoiceData.put("snapshotUrl", (Object)checkInfo.getString("snapshotUrl"));
                    result.put("repeat", (Object)repeatFlag);
                    String verifySaveFlag = RimConfigUtils.getConfig("verify_save");
                    if ("0".equals(verifySaveFlag)) {
                        invoiceData.put("delete", (Object)"2");
                    }
                    InvoiceSaveResult saveResult = invoiceSaveService.save(invoiceData);
                    String isSaleListInvoice = invoiceData.getString("isSaleListInvoice");
                    if ("1".equals(isSaleListInvoice)) {
                        RecognitionCheckHelper recognitionCheckHelper = new RecognitionCheckHelper();
                        recognitionCheckHelper.dealInvoiceAttachRelation(invoiceData);
                    }
                    result.put("serialNo", (Object)saveResult.getSerialNo());
                    result.put("mainId", saveResult.getMainId());
                    result.put("invoiceId", saveResult.getInvoiceId());
                    invoiceData.put("serialNo", (Object)saveResult.getSerialNo());
                    invoiceData.put("invoice_info", (Object)saveResult.getInvoiceInfo());
                    this.deleteUncheckInvoice(invoiceCode, invoiceNo);
                }
            }
        }
        catch (MsgException e) {
            result.put("errcode", (Object)e.getErrorCode());
            result.put("description", (Object)e.getErrorMsg());
        }
        return result;
    }

    public Pair<Boolean, List<String>> signInvoiceSuccessResult(List<String> serialNosList, String status) {
        boolean signFlag = false;
        ArrayList successList = Lists.newArrayList();
        try (TXHandle h = TX.required();){
            try {
                ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(serialNosList.size());
                String tenantNo = TenantUtils.getTenantNo();
                QFilter tenantFilter = new QFilter("tenant_no", "=", (Object)tenantNo);
                QFilter serialNosFilter = new QFilter("serial_no", "in", serialNosList);
                List idList = QueryServiceHelper.queryPrimaryKeys((String)"rim_invoice", (QFilter[])new QFilter[]{tenantFilter, serialNosFilter}, null, (int)serialNosList.size());
                RequestContext request = RequestContext.get();
                Long receiver = Long.parseLong(request.getUserId());
                if (!CollectionUtils.isEmpty((Collection)idList)) {
                    HashMap<String, ArrayList<String>> typeMap = new HashMap<String, ArrayList<String>>(8);
                    DynamicObject[] invoiceArray = BusinessDataServiceHelper.load((Object[])idList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"rim_invoice"));
                    for (DynamicObject invoice : invoiceArray) {
                        invoice.set("original_state", (Object)status);
                        if ("1".equals(status)) {
                            invoice.set("original_time", (Object)new Date());
                            invoice.set("delete", (Object)"1");
                            invoice.set("receiver", (Object)receiver);
                        } else {
                            invoice.set("original_time", null);
                            invoice.set("receiver", null);
                        }
                        InvoiceSaveService invoiceSaveService = new InvoiceSaveService();
                        invoiceSaveService.setMainInvoiceInfo(invoice);
                        saveList.add(invoice);
                        String entity = InputInvoiceTypeEnum.getEntity(invoice.getLong("invoice_type.id"));
                        ArrayList<String> invoiceList = (ArrayList<String>)typeMap.get(entity);
                        if (invoiceList == null) {
                            invoiceList = new ArrayList<String>(4);
                        }
                        invoiceList.add(invoice.getString("serial_no"));
                        typeMap.put(entity, invoiceList);
                        successList.add(invoice.getString("serial_no"));
                    }
                    for (Map.Entry entry : typeMap.entrySet()) {
                        DynamicObject[] invoiceBodys = InvoiceQueryService.loadBySerialNo((String)entry.getKey(), " ", (List)entry.getValue());
                        if (invoiceBodys == null) continue;
                        for (DynamicObject body : invoiceBodys) {
                            body.set("original_state", (Object)status);
                        }
                        ImcSaveServiceHelper.save((DynamicObject[])invoiceBodys);
                    }
                    if ("1".equals(status)) {
                        InvoiceLog.insert("sign", serialNosList, "");
                    } else {
                        InvoiceLog.insert("unsign", serialNosList, "");
                    }
                    this.setUserAndOrg(saveList);
                    ImcSaveServiceHelper.save(saveList);
                    signFlag = true;
                }
            }
            catch (Throwable e) {
                logger.error("\u53d1\u7968\u7b7e\u6536\u5931\u8d25", e);
                h.markRollback();
                throw e;
            }
        }
        return Pair.of((Object)signFlag, (Object)successList);
    }

    public boolean signInvoice(List<String> serialNosList, String status) {
        boolean signFlag = false;
        try (TXHandle h = TX.required();){
            try {
                ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(serialNosList.size());
                String tenantNo = TenantUtils.getTenantNo();
                QFilter tenantFilter = new QFilter("tenant_no", "=", (Object)tenantNo);
                QFilter serialNosFilter = new QFilter("serial_no", "in", serialNosList);
                List idList = QueryServiceHelper.queryPrimaryKeys((String)"rim_invoice", (QFilter[])new QFilter[]{tenantFilter, serialNosFilter}, null, (int)serialNosList.size());
                RequestContext request = RequestContext.get();
                Long receiver = Long.parseLong(request.getUserId());
                if (!CollectionUtils.isEmpty((Collection)idList)) {
                    boolean bl;
                    HashMap<String, ArrayList<String>> typeMap = new HashMap<String, ArrayList<String>>(8);
                    DynamicObject[] invoiceArray = BusinessDataServiceHelper.load((Object[])idList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"rim_invoice"));
                    for (DynamicObject invoice : invoiceArray) {
                        invoice.set("original_state", (Object)status);
                        if ("1".equals(status)) {
                            invoice.set("original_time", (Object)new Date());
                            invoice.set("delete", (Object)"1");
                            invoice.set("receiver", (Object)receiver);
                        } else {
                            invoice.set("original_time", null);
                            invoice.set("receiver", null);
                        }
                        InvoiceSaveService invoiceSaveService = new InvoiceSaveService();
                        invoiceSaveService.setMainInvoiceInfo(invoice);
                        saveList.add(invoice);
                        String entity = InputInvoiceTypeEnum.getEntity(invoice.getLong("invoice_type.id"));
                        ArrayList<String> invoiceList = (ArrayList<String>)typeMap.get(entity);
                        if (invoiceList == null) {
                            invoiceList = new ArrayList<String>(4);
                        }
                        invoiceList.add(invoice.getString("serial_no"));
                        typeMap.put(entity, invoiceList);
                    }
                    for (Map.Entry entry : typeMap.entrySet()) {
                        DynamicObject[] invoiceBodys = InvoiceQueryService.loadBySerialNo((String)entry.getKey(), " ", (List)entry.getValue());
                        if (invoiceBodys == null) continue;
                        for (DynamicObject body : invoiceBodys) {
                            body.set("original_state", (Object)status);
                        }
                        ImcSaveServiceHelper.save((DynamicObject[])invoiceBodys);
                    }
                    if ("1".equals(status)) {
                        InvoiceLog.insert("sign", serialNosList, "trace:" + RequestContext.get().getTraceId());
                    } else {
                        InvoiceLog.insert("unsign", serialNosList, "trace:" + RequestContext.get().getTraceId());
                    }
                    boolean isCollectOwner = SysParamUtil.getSysParamByOrgId(RequestContext.get().getOrgId(), "is_collectowner");
                    if (isCollectOwner && (bl = SysParamUtil.isHitValue(RequestContext.get().getOrgId(), "collectowner_config", "1"))) {
                        this.setUserAndOrg(saveList);
                    }
                    ImcSaveServiceHelper.save(saveList);
                    signFlag = true;
                }
            }
            catch (Throwable e) {
                logger.error("\u53d1\u7968\u7b7e\u6536\u5931\u8d25", e);
                h.markRollback();
                throw e;
            }
        }
        return signFlag;
    }

    private void setUserAndOrg(List<DynamicObject> saveList) {
        if (saveList == null || saveList.size() == 0) {
            return;
        }
        for (DynamicObject mainObj : saveList) {
            DynamicObjectCollection userEntry = mainObj.getDynamicObjectCollection("collect_user_entry");
            boolean curUserFlag = Boolean.FALSE;
            String userId = RequestContext.get().getCurrUserId() + "";
            if (!CollectionUtils.isEmpty((Collection)userEntry)) {
                for (DynamicObject userObj : userEntry) {
                    String pk;
                    DynamicObject user = userObj.getDynamicObject("collect_user");
                    if (null == user || !(pk = user.getPkValue() + "").equals(userId)) continue;
                    userObj.set("collect_user_org", (Object)RequestContext.get().getOrgId());
                    curUserFlag = Boolean.TRUE;
                    break;
                }
            }
            if (curUserFlag) continue;
            DynamicObject item = userEntry.addNew();
            item.set("collect_user", (Object)userId);
            item.set("rim_user", (Object)0);
            item.set("collect_user_org", (Object)RequestContext.get().getOrgId());
            item.set("collect_user_time", (Object)new Date());
        }
    }

    public boolean delInvoice(String serialNo) {
        return this.delInvoice(serialNo, 0L, 0L);
    }

    /*
     * Unable to fully structure code
     */
    public boolean delInvoice(String serialNo, Long userId, Long rimUser) {
        signFlag = false;
        h = TX.required();
        var6_6 = null;
        try {
            if (!kd.bos.util.StringUtils.isNotEmpty((String)serialNo)) ** GOTO lbl15
            filter = new QFilter("serial_no", "=", (Object)serialNo);
            dynamicObject = QueryServiceHelper.queryOne((String)"rim_invoice", (String)"id", (QFilter[])filter.toArray());
            if (dynamicObject == null) {
                var9_12 = signFlag;
                return var9_12;
            }
            try {
                primaryKeyValue = dynamicObject.getLong("id");
                invoiceSaveService = new InvoiceSaveService();
                invoiceSaveService.deleteRelation(primaryKeyValue, userId, rimUser);
lbl15:
                // 2 sources

                signFlag = true;
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
        finally {
            if (h != null) {
                if (var6_6 != null) {
                    try {
                        h.close();
                    }
                    catch (Throwable var10_14) {
                        var6_6.addSuppressed(var10_14);
                    }
                } else {
                    h.close();
                }
            }
        }
        return signFlag;
    }

    public boolean delOldInvoice(String serialNo) {
        return this.delOldInvoice(serialNo, 0L, 0L, 0L);
    }

    public boolean delOldInvoice(String serialNo, Long orgid, Long userId, Long rimUser) {
        boolean signFlag = false;
        try (TXHandle h = TX.required();){
            try {
                if (kd.bos.util.StringUtils.isNotEmpty((String)serialNo)) {
                    String tenantNo = TenantUtils.getTenantNo();
                    if (userId == null || userId <= 0L) {
                        userId = Long.parseLong(RequestContext.get().getUserId());
                    }
                    if (orgid == null || orgid <= 0L) {
                        orgid = RequestContext.get().getOrgId();
                    }
                    String orgId = orgid + "";
                    QFilter tenantFilter = new QFilter("tenant_no", "=", (Object)tenantNo);
                    QFilter serialNoFilter = new QFilter("serial_no", "=", (Object)serialNo);
                    List idList = QueryServiceHelper.queryPrimaryKeys((String)"rim_invoice", (QFilter[])new QFilter[]{tenantFilter, serialNoFilter}, null, (int)100);
                    if (!CollectionUtils.isEmpty((Collection)idList)) {
                        DynamicObject[] mainDynamicObjects = BusinessDataServiceHelper.load((Object[])idList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"rim_invoice"));
                        DynamicObject mainDynamicObject = mainDynamicObjects[0];
                        DynamicObjectCollection userEntry = mainDynamicObject.getDynamicObjectCollection("collect_user_entry");
                        for (int userIndex = userEntry.size() - 1; userIndex >= 0; --userIndex) {
                            DynamicObject userDynamicObject = (DynamicObject)userEntry.get(userIndex);
                            DynamicObject user = userDynamicObject.getDynamicObject("collect_user");
                            Long rim_user = userDynamicObject.getLong("rim_user");
                            if (rimUser > 0L) {
                                if (!Objects.equals(rimUser, rim_user)) continue;
                                userEntry.remove(userIndex);
                                continue;
                            }
                            if (user == null || !Objects.equals(userId, user.getPkValue())) continue;
                            userEntry.remove(userIndex);
                        }
                        DynamicObjectCollection orgEntry = mainDynamicObject.getDynamicObjectCollection("collect_org_entry");
                        for (int orgIndex = orgEntry.size() - 1; orgIndex >= 0; --orgIndex) {
                            String pk;
                            DynamicObject orgDynamicObject = (DynamicObject)orgEntry.get(orgIndex);
                            DynamicObject org = orgDynamicObject.getDynamicObject("collect_org");
                            if (org == null || !(pk = org.getPkValue() + "").equals(orgId) || userEntry.size() != 0) continue;
                            orgEntry.remove(orgIndex);
                        }
                        boolean isDeleted = false;
                        if (userEntry.size() == 0 || orgEntry.size() == 0) {
                            mainDynamicObject.set("delete", (Object)"3");
                            mainDynamicObject.set("tax_org", (Object)0L);
                            mainDynamicObject.set("org_id", (Object)0L);
                            isDeleted = true;
                        }
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{mainDynamicObject});
                        DeleteServiceHelper.delete((String)"rim_invoice_uncheck", (QFilter[])new QFilter[]{tenantFilter, serialNoFilter});
                        if (isDeleted) {
                            Long invoiceType = DynamicObjectUtil.getDynamicObjectLongValue(mainDynamicObject.get("invoice_type"));
                            String entity = InputInvoiceTypeEnum.getEntity(invoiceType);
                            ArrayList<String> serialNos = new ArrayList<String>();
                            serialNos.add(serialNo);
                            DynamicObject[] objList = InvoiceQueryService.loadBySerialNo(entity, tenantNo, serialNos);
                            if (objList != null && objList.length > 0) {
                                for (DynamicObject obj : objList) {
                                    obj.set("delete", (Object)"3");
                                    obj.set("tax_org", (Object)0L);
                                    obj.set("org", (Object)0L);
                                    obj.set("modifytime", (Object)new Date());
                                    obj.set("modifier", (Object)userId);
                                }
                                SaveServiceHelper.save((DynamicObject[])objList);
                            }
                        }
                    }
                }
                signFlag = true;
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
        return signFlag;
    }

    public void convertUnVatInvoice(JSONObject invoiceData, boolean isNeedConvert) {
        Long invoiceType = invoiceData.getLong("invoiceType");
        if (invoiceType != null && invoiceType < 1000L) {
            invoiceType = InputInvoiceTypeEnum.getInvoiceTypeByAwsType(invoiceType.toString());
        }
        if (DeductionUtils.countDeductionType(invoiceType)) {
            Object date = invoiceData.get((Object)"invoiceDate");
            Date invoiceDate = date instanceof Long ? new Date((Long)date) : DateUtils.stringToDate(date.toString());
            BigDecimal taxRate = null;
            BigDecimal totalTaxAmount = null;
            if (InputInvoiceTypeEnum.TRAIN_INVOICE.getCode().equals(invoiceType)) {
                String customerIdentityNum = invoiceData.getString("customerIdentityNum");
                if (kd.bos.util.StringUtils.isEmpty((String)customerIdentityNum)) {
                    customerIdentityNum = invoiceData.getString("customerIdNo");
                }
                totalTaxAmount = DeductionUtils.trainTaxAmountByInvoiceDate(invoiceDate, invoiceData.getBigDecimal("totalAmount"), invoiceData.getString("passengerName"), customerIdentityNum, invoiceData.getString("stationGetOn"), invoiceData.getString("stationGetOff"), invoiceData.getString("businessType"));
                if (isNeedConvert) {
                    invoiceData.put("sequenceNo", (Object)invoiceData.getString("printingSequenceNo"));
                    invoiceData.put("seatGrade", (Object)invoiceData.getString("seat"));
                    invoiceData.put("customerIdNo", (Object)invoiceData.getString("customerIdentityNum"));
                }
            } else if (InputInvoiceTypeEnum.AIR_INVOICE.getCode().equals(invoiceType)) {
                this.setTicketChange(invoiceData);
                String ticketChanges = invoiceData.getString("ticketChanges");
                String endorsement = invoiceData.getString("endorsement");
                boolean isRebook = ("\u9000\u7968\u8d39".equals(endorsement) || "\u9000\u7968\u624b\u7eed\u8d39".equals(endorsement)) && "1".equals(ticketChanges);
                String internationalFlag = invoiceData.getString("internationalFlag");
                if ("2".equals(internationalFlag) || isRebook) {
                    totalTaxAmount = BigDecimal.ZERO;
                } else {
                    BigDecimal otherAmount = invoiceData.getBigDecimal("otherAmount");
                    if (otherAmount == null) {
                        otherAmount = invoiceData.getBigDecimal("otherTotalTaxAmount");
                    }
                    totalTaxAmount = DeductionUtils.airTaxAmountByInvoiceDate(invoiceDate, invoiceData.getBigDecimal("invoiceAmount"), invoiceData.getBigDecimal("fuelSurcharge"), invoiceData.getString("customerName"), otherAmount, invoiceData.getBigDecimal("totalAmount"), invoiceData.getBigDecimal("airportConstructionFee"), invoiceData.getString("placeOfDeparture"), invoiceData.getString("destination"));
                }
                if (isNeedConvert) {
                    invoiceData.put("eticketNo", (Object)invoiceData.getString("electronicTicketNum"));
                    invoiceData.put("customerIdNo", (Object)invoiceData.getString("customerIdentityNum"));
                }
            } else if (InputInvoiceTypeEnum.TRANSPORT_INVOICE.getCode().equals(invoiceType)) {
                if (isNeedConvert) {
                    invoiceData.put("customerIdNo", (Object)invoiceData.getString("customerIdentityNum"));
                }
                totalTaxAmount = DeductionUtils.passengerTransport16TaxAmountByInvoiceDate(invoiceDate, invoiceData.getBigDecimal("totalAmount"), invoiceData.getString("passengerName"), invoiceData.getString("customerIdNo"), invoiceData.getBigDecimal("insurancePremium"), invoiceData.getString("stationGetOn"), invoiceData.getString("stationGetOff"));
            } else if (InputInvoiceTypeEnum.BOAT_INVOICE.getCode().equals(invoiceType)) {
                totalTaxAmount = DeductionUtils.passengerTransport20TaxAmountByInvoiceDate(invoiceDate, invoiceData.getBigDecimal("totalAmount"), invoiceData.getString("passengerName"), invoiceData.getString("customerIdNo"), invoiceData.getString("stationGetOn"), invoiceData.getString("stationGetOff"));
            }
            if (null != totalTaxAmount) {
                taxRate = DeductionUtils.taxRateByInvoiceDateAndInvoiceType(invoiceDate, invoiceType, new Object[0]);
            }
            invoiceData.put("taxRate", taxRate);
            invoiceData.put("totalTaxAmount", (Object)totalTaxAmount);
            invoiceData.put("taxAmount", (Object)totalTaxAmount);
        }
        invoiceData.put("checkStatus", (Object)"1");
        String recognitionImplStr = RimConfigUtils.getConfig("rim_recog_check", "rimpl");
        boolean isAwsRecognition = kd.bos.util.StringUtils.isEmpty((String)recognitionImplStr) || "kd.imc.rim.common.invoice.recognitionnew.impl.AwsRecognitionService".equals(recognitionImplStr);
        boolean isConvertPlace = "1".equals(RimConfigUtils.getConfig("rim_recog_check", "convertplace"));
        if (isAwsRecognition && isConvertPlace) {
            this.convertPlace(invoiceData);
        }
    }

    public void setTicketChange(JSONObject invoiceJson) {
        String invoiceAmountStr;
        String otherAmount;
        String fuelSurchargeStr;
        invoiceJson.put("ticketChanges", (Object)1);
        invoiceJson.put("ticket_changes", (Object)1);
        BigDecimal totalAmountTemp = new BigDecimal("0");
        String airportConstructionFeeStr = CommonUtils.getJsonValue((Map<String, Object>)invoiceJson, String.class, "airportConstructionFee", "airport_construction_fee");
        if (kd.bos.util.StringUtils.isNotEmpty((String)airportConstructionFeeStr)) {
            try {
                BigDecimal airportConstructionFee = new BigDecimal(airportConstructionFeeStr);
                if (airportConstructionFee.compareTo(FpzsConstant.sysMaxAmount) <= 0) {
                    totalAmountTemp = totalAmountTemp.add(airportConstructionFee);
                }
            }
            catch (Exception airportConstructionFee) {
                // empty catch block
            }
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)(fuelSurchargeStr = CommonUtils.getJsonValue((Map<String, Object>)invoiceJson, String.class, "fuelSurcharge", "fuel_surcharge")))) {
            try {
                BigDecimal fuelSurcharge = new BigDecimal(fuelSurchargeStr);
                if (fuelSurcharge.compareTo(FpzsConstant.sysMaxAmount) <= 0) {
                    totalAmountTemp = totalAmountTemp.add(fuelSurcharge);
                }
            }
            catch (Exception fuelSurcharge) {
                // empty catch block
            }
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)(otherAmount = CommonUtils.getJsonValue((Map<String, Object>)invoiceJson, String.class, "otherAmount", "other_amount")))) {
            try {
                BigDecimal otherTotalTaxAmount = BigDecimalUtil.transDecimal(otherAmount);
                if (otherTotalTaxAmount.compareTo(FpzsConstant.sysMaxAmount) <= 0) {
                    totalAmountTemp = totalAmountTemp.add(otherTotalTaxAmount);
                }
            }
            catch (Exception otherTotalTaxAmount) {
                // empty catch block
            }
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)(invoiceAmountStr = CommonUtils.getJsonValue((Map<String, Object>)invoiceJson, String.class, "invoiceAmount", "invoice_amount")))) {
            try {
                BigDecimal invoiceAmount = BigDecimalUtil.transDecimal(invoiceAmountStr);
                if (invoiceAmount.compareTo(FpzsConstant.sysMaxAmount) <= 0) {
                    totalAmountTemp = totalAmountTemp.add(invoiceAmount);
                }
            }
            catch (Exception invoiceAmount) {
                // empty catch block
            }
        }
        BigDecimal totalAmount = null;
        String totalAmountStr = CommonUtils.getJsonValue((Map<String, Object>)invoiceJson, String.class, "totalAmount", "total_amount");
        if (kd.bos.util.StringUtils.isNotEmpty((String)totalAmountStr)) {
            totalAmount = new BigDecimal(totalAmountStr);
        }
        if (null != totalAmount && null != totalAmountTemp && totalAmountTemp.compareTo(totalAmount) > 0) {
            invoiceJson.put("ticketChanges", (Object)2);
            invoiceJson.put("ticket_changes", (Object)2);
        }
    }

    public void convertPlace(JSONObject invoiceJson) {
        JSONArray cityArrayParam = new JSONArray();
        if (kd.bos.util.StringUtils.isNotEmpty((String)invoiceJson.getString("invoiceType"))) {
            JSONObject cityParam;
            Long invoiceType = InputInvoiceTypeEnum.getInvoiceTypeByAwsType(invoiceJson.getString("invoiceType"));
            if (InvoiceConvertUtils.isVatInvoiceType(invoiceType) && !InputInvoiceTypeEnum.AIR_ELE_INVOICE.getCode().equals(invoiceType) && !InputInvoiceTypeEnum.TRAIN_ELE_INVOICE.getCode().equals(invoiceType)) {
                if (kd.bos.util.StringUtils.isNotEmpty((String)invoiceJson.getString("invoiceCode"))) {
                    cityParam = new JSONObject();
                    cityParam.put("invoiceCode", (Object)invoiceJson.getString("invoiceCode"));
                    String salerAddressPhone = this.nullToK(invoiceJson.getString("salerName")) + this.nullToK(invoiceJson.getString("salerAddressPhone"));
                    cityParam.put("salerAddressPhone", (Object)salerAddressPhone);
                    cityParam.put("placeType", (Object)61);
                    cityArrayParam.add((Object)cityParam);
                }
            } else if (InputInvoiceTypeEnum.AIR_INVOICE.getCode().equals(invoiceType) || InputInvoiceTypeEnum.AIR_ELE_INVOICE.getCode().equals(invoiceType)) {
                if (kd.bos.util.StringUtils.isNotEmpty((String)invoiceJson.getString("placeOfDeparture"))) {
                    cityParam = new JSONObject();
                    cityParam.put("place", (Object)invoiceJson.getString("placeOfDeparture"));
                    cityParam.put("key", (Object)"\u673a\u573a");
                    cityParam.put("placeType", (Object)3);
                    cityArrayParam.add((Object)cityParam);
                }
                if (kd.bos.util.StringUtils.isNotEmpty((String)invoiceJson.getString("destination"))) {
                    cityParam = new JSONObject();
                    cityParam.put("place", (Object)invoiceJson.getString("destination"));
                    cityParam.put("key", (Object)"\u673a\u573a");
                    cityParam.put("placeType", (Object)3);
                    cityArrayParam.add((Object)cityParam);
                }
            } else if (InputInvoiceTypeEnum.TRAIN_INVOICE.getCode().equals(invoiceType)) {
                if (kd.bos.util.StringUtils.isNotEmpty((String)invoiceJson.getString("stationGetOn"))) {
                    cityParam = new JSONObject();
                    cityParam.put("place", (Object)(invoiceJson.getString("stationGetOn").contains("\u7ad9") ? invoiceJson.getString("stationGetOn") : invoiceJson.getString("stationGetOn") + "\u7ad9"));
                    cityParam.put("key", (Object)"\u706b\u8f66\u7ad9");
                    cityParam.put("placeType", (Object)1);
                    cityArrayParam.add((Object)cityParam);
                }
                if (kd.bos.util.StringUtils.isNotEmpty((String)invoiceJson.getString("stationGetOff"))) {
                    cityParam = new JSONObject();
                    cityParam.put("place", (Object)(invoiceJson.getString("stationGetOff").contains("\u7ad9") ? invoiceJson.getString("stationGetOff") : invoiceJson.getString("stationGetOff") + "\u7ad9"));
                    cityParam.put("key", (Object)"\u706b\u8f66\u7ad9");
                    cityParam.put("placeType", (Object)1);
                    cityArrayParam.add((Object)cityParam);
                }
            } else if (InputInvoiceTypeEnum.TRAIN_ELE_INVOICE.getCode().equals(invoiceType)) {
                if (kd.bos.util.StringUtils.isNotEmpty((String)invoiceJson.getString("departureStation"))) {
                    cityParam = new JSONObject();
                    cityParam.put("place", (Object)(invoiceJson.getString("departureStation").contains("\u7ad9") ? invoiceJson.getString("departureStation") : invoiceJson.getString("departureStation") + "\u7ad9"));
                    cityParam.put("key", (Object)"\u706b\u8f66\u7ad9");
                    cityParam.put("placeType", (Object)1);
                    cityArrayParam.add((Object)cityParam);
                }
                if (kd.bos.util.StringUtils.isNotEmpty((String)invoiceJson.getString("destinationStation"))) {
                    cityParam = new JSONObject();
                    cityParam.put("place", (Object)(invoiceJson.getString("destinationStation").contains("\u7ad9") ? invoiceJson.getString("destinationStation") : invoiceJson.getString("destinationStation") + "\u7ad9"));
                    cityParam.put("key", (Object)"\u706b\u8f66\u7ad9");
                    cityParam.put("placeType", (Object)1);
                    cityArrayParam.add((Object)cityParam);
                }
            } else if (InputInvoiceTypeEnum.TRANSPORT_INVOICE.getCode().equals(invoiceType) || InputInvoiceTypeEnum.BOAT_INVOICE.getCode().equals(invoiceType)) {
                if (kd.bos.util.StringUtils.isNotEmpty((String)invoiceJson.getString("stationGetOn"))) {
                    cityParam = new JSONObject();
                    cityParam.put("place", (Object)invoiceJson.getString("stationGetOn"));
                    cityParam.put("key", (Object)"\u4ea4\u901a");
                    cityParam.put("placeType", (Object)2);
                    cityArrayParam.add((Object)cityParam);
                }
                if (kd.bos.util.StringUtils.isNotEmpty((String)invoiceJson.getString("stationGetOff"))) {
                    cityParam = new JSONObject();
                    cityParam.put("place", (Object)invoiceJson.getString("stationGetOff"));
                    cityParam.put("key", (Object)"\u4ea4\u901a");
                    cityParam.put("placeType", (Object)2);
                    cityArrayParam.add((Object)cityParam);
                }
            }
        }
        if (cityArrayParam.size() > 0) {
            Long invoiceType;
            HashMap<String, Object> placeParam = new HashMap<String, Object>();
            placeParam.put("data", cityArrayParam);
            JSONObject placeMapResult = ResultContant.createSuccessJSONObject();
            try {
                placeMapResult = AwsFpyService.newInstance().postAppJson("msg_placemap", RequestContext.get().getOrgId(), placeParam);
                logger.info("aws\u7701\u5e02\u533a\u63a5\u53e3\u8fd4\u56de\uff1a" + placeMapResult);
            }
            catch (Exception e) {
                logger.info("\u8c03\u7528aws\u7701\u5e02\u533a\u63a5\u53e3\u5f02\u5e38\uff1a{}", (Object)e);
            }
            JSONObject placeMap = new JSONObject();
            if (placeMapResult != null && kd.bos.util.StringUtils.isNotEmpty((String)placeMapResult.getString("errcode")) && "0000".equals(placeMapResult.getString("errcode")) && null != placeMapResult.get((Object)"data")) {
                placeMap = placeMapResult.getJSONObject("data");
            }
            if (InvoiceConvertUtils.isVatInvoiceType(invoiceType = InputInvoiceTypeEnum.getInvoiceTypeByAwsType(invoiceJson.getString("invoiceType"))) && !InputInvoiceTypeEnum.AIR_ELE_INVOICE.getCode().equals(invoiceType) && !InputInvoiceTypeEnum.TRAIN_ELE_INVOICE.getCode().equals(invoiceType)) {
                JSONObject place;
                String cityName = "";
                String areaName = "";
                String provinceName = "";
                String salerAddressPhone = this.nullToK(invoiceJson.getString("salerName")) + this.nullToK(invoiceJson.getString("salerAddressPhone"));
                if (kd.bos.util.StringUtils.isNotEmpty((String)salerAddressPhone)) {
                    JSONObject place2 = placeMap.getJSONObject(salerAddressPhone);
                    if (null != place2) {
                        if (kd.bos.util.StringUtils.isNotEmpty((String)place2.getString("cityName"))) {
                            cityName = place2.getString("cityName");
                        }
                        if (kd.bos.util.StringUtils.isNotEmpty((String)place2.getString("areaName"))) {
                            areaName = place2.getString("areaName");
                        }
                        if (kd.bos.util.StringUtils.isNotEmpty((String)place2.getString("provinceName"))) {
                            provinceName = place2.getString("provinceName");
                        }
                    }
                } else if (kd.bos.util.StringUtils.isNotEmpty((String)invoiceJson.getString("invoiceCode")) && null != (place = placeMap.getJSONObject(invoiceJson.getString("invoiceCode"))) && kd.bos.util.StringUtils.isNotEmpty((String)place.getString("cityName"))) {
                    cityName = place.getString("cityName");
                }
                invoiceJson.put("sourceArea", (Object)(provinceName + "_" + cityName + "_" + areaName));
                invoiceJson.put("destArea", (Object)"");
            } else if (InputInvoiceTypeEnum.AIR_INVOICE.getCode().equals(invoiceType) || InputInvoiceTypeEnum.AIR_ELE_INVOICE.getCode().equals(invoiceType)) {
                JSONObject place;
                String placeOfDepartureCityName = "";
                String placeOfDepartureAreaName = "";
                String placeOfDepartureProvinceName = "";
                String destinationCityName = "";
                String destinationAreaName = "";
                String destinationProvinceName = "";
                if (kd.bos.util.StringUtils.isNotEmpty((String)invoiceJson.getString("placeOfDeparture")) && null != (place = placeMap.getJSONObject(invoiceJson.getString("placeOfDeparture")))) {
                    if (kd.bos.util.StringUtils.isNotEmpty((String)place.getString("cityName"))) {
                        placeOfDepartureCityName = place.getString("cityName");
                    }
                    if (kd.bos.util.StringUtils.isNotEmpty((String)place.getString("areaName"))) {
                        placeOfDepartureAreaName = place.getString("areaName");
                    }
                    if (kd.bos.util.StringUtils.isNotEmpty((String)place.getString("provinceName"))) {
                        placeOfDepartureProvinceName = place.getString("provinceName");
                    }
                }
                if (kd.bos.util.StringUtils.isNotEmpty((String)invoiceJson.getString("destination")) && null != (place = placeMap.getJSONObject(invoiceJson.getString("destination")))) {
                    if (kd.bos.util.StringUtils.isNotEmpty((String)place.getString("cityName"))) {
                        destinationCityName = place.getString("cityName");
                    }
                    if (kd.bos.util.StringUtils.isNotEmpty((String)place.getString("areaName"))) {
                        destinationAreaName = place.getString("areaName");
                    }
                    if (kd.bos.util.StringUtils.isNotEmpty((String)place.getString("provinceName"))) {
                        destinationProvinceName = place.getString("provinceName");
                    }
                }
                invoiceJson.put("sourceArea", (Object)(placeOfDepartureProvinceName + "_" + placeOfDepartureCityName + "_" + placeOfDepartureAreaName));
                invoiceJson.put("destArea", (Object)(destinationProvinceName + "_" + destinationCityName + "_" + destinationAreaName));
            } else if (InputInvoiceTypeEnum.TRAIN_INVOICE.getCode().equals(invoiceType) || InputInvoiceTypeEnum.TRAIN_ELE_INVOICE.getCode().equals(invoiceType) || InputInvoiceTypeEnum.TRANSPORT_INVOICE.getCode().equals(invoiceType) || InputInvoiceTypeEnum.BOAT_INVOICE.getCode().equals(invoiceType)) {
                JSONObject place;
                String stationGetOnCityName = "";
                String stationGetOnAreaName = "";
                String stationGetOnProvinceName = "";
                String stationGetOffCityName = "";
                String stationGetOffAreaName = "";
                String stationGetOffProvinceName = "";
                if (kd.bos.util.StringUtils.isNotEmpty((String)invoiceJson.getString("stationGetOn")) || kd.bos.util.StringUtils.isNotEmpty((String)invoiceJson.getString("departureStation"))) {
                    String stationGetOn;
                    String string = stationGetOn = kd.bos.util.StringUtils.isNotEmpty((String)invoiceJson.getString("stationGetOn")) ? invoiceJson.getString("stationGetOn") : invoiceJson.getString("departureStation");
                    if ((InputInvoiceTypeEnum.TRAIN_INVOICE.getCode().equals(invoiceType) || InputInvoiceTypeEnum.TRAIN_ELE_INVOICE.getCode().equals(invoiceType)) && !stationGetOn.contains(ResManager.loadKDString((String)"\u7ad9", (String)"InvoiceCollectService_0", (String)"imc-rim-common", (Object[])new Object[0]))) {
                        stationGetOn = stationGetOn + "\u7ad9";
                    }
                    if (null != (place = placeMap.getJSONObject(stationGetOn))) {
                        if (kd.bos.util.StringUtils.isNotEmpty((String)place.getString("cityName"))) {
                            stationGetOnCityName = place.getString("cityName");
                        }
                        if (kd.bos.util.StringUtils.isNotEmpty((String)place.getString("areaName"))) {
                            stationGetOnAreaName = place.getString("areaName");
                        }
                        if (kd.bos.util.StringUtils.isNotEmpty((String)place.getString("provinceName"))) {
                            stationGetOnProvinceName = place.getString("provinceName");
                        }
                    }
                }
                if (kd.bos.util.StringUtils.isNotEmpty((String)invoiceJson.getString("stationGetOff")) || kd.bos.util.StringUtils.isNotEmpty((String)invoiceJson.getString("destinationStation"))) {
                    String stationGetOff;
                    String string = stationGetOff = kd.bos.util.StringUtils.isNotEmpty((String)invoiceJson.getString("stationGetOff")) ? invoiceJson.getString("stationGetOff") : invoiceJson.getString("destinationStation");
                    if ((InputInvoiceTypeEnum.TRAIN_INVOICE.getCode().equals(invoiceType) || InputInvoiceTypeEnum.TRAIN_ELE_INVOICE.getCode().equals(invoiceType)) && !stationGetOff.contains(ResManager.loadKDString((String)"\u7ad9", (String)"InvoiceCollectService_0", (String)"imc-rim-common", (Object[])new Object[0]))) {
                        stationGetOff = stationGetOff + "\u7ad9";
                    }
                    if (null != (place = placeMap.getJSONObject(stationGetOff))) {
                        if (kd.bos.util.StringUtils.isNotEmpty((String)place.getString("cityName"))) {
                            stationGetOffCityName = place.getString("cityName");
                        }
                        if (kd.bos.util.StringUtils.isNotEmpty((String)place.getString("areaName"))) {
                            stationGetOffAreaName = place.getString("areaName");
                        }
                        if (kd.bos.util.StringUtils.isNotEmpty((String)place.getString("provinceName"))) {
                            stationGetOffProvinceName = place.getString("provinceName");
                        }
                    }
                }
                invoiceJson.put("sourceArea", (Object)(stationGetOnProvinceName + "_" + stationGetOnCityName + "_" + stationGetOnAreaName));
                invoiceJson.put("destArea", (Object)(stationGetOffProvinceName + "_" + stationGetOffCityName + "_" + stationGetOffAreaName));
            }
        }
    }

    public DynamicObject getFileBySerial(String serialNo) {
        DynamicObject mainDynamicObject = null;
        if (kd.bos.util.StringUtils.isNotEmpty((String)serialNo)) {
            String tenantNo = TenantUtils.getTenantNo();
            QFilter serialNoFilter = new QFilter("serial_no", "=", (Object)serialNo);
            QFilter tenantFilter = new QFilter("tenant_no", "=", (Object)tenantNo);
            List idList = QueryServiceHelper.queryPrimaryKeys((String)"rim_invoice_file", (QFilter[])new QFilter[]{tenantFilter, serialNoFilter}, null, (int)1);
            if (!CollectionUtils.isEmpty((Collection)idList)) {
                mainDynamicObject = BusinessDataServiceHelper.loadSingle(idList.get(0), (String)"rim_invoice_file");
            }
        }
        return mainDynamicObject;
    }

    public void deleteUncheckInvoice(String invoiceCode, String invoiceNo) {
        String tenantNo = TenantUtils.getTenantNo();
        QFilter tenantFilter = new QFilter("tenant_no", "=", (Object)tenantNo);
        QFilter invoiceCodeFilter = new QFilter("invoice_code", "=", (Object)invoiceCode);
        QFilter invoiceNoFilter = new QFilter("invoice_no", "=", (Object)invoiceNo);
        QFilter deleteFilter = new QFilter("delete", "!=", (Object)"3");
        List idList = QueryServiceHelper.queryPrimaryKeys((String)"rim_invoice_uncheck", (QFilter[])new QFilter[]{tenantFilter, invoiceCodeFilter, invoiceNoFilter, deleteFilter}, null, (int)100);
        if (!CollectionUtils.isEmpty((Collection)idList)) {
            DynamicObject[] uncheckDynamicObjectsTemp = BusinessDataServiceHelper.load((Object[])idList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"rim_invoice_uncheck"));
            DynamicObject uncheckInvoice = uncheckDynamicObjectsTemp[0];
            QFilter serialFilte = new QFilter("serial_no", "=", (Object)uncheckInvoice.getString("serial_no"));
            QFilter statusFilte = new QFilter("status", "in", (Object)ExpenseConstant.getUsedStatus());
            QFilter checkStatusFilte = new QFilter("check_status", "in", (Object)CheckContant.getFailStatus());
            DynamicObjectCollection collect = QueryServiceHelper.query((String)"rim_expense_relation", (String)"expense_id,expense_num", (QFilter[])new QFilter[]{serialFilte, statusFilte, checkStatusFilte});
            if (CollectionUtils.isEmpty((Collection)collect)) {
                uncheckInvoice.set("delete", (Object)"3");
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{uncheckInvoice});
            }
        }
    }

    private void deleteUncheckInvoiceBySerialNo(String serialNo, String checkStatus) {
        MainEntityType entityType;
        QFilter serialNoFilter;
        if (kd.bos.util.StringUtils.isEmpty((String)serialNo)) {
            return;
        }
        QFilter tenantFilter = new QFilter("tenant_no", "=", (Object)TenantUtils.getTenantNo());
        DynamicObject unCheckObject = QueryServiceHelper.queryOne((String)"rim_invoice_uncheck", (String)"id", (QFilter[])new QFilter[]{tenantFilter, serialNoFilter = new QFilter("serial_no", "=", (Object)serialNo)});
        if (unCheckObject == null) {
            return;
        }
        Long unCheckId = unCheckObject.getLong("id");
        String expense_status = (unCheckObject = BusinessDataServiceHelper.loadSingle((Object)unCheckId, (DynamicObjectType)(entityType = EntityMetadataCache.getDataEntityType((String)"rim_invoice_uncheck")))).getString("expense_status");
        if (kd.bos.util.StringUtils.isEmpty((String)expense_status) || "1".equals(expense_status)) {
            DeleteServiceHelper.delete((IDataEntityType)entityType, (Object[])new Object[]{unCheckId});
        } else {
            if ("1".equals(checkStatus)) {
                unCheckObject.set("check_status", (Object)"1");
                unCheckObject.set("check_time", (Object)new Date());
                unCheckObject.set("check_result", (Object)"0000");
            }
            unCheckObject.set("update_time", (Object)new Date());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{unCheckObject});
        }
    }

    public String nullToK(Object input) {
        if (input != null && !input.equals("null")) {
            return input.toString();
        }
        return "";
    }

    public Map<String, Object> addCustomField(AbstractFormPlugin plugin) {
        String entityId = plugin.getView().getEntityId();
        String fieldStr = RimConfigUtils.getConfig("rim_collect_field", entityId);
        if (kd.bos.util.StringUtils.isNotEmpty((String)fieldStr)) {
            String[] fields;
            HashMap<String, Object> customField = new HashMap<String, Object>(4);
            for (String field : fields = fieldStr.split(",")) {
                if (!kd.bos.util.StringUtils.isNotEmpty((String)field) || plugin.getControl(field) == null) continue;
                Object obj = plugin.getView().getModel().getValue(field);
                if (obj instanceof DynamicObject) {
                    customField.put(field, ((DynamicObject)obj).get("id"));
                    continue;
                }
                customField.put(field, obj);
            }
            return customField;
        }
        return null;
    }
}

