/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.collector;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.invoice.collector.InvoiceHisDataSyncService;
import kd.imc.rim.common.invoice.recognitionnew.task.handle.FileHandleService;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.MD5;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.common.utils.StringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;

public class InvoiceHisDataSyncRelationService {
    private static Log LOGGER = LogFactory.getLog(InvoiceHisDataSyncRelationService.class);

    public void saveUserInvoiceRelation(JSONObject param) {
        Object mainId = param.get((Object)"mainId");
        List userIds = (List)param.get((Object)"userIds");
        if (mainId == null || CollectionUtils.isEmpty((Collection)userIds)) {
            return;
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)mainId, (String)"rim_invoice");
        if (dynamicObject != null) {
            DynamicObjectCollection collectUsers = dynamicObject.getDynamicObjectCollection("collect_user_entry");
            if (CollectionUtils.isNotEmpty((Collection)collectUsers)) {
                Long collectUser;
                Set collectUserSet = collectUsers.stream().map(t -> DynamicObjectUtil.getDynamicObjectLongValue(t.get("collect_user"))).collect(Collectors.toSet());
                Iterator iterator = userIds.iterator();
                if (iterator.hasNext() && collectUserSet.contains(collectUser = (Long)iterator.next())) {
                    userIds.remove(collectUser);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)userIds)) {
                Date now = new Date();
                for (Long userId : userIds) {
                    DynamicObject object = collectUsers.addNew();
                    object.set("collect_user", (Object)userId);
                    object.set("collect_user_time", (Object)now);
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
            }
        }
    }

    public Pair<Boolean, List<Long>> checkNeedSave(JSONObject param) {
        HashSet<Long> userIds = new HashSet<Long>();
        if (param == null) {
            LOGGER.info("\u53c2\u6570\u4e3a\u7a7a");
            return Pair.of((Object)false, new ArrayList(0));
        }
        String originalConfig = RimConfigUtils.getConfig("rim_config", "sync_aws_ticket");
        if (!StringUtils.equals((CharSequence)"1", (CharSequence)originalConfig)) {
            LOGGER.info("\u540c\u6b65AWS\u7968\u5939\u6570\u636e\u81f3\u4e2a\u4eba\u7968\u5939\uff0c \u914d\u7f6e\u672a\u5f00\u542f");
            return Pair.of((Object)false, new ArrayList(0));
        }
        JSONArray userPhoneList = param.getJSONArray("userPhoneList");
        if (CollectionUtils.isEmpty((Collection)userPhoneList)) {
            LOGGER.info("\u624b\u673a\u4fe1\u606f\u4e3a\u7a7a");
            return Pair.of((Object)false, new ArrayList(0));
        }
        QFilter qFilter = new QFilter("phone", "in", (Object)userPhoneList);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bos_user", (String)"id,username,phone,number", (QFilter[])new QFilter[]{qFilter});
        if (dynamicObjects == null || dynamicObjects.size() == 0) {
            LOGGER.info("\u7528\u6237\u4e0d\u5b58\u5728");
            return Pair.of((Object)false, new ArrayList(0));
        }
        for (DynamicObject dynamicObject : dynamicObjects) {
            userIds.add(dynamicObject.getLong("id"));
        }
        if (CollectionUtils.isEmpty(userIds)) {
            LOGGER.info("\u4e0d\u80fd\u5b58\u5728\u5bf9\u5e94\u624b\u673a\u53f7\u7684\u7528\u6237");
            return Pair.of((Object)false, new ArrayList(0));
        }
        LOGGER.info("\u6ee1\u8db3\u8981\u6c42\u7684\u7528\u6237id" + ((Object)userIds).toString());
        return Pair.of((Object)true, userIds.stream().collect(Collectors.toList()));
    }

    public void dealAwsAttachment(JSONObject attachParam) {
        JSONArray attachmentArr = attachParam.getJSONArray("attachment");
        if (kd.bos.orm.util.CollectionUtils.isEmpty((Collection)attachmentArr)) {
            return;
        }
        Long userId = attachParam.getLong("userId");
        String serialNo = attachParam.getString("serialNo");
        String isSyncDownload = RimConfigUtils.getConfig("rim_config", "sync_download_aws_invoice_file");
        for (int i = 0; i < attachmentArr.size(); ++i) {
            JSONObject attachment = attachmentArr.getJSONObject(i);
            if (attachment == null) continue;
            attachment.put("expenseId", (Object)serialNo);
            if (userId > 0L) {
                attachment.put("userId", (Object)userId.toString());
            }
            attachment.put("relationType", (Object)"1");
            String fileId = MD5.md5Hex(serialNo + attachment.getString("serialNo"));
            FileHandleService service = FileHandleService.newInstance(FileHandleService.DOWN_TYPE_ATT);
            service.insert(fileId, attachment);
            if (!"1".equals(isSyncDownload)) continue;
            LOGGER.info("\u540c\u6b65\u4e0b\u8f7d\u53d1\u7968\u7684\u9644\u4ef6\uff1a{}", (Object)fileId);
            FileHandleService fileHandleService = FileHandleService.newInstance(FileHandleService.DOWN_TYPE_ATT);
            InvoiceHisDataSyncService.downloadCurrentFileById(fileHandleService, fileId);
        }
        if (!"1".equals(isSyncDownload)) {
            FileHandleService.startDownAwsFile("0");
        }
    }

    public static String desensitizationPhone(String number) {
        if (StringUtils.isBlank((CharSequence)number) || number.length() < 11) {
            return "";
        }
        HashMap<Integer, int[]> desensitizeRules = new HashMap<Integer, int[]>();
        desensitizeRules.put(11, new int[]{3, 7, 4});
        int length = number.length();
        int[] rules = desensitizeRules.getOrDefault(length, new int[]{length / 3, 2 * (length / 3), 8});
        return InvoiceHisDataSyncRelationService.applyDesensitization(number, rules);
    }

    private static String applyDesensitization(String idNumber, int[] rules) {
        int start = rules[0];
        int end = rules[1];
        int maskLength = Math.min(rules[2], end - start);
        StringBuilder sb = new StringBuilder();
        sb.append(idNumber, 0, start);
        for (int i = 0; i < maskLength; ++i) {
            sb.append('*');
        }
        sb.append(idNumber.substring(end));
        return sb.toString();
    }
}

