/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.collector;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.imc.rim.common.invoice.recognitionnew.task.handle.FileHandleService;

public class InvoiceHisImageSyncService {
    private static Log LOGGER = LogFactory.getLog(InvoiceHisImageSyncService.class);
    private String syncInvoice = "1";

    public static InvoiceHisImageSyncService getInstance() {
        return new InvoiceHisImageSyncService();
    }

    public static InvoiceHisImageSyncService getInstanceNoThread() {
        InvoiceHisImageSyncService ihisss = new InvoiceHisImageSyncService();
        ihisss.syncInvoice = "0";
        return ihisss;
    }

    public void syncAttachAndCover(JSONObject result, String billId) {
        LOGGER.info("\u3010\u5f71\u50cf\u540c\u6b65\u3011\u540c\u6b65\u5355\u636e\u9644\u4ef6\u548c\u5c01\u9762\u3002\u4fe1\u606f\uff1a{}", (Object)result);
        try (TXHandle h = TX.requiresNew();){
            try {
                JSONArray coverArr;
                JSONArray attachmentArr = result.getJSONArray("attachment");
                if (attachmentArr != null && attachmentArr.size() > 0) {
                    this.updateAttach(attachmentArr, billId);
                }
                if ((coverArr = result.getJSONArray("cover")) != null && coverArr.size() > 0) {
                    this.uploadCover(coverArr, billId);
                }
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
    }

    private void uploadCover(JSONArray coverArr, String billId) {
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"rim_cover_relation", (String)"id,cover_id", (QFilter[])new QFilter[]{new QFilter("expense_id", "in", (Object)billId)});
        DeleteServiceHelper.delete((String)"rim_cover_relation", (QFilter[])new QFilter[]{new QFilter("expense_id", "in", (Object)billId)});
        DeleteServiceHelper.delete((String)"rim_cover", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)collection.stream().map(v -> Long.parseLong((String)v.get("cover_id"))).toArray())});
        DynamicObject[] files = new DynamicObject[coverArr.size()];
        for (int i = 0; i < coverArr.size(); ++i) {
            DynamicObject file;
            JSONObject cover = coverArr.getJSONObject(i);
            files[i] = file = BusinessDataServiceHelper.newDynamicObject((String)"rim_invoice_file_aws");
            file.set("download_url", (Object)cover.getString("localUrl"));
            file.set("snapshot_url", (Object)cover.getString("snapshotUrl"));
            file.set("ofd_url", (Object)billId);
            file.set("original_file_name", (Object)cover.getString("coverNo"));
        }
        DynamicObject[] saves = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])files);
        if ("0".equals(this.syncInvoice)) {
            LOGGER.info("\u3010\u5f71\u50cf\u540c\u6b65\u3011\uff0c\u5f02\u6b65\u4e0b\u8f7d\uff1a{}\uff0cbillId\uff1a{}", (Object)coverArr.toJSONString(), (Object)billId);
            for (DynamicObject file : saves) {
                FileHandleService service = FileHandleService.newInstance(FileHandleService.DOWN_TYPE_COV);
                service.doBusiness(file);
            }
        } else {
            LOGGER.info("\u3010\u5f71\u50cf\u540c\u6b65\u3011\uff0c\u540c\u6b65\u4e0b\u8f7d\uff1a{}\uff0cbillId\uff1a{}", (Object)coverArr.toJSONString(), (Object)billId);
            ThreadPools.executeOnceIncludeRequestContext((String)"InvoiceImageNotifyService", () -> {
                for (DynamicObject file : saves) {
                    FileHandleService service = FileHandleService.newInstance(FileHandleService.DOWN_TYPE_COV);
                    service.doBusiness(file);
                }
            });
        }
    }

    private void updateAttach(JSONArray attachmentArr, String billId) {
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"rim_attach_relation", (String)"id,attach_id", (QFilter[])new QFilter[]{new QFilter("expense_id", "in", (Object)billId)});
        DeleteServiceHelper.delete((String)"rim_attach_relation", (QFilter[])new QFilter[]{new QFilter("expense_id", "in", (Object)billId)});
        DeleteServiceHelper.delete((String)"rim_attach", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)collection.stream().map(v -> Long.parseLong((String)v.get("attach_id"))).toArray())});
        DynamicObject[] files = new DynamicObject[attachmentArr.size()];
        for (int i = 0; i < attachmentArr.size(); ++i) {
            DynamicObject file;
            JSONObject attach = attachmentArr.getJSONObject(i);
            files[i] = file = BusinessDataServiceHelper.newDynamicObject((String)"rim_invoice_file_aws");
            file.set("serial_no", (Object)attach.getString("serialNo"));
            file.set("download_url", (Object)attach.getString("localUrl"));
            file.set("snapshot_url", (Object)attach.getString("snapshotUrl"));
            file.set("ofd_url", (Object)billId);
            file.set("attachment_name", (Object)attach.getString("attachmentName"));
            file.set("original_file_name", (Object)attach.getString("attachmentName"));
            file.set("file_type", (Object)attach.getString("attachmentType"));
            file.set("remark", (Object)attach.getString("remark"));
        }
        DynamicObject[] saves = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])files);
        if ("0".equals(this.syncInvoice)) {
            LOGGER.info("\u3010\u5f71\u50cf\u540c\u6b65\u3011\uff0c\u5f02\u6b65\u4e0b\u8f7d\uff1a{}\uff0cbillId\uff1a{}", (Object)attachmentArr.toJSONString(), (Object)billId);
            for (DynamicObject file : saves) {
                FileHandleService service = FileHandleService.newInstance(FileHandleService.DOWN_TYPE_ATT);
                service.doBusiness(file);
            }
        } else {
            LOGGER.info("\u3010\u5f71\u50cf\u540c\u6b65\u3011\uff0c\u540c\u6b65\u4e0b\u8f7d\uff1a{}\uff0cbillId\uff1a{}", (Object)attachmentArr.toJSONString(), (Object)billId);
            ThreadPools.executeOnceIncludeRequestContext((String)"InvoiceImageNotifyService", () -> {
                for (DynamicObject file : saves) {
                    FileHandleService service = FileHandleService.newInstance(FileHandleService.DOWN_TYPE_ATT);
                    service.doBusiness(file);
                }
            });
        }
    }
}

