/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.collector;

import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import java.util.concurrent.Callable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.imc.rim.common.invoice.recognition.RecognitionCheckParentTask;
import kd.imc.rim.common.invoice.recognition.impl.RecognitionCheckRemoteTask;
import kd.imc.rim.common.invoice.recognition.impl.RecognitionCheckTask;
import kd.imc.rim.common.multitenant.service.MultiTenantService;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.common.utils.FileUploadUtils;
import kd.imc.rim.common.utils.ImcConfigUtil;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.common.utils.SysParamUtil;
import org.apache.commons.lang3.StringUtils;

public class ScannerService {
    private static final int threadNum = 5;
    private static ThreadPool checkThreadPool = ThreadPools.newFixedThreadPool((String)"scanner_check_pool", (int)5);
    private static final Log LOGGER = LogFactory.getLog(ScannerService.class);
    public static final String operate_invoice = "invoice";
    public static final String operate_attach = "attach";

    public static void startWebScoket(CustomControl control, String linkKey) {
        RequestContext request = RequestContext.get();
        String socketUrl = request.getClientFullContextPath() + "msgwatch/?identifytype=" + linkKey + "&tenantsessionkey=KERPSESSIONID" + request.getTenantId();
        if (socketUrl.startsWith("https")) {
            socketUrl = "wss" + socketUrl.substring(5);
        } else if (socketUrl.startsWith("http")) {
            socketUrl = "ws" + socketUrl.substring(4);
        }
        JSONObject map = new JSONObject();
        map.put("operate", (Object)"open");
        map.put("qrcodeType", (Object)"cloudhub");
        map.put("socketUrl", (Object)socketUrl);
        map.put("linkKey", (Object)linkKey);
        map.put("enableWebSocket", (Object)"1");
        if ("0".equals(RimConfigUtils.getConfig("rim_fpzs", "enablesocket"))) {
            map.put("enableWebSocket", (Object)"0");
        }
        if (new MultiTenantService().isMultiTenant()) {
            map.put("enableWebSocket", (Object)"0");
        }
        map.put("time", (Object)System.currentTimeMillis());
        LOGGER.info("startWebScoket:" + JSONObject.toJSONString((Object)map));
        control.setData((Object)map);
    }

    public static void startInterval(CustomControl control) {
        JSONObject json = new JSONObject();
        json.put("time", (Object)1000);
        json.put("millisec", (Object)1000);
        json.put("request", (Object)System.currentTimeMillis());
        control.setData((Object)json);
    }

    public static void removeUpload(CustomControl control) {
        JSONObject map1 = new JSONObject();
        map1.put("operate", (Object)"remove");
        map1.put("fid", (Object)control.getView().getEntityId());
        control.setData((Object)map1);
    }

    public static void initUpload(CustomControl control, boolean canImportExcels, String title, String name) {
        String baseurl;
        JSONObject map1 = new JSONObject();
        RequestContext request = RequestContext.get();
        map1.put("operate", (Object)"init");
        map1.put("pageId", (Object)(control.getView().getPageId() + name));
        map1.put("title", (Object)title);
        Map<String, String> rimFpzsConfig = ImcConfigUtil.getValue("rim_fpzs");
        int maxfilesize = BigDecimalUtil.transDecimal(rimFpzsConfig.get("maxfilesize")).intValue();
        if (maxfilesize < 1) {
            maxfilesize = 10;
        }
        if (StringUtils.isBlank((CharSequence)(baseurl = rimFpzsConfig.get("pc_baseurl")))) {
            baseurl = request.getClientFullContextPath();
        }
        map1.put("uploadUrl", (Object)(baseurl + "attachment/upload.do"));
        if ("pc_oversea_file_upload".equals(name)) {
            map1.put("cardentry", (Object)"cardentryrowap3");
        } else {
            map1.put("cardentry", (Object)"cardentryrowap");
        }
        map1.put("maxFileSize", (Object)maxfilesize);
        ScannerService.setImageCompress((Map<String, Object>)map1, rimFpzsConfig);
        map1.put("fid", (Object)control.getView().getEntityId());
        map1.put("loadMsg", (Object)ResManager.loadKDString((String)"\u4e0a\u4f20\u4e2d..", (String)"ScannerService_0", (String)"imc-rim-common", (Object[])new Object[0]));
        map1.put("canImportExcels", (Object)canImportExcels);
        control.setData((Object)map1);
    }

    public static void setImageCompress(Map<String, Object> map1, Map<String, String> rimFpzsConfig) {
        double fileLimitSize = 3.0;
        double fileQuality = 0.98;
        int fileLimitPixel = 1500;
        if (rimFpzsConfig != null && StringUtils.isNotEmpty((CharSequence)rimFpzsConfig.get("imageCompress"))) {
            double limitSize;
            String imageCompress = rimFpzsConfig.get("imageCompress");
            String[] str = imageCompress.split(",");
            if (str.length > 0 && (limitSize = BigDecimalUtil.transDecimal(str[0]).doubleValue()) > 0.0 && limitSize <= 8.0) {
                fileLimitSize = limitSize;
            }
            if (str.length > 1 && (limitSize = BigDecimalUtil.transDecimal(str[1]).doubleValue()) > 0.0) {
                fileQuality = limitSize;
            }
            if (str.length > 2 && (limitSize = BigDecimalUtil.transDecimal(str[2]).intValue()) > 0) {
                fileLimitPixel = limitSize;
            }
        }
        map1.put("fileLimitSize", fileLimitSize);
        map1.put("fileQuality", fileQuality);
        map1.put("fileLimitPixel", fileLimitPixel);
    }

    public static void upload(CustomControl control) {
        JSONObject map1 = new JSONObject();
        map1.put("operate", (Object)"upload");
        map1.put("time", (Object)System.currentTimeMillis());
        control.setData((Object)map1);
    }

    public static void init(CustomControl control, String pageId) {
        RequestContext request = RequestContext.get();
        JSONObject map1 = new JSONObject();
        map1.put("pageId", (Object)pageId);
        map1.put("init", (Object)"init");
        map1.put("savePath", (Object)(FileUploadUtils.getInvoiceDir(operate_invoice) + pageId + ""));
        map1.put("uploadUrl", (Object)(request.getClientFullContextPath() + "attachment/upload.do"));
        map1.put("time", (Object)System.currentTimeMillis());
        map1.put("fid", (Object)control.getView().getEntityId());
        ScannerService.setScannerParam(map1);
        map1.put("downloadUrl", (Object)ScannerService.getJsScanner());
        control.setData((Object)map1);
    }

    public static void scanner(CustomControl control, String pageId, String operate) {
        RequestContext request = RequestContext.get();
        JSONObject map1 = new JSONObject();
        map1.put("pageId", (Object)pageId);
        map1.put("operate", (Object)operate);
        map1.put("savePath", (Object)(FileUploadUtils.getInvoiceDir(operate_invoice) + pageId + ""));
        String contextPath = request.getClientFullContextPath();
        if (contextPath.endsWith("/")) {
            contextPath = contextPath.substring(0, contextPath.length() - 1);
        }
        map1.put("contextPath", (Object)contextPath);
        map1.put("uploadUrl", (Object)(contextPath + "/attachment/upload.do"));
        map1.put("time", (Object)System.currentTimeMillis());
        map1.put("fid", (Object)control.getView().getEntityId());
        ScannerService.setScannerParam(map1);
        map1.put("downloadUrl", (Object)ScannerService.getJsScanner());
        control.setData((Object)map1);
    }

    private static void setScannerParam(JSONObject param) {
        Map<String, String> map = ImcConfigUtil.getValue("rim_fpzs");
        String resolution = null;
        String scannerType = null;
        String limitpixel = null;
        if (map != null) {
            resolution = StringUtils.trimToEmpty((String)map.get("resolution"));
            scannerType = StringUtils.trimToEmpty((String)map.get("scanner_type"));
            limitpixel = StringUtils.trimToEmpty((String)map.get("limitpixel"));
        }
        if (StringUtils.isEmpty(scannerType)) {
            scannerType = "rq";
        }
        if (map != null && "dm".equals(scannerType)) {
            param.put("productKey", (Object)map.get("productkey"));
        }
        if (StringUtils.isEmpty((CharSequence)resolution)) {
            resolution = "100";
        }
        if (StringUtils.isEmpty(limitpixel)) {
            limitpixel = "2000";
        }
        param.put("scannerType", (Object)scannerType);
        param.put("resolution", (Object)resolution);
        param.put("fileLimitPixel", (Object)limitpixel);
        param.put("duplex", (Object)"0");
        boolean isDoublePageScan = SysParamUtil.getSysParamByOrgId(RequestContext.get().getOrgId(), "scan_doublepage_flag");
        if (isDoublePageScan) {
            param.put("duplex", (Object)"1");
        }
        param.put("loadMsg", (Object)ResManager.loadKDString((String)"\u626b\u63cf\u4e0a\u4f20\u4e2d..", (String)"ScannerService_1", (String)"imc-rim-common", (Object[])new Object[0]));
    }

    public static boolean scannerFail(AbstractFormPlugin plugin, String eventArgs) {
        if (eventArgs != null) {
            String description;
            if (eventArgs.indexOf("JsScanner.msi") > 0) {
                plugin.getView().showConfirm(ResManager.loadKDString((String)"\u626b\u63cf\u4eea\u9700\u8981\u5b89\u88c5JsScanner\uff0c\u662f\u5426\u5b89\u88c5\uff1f", (String)"ScannerService_2", (String)"imc-rim-common", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("downJsScanner", (IFormPlugin)plugin));
                return false;
            }
            if (eventArgs.indexOf("websocket connect error") > 0) {
                plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u5df2\u7ecf\u8fde\u63a5\u5e76\u6253\u5f00\u626b\u63cf\u4eea\uff01", (String)"ScannerService_3", (String)"imc-rim-common", (Object[])new Object[0]), Integer.valueOf(3000));
                return false;
            }
            if (eventArgs.indexOf("No data source found in this environment") > 0) {
                plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u662f\u5426\u6b63\u786e\u5b89\u88c5\u626b\u63cf\u4eea\u9a71\u52a8\uff01", (String)"ScannerService_4", (String)"imc-rim-common", (Object[])new Object[0]), Integer.valueOf(3000));
                return false;
            }
            JSONObject js = JSONObject.parseObject((String)eventArgs);
            if (js != null && !StringUtils.isEmpty((CharSequence)(description = js.getString("description")))) {
                plugin.getView().showTipNotification(description, Integer.valueOf(3000));
                return true;
            }
        }
        plugin.getView().showErrorNotification(eventArgs);
        return false;
    }

    public static boolean uploadFinish(String eventArgs) {
        return eventArgs != null && (eventArgs.indexOf("cancelSelectSource") > 0 || eventArgs.indexOf("confirmDownload") > 0 || eventArgs.indexOf("cancelDownload") > 0);
    }

    public static String getJsScanner() {
        RequestContext request = RequestContext.get();
        return request.getClientFullContextPath() + "kingdee/imc/scanner/rq-scanner/lib/JsScanner.msi";
    }

    public static void downJsScanner(AbstractFormPlugin plugin) {
        RequestContext request = RequestContext.get();
        plugin.getView().openUrl(request.getClientFullContextPath() + "kingdee/imc/scanner/rq-scanner/lib/JsScanner.msi");
    }

    public static void recognitionInvoice(String source, String pageId, String url, String fileName, JSONObject businessParam, Map<String, Object> customParam) {
        LOGGER.info("Scanner recognitionInvoice...");
        RecognitionCheckParentTask task = new MultiTenantService().isMultiTenant() ? new RecognitionCheckRemoteTask(RequestContext.get(), source, pageId, businessParam, customParam, url, fileName) : new RecognitionCheckTask(RequestContext.get(), source, pageId, businessParam, customParam, url, fileName);
        checkThreadPool.submit((Callable)task);
    }

    public static void addCustomParam(Map<String, Object> params, String pluginType) {
        Map<String, String> rimFpzsConfig = ImcConfigUtil.getValue("rim_plugin_" + pluginType);
        if (rimFpzsConfig != null && !rimFpzsConfig.isEmpty()) {
            params.putAll(rimFpzsConfig);
        }
    }

    public static Long getUploadIndex(JSONObject uploadResult) {
        Long index = BigDecimalUtil.transDecimal(uploadResult.get((Object)"index")).longValue();
        Long timeStamp = uploadResult.getLong("uploadTimeStamp");
        if (timeStamp == null) {
            timeStamp = System.currentTimeMillis();
        }
        return timeStamp + index;
    }

    public static String getPushMsgFormCache(String cacheKey) {
        MultiTenantService service = new MultiTenantService();
        if (service.isMultiTenant()) {
            return (String)service.doPost("FpzsServiceOpenApiImpl", "getFpzsPushData", cacheKey);
        }
        return CacheHelper.get(cacheKey);
    }
}

