/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.collector.impl;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.invoice.collector.InvoiceHeaderDownService;
import kd.imc.rim.common.invoice.collector.InvoiceMainInfoDownService;
import kd.imc.rim.common.invoice.deduction.DeductService;
import kd.imc.rim.common.invoice.deduction.DeductServiceFactory;
import kd.imc.rim.common.invoice.deduction.impl.NewEtaxDeductService;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.UUID;

public class NewEtaxInvoiceDownService
extends InvoiceMainInfoDownService {
    private static Log LOGGER = LogFactory.getLog(NewEtaxInvoiceDownService.class);

    public NewEtaxInvoiceDownService(Long orgId) {
        this.orgId = orgId;
    }

    @Override
    public DeductService getDeductServiceImpl(Long orgId) {
        return DeductServiceFactory.newInstanceForDeduct("4", orgId);
    }

    @Override
    public JSONObject doDown(JSONObject paramJson) {
        DeductService deductService = this.getDeductServiceImpl(this.orgId);
        String billType = paramJson.getString("billType");
        if (StringUtils.isEmpty((CharSequence)billType)) {
            billType = "0";
            paramJson.put("billType", (Object)billType);
        }
        JSONObject searchOpt = paramJson.getJSONObject("searchOpt");
        String deductFlag = searchOpt.getString("deductFlag");
        Date taxPeriod = searchOpt.getDate("taxPeriod");
        if ("1".equals(deductFlag) || "2".equals(deductFlag)) {
            paramJson.put("synctype", (Object)"03");
            searchOpt.clear();
            if (taxPeriod != null) {
                searchOpt.put("taxPeriod", (Object)DateUtils.format(taxPeriod, "yyyyMM"));
            }
            if ("1".equals(billType)) {
                searchOpt.put("invoiceType", (Object)InputInvoiceTypeEnum.HGJKS.getAwsType());
            }
            if ("2".equals(deductFlag)) {
                paramJson.put("synctype", (Object)"09");
            }
        } else if ("0".equals(deductFlag)) {
            searchOpt.remove((Object)"taxPeriod");
            searchOpt.put("authenticateFlags", (Object)"0");
            if ("1".equals(billType) || InputInvoiceTypeEnum.HGJKS.getAwsType().equals(searchOpt.getString("invoiceType"))) {
                searchOpt.put("customDeclarationNo", (Object)searchOpt.getString("invoiceNo"));
            }
        }
        return deductService.queryInvoices(paramJson);
    }

    @Override
    public JSONObject invokeDownInvoice(JSONObject paramJson) {
        String billType = paramJson.getString("billType");
        String invoiceType = paramJson.getString("invoiceType");
        if (StringUtils.isEmpty((CharSequence)billType)) {
            billType = "0";
            paramJson.put("billType", (Object)billType);
        }
        JSONObject searchOpt = paramJson.getJSONObject("searchOpt");
        searchOpt.remove((Object)"manageStatus");
        String deductFlag = searchOpt.getString("deductFlag");
        Date taxPeriod = searchOpt.getDate("taxPeriod");
        if ("1".equals(deductFlag) || "2".equals(deductFlag)) {
            searchOpt.remove((Object)"startTime");
            searchOpt.remove((Object)"endTime");
            searchOpt.remove((Object)"invoiceStatus");
            if (taxPeriod != null) {
                searchOpt.put("taxPeriod", (Object)DateUtils.format(taxPeriod, "yyyyMM"));
            }
        } else if ("0".equals(deductFlag)) {
            searchOpt.remove((Object)"taxPeriod");
            searchOpt.remove((Object)"deductionPurpose");
        }
        ArrayList<String> billTypeList = new ArrayList<String>(1);
        if ("-1".equals(billType) && (StringUtils.isBlank((CharSequence)invoiceType) || "-1".equals(invoiceType))) {
            billTypeList.add("0");
            billTypeList.add("1");
            billTypeList.add("2");
        } else if ("1".equals(billType) || InputInvoiceTypeEnum.HGJKS.getAwsType().equals(invoiceType)) {
            searchOpt.remove((Object)"invoiceStatus");
            billTypeList.add("1");
            searchOpt.put("invoiceType", (Object)InputInvoiceTypeEnum.HGJKS.getAwsType());
        } else if ("2".equals(billType) || InputInvoiceTypeEnum.WITHHOLDING.getAwsType().equals(invoiceType)) {
            searchOpt.remove((Object)"invoiceStatus");
            billTypeList.add("2");
            searchOpt.put("invoiceType", (Object)InputInvoiceTypeEnum.WITHHOLDING.getAwsType());
        } else {
            billTypeList.add("0");
        }
        ArrayList<JSONObject> resultList = new ArrayList<JSONObject>(1);
        JSONObject resultTotal = new JSONObject();
        NewEtaxDeductService deductService = new NewEtaxDeductService(this.orgId);
        String syncType = "8";
        if ("1".equals(deductFlag)) {
            syncType = "9";
        }
        if ("2".equals(deductFlag)) {
            syncType = "10";
        }
        InvoiceHeaderDownService invoiceHeaderDownService = new InvoiceHeaderDownService(this.orgId);
        for (String billTypeParam : billTypeList) {
            paramJson.put("billType", (Object)billTypeParam);
            if (StringUtils.equals((CharSequence)"1", (CharSequence)billTypeParam)) {
                searchOpt.put("invoiceType", (Object)InputInvoiceTypeEnum.HGJKS.getAwsType());
            }
            if (StringUtils.equals((CharSequence)"2", (CharSequence)billTypeParam)) {
                searchOpt.put("invoiceType", (Object)InputInvoiceTypeEnum.WITHHOLDING.getAwsType());
            }
            JSONObject resultObject = ((DeductService)deductService).downInvoiceHeadApply(paramJson);
            resultList.add(resultObject);
            if (!ResultContant.isSuccess(resultObject).booleanValue()) continue;
            JSONObject logParam = new JSONObject();
            logParam.put("searchOpt", (Object)searchOpt);
            logParam.put("rpadownAsyn", (Object)paramJson.getString("rpadownAsyn"));
            logParam.put("billType", (Object)billTypeParam);
            logParam.put("taxNo", (Object)paramJson.getString("taxNo"));
            logParam.put("taskNo", (Object)UUID.getBatchNo("DOWN"));
            logParam.put("syncType", (Object)syncType);
            invoiceHeaderDownService.insertDownLog(logParam, resultObject);
            resultTotal.put("errcode", (Object)resultObject.getString("errcode"));
        }
        if (!ResultContant.isSuccess(resultTotal).booleanValue()) {
            resultTotal.putAll((Map)resultList.stream().filter(t -> StringUtils.isNotBlank((CharSequence)t.getString("errcode"))).findFirst().get());
        }
        resultTotal.put("result", resultList);
        return resultTotal;
    }
}

