/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.deduction;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.invoice.deduction.AsyncDeductQueryService;
import kd.imc.rim.common.invoice.deduction.AsyncDeductSelectService;
import kd.imc.rim.common.invoice.deduction.DeductServiceFactory;
import kd.imc.rim.common.invoice.deduction.impl.AsyncStatisticConfirmQueryServiceImpl;
import kd.imc.rim.common.invoice.deduction.impl.AsyncStatisticCreateQueryServiceImpl;
import kd.imc.rim.common.invoice.deduction.impl.NewAsyncAgrichandleService;
import kd.imc.rim.common.invoice.deduction.impl.NewEtaxAsyncDeductSelectService;

public class AsyncDeductHelper {
    private static final Log LOGGER = LogFactory.getLog(AsyncDeductHelper.class);
    public static final String OPERATETYPE_UPDATE = "1";
    public static final String OPERATETYPE_DOWN = "2";

    public static String handleAsyncLog(DynamicObject selectLog) {
        String taxNo = selectLog.getString("tax_no");
        String selectType = selectLog.getString("select_type");
        if (OPERATETYPE_UPDATE.equals(selectType) || OPERATETYPE_DOWN.equals(selectType)) {
            AsyncDeductHelper.handleSelect(selectLog, taxNo);
        } else if ("6".equals(selectType)) {
            AsyncDeductHelper.handleStatistic(selectLog, taxNo);
        } else if ("7".equals(selectType)) {
            AsyncDeductHelper.handleRecorded(selectLog, taxNo);
        } else if ("8".equals(selectType)) {
            AsyncDeductHelper.handleAgric(selectLog, taxNo);
        } else {
            LOGGER.info("{}\u4e0d\u652f\u6301\u7684\u7c7b\u578b:{}", (Object)taxNo, (Object)selectType);
            return String.format(ResManager.loadKDString((String)"%1$s-\u4e0d\u652f\u6301\u7684\u7c7b\u578b:%2$s", (String)"AsyncDeductHelper_0", (String)"imc-rim-common", (Object[])new Object[0]), taxNo, selectType);
        }
        return null;
    }

    private static String handleAgric(DynamicObject selectLog, String taxNo) {
        String dkType = DeductionConstant.getDkType(taxNo);
        AsyncDeductSelectService deductSelectService = DeductServiceFactory.newInstanceForAsyncAgricHandle(dkType);
        if (deductSelectService == null) {
            LOGGER.info("{}\u7a0e\u5c40\u63a5\u53e3\u914d\u7f6e\u9519\u8bef", (Object)taxNo);
            return String.format(ResManager.loadKDString((String)"%1$s-\u7a0e\u5c40\u63a5\u53e3\u914d\u7f6e\u9519\u8bef", (String)"AsyncDeductHelper_1", (String)"imc-rim-common", (Object[])new Object[0]), taxNo);
        }
        try {
            deductSelectService.querySelectResult(selectLog);
        }
        catch (Exception e) {
            LOGGER.error(taxNo + "\u67e5\u8be2\u519c\u4ea7\u54c1\u5904\u7406\u7ed3\u679c\u9519\u8bef:" + selectLog.get("batch_no"), (Throwable)e);
            return String.format(ResManager.loadKDString((String)"%1$s-\u67e5\u8be2\u519c\u4ea7\u54c1\u5904\u7406\u7ed3\u679c\u9519\u8bef", (String)"AsyncDeductHelper_5", (String)"imc-rim-common", (Object[])new Object[0]), taxNo);
        }
        return null;
    }

    private static String handleRecorded(DynamicObject selectLog, String taxNo) {
        String dkType = DeductionConstant.getDkType(taxNo);
        AsyncDeductSelectService deductSelectService = DeductServiceFactory.newInstanceForAsyncQueryResultRecorded(dkType);
        if (deductSelectService == null) {
            LOGGER.info("{}\u7a0e\u5c40\u63a5\u53e3\u914d\u7f6e\u9519\u8bef", (Object)taxNo);
            return String.format(ResManager.loadKDString((String)"%1$s-\u7a0e\u5c40\u63a5\u53e3\u914d\u7f6e\u9519\u8bef", (String)"AsyncDeductHelper_1", (String)"imc-rim-common", (Object[])new Object[0]), taxNo);
        }
        try {
            deductSelectService.queryRecordedCommitResult(selectLog);
        }
        catch (Exception e) {
            LOGGER.error(taxNo + "\u67e5\u8be2\u52fe\u9009\u7ed3\u679c\u9519\u8bef:" + selectLog.get("batch_no"), (Throwable)e);
            return String.format(ResManager.loadKDString((String)"%1$s-\u67e5\u8be2\u52fe\u9009\u7ed3\u679c\u9519\u8bef", (String)"AsyncDeductHelper_2", (String)"imc-rim-common", (Object[])new Object[0]), taxNo);
        }
        return null;
    }

    private static String handleSelect(DynamicObject selectLog, String taxNo) {
        String dkType = DeductionConstant.getDkType(taxNo);
        AsyncDeductSelectService deductSelectService = DeductServiceFactory.newInstanceForAsyncDeductSelect(dkType);
        if (deductSelectService == null) {
            LOGGER.info("{}\u7a0e\u5c40\u63a5\u53e3\u914d\u7f6e\u9519\u8bef", (Object)taxNo);
            return String.format(ResManager.loadKDString((String)"%1$s-\u7a0e\u5c40\u63a5\u53e3\u914d\u7f6e\u9519\u8bef", (String)"AsyncDeductHelper_1", (String)"imc-rim-common", (Object[])new Object[0]), taxNo);
        }
        try {
            deductSelectService.querySelectResult(selectLog);
        }
        catch (Exception e) {
            LOGGER.error(taxNo + "\u67e5\u8be2\u52fe\u9009\u7ed3\u679c\u9519\u8bef:" + selectLog.get("batch_no"), (Throwable)e);
            return String.format(ResManager.loadKDString((String)"%1$s-\u67e5\u8be2\u52fe\u9009\u7ed3\u679c\u9519\u8bef", (String)"AsyncDeductHelper_2", (String)"imc-rim-common", (Object[])new Object[0]), taxNo);
        }
        return null;
    }

    private static String handleStatistic(DynamicObject selectLog, String taxNo) {
        AsyncDeductQueryService service = null;
        String operateType = selectLog.getString("operate_type");
        if ("7".equals(operateType) || "-7".equals(operateType)) {
            service = new AsyncStatisticCreateQueryServiceImpl();
        } else if ("8".equals(operateType)) {
            service = new AsyncStatisticConfirmQueryServiceImpl();
        }
        if (service == null) {
            LOGGER.info("{}\u4e0d\u652f\u6301\u7684\u7c7b\u578b:{}", (Object)taxNo, (Object)operateType);
            return String.format(ResManager.loadKDString((String)"%1$s-\u4e0d\u652f\u6301\u7684\u7c7b\u578b:%2$s", (String)"AsyncDeductHelper_0", (String)"imc-rim-common", (Object[])new Object[0]), taxNo, operateType);
        }
        try {
            ((AsyncDeductQueryService)service).getResult(selectLog);
        }
        catch (Exception e) {
            LOGGER.error(taxNo + "\u67e5\u8be2\u7edf\u8ba1\u8868\u7ed3\u679c\u9519\u8bef:" + selectLog.get("batch_no"), (Throwable)e);
            return String.format(ResManager.loadKDString((String)"%1$s-\u67e5\u8be2\u7edf\u8ba1\u8868\u7ed3\u679c\u9519\u8bef", (String)"AsyncDeductHelper_3", (String)"imc-rim-common", (Object[])new Object[0]), taxNo);
        }
        return null;
    }

    public static void abandonTask(List<DynamicObject> logs, String selectType, Map<String, String> successBatchNoMap) {
        if (OPERATETYPE_DOWN.equals(selectType) || "8".equals(selectType)) {
            AsyncDeductHelper.handleSelectAgricAbandon(logs, selectType, successBatchNoMap);
        } else if ("7".equals(selectType)) {
            AsyncDeductHelper.handleRecordedAbandon(logs, successBatchNoMap);
        }
    }

    private static void handleRecordedAbandon(List<DynamicObject> logs, Map<String, String> successBatchNoMap) {
        NewEtaxAsyncDeductSelectService newEtaxAsyncDeductSelectService = new NewEtaxAsyncDeductSelectService();
        newEtaxAsyncDeductSelectService.handleRecordedAbandon(logs, successBatchNoMap);
    }

    private static void handleSelectAgricAbandon(List<DynamicObject> logs, String selectType, Map<String, String> successBatchNoMap) {
        NewEtaxAsyncDeductSelectService newEtaxAsyncDeductSelectService = new NewEtaxAsyncDeductSelectService();
        if ("8".equals(selectType)) {
            newEtaxAsyncDeductSelectService = new NewAsyncAgrichandleService();
        }
        newEtaxAsyncDeductSelectService.handleSelectAgricAbandon(logs, successBatchNoMap);
    }
}

