/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.deduction;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.InvoiceDownloadConstant;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.invoice.deduction.DeductStatisticsService;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DeductionUtils;

public abstract class AsyncDeductQueryService {
    private static Log LOGGER = LogFactory.getLog(AsyncDeductQueryService.class);
    protected static final String SELECT_FILEDS = "batch_no,tax_period,org,tax_no,total_num,success_num,fail_num,handle_status,create_time,update_time,bill_type,task_no,async_flag,result_json,result_json_tag,operate_type,description,handle_num,statistics_status";
    protected static final String LOCK_KEY = "rim.AsyncDeductQueryService-";

    public JSONObject queryAsyncResult(JSONObject param) {
        this.checkParam(param);
        String taxNo = param.getString("taxNo");
        String taskNo = param.getString("taskNo");
        String lockKey = LOCK_KEY + taxNo + taskNo;
        try (DLock lock = DLock.create((String)lockKey, (String)ResManager.loadKDString((String)"\u5f02\u6b65\u6570\u636e\u67e5\u8be2", (String)"AsyncDeductQueryService_0", (String)"imc-rim-common", (Object[])new Object[0]));){
            if (lock.tryLock()) {
                QFilter qFilter = new QFilter("task_no", "=", (Object)taskNo).and("tax_no", "=", (Object)taxNo);
                DynamicObject selectLog = BusinessDataServiceHelper.loadSingle((String)"rim_select_log", (String)SELECT_FILEDS, (QFilter[])qFilter.toArray());
                if (ObjectUtils.isEmpty((Object)selectLog)) {
                    JSONObject jSONObject = ResultContant.createJSONObject(ErrorType.TAX_NO_NULL.getCode(), ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u76f8\u5173\u4efb\u52a1\uff0c\u8bf7\u786e\u8ba4\u8bf7\u6c42\u7a0e\u53f7\u6216\u4efb\u52a1\u53f7\u662f\u5426\u6b63\u786e", (String)"AsyncDeductQueryService_1", (String)"imc-rim-common", (Object[])new Object[0]));
                    return jSONObject;
                }
                JSONObject jSONObject = this.query(selectLog);
                return jSONObject;
            }
            LOGGER.info("{}\u4efb\u52a1\u53f7\u8bf7\u6c42\u9891\u7e41", (Object)taskNo);
            JSONObject jSONObject = this.getHandlingResult(ResManager.loadKDString((String)"\u4efb\u52a1\u53f7\u8bf7\u6c42\u9891\u7e41\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"AsyncDeductQueryService_2", (String)"imc-rim-common", (Object[])new Object[0]));
            return jSONObject;
        }
    }

    public JSONObject query(DynamicObject selectLog) {
        if (ObjectUtils.isEmpty((Object)selectLog)) {
            return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL.getCode(), ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u76f8\u5173\u4efb\u52a1\uff0c\u8bf7\u786e\u8ba4\u8bf7\u6c42\u7a0e\u53f7\u6216\u4efb\u52a1\u53f7\u662f\u5426\u6b63\u786e", (String)"AsyncDeductQueryService_1", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        String operateType = selectLog.getString("operate_type");
        this.checkOperateType(operateType);
        String handleStatus = selectLog.getString("handle_status");
        String resultJsonTag = selectLog.getString("result_json_tag");
        if (("1".equals(handleStatus) || "2".equals(handleStatus)) && !StringUtils.isEmpty((CharSequence)resultJsonTag)) {
            return JSON.parseObject((String)resultJsonTag);
        }
        return this.getResult(selectLog);
    }

    public void checkParam(JSONObject param) {
        if (ObjectUtils.isEmpty((Object)param)) {
            throw new MsgException(ErrorType.PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u53c2\u6570\u4e3a\u7a7a", (String)"AsyncDeductQueryService_3", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)param.getString("taxNo"))) {
            throw new MsgException(ErrorType.PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u7a0e\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"AsyncDeductQueryService_4", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)param.getString("taskNo"))) {
            throw new MsgException(ErrorType.PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u4efb\u52a1\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"AsyncDeductQueryService_5", (String)"imc-rim-common", (Object[])new Object[0]));
        }
    }

    public void checkPageNo(JSONObject param) {
        int pageNo;
        if (ObjectUtils.isEmpty((Object)param.get((Object)"pageNo"))) {
            throw new MsgException(ErrorType.PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u5f53\u524d\u9875\u7801\u4e0d\u80fd\u4e3a\u7a7a", (String)"AsyncDeductQueryService_6", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        try {
            pageNo = param.getIntValue("pageNo");
        }
        catch (Exception e) {
            throw new MsgException(ErrorType.PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u5f53\u524d\u9875\u7801\u4e0d\u662f\u6574\u6570", (String)"AsyncDeductQueryService_7", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        if (pageNo <= 0) {
            throw new MsgException(ErrorType.PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u5f53\u524d\u9875\u7801\u4e0d\u80fd\u5c0f\u4e8e1", (String)"AsyncDeductQueryService_8", (String)"imc-rim-common", (Object[])new Object[0]));
        }
    }

    public void checkPageSize(JSONObject param) {
        Integer pageSize;
        try {
            pageSize = param.getInteger("pageSize");
        }
        catch (Exception e) {
            throw new MsgException(ErrorType.PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u5206\u9875\u6570\u91cf\u4e0d\u662f\u6574\u6570", (String)"AsyncDeductQueryService_11", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        if (ObjectUtils.isEmpty((Object)pageSize)) {
            pageSize = InvoiceDownloadConstant.getPageSizeFromConfig(100, "async_query_pagesize");
        }
        if (pageSize <= 0) {
            throw new MsgException(ErrorType.PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u5206\u9875\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e1", (String)"AsyncDeductQueryService_9", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        int pageSizeMax = InvoiceDownloadConstant.getPageSizeFromConfig(1000, "async_query_max_pagesize");
        if (pageSize > pageSizeMax) {
            throw new MsgException(ErrorType.PARAM_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u5206\u9875\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e%s", (String)"AsyncDeductQueryService_10", (String)"imc-rim-common", (Object[])new Object[0]), pageSizeMax));
        }
        param.put("pageSize", (Object)pageSize);
    }

    public void checkOperateType(String operateType) {
    }

    public abstract JSONObject getResult(DynamicObject var1);

    protected void updateSelectLogStatus(DynamicObject selectLog, JSONObject resultJson, String handleStatus) {
        if (ObjectUtils.isEmpty((Object)selectLog) || ObjectUtils.isEmpty((Object)resultJson)) {
            return;
        }
        String description = resultJson.getString("description");
        if (StringUtils.isNotEmpty((CharSequence)description) && description.length() > 100) {
            description = description.substring(0, 100);
        }
        selectLog.set("description", (Object)description);
        selectLog.set("handle_status", (Object)handleStatus);
        selectLog.set("result_json_tag", (Object)resultJson.toJSONString());
        selectLog.set("update_time", (Object)new Date());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{selectLog});
    }

    protected JSONObject handleAsyncRequest(DynamicObject selectLog, JSONObject result, String authenticateFlag) {
        if (ResultContant.isSuccess(result).booleanValue()) {
            JSONObject data = result.getJSONObject("data");
            if ("false".equals(data.getString("isFinish"))) {
                return ResultContant.createJSONObject(ErrorType.STATUS_HANDLING);
            }
            String skssq = CommonUtils.getJsonValue((Map<String, Object>)data, String.class, "taxPeriod", "skssq");
            this.updateSelectLogStatus(selectLog, result, "1");
            DeductStatisticsService.updateDeduction(selectLog.getString("tax_no"), authenticateFlag, skssq, data.getDate("operateTime"));
        } else {
            this.updateSelectLogStatus(selectLog, result, "2");
        }
        return result;
    }

    protected JSONObject handleNotAsyncRequest(DynamicObject selectLog, JSONObject result, String authenticateFlag) {
        int handleNum = selectLog.getInt("handle_num");
        selectLog.set("handle_num", (Object)(++handleNum));
        if (ResultContant.isSuccess(result).booleanValue()) {
            this.updateSelectLogStatus(selectLog, result, "1");
            DeductStatisticsService.updateDeduction(selectLog.getString("tax_no"), authenticateFlag);
            return result;
        }
        Set<String> etaxRetryErrcodes = DeductionUtils.getEtaxRetryErrcodes();
        if (result != null && !etaxRetryErrcodes.contains(result.getString("errcode"))) {
            this.updateSelectLogStatus(selectLog, result, "2");
            return result;
        }
        int num = InvoiceDownloadConstant.getPageSizeFromConfig(5, "async_handle_num");
        if (handleNum > num) {
            this.updateSelectLogStatus(selectLog, result, "2");
            return result;
        }
        this.updateSelectLogStatus(selectLog, result, "3");
        return this.getHandlingResult(result);
    }

    protected JSONObject getHandlingResult(JSONObject result) {
        String description = result != null ? result.getString("description") : "";
        return this.getHandlingResult(description);
    }

    protected JSONObject getHandlingResult(String description) {
        description = StringUtils.isNotEmpty((CharSequence)description) ? String.format("%s[%s]", ErrorType.STATUS_HANDLING.getName(), description) : ErrorType.STATUS_HANDLING.getName();
        return ResultContant.createJSONObject(ErrorType.STATUS_HANDLING.getCode(), description);
    }
}

