/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.deduction;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.InvoiceSaveConstant;
import kd.imc.rim.common.helper.ThreadPoolsHelper;
import kd.imc.rim.common.invoice.deduction.DeductInvoiceOperateService;
import kd.imc.rim.common.invoice.query.InvoiceQueryService;
import kd.imc.rim.common.invoice.save.InvoiceSaveService;
import kd.imc.rim.common.service.InvoiceLog;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.MetadataUtil;
import kd.imc.rim.common.utils.TenantUtils;

public abstract class AsyncDeductSelectService {
    private static Log LOGGER = LogFactory.getLog(AsyncDeductSelectService.class);
    public static final String SELECT_FILEDS = "batch_no,tax_period,org,tax_no,total_num,success_num,fail_num,handle_status,create_time,update_time,bill_type,handle_num,description,task_no,async_flag,result_json,result_json_tag,operate_type,select_type,statistics_status,select_opera_type";
    private static final String SELECT_ACCOUNT_FILEDS = "serial_no,invoice_type,invoice_code,invoice_no,handle_status,select_result,update_time,deduction_purpose,pre_authenticate_flag,select_status,invoice_date,not_deductible_type,total_tax_amount,effective_tax_amount,select_time,tax_period,description,org,invoice_amount,electronic_no,agric_partial_amount,agric_partial_taxamount,select_opera_type";

    public void queryAsyncSelectResultByBatchNo(List<String> batchNoList) {
        ThreadPoolsHelper.queryAsyncSelectResultThreadPool.execute(() -> {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.querySelectResultByBatchNo(batchNoList);
        });
    }

    public static DynamicObject[] getSelectLogObjects(QFilter[] qFilters) {
        if (ObjectUtils.isEmpty((Object[])qFilters)) {
            return null;
        }
        return BusinessDataServiceHelper.load((String)"rim_select_log", (String)SELECT_FILEDS, (QFilter[])qFilters);
    }

    public void querySelectResultByBatchNo(List<String> batchNoList) {
        if (CollectionUtils.isEmpty(batchNoList)) {
            return;
        }
        QFilter batchNoFilter = new QFilter("batch_no", "in", batchNoList);
        QFilter handleStatusFilter = new QFilter("handle_status", "=", (Object)"3");
        Object[] logs = AsyncDeductSelectService.getSelectLogObjects(new QFilter[]{batchNoFilter, handleStatusFilter});
        if (!ObjectUtils.isEmpty((Object[])logs)) {
            ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(logs));
            list.removeIf(log -> !"3".equals(log.getString("handle_status")));
            if (ObjectUtils.isEmpty(list)) {
                return;
            }
            for (DynamicObject dynamicObject : list) {
                this.querySelectResult(dynamicObject);
            }
        }
    }

    public abstract void querySelectResult(DynamicObject var1);

    protected void recoverMainInvoiceStatus(Map<String, String> serialNoStatusMap) {
        this.recoverMainInvoiceStatus(serialNoStatusMap, "");
    }

    protected void recoverMainInvoiceStatus(Map<String, String> serialNoStatusMap, String selectOperaType) {
        if (!CollectionUtils.isEmpty(serialNoStatusMap)) {
            LOGGER.info("\u6062\u590d\u52fe\u9009\u4e2d\u72b6\u6001:{}", serialNoStatusMap);
            DeductInvoiceOperateService operateService = new DeductInvoiceOperateService();
            operateService.updateMainInvoiceSelecting(serialNoStatusMap, "0", selectOperaType);
        }
    }

    protected Map<String, DynamicObject> getSelectAccount(String batchNo) {
        return this.getSelectAccount(batchNo, "");
    }

    protected Map<String, DynamicObject> getSelectAccount(String batchNo, String billType) {
        QFilter batchNoFilter = new QFilter("batch_no", "=", (Object)batchNo);
        DynamicObject[] selectAccounts = BusinessDataServiceHelper.load((String)"rim_select_account", (String)SELECT_ACCOUNT_FILEDS, (QFilter[])batchNoFilter.toArray());
        HashMap<String, DynamicObject> selectAccountMap = new HashMap<String, DynamicObject>(selectAccounts.length);
        for (DynamicObject selectAccount : selectAccounts) {
            String billNo = this.getBillNo(selectAccount.getString("invoice_code"), selectAccount.getString("invoice_no"), billType, selectAccount.getDate("invoice_date"));
            selectAccountMap.put(billNo, selectAccount);
        }
        return selectAccountMap;
    }

    protected String getBillNo(String invoiceCode, String invoiceNo) {
        return this.getBillNo(invoiceCode, invoiceNo, "", null);
    }

    protected String getBillNo(String invoiceCode, String invoiceNo, String billType, Date invoiceDate) {
        if ("2".equals(billType)) {
            return CommonUtils.getInvoiceCodeNoGroup(invoiceCode, invoiceNo) + DateUtils.format(invoiceDate);
        }
        return CommonUtils.getInvoiceCodeNoGroup(invoiceCode, invoiceNo);
    }

    protected DynamicObject getAccountByElectronicNo(Map<String, DynamicObject> selectAccountMap, String electronicNo) {
        if (ObjectUtils.isEmpty(selectAccountMap) || StringUtils.isEmpty((CharSequence)electronicNo)) {
            return null;
        }
        for (DynamicObject dynamicObject : selectAccountMap.values()) {
            if (!StringUtils.equals((CharSequence)electronicNo, (CharSequence)dynamicObject.getString("electronic_no"))) continue;
            return dynamicObject;
        }
        return null;
    }

    public Map<String, String> getFailRecordedAccount(JSONArray failArray, Map<String, DynamicObject> selectAccountMap, List<DynamicObject> updateAccountList, String description, String billType) {
        HashMap serialNoStatusMap;
        block3: {
            block2: {
                serialNoStatusMap = Maps.newHashMap();
                if (CollectionUtils.isEmpty((Collection)failArray)) break block2;
                for (int i = 0; i < failArray.size(); ++i) {
                    JSONObject fail = failArray.getJSONObject(i);
                    String mapKey = this.getBillNo(fail.getString("invoiceCode"), fail.getString("invoiceNo"), billType, fail.getDate("invoiceDate"));
                    DynamicObject updateAccount = selectAccountMap.get(mapKey);
                    if (updateAccount == null && (updateAccount = this.getAccountByElectronicNo(selectAccountMap, fail.getString("invoiceNo"))) == null) continue;
                    updateAccount.set("handle_status", (Object)"1");
                    updateAccount.set("description", (Object)this.subDescription(fail.getString("description")));
                    updateAccount.set("select_result", (Object)fail.getString("entryResult"));
                    updateAccount.set("update_time", (Object)new Date());
                    updateAccountList.add(updateAccount);
                    this.setFailInvoiceRecorded(serialNoStatusMap, updateAccount);
                }
                break block3;
            }
            if (!updateAccountList.isEmpty()) break block3;
            for (Map.Entry<String, DynamicObject> entry : selectAccountMap.entrySet()) {
                DynamicObject failAccount = entry.getValue();
                failAccount.set("handle_status", (Object)"1");
                failAccount.set("select_result", (Object)"31");
                failAccount.set("description", (Object)description);
                failAccount.set("update_time", (Object)new Date());
                updateAccountList.add(failAccount);
                this.setFailInvoiceRecorded(serialNoStatusMap, failAccount);
            }
        }
        return serialNoStatusMap;
    }

    public Map<String, String> getRecordAccountDiscardTask(Map<String, DynamicObject> selectAccountMap, List<DynamicObject> updateAccountList, String description) {
        HashMap serialNoStatusMap = Maps.newHashMap();
        for (Map.Entry<String, DynamicObject> entry : selectAccountMap.entrySet()) {
            DynamicObject failAccount = entry.getValue();
            failAccount.set("handle_status", (Object)"1");
            failAccount.set("select_result", (Object)"43");
            failAccount.set("description", (Object)description);
            failAccount.set("update_time", (Object)new Date());
            updateAccountList.add(failAccount);
            this.setFailInvoiceRecorded(serialNoStatusMap, failAccount);
        }
        return serialNoStatusMap;
    }

    private void setFailInvoiceRecorded(Map<String, String> serialNoStatusMap, DynamicObject failAccount) {
        if (StringUtils.isNotEmpty((CharSequence)failAccount.getString("serial_no"))) {
            String preAuthenticateFlag = failAccount.getString("pre_authenticate_flag");
            if (StringUtils.isEmpty((CharSequence)preAuthenticateFlag)) {
                preAuthenticateFlag = "01";
            }
            serialNoStatusMap.put(failAccount.getString("serial_no"), preAuthenticateFlag);
        }
    }

    protected void save(DynamicObject selectLog, List<DynamicObject> updateAccountList, Map<String, String> serialNoStatusMap) {
        try (TXHandle h = TX.required();){
            try {
                this.recoverMainInvoiceStatus(serialNoStatusMap);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{selectLog});
                SaveServiceHelper.save((DynamicObject[])updateAccountList.toArray(new DynamicObject[updateAccountList.size()]));
            }
            catch (Throwable e) {
                LOGGER.error("\u52fe\u9009\u65e5\u5fd7/\u53f0\u8d26\u5931\u8d25", e);
                h.markRollback();
                throw e;
            }
        }
    }

    public Map<String, String> getSelectAccountDiscardTask(Map<String, DynamicObject> selectAccountMap, List<DynamicObject> updateAccountList, String description) {
        HashMap serialNoStatusMap = Maps.newHashMap();
        for (Map.Entry<String, DynamicObject> entry : selectAccountMap.entrySet()) {
            DynamicObject failAccount = entry.getValue();
            failAccount.set("handle_status", (Object)"1");
            failAccount.set("select_result", (Object)"43");
            failAccount.set("description", (Object)description);
            failAccount.set("update_time", (Object)new Date());
            updateAccountList.add(failAccount);
            this.setFailInvoiceStatus(serialNoStatusMap, failAccount);
        }
        return serialNoStatusMap;
    }

    public Map<String, String> getFailStatusMap(JSONArray failArray, Map<String, DynamicObject> selectAccountMap, List<DynamicObject> updateAccountList, String description, String billType) {
        HashMap serialNoStatusMap;
        block4: {
            block3: {
                serialNoStatusMap = Maps.newHashMap();
                if (CollectionUtils.isEmpty((Collection)failArray)) break block3;
                for (int i = 0; i < failArray.size(); ++i) {
                    JSONObject fail = failArray.getJSONObject(i);
                    String mapKey = this.getBillNo(fail.getString("invoiceCode"), fail.getString("invoiceNo"), billType, fail.getDate("invoiceDate"));
                    DynamicObject updateAccount = selectAccountMap.get(mapKey);
                    if (updateAccount == null && (updateAccount = this.getAccountByElectronicNo(selectAccountMap, fail.getString("invoiceNo"))) == null) continue;
                    String selectResult = fail.getString("selectResult");
                    if (StringUtils.isNotEmpty((CharSequence)selectResult) && selectResult.startsWith("8-")) {
                        selectResult = "8";
                    }
                    updateAccount.set("handle_status", (Object)"1");
                    updateAccount.set("select_result", (Object)selectResult);
                    updateAccount.set("description", (Object)this.getSelectMsg(fail));
                    updateAccount.set("update_time", (Object)new Date());
                    updateAccountList.add(updateAccount);
                    this.setFailInvoiceStatus(serialNoStatusMap, updateAccount);
                }
                break block4;
            }
            if (!updateAccountList.isEmpty()) break block4;
            for (Map.Entry<String, DynamicObject> entry : selectAccountMap.entrySet()) {
                DynamicObject failAccount = entry.getValue();
                failAccount.set("handle_status", (Object)"1");
                failAccount.set("select_result", (Object)"31");
                failAccount.set("description", (Object)description);
                failAccount.set("update_time", (Object)new Date());
                updateAccountList.add(failAccount);
                this.setFailInvoiceStatus(serialNoStatusMap, failAccount);
            }
        }
        return serialNoStatusMap;
    }

    public void updateMainSaveLog(Map<String, String> serialNoStatusMap, DynamicObject selectLog, List<DynamicObject> updateAccountList) {
        this.updateMainSaveLog(serialNoStatusMap, selectLog, updateAccountList, "");
    }

    public void updateMainSaveLog(Map<String, String> serialNoStatusMap, DynamicObject selectLog, List<DynamicObject> updateAccountList, String selectOperaType) {
        try (TXHandle h = TX.required();){
            try {
                this.recoverMainInvoiceStatus(serialNoStatusMap, selectOperaType);
                selectLog.set("update_time", (Object)new Date());
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{selectLog});
                SaveServiceHelper.save((DynamicObject[])updateAccountList.toArray(new DynamicObject[updateAccountList.size()]));
            }
            catch (Throwable e) {
                LOGGER.error("\u52fe\u9009\u65e5\u5fd7/\u53f0\u8d26\u5931\u8d25", e);
                h.markRollback();
                throw e;
            }
        }
    }

    protected String subDescription(String description) {
        if (StringUtils.isNotBlank((CharSequence)description) && description.length() > 100) {
            description = description.substring(0, 100);
        }
        return description;
    }

    protected String getSelectMsg(JSONObject fail) {
        if (fail == null) {
            return "";
        }
        String msg = fail.getString("description");
        if (StringUtils.isEmpty((CharSequence)msg)) {
            msg = MetadataUtil.getComboItemName("rim_select_account", "select_result", fail.getString("selectResult"));
        }
        if (StringUtils.isNotBlank((CharSequence)msg) && msg.length() > 100) {
            msg = msg.substring(0, 100);
        }
        return msg;
    }

    public void saveAccountRecorded(Map<String, String> serialNoStatusMap, DynamicObject selectLog, List<DynamicObject> updateAccountList) {
        this.saveAccountRecorded(serialNoStatusMap, selectLog, updateAccountList, "");
    }

    public void saveAccountRecorded(Map<String, String> serialNoStatusMap, DynamicObject selectLog, List<DynamicObject> updateAccountList, String selectOperaType) {
        try (TXHandle h = TX.required();){
            try {
                this.recoverMainInvoiceRecordedStatus(serialNoStatusMap, selectOperaType);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{selectLog});
                SaveServiceHelper.save((DynamicObject[])updateAccountList.toArray(new DynamicObject[updateAccountList.size()]));
            }
            catch (Throwable e) {
                LOGGER.error("\u52fe\u9009\u65e5\u5fd7/\u53f0\u8d26\u5931\u8d25", e);
                h.markRollback();
                throw e;
            }
        }
    }

    private void recoverMainInvoiceRecordedStatus(Map<String, String> serialNoStatusMap, String selectOperaType) {
        if (!CollectionUtils.isEmpty(serialNoStatusMap)) {
            LOGGER.info("\u5165\u8d26\u7533\u8bf7\u5931\u8d25\uff1a\u56de\u6eda\u5165\u8d26\u72b6\u6001:{}", serialNoStatusMap);
            QFilter invoiceFilter = new QFilter("serial_no", "in", serialNoStatusMap.keySet());
            String tenantNo = TenantUtils.getTenantNo();
            QFilter tenantFilter = new QFilter("tenant_no", "=", (Object)tenantNo);
            QFilter taxRecordedStatusFilter = new QFilter("tax_recorded_status", "in", (Object)"11");
            DynamicObject[] mainDynamicObjects = BusinessDataServiceHelper.load((String)"rim_invoice", (String)MetadataUtil.getFields("rim_invoice"), (QFilter[])new QFilter[]{invoiceFilter, taxRecordedStatusFilter, tenantFilter});
            if (mainDynamicObjects == null || mainDynamicObjects.length == 0) {
                LOGGER.info("\u4e0d\u5b58\u5728\u9700\u8981\u56de\u6eda\u5165\u8d26\u72b6\u6001\u7684\u53d1\u7968\u6570\u636e");
                return;
            }
            if (mainDynamicObjects != null && mainDynamicObjects.length > 0) {
                HashMap<Long, List> typeMap = new HashMap<Long, List>(8);
                for (DynamicObject mainDynamicObject : mainDynamicObjects) {
                    String serialNo1 = mainDynamicObject.getString("serial_no");
                    Long typeId = mainDynamicObject.getLong("invoice_type_id");
                    List list = typeMap.getOrDefault(typeId, new ArrayList(8));
                    list.add(serialNo1);
                    typeMap.put(typeId, list);
                    mainDynamicObject.set("tax_recorded_status", (Object)serialNoStatusMap.getOrDefault(mainDynamicObject.getString("serial_no"), "01"));
                    mainDynamicObject.set("modifytime", (Object)new Date());
                    if (!"2".equals(selectOperaType)) continue;
                    InvoiceSaveService.setExtInfo(mainDynamicObject, InvoiceSaveConstant.EXT_AUTO_RZ_FLAG, "1");
                }
                try (TXHandle h = TX.required();){
                    try {
                        for (Map.Entry entry : typeMap.entrySet()) {
                            String entity;
                            Object[] invoiceList;
                            if (ObjectUtils.isEmpty(entry) || ArrayUtils.isEmpty((Object[])(invoiceList = InvoiceQueryService.loadAllBySerialNo(entity = InputInvoiceTypeEnum.getEntity((Long)entry.getKey()), tenantNo, (Collection)entry.getValue())))) continue;
                            for (Object bodyDynamicObject : invoiceList) {
                                bodyDynamicObject.set("tax_recorded_status", (Object)serialNoStatusMap.getOrDefault(bodyDynamicObject.getString("serial_no"), "01"));
                                bodyDynamicObject.set("modifytime", (Object)new Date());
                            }
                            SaveServiceHelper.save((DynamicObject[])invoiceList);
                        }
                        SaveServiceHelper.save((DynamicObject[])mainDynamicObjects);
                        ThreadPools.executeOnceIncludeRequestContext((String)"AsyncDeductSelectService.saveRecordedInvoiceLog1", () -> this.saveLogRecordedFail(serialNoStatusMap));
                    }
                    catch (Throwable e) {
                        h.markRollback();
                        throw e;
                    }
                }
            }
        }
    }

    private void saveLogRecordedFail(Map<String, String> serialNoStatusMap) {
        if (!CollectionUtils.isEmpty(serialNoStatusMap)) {
            for (String serialNo : serialNoStatusMap.keySet()) {
                JSONObject info = new JSONObject();
                info.put("opeateType", (Object)ResManager.loadKDString((String)"\u6062\u590d\u5165\u8d26\u5904\u7406\u4e2d\u7684\u5165\u8d26\u72b6\u6001", (String)"AsyncDeductSelectService_0", (String)"imc-rim-common", (Object[])new Object[0]));
                info.put("tax_recorded_status", (Object)serialNoStatusMap.getOrDefault(serialNo, "01"));
                info.put("traceId", (Object)RequestContext.get().getTraceId());
                InvoiceLog.insert("tax_recorded", serialNo, info.toJSONString());
            }
        }
    }

    public void updateSuccessRecordedInfo(List<JSONObject> updateInvoiceList) {
        LOGGER.info("\u5165\u8d26\u7533\u8bf7\u6210\u529f\uff0c\u66f4\u65b0\u5165\u8d26\u53c2\u6570:" + updateInvoiceList);
        if (null != updateInvoiceList && updateInvoiceList.size() > 0) {
            Map<String, JSONObject> serialNoMap = updateInvoiceList.stream().collect(Collectors.toMap(t -> t.getString("serial_no"), t -> t, (k1, k2) -> k1));
            QFilter invoiceFilter = new QFilter("serial_no", "in", serialNoMap.keySet());
            String tenantNo = TenantUtils.getTenantNo();
            QFilter tenantFilter = new QFilter("tenant_no", "=", (Object)tenantNo);
            DynamicObject[] mainDynamicObjects = BusinessDataServiceHelper.load((String)"rim_invoice", (String)MetadataUtil.getFields("rim_invoice"), (QFilter[])new QFilter[]{invoiceFilter, tenantFilter});
            if (mainDynamicObjects == null || mainDynamicObjects.length == 0) {
                LOGGER.info("\u4e0d\u5b58\u5728\u9700\u8981\u66f4\u65b0\u7a0e\u5c40\u5165\u8d26\u7684\u53d1\u7968\u6570\u636e");
                return;
            }
            if (mainDynamicObjects != null && mainDynamicObjects.length > 0) {
                HashMap<Long, List> typeMap = new HashMap<Long, List>(8);
                for (DynamicObject mainDynamicObject : mainDynamicObjects) {
                    String serialNo1 = mainDynamicObject.getString("serial_no");
                    Long typeId = mainDynamicObject.getLong("invoice_type_id");
                    List list = typeMap.getOrDefault(typeId, new ArrayList(8));
                    list.add(serialNo1);
                    typeMap.put(typeId, list);
                    JSONObject jsonObject = serialNoMap.get(mainDynamicObject.getString("serial_no"));
                    this.setRecordedInfo(mainDynamicObject, jsonObject);
                }
                try (TXHandle h = TX.required();){
                    try {
                        for (Map.Entry entry : typeMap.entrySet()) {
                            String entity;
                            Object[] invoiceList;
                            if (ObjectUtils.isEmpty(entry) || ArrayUtils.isEmpty((Object[])(invoiceList = InvoiceQueryService.loadAllBySerialNo(entity = InputInvoiceTypeEnum.getEntity((Long)entry.getKey()), tenantNo, (Collection)entry.getValue())))) continue;
                            for (Object bodyDynamicObject : invoiceList) {
                                JSONObject jsonObject = serialNoMap.get(bodyDynamicObject.getString("serial_no"));
                                this.setRecordedInfo((DynamicObject)bodyDynamicObject, jsonObject);
                                String recordedMxUuid = bodyDynamicObject.getString("recorded_mxuuid");
                                String recordedRzUuid = bodyDynamicObject.getString("recorded_rzuuid");
                                if ((!StringUtils.isBlank((CharSequence)recordedMxUuid) || !StringUtils.isNotBlank((CharSequence)jsonObject.getString("mxuuid"))) && (!StringUtils.isBlank((CharSequence)recordedRzUuid) || !StringUtils.isNotBlank((CharSequence)jsonObject.getString("rzuuid")))) continue;
                                bodyDynamicObject.set("recorded_mxuuid", (Object)jsonObject.getString("mxuuid"));
                                bodyDynamicObject.set("recorded_rzuuid", (Object)jsonObject.getString("rzuuid"));
                            }
                            SaveServiceHelper.save((DynamicObject[])invoiceList);
                        }
                        SaveServiceHelper.save((DynamicObject[])mainDynamicObjects);
                        ThreadPools.executeOnceIncludeRequestContext((String)"AsyncDeductSelectService.saveRecordedInvoiceLog2", () -> this.saveLogRecordedSuccess(serialNoMap));
                    }
                    catch (Throwable e) {
                        h.markRollback();
                        throw e;
                    }
                }
            }
        }
    }

    private void saveLogRecordedSuccess(Map<String, JSONObject> serialNoStatusMap) {
        if (!CollectionUtils.isEmpty(serialNoStatusMap)) {
            String traceId = RequestContext.get().getTraceId();
            for (Map.Entry<String, JSONObject> entry : serialNoStatusMap.entrySet()) {
                JSONObject info = new JSONObject();
                String serialNo = entry.getKey();
                JSONObject example = entry.getValue();
                info.put("opeateType", (Object)ResManager.loadKDString((String)"\u5165\u8d26\u6210\u529f\uff0c\u66f4\u65b0\u5165\u8d26\u72b6\u6001", (String)"AsyncDeductSelectService_1", (String)"imc-rim-common", (Object[])new Object[0]));
                info.put("tax_recorded_status", (Object)example.getString("tax_recorded_status"));
                info.put("select_time", (Object)example.getDate("select_time"));
                info.put("traceId", (Object)traceId);
                InvoiceLog.insert("tax_recorded", serialNo, info.toJSONString());
            }
        }
    }

    private void setRecordedInfo(DynamicObject mainDynamicObject, JSONObject jsonObject) {
        String dktype = jsonObject.getString("dktype");
        String taxRecordedStatus = jsonObject.getString("tax_recorded_status");
        mainDynamicObject.set("tax_recorded_status", (Object)taxRecordedStatus);
        mainDynamicObject.set("tax_recorded_purpose", (Object)taxRecordedStatus);
        if ("4".equals(dktype)) {
            mainDynamicObject.set("tax_recorded_time", (Object)jsonObject.getDate("select_time"));
        }
        if ("5".equals(dktype)) {
            mainDynamicObject.set("tax_recorded_period", (Object)jsonObject.getDate("select_time"));
            if (StringUtils.isNotBlank((CharSequence)jsonObject.getString("lqTaxRecordedTime"))) {
                mainDynamicObject.set("tax_recorded_time", (Object)DateUtils.stringToDate(jsonObject.getString("lqTaxRecordedTime"), "yyyyMMdd"));
            }
        }
        if ("06".equals(taxRecordedStatus)) {
            mainDynamicObject.set("tax_recorded_purpose", (Object)"");
            mainDynamicObject.set("tax_recorded_time", null);
            mainDynamicObject.set("tax_recorded_period", null);
        }
        mainDynamicObject.set("modifytime", (Object)new Date());
    }

    public void queryRecordedCommitResult(DynamicObject selectLog) {
        LOGGER.info("\u8be5\u7ec4\u7ec7\u7684\u6536\u7968\u901a\u9053\u6682\u4e0d\u652f\u6301\u7a0e\u5c40\u5165\u8d26\u64cd\u4f5c");
    }

    public void setUpdateInvoiceData(JSONObject example, DynamicObject updateAccount, JSONObject successJson, String deductibleMode) {
    }

    public void updateInvoiceData(String taxNo, JSONArray updateInvoiceArray, String deductibleMode) {
        DeductInvoiceOperateService deductInvoiceOperateService = new DeductInvoiceOperateService();
        deductInvoiceOperateService.updateBatchSelectedInvoice(updateInvoiceArray, deductibleMode, taxNo);
    }

    public void setFailInvoiceStatus(Map<String, String> serialNoStatusMap, DynamicObject failAccount) {
        if (StringUtils.isNotEmpty((CharSequence)failAccount.getString("serial_no"))) {
            String preAuthenticateFlag = failAccount.getString("pre_authenticate_flag");
            if (StringUtils.isEmpty((CharSequence)preAuthenticateFlag) || "5".equals(preAuthenticateFlag)) {
                preAuthenticateFlag = "1".equals(failAccount.getString("select_status")) ? "0" : "1";
            }
            serialNoStatusMap.put(failAccount.getString("serial_no"), preAuthenticateFlag);
        }
    }

    protected JSONObject doSelect(Long orgId, JSONObject param) {
        return null;
    }
}

