/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.deduction;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.rim.common.constant.CheckContant;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.InvoiceSaveConstant;
import kd.imc.rim.common.ek.EkServiceFactory;
import kd.imc.rim.common.invoice.deduction.DeductInvoiceOperateService;
import kd.imc.rim.common.invoice.deduction.DeductSelectService;
import kd.imc.rim.common.invoice.deduction.DeductService;
import kd.imc.rim.common.invoice.deduction.DeductServiceFactory;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DeductionUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.common.utils.TenantUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.compress.utils.Sets;

public class AutoDeductSelectService {
    private static Log LOGGER = LogFactory.getLog(AutoDeductSelectService.class);

    public void autoDeductSelect(DynamicObject config, Long orgId, String taxNo) {
        String dkType = DeductionConstant.getDkType(taxNo);
        try {
            if (StringUtils.isEmpty((CharSequence)taxNo) || Objects.equals(orgId, Long.valueOf("0"))) {
                LOGGER.info("\u7a0e\u53f7\u6216\u8005\u7ec4\u7ec7id\u4e3a\u7a7a,{}-{}", (Object)taxNo, (Object)orgId);
                return;
            }
            if (TenantUtils.isSmallScaleTaxpayer(taxNo)) {
                LOGGER.info("\u7a0e\u53f7:{},orgid:{}-\u4f01\u4e1a\u6027\u8d28\u4e3a\u5c0f\u89c4\u6a21\u7eb3\u7a0e\u4eba,\u4e0d\u652f\u6301\u52fe\u9009\u529f\u80fd", (Object)taxNo, (Object)orgId);
                return;
            }
            DeductService deductService = DeductServiceFactory.newInstanceForDeduct(dkType, orgId, null);
            if (deductService == null) {
                LOGGER.info("\u7a0e\u5c40\u63a5\u53e3\u914d\u7f6e\u9519\u8bef");
                return;
            }
            String taxperiodStr = deductService.syncGetTaxperiod(taxNo);
            Date taxperiod = null;
            if (!StringUtils.isNotEmpty((CharSequence)taxperiodStr)) {
                LOGGER.info("\u83b7\u53d6\u5f53\u524d\u5c5e\u671f\u9519\u8bef{}", (Object)taxNo);
                return;
            }
            taxperiod = DateUtils.stringToDate(taxperiodStr, "yyyyMM");
            List<DynamicObject> invoiceList = this.queryInvoiceByConfig(config, taxperiod, orgId, taxNo);
            if (!CollectionUtils.isEmpty(invoiceList)) {
                ArrayList vatDeductSerialNos = Lists.newArrayList();
                ArrayList taxDeductSerialNos = Lists.newArrayList();
                HashMap customMap = Maps.newHashMap();
                HashMap vatMap = Maps.newHashMap();
                HashMap dkdjMap = Maps.newHashMap();
                for (DynamicObject dynamicObject : invoiceList) {
                    Long invoictType = DynamicObjectUtil.getDynamicObjectLongValue(dynamicObject.get("invoice_type"));
                    if (InputInvoiceTypeEnum.WITHHOLDING.getCode().equals(invoictType)) {
                        this.getDeductType(dynamicObject, dkdjMap);
                        vatDeductSerialNos.add(dynamicObject.getString("serial_no"));
                        continue;
                    }
                    if (InputInvoiceTypeEnum.HGJKS.getCode().equals(invoictType)) {
                        this.getDeductType(dynamicObject, customMap);
                        vatDeductSerialNos.add(dynamicObject.getString("serial_no"));
                        continue;
                    }
                    if (InputInvoiceTypeEnum.canDeduction(invoictType).booleanValue()) {
                        this.getDeductType(dynamicObject, vatMap);
                        vatDeductSerialNos.add(dynamicObject.getString("serial_no"));
                        continue;
                    }
                    if (!InputInvoiceTypeEnum.canTransportDeduction(invoictType).booleanValue()) continue;
                    taxDeductSerialNos.add(dynamicObject.getString("serial_no"));
                }
                JSONObject param = new JSONObject();
                param.put("orgId", (Object)orgId);
                param.put("taxNo", (Object)taxNo);
                LOGGER.info("\u81ea\u52a8\u62b5\u6263-\u7a0e\u5c40\u53d1\u7968\u62b5\u6263:{},{}", (Object)taxNo, (Object)vatDeductSerialNos);
                param.put("selectOperationType", (Object)"2");
                DeductSelectService invoiceDeductService = DeductServiceFactory.newInstanceForDeductSelect(dkType);
                if (invoiceDeductService == null) {
                    LOGGER.info("\u7a0e\u5c40\u63a5\u53e3\u914d\u7f6e\u9519\u8bef");
                    return;
                }
                param.put("deductibleMode", (Object)"1");
                param.put("billType", (Object)"2");
                this.handleDeductSelect(param, dkdjMap, invoiceDeductService);
                param.put("billType", (Object)"1");
                this.handleDeductSelect(param, customMap, invoiceDeductService);
                param.put("billType", (Object)"0");
                this.handleDeductSelect(param, vatMap, invoiceDeductService);
                if (!CollectionUtils.isEmpty((Collection)taxDeductSerialNos)) {
                    LOGGER.info("\u81ea\u52a8\u62b5\u6263-\u65c5\u5ba2\u8fd0\u8f93\u62b5\u6263:{},{}", (Object)taxNo, (Object)taxDeductSerialNos);
                    DeductInvoiceOperateService operateService = new DeductInvoiceOperateService();
                    operateService.transportDeductBySerialNo(taxDeductSerialNos, "1", taxperiod, "6", "2");
                }
            }
        }
        catch (Exception e) {
            LOGGER.info("autoDeductSelectError" + taxNo, (Object)e);
        }
    }

    private void handleDeductSelect(JSONObject param, Map<String, JSONArray> map, DeductSelectService invoiceDeductService) {
        if (!CollectionUtils.isEmpty(map)) {
            Set<Map.Entry<String, JSONArray>> entrySet = map.entrySet();
            for (Map.Entry<String, JSONArray> entry : entrySet) {
                String deductibleMode = DeductionConstant.getDeductibleMode(entry.getKey(), "1");
                Long orgId = param.getLong("orgId");
                String taxNo = param.getString("taxNo");
                if (!"2".equals(deductibleMode) && !"-2".equals(deductibleMode) && DeductionUtils.checkStatisticsStatus(taxNo, orgId)) {
                    LOGGER.info("\u7a0e\u53f7:{},orgid:{}-\u5f53\u524d\u7a0e\u6b3e\u6240\u5c5e\u671f\u7edf\u8ba1\u8868\u5df2\u751f\u6210\uff0c\u8bf7\u64a4\u9500\u7edf\u8ba1\u518d\u52fe\u9009\uff0c\u6216\u4f7f\u7528\u3010\u5f53\u671f\u62b5\u6263\u52fe\u9009\u7edf\u8ba1\u3011\u67e5\u8be2\u66f4\u65b0\u7edf\u8ba1", (Object)taxNo, (Object)orgId);
                    continue;
                }
                param.put("deductibleMode", (Object)deductibleMode);
                param.put("invoices", (Object)entry.getValue());
                JSONObject result2 = invoiceDeductService.batchSelectInvoices(param);
                LOGGER.info("\u81ea\u52a8\u52fe\u9009\u7ed3\u679c:{},{}", (Object)param.getString("taxNo"), (Object)result2);
            }
        }
    }

    private void getDeductType(DynamicObject invoice, Map<String, JSONArray> map) {
        String deductionPurpose = invoice.getString("deduction_purpose");
        if (StringUtils.isEmpty((CharSequence)deductionPurpose)) {
            deductionPurpose = "1";
        }
        JSONArray invoiceList = map.getOrDefault(deductionPurpose, new JSONArray());
        invoiceList.add((Object)DeductionConstant.createSelectJson(invoice));
        map.put(deductionPurpose, invoiceList);
    }

    public List<DynamicObject> queryInvoiceByConfig(DynamicObject config, Date taxperiod, Long orgId, String taxno) {
        String auditStatus;
        String invoiceresouce;
        String receipttype;
        List<Long> orgList = TenantUtils.queryChildOrgIdList(taxno);
        if (orgList != null && !orgList.isEmpty() && orgId != null && !orgList.contains(orgId)) {
            orgList.add(orgId);
        }
        String deductconfig = config.getString("deductconfig");
        BigDecimal inputTaxAmount = config.getBigDecimal("input_taxamount");
        String orderBy = "createtime asc";
        BigDecimal surplusDeductAmount = BigDecimal.ZERO;
        String deductconfigtype = config.getString("deductconfigtype");
        if ("1".equals(deductconfig)) {
            if (inputTaxAmount == null || inputTaxAmount.compareTo(BigDecimal.ZERO) <= 0) {
                LOGGER.info("\u5f53\u671f\u62b5\u6263\u7a0e\u989d\u5c0f\u4e8e0,\u4e0d\u53ef\u62b5\u6263,{}", (Object)taxno);
                return null;
            }
            orderBy = "1".equals(deductconfigtype) ? "createtime asc" : "invoice_date asc";
            BigDecimal totalDeductedTaxAmount = this.getDeductedTaxAmount(orgList, taxno, taxperiod);
            surplusDeductAmount = inputTaxAmount.multiply(new BigDecimal("1000")).subtract(totalDeductedTaxAmount);
            if (surplusDeductAmount.compareTo(BigDecimal.ZERO) <= 0) {
                LOGGER.info("\u5269\u4f59\u62b5\u6263\u7a0e\u989d\u5c0f\u4e8e0,{}\u4e0d\u518d\u81ea\u52a8\u62b5\u6263", (Object)taxno);
                return null;
            }
        }
        Set<Object> serialNos = Sets.newHashSet((Object[])new String[0]);
        DynamicObjectCollection businessbill = config.getDynamicObjectCollection("businessbill");
        ArrayList expenseTypeNumbers = Lists.newArrayList();
        if (!CollectionUtils.isEmpty((Collection)businessbill)) {
            for (DynamicObject dynamicObject : businessbill) {
                DynamicObject fbasedataid = dynamicObject.getDynamicObject("fbasedataid");
                expenseTypeNumbers.add(fbasedataid.getString("number"));
            }
            String tick = config.getString("tick");
            List<String> deductionFlagList = null;
            if (StringUtils.isNotEmpty((CharSequence)tick) && !tick.contains("-1")) {
                deductionFlagList = CommonUtils.getMultiValues(tick);
            }
            if (CollectionUtils.isEmpty((Collection)(serialNos = this.getExpenseSerialNos(orgList, expenseTypeNumbers, deductionFlagList)))) {
                LOGGER.info("\u6ca1\u6709\u5355\u636e\u6570\u636e,\u4e0d\u62b5\u6263{}", (Object)taxno);
                return null;
            }
        }
        ArrayList filters = Lists.newArrayList();
        filters.add(new QFilter("org", "in", orgList));
        String periodConfig = config.getString("preiod");
        if (StringUtils.isNotEmpty((CharSequence)periodConfig)) {
            periodConfig = periodConfig.replace(",", "").trim();
            LOGGER.info("\u6309\u6240\u5c5e\u7a0e\u671f{}", (Object)periodConfig);
            if ("1".equals(periodConfig)) {
                filters.add(new QFilter("account_date", "<", (Object)taxperiod));
            } else if ("2".equals(periodConfig)) {
                filters.add(new QFilter("account_date", ">=", (Object)taxperiod));
                filters.add(new QFilter("account_date", "<", (Object)DateUtils.addMonth(taxperiod, 1)));
            } else if ("3".equals(periodConfig)) {
                filters.add(new QFilter("account_date", ">=", (Object)DateUtils.addMonth(taxperiod, 1)));
            } else if ("12".equals(periodConfig)) {
                filters.add(new QFilter("account_date", "<", (Object)DateUtils.addMonth(taxperiod, 1)));
            } else if ("23".equals(periodConfig)) {
                filters.add(new QFilter("account_date", ">=", (Object)taxperiod));
            }
        }
        if (!CollectionUtils.isEmpty((Collection)serialNos)) {
            filters.add(new QFilter("serial_no", "in", (Object)serialNos));
        }
        filters.add(new QFilter("deduction_flag", "=", (Object)"1"));
        filters.add(new QFilter("invoice_date", "<=", (Object)DateUtils.getLastDateOfMonth(taxperiod)));
        QFilter taxnoFilter = new QFilter("buyer_tax_no", "=", (Object)taxno);
        filters.add(taxnoFilter);
        String pretick = config.getString("pretick");
        QFilter selectStatusFilter = null;
        QFilter transportStatusFilter = null;
        if (StringUtils.isNotEmpty((CharSequence)pretick)) {
            if (pretick.contains("-1")) {
                selectStatusFilter = new QFilter("authenticate_flag", "in", (Object)new String[]{"0", "4"});
                transportStatusFilter = new QFilter("transport_deduction", "in", (Object)new String[]{"0", "2"});
            } else {
                List<String> multiValues = CommonUtils.getMultiValues(pretick);
                selectStatusFilter = new QFilter("authenticate_flag", "in", multiValues);
                ArrayList transportStatus = Lists.newArrayList();
                for (String value : multiValues) {
                    if ("4".equals(value)) {
                        transportStatus.add("2");
                        continue;
                    }
                    transportStatus.add(value);
                }
                transportStatusFilter = new QFilter("transport_deduction", "in", (Object)transportStatus);
            }
        } else {
            selectStatusFilter = new QFilter("authenticate_flag", "in", (Object)new String[]{"0", "4"});
            transportStatusFilter = new QFilter("transport_deduction", "in", (Object)new String[]{"0", "2"});
        }
        String invovicestatus = config.getString("invovicestatus");
        if (StringUtils.isNotEmpty((CharSequence)invovicestatus) && !invovicestatus.contains("-1")) {
            filters.add(new QFilter("expense_status", "in", CommonUtils.getMultiValues(invovicestatus)));
        }
        if (StringUtils.isNotEmpty((CharSequence)(receipttype = config.getString("receipttype"))) && !receipttype.contains("-1")) {
            filters.add(new QFilter("original_state", "in", CommonUtils.getMultiValues(receipttype)));
        }
        if (StringUtils.isNotEmpty((CharSequence)(invoiceresouce = config.getString("invoiceresouce"))) && !invoiceresouce.contains("-1")) {
            filters.add(new QFilter("collect_type", "in", CommonUtils.getMultiValues(invoiceresouce)));
        }
        if (StringUtils.isNotEmpty((CharSequence)(auditStatus = config.getString("audit_result"))) && !auditStatus.contains("-1")) {
            filters.add(new QFilter("audit_result", "in", CommonUtils.getMultiValues(auditStatus)));
        }
        String checkStatus = config.getString("check_status");
        QFilter checkFilter = new QFilter("check_status", "in", (Object)CheckContant.getSuccessStatus());
        if (StringUtils.isNotEmpty((CharSequence)checkStatus) && !checkStatus.contains("-1")) {
            checkFilter = new QFilter("check_status", "in", CommonUtils.getMultiValues(checkStatus));
        }
        filters.add(checkFilter);
        filters.add(new QFilter("delete", "=", (Object)"1"));
        filters.add(new QFilter("cancel_select_type", "!=", (Object)"1"));
        List<QFilter> ekFilterList = EkServiceFactory.getInvoiceSelectService().getAutoDeductQFilter(config);
        if (ekFilterList != null && !ekFilterList.isEmpty()) {
            filters.addAll(ekFilterList);
        }
        String invoicetype = config.getString("invoicetype");
        ArrayList dkdjInvoiceTypes = Lists.newArrayList();
        dkdjInvoiceTypes.add(InputInvoiceTypeEnum.WITHHOLDING.getCode());
        ArrayList vatInvoiceTypes = Lists.newArrayList();
        ArrayList transportInvoiceTypes = Lists.newArrayList();
        Collections.addAll(transportInvoiceTypes, InputInvoiceTypeEnum.getTransportTypes());
        if (StringUtils.isNotEmpty((CharSequence)invoicetype) && !invoicetype.contains("-1")) {
            if (!invoicetype.contains("00")) {
                transportInvoiceTypes.clear();
            }
            if (!invoicetype.contains("47")) {
                dkdjInvoiceTypes.clear();
            }
            List<String> values = CommonUtils.getMultiValues(invoicetype);
            for (String value : values) {
                Long longType;
                if ("00".equals(value) || "47".equals(value) || !InputInvoiceTypeEnum.canDeduction(longType = InputInvoiceTypeEnum.getInvoiceTypeByAwsType(value)).booleanValue()) continue;
                vatInvoiceTypes.add(longType);
            }
        } else {
            Collections.addAll(vatInvoiceTypes, InputInvoiceTypeEnum.getDeductionTypes());
        }
        ArrayList invoiceCollectionAll = Lists.newArrayList();
        vatInvoiceTypes.remove(InputInvoiceTypeEnum.WITHHOLDING.getCode());
        QFilter vatTypes = new QFilter("invoice_type", "in", (Object)vatInvoiceTypes);
        String queryFeilds = "id,serial_no,invoice_type,invoice_code,invoice_no,invoice_date,invoice_amount,total_tax_amount,total_amount,authenticate_flag,effective_tax_amount,buyer_tax_no,org,isvoucher,invoice_status,deduction_flag,deduction_purpose,not_deductible_type,saler_name,saler_tax_no,output_type,remark,electronic_no,createtime,purchase_ticket,agric_handle_status,invoice_risk_level,ext_info";
        int pageSize = RimConfigUtils.getPageSizeFromConfig(5000, "rim_deduction", "auto_select_pagesize");
        if (!CollectionUtils.isEmpty((Collection)vatInvoiceTypes)) {
            filters.add(vatTypes);
            filters.add(selectStatusFilter);
            DynamicObjectCollection vatInvoiceCollection = QueryServiceHelper.query((String)"rim_invoice", (String)queryFeilds, (QFilter[])filters.toArray(new QFilter[filters.size()]), (String)orderBy, (int)pageSize);
            invoiceCollectionAll.addAll(vatInvoiceCollection);
        }
        QFilter dkdjInvoiceTypeFilter = new QFilter("invoice_type", "in", (Object)dkdjInvoiceTypes);
        if (!CollectionUtils.isEmpty((Collection)dkdjInvoiceTypes)) {
            filters.remove(vatTypes);
            filters.remove(checkFilter);
            filters.add(dkdjInvoiceTypeFilter);
            DynamicObjectCollection vatInvoiceCollection = QueryServiceHelper.query((String)"rim_invoice", (String)queryFeilds, (QFilter[])filters.toArray(new QFilter[filters.size()]), (String)orderBy, (int)pageSize);
            invoiceCollectionAll.addAll(vatInvoiceCollection);
        }
        if (!CollectionUtils.isEmpty((Collection)transportInvoiceTypes)) {
            filters.remove(selectStatusFilter);
            filters.remove(vatTypes);
            filters.remove(dkdjInvoiceTypeFilter);
            if (!filters.contains(checkFilter)) {
                filters.add(checkFilter);
            }
            filters.add(transportStatusFilter);
            QFilter eTypeFiler = new QFilter("invoice_type", "=", (Object)InputInvoiceTypeEnum.ORDINARY_ELECTRON.getCode());
            filters.add(eTypeFiler);
            DynamicObjectCollection eInvoiceCollection = QueryServiceHelper.query((String)"rim_invoice", (String)queryFeilds, (QFilter[])filters.toArray(new QFilter[filters.size()]), (String)orderBy);
            invoiceCollectionAll.addAll(eInvoiceCollection);
            transportInvoiceTypes.remove(InputInvoiceTypeEnum.ORDINARY_ELECTRON.getCode());
            filters.add(new QFilter("invoice_type", "in", (Object)transportInvoiceTypes));
            filters.remove(taxnoFilter);
            filters.remove(eTypeFiler);
            DynamicObjectCollection otherInvoiceCollection = QueryServiceHelper.query((String)"rim_invoice", (String)queryFeilds, (QFilter[])filters.toArray(new QFilter[filters.size()]), (String)orderBy);
            invoiceCollectionAll.addAll(otherInvoiceCollection);
        }
        String riskLevel = config.getString("risk_level");
        invoiceCollectionAll.removeIf(s -> InvoiceSaveConstant.isMatchFromExtInfo(s, InvoiceSaveConstant.EXT_AUTO_GX_FLAG) || this.filterRiskLevel((DynamicObject)s, riskLevel));
        if ("1".equals(deductconfig)) {
            if ("1".equals(deductconfigtype)) {
                invoiceCollectionAll.sort((o1, o2) -> o1.getDate("createtime").compareTo(o2.getDate("createtime")));
            } else {
                invoiceCollectionAll.sort((o1, o2) -> o1.getDate("invoice_date").compareTo(o2.getDate("invoice_date")));
            }
            return this.getCanDeductInvoices(invoiceCollectionAll, surplusDeductAmount);
        }
        return invoiceCollectionAll;
    }

    public Set<String> getExpenseSerialNos(List<Long> orgList, List<String> expenseTypeNumbers, List<String> deductionFlagList) {
        QFilter orgFilter = new QFilter("orgid", "in", orgList);
        QFilter expenseTypeFilter = new QFilter("expense_type", "in", expenseTypeNumbers);
        DynamicObjectCollection queryExpenses = QueryServiceHelper.query((String)"rim_expense", (String)"expense_id", (QFilter[])new QFilter[]{orgFilter, expenseTypeFilter}, (String)"create_time desc");
        if (!CollectionUtils.isEmpty((Collection)queryExpenses)) {
            DynamicObjectCollection queryExpenseRelations;
            Object[] expenseIds = queryExpenses.stream().map(s -> s.get("expense_id")).toArray();
            QFilter expenseIdFilter = new QFilter("expense_id", "in", (Object)expenseIds);
            QFilter deductFilter = null;
            if (!CollectionUtils.isEmpty(deductionFlagList)) {
                deductFilter = new QFilter("deduction_flag", "in", deductionFlagList);
            }
            if (!CollectionUtils.isEmpty((Collection)(queryExpenseRelations = QueryServiceHelper.query((String)"rim_expense_relation", (String)"serial_no", (QFilter[])new QFilter[]{expenseIdFilter, expenseTypeFilter, deductFilter}, (String)"create_time desc")))) {
                return queryExpenseRelations.stream().map(s -> s.getString("serial_no")).collect(Collectors.toSet());
            }
        }
        return Sets.newHashSet((Object[])new String[0]);
    }

    private BigDecimal getDeductedTaxAmount(List<Long> orgList, String taxno, Date taxperiod) {
        BigDecimal totalDeductAmount = BigDecimal.ZERO;
        QFilter orgFilter = new QFilter("org", "in", orgList);
        QFilter vatTypeFilter = new QFilter("invoice_type", "in", (Object)InputInvoiceTypeEnum.getDeductionTypes());
        QFilter authenticateFlagFilter = new QFilter("authenticate_flag", "in", (Object)new String[]{"1", "2", "3"});
        QFilter taxnoFilter = new QFilter("buyer_tax_no", "=", (Object)taxno);
        QFilter taxperiodFilter = new QFilter("tax_period", "=", (Object)taxperiod);
        QFilter deductionPurposeFilter = new QFilter("deduction_purpose", "=", (Object)"1");
        QFilter[] vatFilters = new QFilter[]{orgFilter, vatTypeFilter, taxnoFilter, taxperiodFilter, authenticateFlagFilter, deductionPurposeFilter};
        totalDeductAmount = totalDeductAmount.add(this.querySumEffectiveTaxAmount(vatFilters));
        QFilter transportDeductionFilter = new QFilter("transport_deduction", "=", (Object)"1");
        QFilter eInvoiceTypeFilter = new QFilter("invoice_type", "=", (Object)InputInvoiceTypeEnum.ORDINARY_ELECTRON.getCode());
        QFilter[] eInvoiceFilters = new QFilter[]{orgFilter, eInvoiceTypeFilter, taxnoFilter, taxperiodFilter, transportDeductionFilter};
        totalDeductAmount = totalDeductAmount.add(this.querySumEffectiveTaxAmount(eInvoiceFilters));
        ArrayList otherTranportTypes = Lists.newArrayList();
        Collections.addAll(otherTranportTypes, InputInvoiceTypeEnum.getTransportTypes());
        otherTranportTypes.remove(InputInvoiceTypeEnum.ORDINARY_ELECTRON.getCode());
        QFilter otherTypeFilter = new QFilter("invoice_type", "in", (Object)otherTranportTypes);
        QFilter[] otherInvoiceFilters = new QFilter[]{orgFilter, otherTypeFilter, taxperiodFilter, transportDeductionFilter};
        totalDeductAmount = totalDeductAmount.add(this.querySumEffectiveTaxAmount(otherInvoiceFilters));
        return totalDeductAmount;
    }

    private BigDecimal querySumEffectiveTaxAmount(QFilter[] qFilters) {
        ORM orm = ORM.create();
        DataSet vatDataSet = orm.queryDataSet(this.getClass().getName(), "rim_invoice", "sum(effective_tax_amount) as effective_tax_amount", qFilters);
        if (!vatDataSet.isEmpty()) {
            Row row = vatDataSet.next();
            return BigDecimalUtil.transDecimal(row.getBigDecimal("effective_tax_amount"));
        }
        return BigDecimal.ZERO;
    }

    private List<DynamicObject> getCanDeductInvoices(List<DynamicObject> invoiceCollectionAll, BigDecimal surplusDeductAmount) {
        if (CollectionUtils.isEmpty(invoiceCollectionAll)) {
            return invoiceCollectionAll;
        }
        BigDecimal totalTaxAmount = BigDecimal.ZERO;
        ArrayList selectInvoices = Lists.newArrayList();
        for (DynamicObject invoice : invoiceCollectionAll) {
            BigDecimal invoiceTaxAmount = BigDecimalUtil.transDecimal(invoice.get("total_tax_amount"));
            BigDecimal subTotalTaxAmount = totalTaxAmount.add(invoiceTaxAmount);
            if (subTotalTaxAmount.compareTo(surplusDeductAmount) > 0) continue;
            selectInvoices.add(invoice);
            totalTaxAmount = totalTaxAmount.add(invoiceTaxAmount);
        }
        return selectInvoices;
    }

    private boolean filterRiskLevel(DynamicObject object, String riskLevelConfig) {
        if (object == null) {
            return false;
        }
        Long invoiceType = DynamicObjectUtil.getDynamicObjectLongValue(object.get("invoice_type"));
        if (InputInvoiceTypeEnum.HGJKS.getCode().equals(invoiceType) || InputInvoiceTypeEnum.WITHHOLDING.getCode().equals(invoiceType)) {
            return false;
        }
        String invoiceRiskLevel = object.getString("invoice_risk_level");
        if (StringUtils.isEmpty((CharSequence)invoiceRiskLevel)) {
            return false;
        }
        if ("3".equals(invoiceRiskLevel)) {
            return true;
        }
        if (StringUtils.isNotBlank((CharSequence)riskLevelConfig) && !riskLevelConfig.contains("-1")) {
            List<String> multiValues = CommonUtils.getMultiValues(riskLevelConfig);
            return !multiValues.contains(invoiceRiskLevel);
        }
        return false;
    }
}

