/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.deduction;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.imc.rim.common.constant.CollectTypeEnum;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.InvoiceSaveConstant;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.ek.EkServiceFactory;
import kd.imc.rim.common.ek.model.InvoiceSelect;
import kd.imc.rim.common.ek.service.InvoiceSelectService;
import kd.imc.rim.common.invoice.deduction.DeductionDownService;
import kd.imc.rim.common.invoice.deduction.DeductionTableSaveTask;
import kd.imc.rim.common.invoice.deduction.SelectAccountService;
import kd.imc.rim.common.invoice.deduction.UpdateAuthenticateFlagTask;
import kd.imc.rim.common.invoice.query.InvoiceQueryService;
import kd.imc.rim.common.invoice.query.convert.InvoiceConvertService;
import kd.imc.rim.common.invoice.save.InvoiceSaveService;
import kd.imc.rim.common.service.InvoiceLog;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DeductionUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.ImcConfigUtil;
import kd.imc.rim.common.utils.ListUtils;
import kd.imc.rim.common.utils.MetadataUtil;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.common.utils.TenantUtils;
import kd.imc.rim.common.utils.UUID;
import kd.sdk.annotation.SdkDeprecated;
import org.apache.commons.lang3.tuple.Pair;

public class DeductInvoiceOperateService {
    private static Log LOGGER = LogFactory.getLog(DeductInvoiceOperateService.class);
    private static final String RESET_READYSELECT_KEY = "reset_readyselect";
    private static final int CHECKTHREADPOOL_SIZE = 6;
    private static ThreadPool checkThreadPool = ThreadPools.newFixedThreadPool((String)"Down_invoice_check_thread", (int)6);
    private static final int AUTHENTICATETHREADPOOL_SIZE = 6;
    private static ThreadPool authenticateThreadPool = ThreadPools.newFixedThreadPool((String)"upate_authenticate_thread", (int)6);

    public List<Map<String, Object>> queryVatDeductInvoiceData(QFilter[] qFilters, String mainFields) {
        ArrayList<Map<String, Object>> invoiceList = new ArrayList<Map<String, Object>>();
        DynamicObjectCollection mainCollection = this.queryDeductMainInvoiceData(qFilters, mainFields);
        if (!CollectionUtils.isEmpty((Collection)mainCollection)) {
            for (DynamicObject object : mainCollection) {
                Map<String, Object> map = DynamicObjectUtil.dynamicObjectToMap(object);
                invoiceList.add(map);
            }
        }
        return invoiceList;
    }

    public DynamicObjectCollection queryDeductMainInvoiceData(QFilter[] qFilters, String mainFields) {
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"rim_invoice", (String)mainFields, (QFilter[])qFilters);
        return collection;
    }

    public List<Map<String, Object>> queryNoVatDedectInvoiceData(QFilter[] qFilters, String mainFields) {
        ArrayList<Map<String, Object>> invoiceList = new ArrayList<Map<String, Object>>();
        DynamicObjectCollection mainCollection = this.queryDeductMainInvoiceData(qFilters, mainFields);
        if (!CollectionUtils.isEmpty((Collection)mainCollection)) {
            List<Map<String, DynamicObject>> details = DeductInvoiceOperateService.queryDetail(mainCollection);
            for (Map<String, DynamicObject> map : details) {
                Long invoiceType;
                DynamicObject mainObj = map.get("main");
                Map<String, Object> mainMap = DynamicObjectUtil.dynamicObjectToMap(mainObj);
                Map<String, Object> bodyMap = DynamicObjectUtil.dynamicObjectToMap(map.get("detail"));
                Map<String, Object> xbrlMap = DynamicObjectUtil.dynamicObjectToMap(map.get("xbrl"));
                InvoiceConvertService.putAll(mainMap, bodyMap);
                InvoiceConvertService.putAll(mainMap, xbrlMap);
                try {
                    DynamicObject invoiceTypeObj = mainObj.getDynamicObject("invoice_type");
                    invoiceType = invoiceTypeObj.getLong("id");
                }
                catch (Exception e) {
                    invoiceType = mainObj.getLong("invoice_type");
                }
                InvoiceConvertService.updateAirInvocieAmount(invoiceType, mainMap, bodyMap);
                invoiceList.add(mainMap);
            }
        }
        return invoiceList;
    }

    private static List<Map<String, DynamicObject>> queryDetail(DynamicObjectCollection mainCollection) {
        ArrayList<Map<String, DynamicObject>> invoiceList = new ArrayList<Map<String, DynamicObject>>(mainCollection.size());
        HashMap<String, List> typeSerialMap = new HashMap<String, List>();
        for (DynamicObject obj : mainCollection) {
            Long invoiceType = obj.getLong("invoice_type");
            String entity = InputInvoiceTypeEnum.getEntity(invoiceType);
            List list = typeSerialMap.getOrDefault(entity, new ArrayList());
            list.add(obj.getString("serial_no"));
            typeSerialMap.put(entity, list);
        }
        String tenantNo = TenantUtils.getTenantNo();
        HashMap<String, DynamicObject> bodyMap = new HashMap<String, DynamicObject>(16);
        for (Map.Entry entry : typeSerialMap.entrySet()) {
            DynamicObject[] dynamics = InvoiceQueryService.loadBySerialNo((String)entry.getKey(), tenantNo, ((List)entry.getValue()).toArray(new String[((List)entry.getValue()).size()]));
            if (dynamics == null) continue;
            for (DynamicObject obj : dynamics) {
                bodyMap.put(obj.getString("serial_no"), obj);
            }
        }
        for (DynamicObject object : mainCollection) {
            String serialNo = object.getString("serial_no");
            HashMap<String, Object> map = new HashMap<String, Object>(4);
            map.put("main", object);
            map.put("detail", bodyMap.get(serialNo));
            invoiceList.add(map);
        }
        return invoiceList;
    }

    @SdkDeprecated
    public void updateBatchSelectedInvoice(JSONArray updateSelectInvoiceArray, String deductibleMode) {
        this.updateBatchSelectedInvoice(updateSelectInvoiceArray, deductibleMode, null);
    }

    public void updateBatchSelectedInvoice(JSONArray updateSelectInvoiceArray, String deductibleMode, String taxNo) {
        LOGGER.info("\u66f4\u65b0\u62b5\u6263\u52fe\u9009/\u9884\u62b5\u6263\u53c2\u6570:" + updateSelectInvoiceArray);
        if (!CollectionUtils.isEmpty((Collection)updateSelectInvoiceArray)) {
            HashMap<String, JSONObject> invoiceMap = new HashMap<String, JSONObject>(8);
            ArrayList<String> serialNoList = new ArrayList<String>(8);
            for (int i = 0; i < updateSelectInvoiceArray.size(); ++i) {
                JSONObject example = updateSelectInvoiceArray.getJSONObject(i);
                if (StringUtils.isBlank((Object)example.get((Object)"deduction_purpose"))) {
                    example.put("deduction_purpose", (Object)1);
                }
                if (StringUtils.isBlank((Object)example.get((Object)"manage_status"))) {
                    example.put("manage_status", (Object)0);
                }
                String serialNo = example.getString("serial_no");
                serialNoList.add(serialNo);
                invoiceMap.put(serialNo, example);
            }
            String tenantNo = TenantUtils.getTenantNo();
            DynamicObject[] mainDynamicObjects = InvoiceQueryService.loadAllBySerialNo("rim_invoice", tenantNo, serialNoList);
            InvoiceSaveService service = new InvoiceSaveService();
            String presetDeductionPurpose = "";
            String resetReadyselect = RimConfigUtils.getConfig("rim_deduction", RESET_READYSELECT_KEY);
            String compareOptimeConfig = ImcConfigUtil.getValue("rim_deduction", "not_compare_optime");
            if (mainDynamicObjects != null && mainDynamicObjects.length > 0) {
                HashMap invoiceInfo = Maps.newHashMap();
                HashMap<Long, List> typeMap = new HashMap<Long, List>(8);
                for (DynamicObject mainDynamicObject : mainDynamicObjects) {
                    String serialNo1 = mainDynamicObject.getString("serial_no");
                    Long typeId = mainDynamicObject.getLong("invoice_type_id");
                    List list = typeMap.getOrDefault(typeId, new ArrayList(8));
                    list.add(serialNo1);
                    typeMap.put(typeId, list);
                    JSONObject example1 = (JSONObject)invoiceMap.get(serialNo1);
                    presetDeductionPurpose = mainDynamicObject.getString("preset_deduction_purpose");
                    if ("-1".equals(deductibleMode) || "-4".equals(deductibleMode) || "-2".equals(deductibleMode)) {
                        mainDynamicObject.set("cancel_select_type", (Object)example1.getString("cancel_select_type"));
                        if (StringUtils.equals((CharSequence)"1", (CharSequence)resetReadyselect)) {
                            example1.put("pre_authenticate_flag", (Object)this.getPreAuthenticateFlag(serialNo1));
                        }
                    }
                    this.setUpdateSelectValus(example1, mainDynamicObject, presetDeductionPurpose, invoiceInfo, compareOptimeConfig);
                    String authenticateFlag = example1.getString("authenticate_flag");
                    if (InputInvoiceTypeEnum.HGJKS.getCode().equals(typeId) && this.isSetHgjksTaxNo(mainDynamicObject.getString("buyer_tax_no"), taxNo, authenticateFlag)) {
                        mainDynamicObject.set("buyer_tax_no", (Object)taxNo);
                    }
                    service.setMainInvoiceInfo(mainDynamicObject);
                }
                try (TXHandle h = TX.required();){
                    try {
                        for (Map.Entry entry : typeMap.entrySet()) {
                            String entity;
                            Object[] invoiceList;
                            if (ObjectUtils.isEmpty(entry) || ArrayUtils.isEmpty((Object[])(invoiceList = InvoiceQueryService.loadAllBySerialNo(entity = InputInvoiceTypeEnum.getEntity((Long)entry.getKey()), tenantNo, (Collection)entry.getValue())))) continue;
                            for (Object bodyDynamicObject : invoiceList) {
                                String serialNo2 = bodyDynamicObject.getString("serial_no");
                                JSONObject example2 = (JSONObject)invoiceMap.get(serialNo2);
                                this.setUpdateSelectValus(example2, (DynamicObject)bodyDynamicObject, presetDeductionPurpose, invoiceInfo, compareOptimeConfig);
                                if (!"rim_inv_custom".equals(entity) || !this.isSetHgjksTaxNo(bodyDynamicObject.getString("dept_tax_no"), taxNo, example2.getString("authenticate_flag"))) continue;
                                bodyDynamicObject.set("dept_tax_no", (Object)taxNo);
                            }
                            SaveServiceHelper.save((DynamicObject[])invoiceList);
                        }
                        SaveServiceHelper.save((DynamicObject[])mainDynamicObjects);
                        this.informEkService(serialNoList, deductibleMode);
                        ThreadPools.executeOnceIncludeRequestContext((String)"DeductInvoiceOperateService.saveInvoiceLog3", () -> InvoiceLog.insert("deduct_authenticate", invoiceInfo));
                    }
                    catch (Throwable e) {
                        h.markRollback();
                        throw e;
                    }
                }
            }
        }
    }

    private boolean isSetHgjksTaxNo(String buyerTaxNo, String taxNo, String authenticateFlag) {
        return StringUtils.isEmpty((CharSequence)buyerTaxNo) && StringUtils.isNotEmpty((CharSequence)taxNo) && ("0".equals(authenticateFlag) || "1".equals(authenticateFlag));
    }

    private String getPreAuthenticateFlag(String serialNo) {
        String preAuthenticateFlag = "";
        QFilter selectAccountFilter = new QFilter("serial_no", "=", (Object)serialNo).and("select_result", "=", (Object)"1").and("select_status", "=", (Object)"1");
        DynamicObjectCollection querys = QueryServiceHelper.query((String)"rim_select_account", (String)"pre_authenticate_flag", (QFilter[])selectAccountFilter.toArray(), (String)"update_time desc", (int)1);
        if (!CollectionUtils.isEmpty((Collection)querys)) {
            preAuthenticateFlag = ((DynamicObject)querys.get(0)).getString("pre_authenticate_flag");
        }
        return preAuthenticateFlag;
    }

    private void setUpdateSelectValus(JSONObject example, DynamicObject dynamicObject, String presetDeductionPurpose, Map<String, String> invoiceInfo, String compareOptimeConfig) {
        String preAuthenticate;
        JSONObject info = new JSONObject();
        String serialNo = example.getString("serial_no");
        dynamicObject.set("modifytime", (Object)new Date());
        String authenticateFlag = example.getString("authenticate_flag");
        info.put("traceId", (Object)RequestContext.get().getTraceId());
        if ("1".equals(authenticateFlag) && StringUtils.isEmpty((CharSequence)example.getString("tax_period")) && ("1".equals(preAuthenticate = dynamicObject.getString("authenticate_flag")) || "2".equals(preAuthenticate) || "3".equals(preAuthenticate))) {
            return;
        }
        info.put("authenticateFlag", (Object)authenticateFlag);
        String preAuthenticateFlag = example.getString("pre_authenticate_flag");
        if (StringUtils.equals((CharSequence)"4", (CharSequence)preAuthenticateFlag)) {
            dynamicObject.set("authenticate_flag", (Object)preAuthenticateFlag);
            invoiceInfo.put(serialNo, info.toJSONString());
            return;
        }
        Date operateTime = example.getDate("operate_time");
        if (operateTime != null && !"1".equals(compareOptimeConfig)) {
            Date taxOperatetime = dynamicObject.getDate("tax_operatetime");
            if (taxOperatetime != null && operateTime.compareTo(taxOperatetime) < 0) {
                return;
            }
            dynamicObject.set("tax_operatetime", (Object)operateTime);
        }
        dynamicObject.set("authenticate_flag", (Object)authenticateFlag);
        if ("1".equals(authenticateFlag) || "4".equals(authenticateFlag)) {
            if (example.getDate("select_time") != null) {
                dynamicObject.set("select_time", (Object)example.getDate("select_time"));
            }
            dynamicObject.set("manage_status", (Object)example.getString("manage_status"));
            if (StringUtils.isNotEmpty((CharSequence)example.getString("effective_tax_amount"))) {
                dynamicObject.set("effective_tax_amount", (Object)example.getString("effective_tax_amount"));
            } else {
                BigDecimal effective_tax_amount = dynamicObject.getBigDecimal("effective_tax_amount");
                if (effective_tax_amount.compareTo(BigDecimal.ZERO) == 0) {
                    Map<String, Object> map = DynamicObjectUtil.dynamicObjectToMap(dynamicObject);
                    dynamicObject.set("effective_tax_amount", (Object)CommonUtils.getJsonValue(map, BigDecimal.class, "total_tax_amount", "tax_amount"));
                }
            }
            String taxPeriod = example.getString("tax_period");
            if (StringUtils.isNotEmpty((CharSequence)taxPeriod)) {
                dynamicObject.set("tax_period", (Object)DateUtils.stringToDate(taxPeriod, "yyyyMM"));
            }
            String deductionPurpose = example.getString("deduction_purpose");
            info.put("deductionPurpose", (Object)deductionPurpose);
            dynamicObject.set("deduction_purpose", (Object)deductionPurpose);
            String notDeductibleType = example.getString("not_deductible_type");
            if ("2".equals(deductionPurpose)) {
                if (StringUtils.isNotEmpty((CharSequence)notDeductibleType)) {
                    dynamicObject.set("not_deductible_type", (Object)notDeductibleType);
                    info.put("notDeductibleType", (Object)notDeductibleType);
                }
            } else {
                dynamicObject.set("not_deductible_type", null);
            }
        } else {
            dynamicObject.set("select_time", null);
            dynamicObject.set("tax_period", null);
            dynamicObject.set("not_deductible_type", null);
            if (StringUtils.isNotEmpty((CharSequence)presetDeductionPurpose)) {
                dynamicObject.set("deduction_purpose", (Object)presetDeductionPurpose);
            } else {
                dynamicObject.set("deduction_purpose", (Object)"");
            }
        }
        invoiceInfo.put(serialNo, info.toJSONString());
    }

    public void updateAuthenticateFlag(String authenticateFlag, String taxNo, Date taxPeriod, String[] deductionPurposes) {
        this.updateAuthenticateFlag(authenticateFlag, taxNo, taxPeriod, null, deductionPurposes);
    }

    public void updateAuthenticateFlag(String authenticateFlag, String taxNo, Date taxPeriod, Date operateTime, String[] deductionPurposes) {
        QFilter purposeFilter;
        QFilter filter1 = new QFilter("buyer_tax_no", "=", (Object)taxNo);
        QFilter filter2 = null;
        QFilter filter3 = new QFilter("tax_period", "=", (Object)taxPeriod);
        filter2 = "2".equals(authenticateFlag) ? new QFilter("authenticate_flag", "=", (Object)"1") : new QFilter("authenticate_flag", "=", (Object)"2");
        String tenantNo = TenantUtils.getTenantNo();
        QFilter tenantFilter = new QFilter("tenant_no", "=", (Object)tenantNo);
        QFilter[] filterArray = new QFilter[]{tenantFilter, filter1, filter2, filter3, purposeFilter = new QFilter("deduction_purpose", "in", (Object)deductionPurposes)};
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"rim_invoice", (String)"id", (QFilter[])filterArray);
        if (CollectionUtils.isEmpty((Collection)collection)) {
            return;
        }
        List ids = collection.stream().map(s -> s.get("id")).collect(Collectors.toList());
        ArrayList futureList = new ArrayList(collection.size());
        int index = 1;
        long start = System.currentTimeMillis();
        LOGGER.info("\u7edf\u8ba1\u8868\u64cd\u4f5c\u66f4\u65b0\u53d1\u7968\u5f00\u59cb:{}", (Object)taxNo);
        int pageSize = RimConfigUtils.getPageSizeFromConfig(150, "rim_deduction", "update_authenticateflag_size");
        List lists = ListUtils.splitList(ids, pageSize);
        collection.clear();
        if (CollectionUtils.isEmpty(lists)) {
            return;
        }
        for (List<Object> list : lists) {
            UpdateAuthenticateFlagTask updateTask = new UpdateAuthenticateFlagTask(RequestContext.get(), list, authenticateFlag, operateTime);
            futureList.add(authenticateThreadPool.submit((Callable)updateTask));
            CommonUtils.futureWait(futureList, 6, index);
            ++index;
        }
        CommonUtils.futureWait(futureList, 6, 6);
        LOGGER.info("\u7edf\u8ba1\u8868\u64cd\u4f5c\u66f4\u65b0\u53d1\u7968\u7ed3\u675f:{},\u8017\u65f6:{}", (Object)taxNo, (Object)(System.currentTimeMillis() - start));
    }

    public void saveDownInvoice(List<JSONObject> invoiceList, Long orgId, String userId) {
        this.saveDownInvoice(invoiceList, orgId, userId, "");
    }

    public void asyncSaveDownInvoice(List<JSONObject> invoiceList, Long orgId, String userId) {
        this.asyncSaveDownInvoice(invoiceList, orgId, userId, "");
    }

    public void saveDownInvoice(List<JSONObject> invoiceList, Long orgId, String userId, String taxNo) {
        if (!CollectionUtils.isEmpty(invoiceList)) {
            ThreadPools.executeOnceIncludeRequestContext((String)"AsyncSaveInvoiceRun", () -> this.asyncSaveDownInvoice(invoiceList, orgId, userId, taxNo));
        }
    }

    public void asyncSaveDownInvoice(List<JSONObject> invoiceList, Long orgId, String userId, String taxNo) {
        LOGGER.info("\u7a0e\u76d8\u4e0b\u8f7d\u53d1\u7968\u6570\u91cf\uff1a" + invoiceList.size());
        String addFlag = RimConfigUtils.getConfig("rim_deduction", "add_buyer_info");
        String companyName = TenantUtils.getCompanyNameByTaxNo(taxNo);
        long start = System.currentTimeMillis();
        ArrayList futureList = new ArrayList(invoiceList.size());
        int index = 1;
        for (JSONObject invoice : invoiceList) {
            invoice.put("org_id", (Object)orgId);
            invoice.put("taxNo", (Object)TenantUtils.getTaxNoByOrgId(orgId));
            DeductionUtils.setTaxDownCollectInfo(invoice);
            DeductionUtils.addBuyerInfo(invoice, taxNo, companyName, addFlag);
            if (CollectTypeEnum.TAX_EXCEL_IMPORT.getName().equals(invoice.getString("resource"))) {
                Long invoiceType = InputInvoiceTypeEnum.getInvoiceTypeByAwsType(invoice.getString("invoiceType"));
                String buyerTaxNo = invoice.getString("buyerTaxNo");
                if (kd.imc.rim.common.utils.StringUtils.isEmpty((CharSequence)buyerTaxNo)) {
                    String taxNoByOrgId = TenantUtils.getTaxNoByOrgId(orgId);
                    companyName = TenantUtils.getCompanyNameByTaxNo(taxNoByOrgId);
                    DeductionUtils.addBuyerInfo(invoice, taxNoByOrgId, companyName, "1");
                }
            }
            DeductionTableSaveTask saveTask = new DeductionTableSaveTask(RequestContext.get(), invoice, orgId, userId);
            futureList.add(checkThreadPool.submit((Callable)saveTask));
            CommonUtils.futureWait(futureList, 6, index);
            ++index;
        }
        CommonUtils.futureWait(futureList, 6, 6);
        LOGGER.info("\u7a0e\u76d8\u4e0b\u8f7d{}\u5f20\u53d1\u7968\u4fdd\u5b58\u8017\u65f6:{}", (Object)invoiceList.size(), (Object)(System.currentTimeMillis() - start));
    }

    public Pair<Boolean, String> isUpdateDownInvoice(InvoiceSaveService saveService, Long invoiceType, JSONObject invoice) {
        return DeductionDownService.isUpdateDownInvoice(saveService, invoiceType, invoice);
    }

    public String handleTaxFullInvoice(InvoiceSaveService service, JSONObject invoiceJson) {
        return DeductionDownService.handleTaxFullInvoice(service, invoiceJson);
    }

    @SdkDeprecated
    public JSONObject transportDeductBySerialNo(List<String> serialNos, String transportDeduction, Date taxPeriod, String deductibleMode, String selectOperaType) {
        return this.transportDeductBySerialNo(serialNos, transportDeduction, taxPeriod, deductibleMode, UUID.getBatchNo("DEDUCT"), selectOperaType, true);
    }

    public JSONObject transportDeductBySerialNo(List<String> serialNos, String transportDeduction, Date taxPeriod, String deductibleMode, String batchNo, String selectOperaType, boolean saveAccount) {
        JSONArray batchNoArr = new JSONArray();
        taxPeriod = DateUtils.getFirstDateOfMonth(taxPeriod);
        JSONObject result = ResultContant.createSuccessJSONObject();
        String tenantNo = TenantUtils.getTenantNo();
        InvoiceSaveService saveService = new InvoiceSaveService();
        Object[] mainDynamicObjects = InvoiceQueryService.loadAllBySerialNo("rim_invoice", tenantNo, serialNos);
        if (!ObjectUtils.isEmpty((Object[])mainDynamicObjects)) {
            HashMap<Long, ArrayList<String>> typeMap = new HashMap<Long, ArrayList<String>>(8);
            HashMap<String, BigDecimal> taxAmountMap = new HashMap<String, BigDecimal>(8);
            for (Object mainDynamicObject : mainDynamicObjects) {
                String serialNo = mainDynamicObject.getString("serial_no");
                Long typeId = mainDynamicObject.getLong("invoice_type_id");
                ArrayList<String> list = (ArrayList<String>)typeMap.get(typeId);
                if (list == null) {
                    list = new ArrayList<String>(8);
                }
                list.add(serialNo);
                typeMap.put(typeId, list);
                BigDecimal taxAmount = mainDynamicObject.getBigDecimal("total_tax_amount");
                taxAmountMap.put(serialNo, taxAmount);
                this.setTransportDeductValue((DynamicObject)mainDynamicObject, transportDeduction, taxPeriod, taxAmount);
                if (!"2".equals(transportDeduction)) {
                    saveService.setMainInvoiceInfo((DynamicObject)mainDynamicObject);
                }
                if (!"-6".equals(deductibleMode)) continue;
                mainDynamicObject.set("cancel_select_type", (Object)selectOperaType);
            }
            try (TXHandle h = TX.required();){
                try {
                    SaveServiceHelper.save((DynamicObject[])mainDynamicObjects);
                    for (Map.Entry entry : typeMap.entrySet()) {
                        String entity = InputInvoiceTypeEnum.getEntity((Long)entry.getKey());
                        Object[] invoiceList = InvoiceQueryService.loadBySerialNo(entity, tenantNo, (List)entry.getValue());
                        if (ArrayUtils.isEmpty((Object[])invoiceList)) continue;
                        for (Object mainDynamicObject : invoiceList) {
                            String serialNo = mainDynamicObject.getString("serial_no");
                            this.setTransportDeductValue((DynamicObject)mainDynamicObject, transportDeduction, taxPeriod, (BigDecimal)taxAmountMap.get(serialNo));
                        }
                        SaveServiceHelper.save((DynamicObject[])invoiceList);
                    }
                    this.informEkService(serialNos, deductibleMode);
                    if (saveAccount) {
                        this.saveAccountLog(serialNos, taxPeriod, batchNo, deductibleMode, selectOperaType);
                    }
                    JSONObject info = new JSONObject();
                    info.put("transportDeduction", (Object)transportDeduction);
                    info.put("traceId", (Object)RequestContext.get().getTraceId());
                    ThreadPools.executeOnceIncludeRequestContext((String)"DeductInvoiceOperateService.saveInvoiceLog2", () -> InvoiceLog.insert("transport_deduction", serialNos, info.toJSONString()));
                }
                catch (Throwable e) {
                    h.markRollback();
                    throw e;
                }
            }
        }
        batchNoArr.add((Object)batchNo);
        result.put("batchNoList", (Object)batchNoArr);
        return result;
    }

    private void saveAccountLog(List<String> serialNos, Date taxPeriod, String batchNo, String deductibleMode, String selectOperaType) {
        JSONArray selectAccountList = this.getTransportAccount(serialNos, batchNo, deductibleMode, selectOperaType);
        SelectAccountService selectAccountService = new SelectAccountService();
        selectAccountService.asyncSaveSelectAccount(selectAccountList, taxPeriod);
    }

    public JSONArray getTransportAccount(List<String> serialNos, String batchNo, String deductibleMode, String selectOperaType) {
        JSONArray selectAccountList = new JSONArray();
        for (String serialNo : serialNos) {
            JSONObject account = new JSONObject();
            account.put("batch_no", (Object)batchNo);
            account.put("serial_no", (Object)serialNo);
            account.put("deduction_purpose", (Object)deductibleMode);
            account.put("select_status", (Object)"0");
            account.put("select_result", (Object)"1");
            account.put("select_opera_type", (Object)selectOperaType);
            account.put("handle_status", (Object)"1");
            selectAccountList.add((Object)account);
        }
        return selectAccountList;
    }

    private void setTransportDeductValue(DynamicObject dynamicObject, String transportDeduction, Date taxPeriod, BigDecimal taxAmount) {
        if ("1".equals(transportDeduction) || "2".equals(transportDeduction)) {
            dynamicObject.set("transport_deduction", (Object)transportDeduction);
            dynamicObject.set("authenticate_time", (Object)new Date());
            dynamicObject.set("tax_period", (Object)taxPeriod);
            BigDecimal effective_tax_amount = BigDecimalUtil.transDecimal(dynamicObject.getBigDecimal("effective_tax_amount"));
            if (effective_tax_amount.compareTo(BigDecimal.ZERO) == 0) {
                effective_tax_amount = taxAmount;
            }
            dynamicObject.set("effective_tax_amount", (Object)effective_tax_amount);
            dynamicObject.set("modifytime", (Object)new Date());
        } else {
            dynamicObject.set("transport_deduction", (Object)transportDeduction);
            dynamicObject.set("authenticate_time", null);
            dynamicObject.set("tax_period", null);
            dynamicObject.set("modifytime", (Object)new Date());
        }
    }

    public void updateMainInvoiceSelecting(Map<String, String> serialNoStatusMap) {
        this.updateMainInvoiceSelecting(serialNoStatusMap, "1");
    }

    public void updateMainInvoiceSelecting(Map<String, String> serialNoStatusMap, String operateType) {
        this.updateMainInvoiceSelecting(serialNoStatusMap, operateType, "");
    }

    public void updateMainInvoiceSelecting(Map<String, String> serialNoStatusMap, String operateType, String selectOperaType) {
        if (!CollectionUtils.isEmpty(serialNoStatusMap)) {
            QFilter serialNoFilter = new QFilter("serial_no", "in", serialNoStatusMap.keySet());
            QFilter authenticateFilter = null;
            if ("0".equals(operateType)) {
                authenticateFilter = new QFilter("authenticate_flag", "=", (Object)"5");
            }
            String tenantNo = TenantUtils.getTenantNo();
            QFilter tenantFilter = new QFilter("tenant_no", "=", (Object)tenantNo);
            DynamicObjectCollection collection = QueryServiceHelper.query((String)"rim_invoice", (String)"id", (QFilter[])new QFilter[]{tenantFilter, serialNoFilter, authenticateFilter});
            DynamicObject[] mainDynamicObjects = null;
            if (!CollectionUtils.isEmpty((Collection)collection)) {
                Object[] idArray = collection.stream().map(s -> s.get("id")).toArray();
                mainDynamicObjects = BusinessDataServiceHelper.load((Object[])idArray, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"rim_invoice"));
            }
            InvoiceSaveService service = new InvoiceSaveService();
            if (mainDynamicObjects != null && mainDynamicObjects.length > 0) {
                HashMap<Long, List> typeMap = new HashMap<Long, List>(8);
                for (DynamicObject mainDynamicObject : mainDynamicObjects) {
                    String serialNo1 = mainDynamicObject.getString("serial_no");
                    Long typeId = mainDynamicObject.getLong("invoice_type_id");
                    List list = typeMap.getOrDefault(typeId, new ArrayList(8));
                    list.add(serialNo1);
                    typeMap.put(typeId, list);
                    mainDynamicObject.set("authenticate_flag", (Object)serialNoStatusMap.getOrDefault(mainDynamicObject.getString("serial_no"), "0"));
                    mainDynamicObject.set("modifytime", (Object)new Date());
                    service.setMainInvoiceInfo(mainDynamicObject);
                    if (!"2".equals(selectOperaType)) continue;
                    InvoiceSaveService.setExtInfo(mainDynamicObject, InvoiceSaveConstant.EXT_AUTO_GX_FLAG, "1");
                }
                try (TXHandle h = TX.required();){
                    try {
                        for (Map.Entry entry : typeMap.entrySet()) {
                            String entity;
                            Object[] invoiceList;
                            if (ObjectUtils.isEmpty(entry) || ArrayUtils.isEmpty((Object[])(invoiceList = InvoiceQueryService.loadAllBySerialNo(entity = InputInvoiceTypeEnum.getEntity((Long)entry.getKey()), tenantNo, (Collection)entry.getValue())))) continue;
                            for (Object bodyDynamicObject : invoiceList) {
                                bodyDynamicObject.set("authenticate_flag", (Object)serialNoStatusMap.getOrDefault(bodyDynamicObject.getString("serial_no"), "0"));
                                bodyDynamicObject.set("modifytime", (Object)new Date());
                            }
                            SaveServiceHelper.save((DynamicObject[])invoiceList);
                        }
                        SaveServiceHelper.save((DynamicObject[])mainDynamicObjects);
                        ThreadPools.executeOnceIncludeRequestContext((String)"DeductInvoiceOperateService.saveInvoiceLog4", () -> this.saveLog(serialNoStatusMap));
                    }
                    catch (Throwable e) {
                        h.markRollback();
                        throw e;
                    }
                }
            }
        }
    }

    private void saveLog(Map<String, String> serialNoStatusMap) {
        if (!CollectionUtils.isEmpty(serialNoStatusMap)) {
            for (String serialNo : serialNoStatusMap.keySet()) {
                JSONObject info = new JSONObject();
                info.put("opeateType", (Object)ResManager.loadKDString((String)"\u6062\u590d\u52fe\u9009\u4e2d\u7684\u8ba4\u8bc1\u72b6\u6001", (String)"DeductInvoiceOperateService_1", (String)"imc-rim-common", (Object[])new Object[0]));
                info.put("authenticateFlag", (Object)serialNoStatusMap.getOrDefault(serialNo, "0"));
                info.put("traceId", (Object)RequestContext.get().getTraceId());
                InvoiceLog.insert("deduct_authenticate", serialNo, info.toJSONString());
            }
        }
    }

    private void informEkService(List<String> serialNoList, String deductibleMode) {
        LOGGER.info("\u901a\u77e5\u4e8c\u5f00\u63a5\u53e3,\u64cd\u4f5c:{},\u6d41\u6c34\u53f7:{}", (Object)MetadataUtil.getComboItemName("rim_select_account", "deduction_purpose", deductibleMode), serialNoList);
        InvoiceSelectService invoiceSelectService = EkServiceFactory.getInvoiceSelectService();
        InvoiceSelect invoiceSelect = new InvoiceSelect();
        invoiceSelect.setSerialList(serialNoList);
        if ("5".equals(deductibleMode)) {
            invoiceSelect.setStatus("1");
            invoiceSelectService.afterPreSelected(invoiceSelect);
        } else if ("-5".equals(deductibleMode)) {
            invoiceSelect.setStatus("0");
            invoiceSelectService.afterPreSelected(invoiceSelect);
        } else if ("1".equals(deductibleMode) || "4".equals(deductibleMode) || "2".equals(deductibleMode)) {
            invoiceSelect.setStatus("1");
            invoiceSelectService.afterSelected(invoiceSelect);
        } else if ("-1".equals(deductibleMode) || "-4".equals(deductibleMode) || "-2".equals(deductibleMode)) {
            invoiceSelect.setStatus("0");
            invoiceSelectService.afterSelected(invoiceSelect);
        } else if ("6".equals(deductibleMode)) {
            invoiceSelect.setStatus("1");
            invoiceSelectService.afterTransportSelected(invoiceSelect);
        } else if ("-6".equals(deductibleMode)) {
            invoiceSelect.setStatus("0");
            invoiceSelectService.afterTransportSelected(invoiceSelect);
        } else if ("13".equals(deductibleMode) || "14".equals(deductibleMode) || "15".equals(deductibleMode) || "16".equals(deductibleMode) || "17".equals(deductibleMode)) {
            invoiceSelect.setStatus("1");
            invoiceSelectService.afterAgricHanded(invoiceSelect);
        }
    }

    public void updateMainInvoiceHanding(Map<String, String> serialNoStatusMap, String status) {
        if (!CollectionUtils.isEmpty(serialNoStatusMap)) {
            ArrayList<String> serialNos = new ArrayList<String>(serialNoStatusMap.keySet());
            QFilter serialNoFilter = new QFilter("serial_no", "in", serialNos);
            QFilter handlestatusFilter = null;
            if ("0".equals(status)) {
                handlestatusFilter = new QFilter("agric_handle_status", "=", (Object)"3");
            }
            String tenantNo = TenantUtils.getTenantNo();
            QFilter tenantFilter = new QFilter("tenant_no", "=", (Object)tenantNo);
            DynamicObjectCollection collection = QueryServiceHelper.query((String)"rim_invoice", (String)"id", (QFilter[])new QFilter[]{tenantFilter, serialNoFilter, handlestatusFilter});
            DynamicObject[] mainDynamicObjects = null;
            if (!CollectionUtils.isEmpty((Collection)collection)) {
                Object[] idArray = collection.stream().map(s -> s.get("id")).toArray();
                mainDynamicObjects = BusinessDataServiceHelper.load((Object[])idArray, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"rim_invoice"));
            }
            if (mainDynamicObjects != null && mainDynamicObjects.length > 0) {
                HashMap<Long, List> typeMap = new HashMap<Long, List>(8);
                for (DynamicObject mainDynamicObject : mainDynamicObjects) {
                    String serialNo1 = mainDynamicObject.getString("serial_no");
                    Long typeId = mainDynamicObject.getLong("invoice_type_id");
                    List list = typeMap.getOrDefault(typeId, new ArrayList(8));
                    list.add(serialNo1);
                    typeMap.put(typeId, list);
                    mainDynamicObject.set("agric_handle_status", (Object)serialNoStatusMap.get(serialNo1));
                    mainDynamicObject.set("modifytime", (Object)new Date());
                }
                try (TXHandle h = TX.required();){
                    try {
                        for (Map.Entry entry : typeMap.entrySet()) {
                            String entity;
                            Object[] invoiceList;
                            if (ObjectUtils.isEmpty(entry) || ArrayUtils.isEmpty((Object[])(invoiceList = InvoiceQueryService.loadAllBySerialNo(entity = InputInvoiceTypeEnum.getEntity((Long)entry.getKey()), tenantNo, (Collection)entry.getValue())))) continue;
                            for (Object bodyDynamicObject : invoiceList) {
                                String serialNo2 = bodyDynamicObject.getString("serial_no");
                                bodyDynamicObject.set("agric_handle_status", (Object)serialNoStatusMap.get(serialNo2));
                                bodyDynamicObject.set("modifytime", (Object)new Date());
                            }
                            SaveServiceHelper.save((DynamicObject[])invoiceList);
                        }
                        SaveServiceHelper.save((DynamicObject[])mainDynamicObjects);
                        InvoiceLog.insert("agric_handle", serialNos, "status:" + status);
                    }
                    catch (Throwable e) {
                        h.markRollback();
                        throw e;
                    }
                }
            }
        }
    }

    public void updateAgricHandleInvoice(JSONArray updateSelectInvoiceArray, String deductibleMode, String taxNo) {
        LOGGER.info("\u66f4\u65b0\u519c\u4ea7\u54c1\u5904\u7406\u53c2\u6570:{}-{}", (Object)taxNo, (Object)updateSelectInvoiceArray);
        if (!CollectionUtils.isEmpty((Collection)updateSelectInvoiceArray)) {
            HashMap<String, JSONObject> invoiceMap = new HashMap<String, JSONObject>(8);
            ArrayList<String> serialNoList = new ArrayList<String>(8);
            for (int i = 0; i < updateSelectInvoiceArray.size(); ++i) {
                JSONObject example = updateSelectInvoiceArray.getJSONObject(i);
                String serialNo = example.getString("serial_no");
                serialNoList.add(serialNo);
                invoiceMap.put(serialNo, example);
            }
            String tenantNo = TenantUtils.getTenantNo();
            DynamicObject[] mainDynamicObjects = InvoiceQueryService.loadAllBySerialNo("rim_invoice", tenantNo, serialNoList);
            if (mainDynamicObjects != null && mainDynamicObjects.length > 0) {
                HashMap invoiceInfo = Maps.newHashMap();
                HashMap<Long, List> typeMap = new HashMap<Long, List>(8);
                for (DynamicObject mainDynamicObject : mainDynamicObjects) {
                    String serialNo1 = mainDynamicObject.getString("serial_no");
                    Long typeId = mainDynamicObject.getLong("invoice_type_id");
                    List list = typeMap.getOrDefault(typeId, new ArrayList(8));
                    list.add(serialNo1);
                    typeMap.put(typeId, list);
                    JSONObject example1 = (JSONObject)invoiceMap.get(serialNo1);
                    this.setUpdateAgricHandleValus(example1, mainDynamicObject, deductibleMode, invoiceInfo);
                    String deductionFlag = InvoiceSaveService.getBillDeductionFlag(mainDynamicObject, CollectTypeEnum.PC_SHUIPAN.getCode());
                    if (deductionFlag != null) continue;
                    mainDynamicObject.set(InvoiceSaveConstant.FIELD_DEDUCTION_FLAG, (Object)"1");
                    example1.put("deductionFlag", (Object)"1");
                    InvoiceSaveService.setExtInfo(mainDynamicObject, InvoiceSaveConstant.EXT_DEDUCTION_FLAG, mainDynamicObject.getString(InvoiceSaveConstant.FIELD_DEDUCTION_FLAG));
                }
                try (TXHandle h = TX.required();){
                    try {
                        for (Map.Entry entry : typeMap.entrySet()) {
                            String entity;
                            Object[] invoiceList;
                            if (ObjectUtils.isEmpty(entry) || ArrayUtils.isEmpty((Object[])(invoiceList = InvoiceQueryService.loadAllBySerialNo(entity = InputInvoiceTypeEnum.getEntity((Long)entry.getKey()), tenantNo, (Collection)entry.getValue())))) continue;
                            for (Object bodyDynamicObject : invoiceList) {
                                String serialNo2 = bodyDynamicObject.getString("serial_no");
                                JSONObject example2 = (JSONObject)invoiceMap.get(serialNo2);
                                this.setUpdateAgricHandleValus(example2, (DynamicObject)bodyDynamicObject, deductibleMode, invoiceInfo);
                            }
                            SaveServiceHelper.save((DynamicObject[])invoiceList);
                        }
                        SaveServiceHelper.save((DynamicObject[])mainDynamicObjects);
                        this.informEkService(serialNoList, deductibleMode);
                        ThreadPools.executeOnceIncludeRequestContext((String)"DeductInvoiceOperateService.saveInvoiceLog3", () -> InvoiceLog.insert("agric_handle", invoiceInfo));
                    }
                    catch (Throwable e) {
                        h.markRollback();
                        throw e;
                    }
                }
            }
        }
    }

    private void setUpdateAgricHandleValus(JSONObject example, DynamicObject dynamicObject, String deductibleMode, Map<String, String> invoiceInfo) {
        String deductionFlag;
        JSONObject info = new JSONObject();
        String serialNo = example.getString("serial_no");
        dynamicObject.set("modifytime", (Object)new Date());
        info.put("agricHandleStatus", (Object)"1");
        String agricPrehandleType = DeductionUtils.convertAgricPrehandleType(deductibleMode);
        info.put("agricPrehandleType", (Object)agricPrehandleType);
        dynamicObject.set("agric_handle_status", (Object)"1");
        dynamicObject.set("agric_prehandletype", (Object)agricPrehandleType);
        dynamicObject.set("agric_partial_amount", example.get((Object)"agric_partial_amount"));
        dynamicObject.set("agric_partial_taxamount", example.get((Object)"agric_partial_taxamount"));
        info.put("traceId", (Object)RequestContext.get().getTraceId());
        if (StringUtils.isNotEmpty((CharSequence)example.getString("effective_tax_amount"))) {
            dynamicObject.set("effective_tax_amount", (Object)example.getString("effective_tax_amount"));
        }
        String deductionPurpose = example.getString("deduction_purpose");
        info.put("deductionPurpose", (Object)deductionPurpose);
        dynamicObject.set("deduction_purpose", (Object)deductionPurpose);
        if ("13".equals(deductibleMode) || "14".equals(deductibleMode) || "15".equals(deductibleMode)) {
            dynamicObject.set("purchase_ticket", (Object)"1");
        } else {
            dynamicObject.set("purchase_ticket", (Object)"2");
        }
        String authenticateFlag = dynamicObject.getString("authenticate_flag");
        if (StringUtils.isEmpty((CharSequence)authenticateFlag)) {
            dynamicObject.set("authenticate_flag", (Object)"0");
        }
        if (StringUtils.isNotEmpty((CharSequence)(deductionFlag = example.getString("deductionFlag")))) {
            dynamicObject.set(InvoiceSaveConstant.FIELD_DEDUCTION_FLAG, (Object)deductionFlag);
        }
        invoiceInfo.put(serialNo, info.toJSONString());
    }
}

