/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.deduction;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.invoice.deduction.DeductInvoiceOperateService;
import kd.imc.rim.common.invoice.deduction.DeductService;
import kd.imc.rim.common.invoice.deduction.SelectAccountService;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.ImcConfigUtil;
import kd.imc.rim.common.utils.ListUtils;
import kd.imc.rim.common.utils.MetadataUtil;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.common.utils.UUID;
import kd.imc.rim.common.utils.ViewUtil;
import org.apache.commons.lang3.tuple.Pair;

public abstract class DeductSelectService {
    private static Log LOGGER = LogFactory.getLog(DeductSelectService.class);
    protected int selectSize;

    public String getTitle() {
        return ResManager.loadKDString((String)"\u53d1\u7968\u52fe\u9009", (String)"DeductSelectService_10", (String)"imc-rim-common", (Object[])new Object[0]);
    }

    public JSONObject moreTaxNoInvoiceSelect(JSONObject paramJson) {
        JSONArray invoices;
        List list;
        Map<String, List<JSONObject>> invoiceGroupMap;
        JSONObject result = ResultContant.createSuccessJSONObject();
        LOGGER.info("\u52fe\u9009\u53c2\u6570:{}", (Object)paramJson);
        if (StringUtils.isBlank((Object)paramJson)) {
            result.put("errcode", (Object)"0201");
            result.put("description", (Object)ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef", (String)"DeductSelectService_0", (String)"imc-rim-common", (Object[])new Object[0]));
            return result;
        }
        if (CollectionUtils.isEmpty((Collection)paramJson.getJSONArray("invoices"))) {
            result.put("errcode", (Object)"0201");
            result.put("description", (Object)ResManager.loadKDString((String)"\u52fe\u9009\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (String)"DeductSelectService_1", (String)"imc-rim-common", (Object[])new Object[0]));
            return result;
        }
        if (StringUtils.isEmpty((CharSequence)paramJson.getString("taskNo"))) {
            paramJson.put("taskNo", (Object)UUID.randomUUID());
        }
        if (CollectionUtils.isEmpty(invoiceGroupMap = (list = JSONArray.parseArray((String)(invoices = paramJson.getJSONArray("invoices")).toJSONString(), JSONObject.class)).stream().filter(s -> StringUtils.isNotEmpty((CharSequence)s.getString("buyerTaxNo"))).collect(Collectors.groupingBy(s -> s.getString("buyerTaxNo"))))) {
            result.put("errcode", (Object)"0201");
            result.put("description", (Object)ResManager.loadKDString((String)"\u52fe\u9009\u6570\u636e\u6ca1\u6709\u4f20\u5165\u8d2d\u65b9\u7a0e\u53f7", (String)"DeductSelectService_2", (String)"imc-rim-common", (Object[])new Object[0]));
            return result;
        }
        int successNum = 0;
        int failNum = 0;
        String sync = "1";
        StringBuilder message = new StringBuilder();
        Set<Map.Entry<String, List<JSONObject>>> entrySet = invoiceGroupMap.entrySet();
        JSONArray batchNoArrTotal = new JSONArray();
        for (Map.Entry<String, List<JSONObject>> entry : entrySet) {
            JSONArray batchNoArr;
            Long orgId = null;
            paramJson.put("taxNo", (Object)entry.getKey());
            List<JSONObject> invoiceList = entry.getValue();
            for (JSONObject invoice : invoiceList) {
                if (ObjectUtils.isEmpty(orgId)) {
                    orgId = invoice.getLong("orgId");
                }
                invoice.remove((Object)"orgId");
            }
            paramJson.put("orgId", orgId);
            paramJson.put("invoices", invoiceList);
            JSONObject selectRtn = this.batchSelectInvoices(paramJson);
            sync = selectRtn.getString("sync");
            if (!ResultContant.isSuccess(selectRtn).booleanValue()) {
                result.put("errcode", selectRtn.get((Object)"errcode"));
            }
            if (!CollectionUtils.isEmpty((Collection)(batchNoArr = selectRtn.getJSONArray("batchNoList")))) {
                batchNoArrTotal.addAll((Collection)batchNoArr);
            }
            successNum += selectRtn.getInteger("successNum").intValue();
            failNum += selectRtn.getInteger("failNum").intValue();
            message.append(selectRtn.get((Object)"message"));
        }
        result.put("batchNoList", (Object)batchNoArrTotal);
        result.put("successNum", (Object)successNum);
        result.put("failNum", (Object)failNum);
        result.put("message", (Object)message.toString());
        result.put("sync", (Object)sync);
        return result;
    }

    public JSONObject batchSelectInvoices(JSONObject paramJson) {
        boolean isDateSplit;
        JSONObject result = ResultContant.createSuccessJSONObject();
        String taxNo = paramJson.getString("taxNo");
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            result.put("errcode", (Object)"0201");
            result.put("description", (Object)ResManager.loadKDString((String)"\u8bf7\u5148\u914d\u7f6e\u5f53\u524d\u7ec4\u7ec7\u7a0e\u53f7", (String)"DeductSelectService_3", (String)"imc-rim-common", (Object[])new Object[0]));
            return result;
        }
        Long orgId = paramJson.getLong("orgId");
        paramJson.put("userId", (Object)RequestContext.get().getUserId());
        if (ObjectUtils.isEmpty((Object)orgId)) {
            orgId = RequestContext.get().getOrgId();
            paramJson.put("orgId", (Object)orgId);
        }
        if (StringUtils.isEmpty((CharSequence)paramJson.getString("taskNo"))) {
            paramJson.put("taskNo", (Object)UUID.randomUUID());
        }
        DeductService service = this.getDeductServiceImpl(orgId);
        int successNum = 0;
        int failNum = 0;
        String sync = "1";
        StringBuilder message = new StringBuilder();
        JSONArray invoices = paramJson.getJSONArray("invoices");
        List invoiceList = JSONObject.parseArray((String)invoices.toJSONString(), JSONObject.class);
        ArrayList<String> batchNoList = new ArrayList<String>(8);
        String dkType = DeductionConstant.getDkType(taxNo);
        String dateSplit = RimConfigUtils.getConfig("rim_deduction", "all_type_split");
        boolean bl = isDateSplit = "1".equals(dateSplit) || "1".equals(dkType) || "4".equals(dkType);
        if (isDateSplit && !"1".equals(paramJson.getString("notDateSplit"))) {
            Map<String, List<JSONObject>> listToMonth = ListUtils.splitListToMonth(invoiceList, "invoiceDate");
            if (!CollectionUtils.isEmpty(listToMonth)) {
                for (List<JSONObject> list : listToMonth.values()) {
                    JSONObject resultMap = this.selectForGroups(list, paramJson, batchNoList, service);
                    successNum += ((Integer)resultMap.get((Object)"successNum")).intValue();
                    failNum += ((Integer)resultMap.get((Object)"failNum")).intValue();
                    message.append(resultMap.get((Object)"message"));
                    sync = (String)resultMap.get((Object)"sync");
                }
            }
        } else {
            JSONObject resultMap = this.selectForGroups(invoiceList, paramJson, batchNoList, service);
            successNum += ((Integer)resultMap.get((Object)"successNum")).intValue();
            failNum += ((Integer)resultMap.get((Object)"failNum")).intValue();
            message.append(resultMap.get((Object)"message"));
            sync = (String)resultMap.get((Object)"sync");
        }
        result.put("successNum", (Object)successNum);
        result.put("failNum", (Object)failNum);
        result.put("message", (Object)message.toString());
        result.put("sync", (Object)sync);
        String pageSelect = paramJson.getString("pageSelect");
        if ("1".equals(pageSelect) && !org.apache.commons.collections.CollectionUtils.isEmpty(batchNoList)) {
            result.put("batchNoList", (Object)JSONArray.parseArray((String)JSON.toJSONString(batchNoList)));
        }
        this.queryAsyncSelectResult(batchNoList);
        return result;
    }

    private JSONObject selectForGroups(List<JSONObject> invoiceList, JSONObject paramJson, List<String> batchNoList, DeductService service) {
        int successNum = 0;
        int failNum = 0;
        String sync = "";
        StringBuilder message = new StringBuilder();
        if (invoiceList.size() <= this.selectSize) {
            paramJson.put("requestId", (Object)UUID.randomUUID());
            paramJson.put("invoices", invoiceList);
            Map<String, Object> resultMap = this.selectedResult(service, paramJson);
            successNum += ((Integer)resultMap.get("successNum")).intValue();
            failNum += ((Integer)resultMap.get("failNum")).intValue();
            message.append(resultMap.get("message"));
            String batchNo = (String)resultMap.get("batchNo");
            sync = (String)resultMap.get("sync");
            if (StringUtils.isNotEmpty((CharSequence)batchNo)) {
                if (batchNo.contains(",")) {
                    batchNoList.addAll(Arrays.asList(batchNo.split(",")));
                } else {
                    batchNoList.add(batchNo);
                }
            }
        } else {
            List<List<JSONObject>> groups = ListUtils.splitList(invoiceList, this.selectSize);
            if (!CollectionUtils.isEmpty(groups)) {
                for (List<JSONObject> array : groups) {
                    paramJson.put("requestId", (Object)UUID.randomUUID());
                    paramJson.put("invoices", array);
                    Map<String, Object> resultMap = this.selectedResult(service, paramJson);
                    sync = (String)resultMap.get("sync");
                    successNum += ((Integer)resultMap.get("successNum")).intValue();
                    failNum += ((Integer)resultMap.get("failNum")).intValue();
                    message.append(resultMap.get("message"));
                    String batchNo1 = (String)resultMap.get("batchNo");
                    if (!StringUtils.isNotEmpty((CharSequence)batchNo1)) continue;
                    if (batchNo1.contains(",")) {
                        batchNoList.addAll(Arrays.asList(batchNo1.split(",")));
                        continue;
                    }
                    batchNoList.add(batchNo1);
                }
            }
        }
        JSONObject result = new JSONObject();
        result.put("successNum", (Object)successNum);
        result.put("failNum", (Object)failNum);
        result.put("message", (Object)message.toString());
        result.put("sync", (Object)sync);
        return result;
    }

    public abstract DeductService getDeductServiceImpl(Long var1);

    public Map<String, Object> selectedResult(DeductService service, JSONObject paramJson) {
        String operateName;
        HashMap result = Maps.newHashMap();
        int successNum = 0;
        int failNum = 0;
        String taxNo = paramJson.getString("taxNo");
        JSONObject gxInvoicesRtn = null;
        gxInvoicesRtn = StringUtils.isNotEmpty((CharSequence)paramJson.getString("errcode")) ? ResultContant.createJSONObject(paramJson.getString("errcode"), paramJson.getString("description")) : service.gxInvoices(paramJson);
        CommonUtils.copyData(paramJson, gxInvoicesRtn, "account");
        String batchNo = UUID.getBatchNoByTaxNo(taxNo);
        StringBuilder message = new StringBuilder();
        JSONObject resultData = gxInvoicesRtn.getJSONObject("data");
        String deductibleMode = paramJson.getString("deductibleMode");
        Pair<String, String> deductionPurposeMap = DeductionConstant.getDeductionPurpose(deductibleMode);
        String string = operateName = "1".equals(deductionPurposeMap.getLeft()) ? ResManager.loadKDString((String)"\u53d1\u7968\u52fe\u9009", (String)"DeductSelectService_10", (String)"imc-rim-common", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u64a4\u9500\u52fe\u9009", (String)"DeductSelectService_11", (String)"imc-rim-common", (Object[])new Object[0]);
        if (resultData != null && resultData.get((Object)"success") != null && resultData.get((Object)"fail") != null) {
            this.updateInvoiceStatus(paramJson, resultData, batchNo, message, "1");
            successNum = resultData.getJSONArray("success").size();
            JSONArray failArray = resultData.getJSONArray("fail");
            failNum = failArray.size();
        } else if (Objects.equals("10006", gxInvoicesRtn.getString("errcode"))) {
            this.insertSelectAccount(paramJson, "10006", ResManager.loadKDString((String)"\u6ca1\u6709\u7533\u8bf7\u8f6f\u8bc1\u4e66", (String)"DeductSelectService_12", (String)"imc-rim-common", (Object[])new Object[0]), batchNo, "1", "2");
            failNum = paramJson.getJSONArray("invoices").size();
            this.setFailMessage(paramJson, String.format(ResManager.loadKDString((String)"\u7a0e\u53f7:%1$s \u6ca1\u6709\u7533\u8bf7\u8f6f\u8bc1\u4e66\u3002", (String)"DeductSelectService_4", (String)"imc-rim-common", (Object[])new Object[0]), taxNo), message);
        } else {
            this.insertSelectAccount(paramJson, gxInvoicesRtn.getString("errcode"), gxInvoicesRtn.getString("description"), batchNo, "1", "2");
            failNum = paramJson.getJSONArray("invoices").size();
            this.setFailMessage(paramJson, String.format(ResManager.loadKDString((String)"%1$s\u5931\u8d25:%2$s", (String)"DeductSelectService_5", (String)"imc-rim-common", (Object[])new Object[0]), operateName, gxInvoicesRtn.getString("description")), message);
        }
        result.put("batchNo", batchNo);
        result.put("errcode", gxInvoicesRtn.getString("errcode"));
        result.put("successNum", successNum);
        result.put("failNum", failNum);
        result.put("message", message.toString());
        result.put("sync", "1");
        return result;
    }

    public void updateInvoiceStatus(JSONObject paramJson, JSONObject resultData, String batchNo, StringBuilder message, String selectType) {
        String electronicNo;
        LOGGER.info("\u66f4\u65b0\u53d1\u7968\u8ba4\u8bc1\u72b6\u6001");
        JSONArray invoiceParams = paramJson.getJSONArray("invoices");
        JSONArray successArray = resultData.getJSONArray("success");
        JSONArray failArray = resultData.getJSONArray("fail");
        JSONArray selectAccountList = new JSONArray();
        String taxPeriod = resultData.getString("taxPeriod");
        String deductibleMode = paramJson.getString("deductibleMode");
        Pair<String, String> deductionPurposeMap = DeductionConstant.getDeductionPurpose(deductibleMode);
        DeductInvoiceOperateService deductInvoiceOperateService = new DeductInvoiceOperateService();
        String selectOperationType = paramJson.getString("selectOperationType");
        if (StringUtils.isEmpty((CharSequence)selectOperationType)) {
            selectOperationType = "1";
        }
        String operateName = "1".equals(deductionPurposeMap.getLeft()) ? ResManager.loadKDString((String)"\u53d1\u7968\u52fe\u9009", (String)"DeductSelectService_10", (String)"imc-rim-common", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u64a4\u9500\u52fe\u9009", (String)"DeductSelectService_11", (String)"imc-rim-common", (Object[])new Object[0]);
        String billType = paramJson.getString("billType");
        JSONArray updateSelectInvoiceArray = new JSONArray();
        if (!CollectionUtils.isEmpty((Collection)successArray)) {
            JSONObject success = null;
            JSONObject param = null;
            JSONObject example = null;
            JSONObject selectAccount = null;
            block0: for (int i = 0; i < successArray.size(); ++i) {
                success = successArray.getJSONObject(i);
                for (int j = 0; j < invoiceParams.size(); ++j) {
                    String notDeductibleType;
                    param = invoiceParams.getJSONObject(j);
                    if (!CommonUtils.compareInvoiceCodeNo(success, param, billType)) continue;
                    String serialNo = param.getString("serialNo");
                    String invoiceTypeStr = param.getString("invoiceType");
                    Long invoiceType = this.getInvoiceType(invoiceTypeStr);
                    if (StringUtils.isEmpty((CharSequence)serialNo)) {
                        Pair<String, Long> serialNoPair = this.querySerialNoByCodeNo(param, billType);
                        serialNo = (String)serialNoPair.getLeft();
                        invoiceType = (Long)serialNoPair.getRight();
                    }
                    if (StringUtils.isEmpty((CharSequence)(notDeductibleType = success.getString("notDeductibleType")))) {
                        notDeductibleType = param.getString("notDeductibleType");
                    }
                    if (StringUtils.isNotEmpty((CharSequence)serialNo)) {
                        example = new JSONObject();
                        example.put("serial_no", (Object)serialNo);
                        example.put("invoice_type", (Object)invoiceType);
                        String deductionPurpose = success.getString("deductiblePurpose");
                        if (StringUtils.isEmpty((CharSequence)deductionPurpose)) {
                            deductionPurpose = (String)deductionPurposeMap.getRight();
                        }
                        example.put("deduction_purpose", (Object)deductionPurpose);
                        example.put("effective_tax_amount", (Object)success.getBigDecimal("effectiveTaxAmount"));
                        example.put("tax_period", (Object)success.getString("taxPeriod"));
                        example.put("authenticate_flag", deductionPurposeMap.getLeft());
                        example.put("select_time", (Object)success.getString("selectDate"));
                        example.put("cancel_select_type", (Object)selectOperationType);
                        example.put("not_deductible_type", (Object)notDeductibleType);
                        example.put("operate_time", (Object)success.getString("operateTime"));
                        updateSelectInvoiceArray.add((Object)example);
                    }
                    selectAccount = this.getBaseSelectAccount(batchNo, serialNo, param, selectOperationType, deductibleMode, (String)deductionPurposeMap.getLeft(), invoiceType);
                    electronicNo = this.getElectronicNo(success, param);
                    selectAccount.put("electronic_no", (Object)electronicNo);
                    selectAccount.put("not_deductible_type", (Object)notDeductibleType);
                    selectAccount.put("effective_tax_amount", (Object)success.getBigDecimal("effectiveTaxAmount"));
                    selectAccount.put("select_time", (Object)success.getString("selectDate"));
                    selectAccount.put("select_result", (Object)"1");
                    selectAccount.put("handle_status", (Object)"1");
                    selectAccount.put("description", (Object)ResManager.loadKDString((String)"\u6210\u529f", (String)"DeductSelectService_6", (String)"imc-rim-common", (Object[])new Object[0]));
                    selectAccountList.add((Object)selectAccount);
                    continue block0;
                }
            }
        }
        if (!CollectionUtils.isEmpty((Collection)failArray)) {
            long failStartTime = System.currentTimeMillis();
            JSONObject fail = null;
            JSONObject param = null;
            JSONObject selectAccount = null;
            block2: for (int i = 0; i < failArray.size(); ++i) {
                fail = failArray.getJSONObject(i);
                if (fail == null) continue;
                for (int j = 0; j < invoiceParams.size(); ++j) {
                    param = invoiceParams.getJSONObject(j);
                    if (!CommonUtils.compareInvoiceCodeNo(fail, param, billType)) continue;
                    String serialNo = param.getString("serialNo");
                    String invoiceTypeStr = param.getString("invoiceType");
                    Long invoiceType = this.getInvoiceType(invoiceTypeStr);
                    if (StringUtils.isEmpty((CharSequence)serialNo)) {
                        Pair<String, Long> failSerialNoPair = this.querySerialNoByCodeNo(param, billType);
                        serialNo = (String)failSerialNoPair.getLeft();
                        invoiceType = (Long)failSerialNoPair.getRight();
                    }
                    selectAccount = this.getBaseSelectAccount(batchNo, serialNo, param, selectOperationType, deductibleMode, (String)deductionPurposeMap.getLeft(), invoiceType);
                    electronicNo = this.getElectronicNo(fail, param);
                    selectAccount.put("electronic_no", (Object)electronicNo);
                    selectAccount.put("not_deductible_type", (Object)param.getString("notDeductibleType"));
                    selectAccount.put("pre_authenticate_flag", param.get((Object)"preAuthenticateFlag"));
                    selectAccount.put("effective_tax_amount", (Object)param.getBigDecimal("effectiveTaxAmount"));
                    String selectResult = fail.getString("selectResult");
                    if (StringUtils.isNotEmpty((CharSequence)selectResult) && selectResult.startsWith("8-")) {
                        selectResult = "8";
                    }
                    selectAccount.put("select_result", (Object)selectResult);
                    selectAccount.put("handle_status", (Object)"2");
                    selectAccountList.add((Object)selectAccount);
                    String msg = fail.getString("description");
                    if ("2".equals(selectResult)) {
                        Date invoiceDate = param.getDate("invoiceDate");
                        Date nowDate = DateUtils.getDayStart(new Date());
                        if (invoiceDate != null && nowDate.compareTo(invoiceDate) == 0) {
                            msg = ResManager.loadKDString((String)"\u5f53\u5929\u5f00\u5177\u7684\u53d1\u7968\u4e0d\u80fd\u52fe\u9009,\u8bf7\u7b2c\u4e8c\u5929\u518d\u64cd\u4f5c", (String)"DeductSelectService_7", (String)"imc-rim-common", (Object[])new Object[0]);
                            selectResult = "37";
                            selectAccount.put("select_result", (Object)selectResult);
                        }
                    }
                    if (StringUtils.isEmpty((CharSequence)msg)) {
                        msg = MetadataUtil.getComboItemName("rim_select_account", "select_result", selectResult);
                    }
                    selectAccount.put("description", (Object)msg);
                    message.append(String.format(ResManager.loadKDString((String)"\u53d1\u7968:%1$s %2$s\u5931\u8d25:%3$s\u3002", (String)"DeductSelectService_8", (String)"imc-rim-common", (Object[])new Object[0]), CommonUtils.getInvoiceCodeNoGroup(param.getString("invoiceCode"), param.getString("invoiceNo")), operateName, msg)).append(ViewUtil.LINE_SEPARATOR);
                    continue block2;
                }
            }
            LOGGER.info("\u7ec4\u88c5\u5931\u8d25\u7684\u6570\u636e\u8017\u65f6:{}", (Object)(System.currentTimeMillis() - failStartTime));
        }
        deductInvoiceOperateService.updateBatchSelectedInvoice(updateSelectInvoiceArray, deductibleMode, paramJson.getString("taxNo"));
        SelectAccountService selectAccountService = new SelectAccountService();
        JSONObject logParam = this.getSelectLog(paramJson, batchNo, selectType, taxPeriod, deductibleMode, selectOperationType, "1");
        selectAccountService.asyncSaveSelectLogAndAccount(logParam, selectAccountList);
    }

    private JSONObject getSelectLog(JSONObject paramJson, String batchNo, String selectType, String taxPeriod, String deductibleMode, String selectOperationType, String selectStatusSuccess) {
        JSONObject logParam = new JSONObject();
        logParam.put("taskNo", (Object)paramJson.getString("taskNo"));
        logParam.put("taxPeriod", (Object)taxPeriod);
        Long orgId = paramJson.getLong("orgId");
        if (orgId == null || orgId == 0L) {
            orgId = RequestContext.get().getOrgId();
        }
        logParam.put("orgId", (Object)orgId);
        logParam.put("taxNo", (Object)paramJson.getString("taxNo"));
        logParam.put("batchNo", (Object)batchNo);
        String asyncFlag = Optional.ofNullable(paramJson.getString("asyncFlag")).filter(StringUtils::isNotEmpty).orElse("0");
        logParam.put("asyncFlag", (Object)asyncFlag);
        logParam.put("selectType", (Object)selectType);
        logParam.put("billType", (Object)paramJson.getString("billType"));
        logParam.put("account", (Object)paramJson.getString("account"));
        logParam.put("selectOperaType", (Object)selectOperationType);
        logParam.put("deductibleMode", (Object)deductibleMode);
        logParam.put("handleStatus", (Object)selectStatusSuccess);
        return logParam;
    }

    private Long getInvoiceType(String invoiceTypeStr) {
        Long invoiceType = 0L;
        if (StringUtils.isEmpty((CharSequence)invoiceTypeStr)) {
            return invoiceType;
        }
        try {
            invoiceType = invoiceTypeStr.length() > 6 ? Long.valueOf(Long.parseLong(invoiceTypeStr)) : InputInvoiceTypeEnum.getInvoiceTypeByAwsType(invoiceTypeStr);
        }
        catch (Exception e) {
            LOGGER.info("\u53d1\u7968\u7c7b\u578b\u683c\u5f0f\u8f6c\u6362\u5931\u8d25:" + e);
        }
        return invoiceType;
    }

    public void insertSelectAccount(JSONObject paramJson, String errcode, String batchNo, String selectType, String handleStatus) {
        this.insertSelectAccount(paramJson, errcode, null, batchNo, selectType, handleStatus, true);
    }

    public void insertSelectAccount(JSONObject paramJson, String errcode, String description, String batchNo, String selectType, String handleStatus) {
        this.insertSelectAccount(paramJson, errcode, description, batchNo, selectType, handleStatus, true);
    }

    public void insertSelectAccount(JSONObject paramJson, String errcode, String description, String batchNo, String selectType, String handleStatus, boolean isAsyncSave) {
        JSONArray selectAccountList = new JSONArray();
        String deductibleMode = paramJson.getString("deductibleMode");
        Pair<String, String> deductionPurposeMap = DeductionConstant.getDeductionPurpose(deductibleMode);
        JSONArray invoiceParams = paramJson.getJSONArray("invoices");
        JSONObject param = null;
        JSONObject selectAccount = null;
        String selectOperationType = paramJson.getString("selectOperationType");
        if (StringUtils.isEmpty((CharSequence)selectOperationType)) {
            selectOperationType = "1";
        }
        String billType = paramJson.getString("billType");
        for (int j = 0; j < invoiceParams.size(); ++j) {
            param = invoiceParams.getJSONObject(j);
            String serialNo = param.getString("serialNo");
            String invoiceTypeStr = param.getString("invoiceType");
            Long invoiceType = this.getInvoiceType(invoiceTypeStr);
            if (StringUtils.isEmpty((CharSequence)serialNo)) {
                Pair<String, Long> serialNoPair = this.querySerialNoByCodeNo(param, billType);
                serialNo = (String)serialNoPair.getLeft();
                invoiceType = (Long)serialNoPair.getRight();
            }
            selectAccount = this.getBaseSelectAccount(batchNo, serialNo, param, selectOperationType, deductibleMode, (String)deductionPurposeMap.getLeft(), invoiceType);
            String electronicNo = this.getElectronicNo(null, param);
            selectAccount.put("electronic_no", (Object)electronicNo);
            selectAccount.put("not_deductible_type", (Object)param.getString("notDeductibleType"));
            selectAccount.put("effective_tax_amount", (Object)param.getBigDecimal("effectiveTaxAmount"));
            selectAccount.put("agric_partial_amount", (Object)param.getBigDecimal("agricPartialAmount"));
            if ("10006".equals(errcode)) {
                selectAccount.put("select_result", (Object)"33");
            } else if (ErrorType.STATUS_HANDLING.getCode().equals(errcode)) {
                selectAccount.put("select_result", (Object)"35");
            } else if (ErrorType.ALl_E_LOGIN_FAIL.getCode().equals(errcode)) {
                selectAccount.put("select_result", (Object)"36");
            } else {
                selectAccount.put("select_result", (Object)"34");
            }
            if (StringUtils.isNotBlank((CharSequence)param.getString("selectResult"))) {
                selectAccount.put("select_result", (Object)param.getString("selectResult"));
                selectAccount.put("handle_status", (Object)"2");
                selectAccount.put("description", (Object)param.getString("description"));
            } else {
                selectAccount.put("handle_status", (Object)handleStatus);
            }
            if (StringUtils.isEmpty((CharSequence)selectAccount.getString("description"))) {
                if (StringUtils.isEmpty((CharSequence)description)) {
                    description = MetadataUtil.getComboItemName("rim_select_account", "select_result", selectAccount.getString("select_result"));
                }
                selectAccount.put("description", (Object)description);
            }
            selectAccountList.add((Object)selectAccount);
        }
        String taxNo = paramJson.getString("taxNo");
        String taxPeriod = paramJson.getString("taxPeriod");
        if (StringUtils.isEmpty((CharSequence)taxPeriod)) {
            taxPeriod = DeductionConstant.getSkssq(taxNo);
        }
        SelectAccountService selectAccountService = new SelectAccountService();
        JSONObject logParam = this.getSelectLog(paramJson, batchNo, selectType, taxPeriod, deductibleMode, selectOperationType, handleStatus);
        if (isAsyncSave) {
            selectAccountService.asyncSaveSelectLogAndAccount(logParam, selectAccountList);
        } else {
            selectAccountService.saveSelectLogAndAccount(logParam, selectAccountList);
        }
    }

    public void setFailMessage(JSONObject paramJson, String failResult, StringBuilder message) {
        JSONArray invoiceParams = paramJson.getJSONArray("invoices");
        for (int i = 0; i < invoiceParams.size(); ++i) {
            JSONObject invoice = invoiceParams.getJSONObject(i);
            message.append(String.format(ResManager.loadKDString((String)"\u53d1\u7968:%1$s %2$s\u3002", (String)"DeductSelectService_9", (String)"imc-rim-common", (Object[])new Object[0]), CommonUtils.getInvoiceCodeNoGroup(invoice.getString("invoiceCode"), invoice.getString("invoiceNo")), failResult)).append(ViewUtil.LINE_SEPARATOR);
        }
    }

    public void queryAsyncSelectResult(List<String> batchNoList) {
    }

    public void updateInvoiceSelecting(Map<String, String> serialNoStatusMap) {
        if (!CollectionUtils.isEmpty(serialNoStatusMap)) {
            LOGGER.info("\u66f4\u65b0\u53d1\u7968\u52fe\u9009\u72b6\u6001:{}", serialNoStatusMap);
            DeductInvoiceOperateService operateService = new DeductInvoiceOperateService();
            operateService.updateMainInvoiceSelecting(serialNoStatusMap);
        }
    }

    private Pair<String, Long> querySerialNoByCodeNo(JSONObject param, String billType) {
        String serialNo = null;
        Long invoiceType = 0L;
        if (param != null) {
            DynamicObject dbInvoiceObj;
            QFilter invoiceCodeNoFilter = new QFilter("invoice_code", "=", (Object)StringUtils.trimToEmpty((String)param.getString("invoiceCode"))).and("invoice_no", "=", (Object)param.getString("invoiceNo"));
            Date invoiceDate = param.getDate("invoiceDate");
            if ("2".equals(billType) && invoiceDate != null) {
                invoiceDate = DateUtils.trunc(invoiceDate);
                invoiceCodeNoFilter.and("invoice_date", ">=", (Object)invoiceDate);
                invoiceCodeNoFilter.and("invoice_date", "<", (Object)DateUtils.addDay(invoiceDate, 1));
            }
            if ((dbInvoiceObj = QueryServiceHelper.queryOne((String)"rim_invoice", (String)"invoice_type, serial_no", (QFilter[])invoiceCodeNoFilter.toArray())) != null) {
                serialNo = dbInvoiceObj.getString("serial_no");
                invoiceType = DynamicObjectUtil.getDynamicObjectLongValue(dbInvoiceObj.get("invoice_type"));
            }
        }
        return Pair.of(serialNo, (Object)invoiceType);
    }

    private JSONObject getBaseSelectAccount(String batchNo, String serialNo, JSONObject param, String selectOperationType, String deductibleMode, String selectStatus, Long invoiceType) {
        JSONObject selectAccount = new JSONObject();
        selectAccount.put("batch_no", (Object)batchNo);
        selectAccount.put("serial_no", (Object)serialNo);
        selectAccount.put("invoice_code", (Object)param.getString("invoiceCode"));
        selectAccount.put("invoice_no", (Object)param.getString("invoiceNo"));
        selectAccount.put("electronic_no", (Object)param.getString("etaxInvoiceNo"));
        selectAccount.put("invoice_type", (Object)invoiceType);
        selectAccount.put("select_opera_type", (Object)selectOperationType);
        selectAccount.put("pre_authenticate_flag", param.get((Object)"preAuthenticateFlag"));
        selectAccount.put("deduction_purpose", (Object)deductibleMode);
        selectAccount.put("total_tax_amount", (Object)param.getBigDecimal("totalTaxAmount"));
        selectAccount.put("invoice_amount", (Object)param.getBigDecimal("invoiceAmount"));
        selectAccount.put("invoice_date", param.get((Object)"invoiceDate"));
        selectAccount.put("saler_name", param.get((Object)"salerName"));
        selectAccount.put("saler_tax_no", param.get((Object)"salerTaxNo"));
        selectAccount.put("select_status", (Object)selectStatus);
        return selectAccount;
    }

    private String getElectronicNo(JSONObject result, JSONObject param) {
        String etaxInvoiceNo;
        if (result != null && StringUtils.isNotEmpty((CharSequence)(etaxInvoiceNo = result.getString("etaxInvoiceNo")))) {
            return etaxInvoiceNo;
        }
        if (param != null) {
            return param.getString("etaxInvoiceNo");
        }
        return null;
    }

    public void handlePartialFail(JSONArray fail, JSONArray invoices, StringBuilder message, String operateName) {
        this.handlePartialFail(fail, invoices, message, operateName, "");
    }

    public void handlePartialFail(JSONArray fail, JSONArray invoices, StringBuilder message, String operateName, String billType) {
        if (CollectionUtils.isEmpty((Collection)fail) || CollectionUtils.isEmpty((Collection)invoices)) {
            return;
        }
        block0: for (int j = 0; j < invoices.size(); ++j) {
            JSONObject invoice = invoices.getJSONObject(j);
            for (int i = 0; i < fail.size(); ++i) {
                JSONObject failJson = fail.getJSONObject(i);
                if (!CommonUtils.compareInvoiceCodeNo(failJson, invoice, billType)) continue;
                invoice.put("selectResult", (Object)failJson.getString("selectResult"));
                invoice.put("description", (Object)failJson.getString("description"));
                message.append(String.format(ResManager.loadKDString((String)"\u53d1\u7968:%1$s %2$s\u5931\u8d25:%3$s\u3002", (String)"DeductSelectService_8", (String)"imc-rim-common", (Object[])new Object[0]), CommonUtils.getInvoiceCodeNoGroup(invoice.getString("invoiceCode"), invoice.getString("invoiceNo")), operateName, failJson.getString("description"))).append(ViewUtil.LINE_SEPARATOR);
                continue block0;
            }
        }
    }

    public static boolean isSyncDown(String taxNo) {
        Map<String, String> downSyncMap = ImcConfigUtil.getValue("rim_etax_select_syn");
        if (ObjectUtils.isEmpty(downSyncMap) || ObjectUtils.isEmpty((Object)taxNo)) {
            return false;
        }
        String allAsync = downSyncMap.get("all_taxno");
        String taxNoAsync = downSyncMap.get(taxNo);
        String batchTaxNos = downSyncMap.get("taxnos");
        return StringUtils.contains((CharSequence)batchTaxNos, (CharSequence)taxNo) || "1".equals(allAsync) || "1".equals(taxNoAsync);
    }
}

