/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.deduction;

import com.alibaba.fastjson.JSONObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPools;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.utils.TenantUtils;

public abstract class DeductService {
    private static Log LOGGER = LogFactory.getLog(DeductService.class);
    protected AbstractFormPlugin plugin;
    protected Long orgId;
    public int maxSizeRecorded = 500;

    public JSONObject login(JSONObject param) {
        return this.getDefultLoginResult();
    }

    public JSONObject login(String taxNo, String operationKey, AbstractFormPlugin plugin) {
        return this.getDefultLoginResult();
    }

    public JSONObject login(String taxNo) {
        return this.getDefultLoginResult();
    }

    protected JSONObject getDefultLoginResult() {
        JSONObject data = new JSONObject();
        data.put("loginType", (Object)"1");
        return ResultContant.createSuccessJSONObject(data);
    }

    public boolean needOpenLoginPage(JSONObject data) {
        return data != null && !"1".equals(data.getString("loginType")) && "-1".equals(data.getString("etaxAccountType"));
    }

    public void showLoginPage(JSONObject param, AbstractFormPlugin plugin, String actionId) {
    }

    public void clearLoginState(String taxNo) {
    }

    public String syncGetTaxperiod(String taxNo) {
        LOGGER.info("\u540c\u6b65\u83b7\u53d6\u7a0e\u671f" + taxNo);
        String taxPeriod = "";
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return taxPeriod;
        }
        if (DeductionConstant.updateSkssq(taxNo).booleanValue()) {
            String ssq;
            JSONObject data;
            JSONObject resultJson = this.queryTaxperiod(taxNo);
            if (ResultContant.isSuccess(resultJson).booleanValue() && (data = resultJson.getJSONObject("data")) != null && StringUtils.isNotEmpty((CharSequence)(ssq = data.getString("skssq")))) {
                DeductionConstant.cacheSkssq(taxNo, ssq);
                String[] ssqs = ssq.split(";");
                taxPeriod = ssqs[0];
            }
        } else {
            taxPeriod = DeductionConstant.getSkssq(taxNo);
        }
        return taxPeriod;
    }

    public abstract JSONObject queryTaxperiod(String var1);

    public void getTaxPeriod() {
        String taxNo = TenantUtils.getTaxNoByOrgId(this.orgId);
        this.getTaxPeriodByTaxNo(taxNo);
    }

    public void getTaxPeriodByTaxNo(String taxNo) {
        if (StringUtils.isEmpty((CharSequence)taxNo)) {
            return;
        }
        if (DeductionConstant.updateSkssq(taxNo).booleanValue()) {
            ThreadPools.executeOnceIncludeRequestContext((String)"HolytaxCommonsService.getTaxPeriod", () -> {
                try (DLock lock = DLock.create((String)("rim.getTaxPeriod" + taxNo), (String)ResManager.loadKDString((String)"\u83b7\u53d6\u6240\u5c5e\u7a0e\u671f", (String)"DeductService_0", (String)"imc-rim-common", (Object[])new Object[0]));){
                    if (lock.tryLock()) {
                        String ssq;
                        JSONObject data;
                        JSONObject resultJson = this.queryTaxperiod(taxNo);
                        LOGGER.info("\u83b7\u53d6\u7a0e\u671f\u7ed3\u679c\u8fd4\u56de:" + resultJson);
                        if (ResultContant.isSuccess(resultJson).booleanValue() && (data = resultJson.getJSONObject("data")) != null && StringUtils.isNotEmpty((CharSequence)(ssq = data.getString("skssq")))) {
                            DeductionConstant.cacheSkssq(taxNo, ssq);
                        }
                    }
                }
            });
        }
    }

    public void getTaxPeriod(String taxNo) {
        this.getTaxPeriodByTaxNo(taxNo);
    }

    public JSONObject changeTaxperiod(JSONObject bodyJson) {
        return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL.getCode(), ResManager.loadKDString((String)"\u975e\u65b0\u7535\u5b50\u5e73\u53f0\u6216\u8005\u4e50\u4f01\u901a\u9053\uff0c\u4e0d\u652f\u6301\u53d8\u66f4\u5c5e\u671f\u3002", (String)"DeductService_1", (String)"imc-rim-common", (Object[])new Object[0]));
    }

    public abstract JSONObject queryInvoices(JSONObject var1);

    public abstract JSONObject getStatisticTable(JSONObject var1);

    public JSONObject queryStatisticTable(JSONObject param) {
        return null;
    }

    public abstract JSONObject createStatisticTable(JSONObject var1);

    public abstract JSONObject cancelStatisticTable(JSONObject var1);

    public abstract JSONObject confirmStatisticTable(JSONObject var1);

    public JSONObject queryConfirmStatisticTable(JSONObject paramJson) {
        return null;
    }

    public abstract JSONObject gxInvoices(JSONObject var1);

    public JSONObject gxInvoicesQuery(JSONObject bodyJson) {
        return null;
    }

    public JSONObject queryHistoryStatistics(String taxNo, String taxPeriod, String invoiceType) {
        return null;
    }

    public JSONObject queryHistoryStatistics(String taxNo, String taxPeriod, String invoiceType, String synctype) {
        return null;
    }

    public JSONObject queryHistoryStatistics(String taxNo, String taxPeriod) {
        return this.queryHistoryStatistics(taxNo, taxPeriod, "");
    }

    public abstract JSONObject queryHistoryStatistics(String var1, String var2, boolean var3);

    public JSONObject queryHistoryStatisticsTable(String taxNo, String taxPeriod) {
        return null;
    }

    public JSONObject applyFullInvoice(JSONObject paramJson) {
        return null;
    }

    public JSONObject downFullInvoice(JSONObject paramJson) {
        return null;
    }

    public JSONObject incrementalDownFullInvoice(JSONObject param) {
        return null;
    }

    public JSONObject queryInvoiceStatus(JSONObject paramJson) {
        return null;
    }

    public abstract JSONObject getDrawbackStatisticTable(JSONObject var1);

    public abstract JSONObject drawbackStatisticConfirm(JSONObject var1);

    public JSONObject applyInvoiceFile(JSONObject param) {
        return null;
    }

    public JSONObject gxInvoicesAsyn(JSONObject requestParam) {
        return null;
    }

    public JSONObject downInvoiceFile(JSONObject param) {
        return null;
    }

    public JSONObject discardTasks(JSONObject bodyJson) {
        return null;
    }

    public JSONObject agricInvoiceHandle(JSONObject param) {
        return ResultContant.createJSONObject(ErrorType.AGRIC_HANDLE_NONSUPPORT);
    }

    public JSONObject agricInvoiceHandleQuery(JSONObject param) {
        return ResultContant.createJSONObject(ErrorType.AGRIC_HANDLE_NONSUPPORT);
    }

    public JSONObject checkRecordedInvoiceParam(JSONObject param, String operateType) {
        return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u7684\u6536\u7968\u901a\u9053\u4e0d\u652f\u6301\u7a0e\u5c40\u5165\u8d26\u64cd\u4f5c", (String)"DeductService_4", (String)"imc-rim-common", (Object[])new Object[0]));
    }

    public JSONObject createRecordedInvoiceParam(JSONObject param) {
        return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u7684\u6536\u7968\u901a\u9053\u4e0d\u652f\u6301\u7a0e\u5c40\u5165\u8d26\u64cd\u4f5c", (String)"DeductService_4", (String)"imc-rim-common", (Object[])new Object[0]));
    }

    public JSONObject recordedCommit(JSONObject param) {
        return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL.getCode(), ResManager.loadKDString((String)"\u975erpa\u5165\u8d26\u63a5\u53e3\uff0c\u4e0d\u652f\u6301\u5165\u8d26\u63d0\u4ea4", (String)"DeductService_2", (String)"imc-rim-common", (Object[])new Object[0]));
    }

    public JSONObject queryRecordedCommitResult(JSONObject param) {
        return ResultContant.createJSONObject(ErrorType.TAX_NO_NULL.getCode(), ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u7684\u6536\u7968\u901a\u9053\u4e0d\u652f\u6301\u5165\u8d26\u63d0\u4ea4\u7ed3\u679c\u67e5\u8be2", (String)"DeductService_3", (String)"imc-rim-common", (Object[])new Object[0]));
    }

    public JSONObject applyDownAgricInvoice(JSONObject paramJson) {
        return ResultContant.createJSONObject(ErrorType.AGRIC_DOWN_NONSUPPORT);
    }

    public JSONObject downAgricInvoice(JSONObject paramJson) {
        return ResultContant.createJSONObject(ErrorType.AGRIC_DOWN_NONSUPPORT);
    }

    public JSONObject getDownInvoiceHeadResult(JSONObject paramJson) {
        return ResultContant.createJSONObject(ErrorType.DOWN_HEAD_NOT_SUPPORT);
    }

    public JSONObject downInvoiceHeadApply(JSONObject paramJson) {
        return ResultContant.createJSONObject(ErrorType.DOWN_HEAD_NOT_SUPPORT);
    }

    public JSONObject batchTaskHandleQuery(JSONObject paramJson) {
        return ResultContant.createJSONObject(ErrorType.FAIL);
    }
}

