/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.deduction;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.imc.rim.common.constant.DeductInvoiceTypeEnum;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.constant.StatisticsStatusEnum;
import kd.imc.rim.common.helper.ImcSaveServiceHelper;
import kd.imc.rim.common.invoice.collector.InvoiceHeaderDownService;
import kd.imc.rim.common.invoice.deduction.DeductInvoiceOperateService;
import kd.imc.rim.common.invoice.deduction.DeductService;
import kd.imc.rim.common.invoice.deduction.DeductServiceFactory;
import kd.imc.rim.common.invoice.deduction.SelectAccountService;
import kd.imc.rim.common.invoice.deduction.StatisticService;
import kd.imc.rim.common.invoice.deduction.UpdatePeriodInvoiceTask;
import kd.imc.rim.common.invoice.deduction.impl.LqDeductService;
import kd.imc.rim.common.invoice.download.impl.HeaderInvoiceDownServiceImpl;
import kd.imc.rim.common.invoice.model.SelectLog;
import kd.imc.rim.common.invoice.query.convert.InvoiceConvertService;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DeductionUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.MetadataUtil;
import kd.imc.rim.common.utils.TenantUtils;
import kd.imc.rim.common.utils.UUID;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class DeductStatisticsService {
    private static Log LOGGER = LogFactory.getLog(DeductStatisticsService.class);
    private static final int PERIOD_THREADPOOL_SIZE = 6;
    private static ThreadPool periodInvoiceThreadPool = ThreadPools.newFixedThreadPool((String)"upate_period_invoice_thread", (int)6);
    private static final String[] BILL_TYPES = new String[]{"0", "1"};
    private static final String SELECT_FILED = "serial_no,invoice_code,invoice_no,invoice_date,invoice_amount,effective_tax_amount,total_tax_amount,saler_name,buyer_tax_no,buyer_name,invoice_type,invoice_status,manage_status,deduction_purpose,tax_period,authenticate_time,authenticate_flag,select_time,not_deductible_type,invoice_source,invoice_risk_level,special_type_mark,purchase_ticket,agric_handle_status,electronic_no";

    private static List<String> getITEMS_HEADERS() {
        ArrayList<String> list = new ArrayList<String>(16);
        list.add(ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"DeductStatisticsService_0", (String)"imc-rim-common", (Object[])new Object[0]));
        list.add(ResManager.loadKDString((String)"\u53d1\u7968\u7c7b\u578b", (String)"DeductStatisticsService_1", (String)"imc-rim-common", (Object[])new Object[0]));
        list.add(ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801", (String)"DeductStatisticsService_2", (String)"imc-rim-common", (Object[])new Object[0]));
        list.add(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801", (String)"DeductStatisticsService_3", (String)"imc-rim-common", (Object[])new Object[0]));
        list.add(ResManager.loadKDString((String)"\u5f00\u7968\u65e5\u671f", (String)"DeductStatisticsService_4", (String)"imc-rim-common", (Object[])new Object[0]));
        list.add(ResManager.loadKDString((String)"\u9500\u65b9\u540d\u79f0", (String)"DeductStatisticsService_31", (String)"imc-rim-common", (Object[])new Object[0]));
        list.add(ResManager.loadKDString((String)"\u4e0d\u542b\u7a0e\u91d1\u989d", (String)"DeductStatisticsService_5", (String)"imc-rim-common", (Object[])new Object[0]));
        list.add(ResManager.loadKDString((String)"\u53ef\u62b5\u6263\u7a0e\u989d", (String)"DeductStatisticsService_6", (String)"imc-rim-common", (Object[])new Object[0]));
        list.add(ResManager.loadKDString((String)"\u53d1\u7968\u72b6\u6001", (String)"DeductStatisticsService_7", (String)"imc-rim-common", (Object[])new Object[0]));
        list.add(ResManager.loadKDString((String)"\u52fe\u9009\u72b6\u6001", (String)"DeductStatisticsService_8", (String)"imc-rim-common", (Object[])new Object[0]));
        list.add(ResManager.loadKDString((String)"\u52fe\u9009\u65f6\u95f4", (String)"DeductStatisticsService_9", (String)"imc-rim-common", (Object[])new Object[0]));
        list.add(ResManager.loadKDString((String)"\u62b5\u6263\u7528\u9014", (String)"DeductStatisticsService_10", (String)"imc-rim-common", (Object[])new Object[0]));
        list.add(ResManager.loadKDString((String)"\u4e0d\u62b5\u6263\u539f\u56e0", (String)"DeductStatisticsService_11", (String)"imc-rim-common", (Object[])new Object[0]));
        list.add(ResManager.loadKDString((String)"\u7ba1\u7406\u72b6\u6001", (String)"DeductStatisticsService_12", (String)"imc-rim-common", (Object[])new Object[0]));
        return list;
    }

    public static Map<String, String> getCompanyNameAndTaxNo(Long orgId, Long taxOrgId) {
        Map<String, String> nameAndTaxNoResult = null;
        if (taxOrgId != null && taxOrgId > 0L) {
            nameAndTaxNoResult = TenantUtils.getCompanyNameAndTaxNoByTaxOrgId(taxOrgId);
        }
        if (CollectionUtils.isEmpty(nameAndTaxNoResult) && orgId != null && orgId > 0L) {
            nameAndTaxNoResult = TenantUtils.getCompanyNameAndTaxNoByOrgId(orgId);
        }
        return nameAndTaxNoResult;
    }

    private static Long getCacheKey(Long orgId, Long taxOrgId) {
        if (taxOrgId != null && taxOrgId > 0L) {
            return taxOrgId;
        }
        return orgId;
    }

    public static JSONObject exportData(DynamicObjectCollection statisticsEntity, JSONObject invoiceJson, Long orgId, String taxNo, String companyName, Date updateTime, String caption, String taxperiod) {
        JSONObject result;
        block43: {
            result = ResultContant.createSuccessJSONObject();
            try (XSSFWorkbook wb = new XSSFWorkbook();){
                Throwable throwable;
                if (!CollectionUtils.isEmpty((Collection)statisticsEntity)) {
                    JSONArray statisticsArray = DeductStatisticsService.convertStatisticsArray(statisticsEntity);
                    JSONObject jSONObject = DeductStatisticsService.createStatisticsSheet(wb, ResManager.loadKDString((String)"\u62b5\u6263\u7edf\u8ba1\u8868", (String)"DeductStatisticsService_13", (String)"imc-rim-common", (Object[])new Object[0]), updateTime, companyName, taxNo, taxperiod, statisticsArray);
                }
                JSONObject invoicesNums = DeductStatisticsService.createInvoicesSheet(wb, ResManager.loadKDString((String)"\u5c5e\u671f\u53d1\u7968\u6e05\u5355", (String)"DeductStatisticsService_14", (String)"imc-rim-common", (Object[])new Object[0]), invoiceJson, orgId, taxNo);
                byte[] bytes = null;
                try {
                    throwable = null;
                    try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                        wb.write((OutputStream)os);
                        bytes = os.toByteArray();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (IOException e1) {
                    result = ResultContant.createJSONObject("1002", ResManager.loadKDString((String)"\u5bfc\u51faExcel\u5931\u8d25", (String)"DeductStatisticsService_15", (String)"imc-rim-common", (Object[])new Object[0]));
                    LOGGER.error("\u5bfc\u51faExcel\u5931\u8d25", (Throwable)e1);
                }
                if (bytes != null) {
                    throwable = null;
                    try (ByteArrayInputStream in = new ByteArrayInputStream(bytes);){
                        String fileName = caption + "_" + taxNo + "_" + taxperiod + "_" + DateUtils.format(new Date(), "yyyy-MM-dd") + ".xlsx";
                        String urls = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, (InputStream)in, 5000);
                        result.put("data", (Object)urls);
                        break block43;
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
                result = ResultContant.createJSONObject("1002", ResManager.loadKDString((String)"\u5bfc\u51faExcel\u5931\u8d25", (String)"DeductStatisticsService_15", (String)"imc-rim-common", (Object[])new Object[0]));
            }
            catch (IOException e) {
                LOGGER.error((Throwable)e);
                result = ResultContant.createJSONObject("1002", ResManager.loadKDString((String)"\u5bfc\u51faExcel\u5931\u8d25", (String)"DeductStatisticsService_15", (String)"imc-rim-common", (Object[])new Object[0]));
            }
        }
        return result;
    }

    private static JSONArray convertStatisticsArray(DynamicObjectCollection statisticsEntity) {
        JSONArray statisticsArr = new JSONArray();
        for (DynamicObject dynamicObject : statisticsEntity) {
            JSONObject json = new JSONObject();
            String invoiceType = dynamicObject.getString("c_deduct_invoice_type");
            json.put("invoiceType", (Object)invoiceType);
            json.put("deductibleNum", (Object)dynamicObject.getInt("c_deduct_num"));
            String itemDeductibleAmount = dynamicObject.getString("c_deduct_invoice_amount");
            json.put("deductibleAmount", (Object)BigDecimalUtil.transDecimal(itemDeductibleAmount));
            String itemDeductibleTax = dynamicObject.getString("c_deducteffectiveamount");
            json.put("deductibleTax", (Object)BigDecimalUtil.transDecimal(itemDeductibleTax));
            json.put("unDeductibleNum", (Object)dynamicObject.getInt("c_undeduct_num"));
            String itemUnDeductibleAmount = dynamicObject.getString("c_undeduct_invoice_amount");
            json.put("unDeductibleAmount", (Object)BigDecimalUtil.transDecimal(itemUnDeductibleAmount));
            String itemUnDeductibleTax = dynamicObject.getString("c_undeducteffectiveamount");
            json.put("unDeductibleTax", (Object)BigDecimalUtil.transDecimal(itemUnDeductibleTax));
            statisticsArr.add((Object)json);
        }
        return statisticsArr;
    }

    public static JSONObject createStatisticsSheet(XSSFWorkbook wb, String sheetName, Date updateTime, String companyName, String taxNo, String taxperiod, JSONArray statisticsArr) {
        XSSFSheet statisticSheet = wb.createSheet(sheetName);
        XSSFRow titleRow = statisticSheet.createRow(0);
        statisticSheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 6));
        XSSFCell titleCell = titleRow.createCell(0);
        XSSFRichTextString titleText = new XSSFRichTextString(ResManager.loadKDString((String)"\u62b5\u6263\u53d1\u7968\u7edf\u8ba1\u8868", (String)"DeductStatisticsService_16", (String)"imc-rim-common", (Object[])new Object[0]));
        titleCell.setCellValue((RichTextString)titleText);
        XSSFCellStyle styleTitle = wb.createCellStyle();
        styleTitle.setAlignment(HorizontalAlignment.CENTER);
        styleTitle.setVerticalAlignment(VerticalAlignment.CENTER);
        titleCell.setCellStyle((CellStyle)styleTitle);
        XSSFRow updateTimeRow = statisticSheet.createRow(1);
        statisticSheet.addMergedRegion(new CellRangeAddress(1, 1, 0, 6));
        updateTimeRow.createCell(0).setCellValue((RichTextString)new XSSFRichTextString(String.format(ResManager.loadKDString((String)"\uff08\u62a5\u8868\u66f4\u65b0\u65f6\u95f4\uff1a%s\uff09", (String)"DeductStatisticsService_17", (String)"imc-rim-common", (Object[])new Object[0]), DateUtils.format(updateTime, "yyyy-MM-dd HH:mm:ss"))));
        updateTimeRow.getCell(0).setCellStyle((CellStyle)styleTitle);
        XSSFRow baseInfoRow = statisticSheet.createRow(2);
        statisticSheet.addMergedRegion(new CellRangeAddress(2, 2, 0, 1));
        statisticSheet.addMergedRegion(new CellRangeAddress(2, 2, 2, 3));
        statisticSheet.addMergedRegion(new CellRangeAddress(2, 2, 4, 5));
        baseInfoRow.createCell(0).setCellValue((RichTextString)new XSSFRichTextString(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u540d\u79f0:%s", (String)"DeductStatisticsService_20", (String)"imc-rim-common", (Object[])new Object[0]), companyName)));
        baseInfoRow.createCell(2).setCellValue((RichTextString)new XSSFRichTextString(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7:%s", (String)"DeductStatisticsService_21", (String)"imc-rim-common", (Object[])new Object[0]), taxNo)));
        baseInfoRow.createCell(4).setCellValue((RichTextString)new XSSFRichTextString(String.format(ResManager.loadKDString((String)"\u6240\u5c5e\u6708\u4efd:%s", (String)"DeductStatisticsService_22", (String)"imc-rim-common", (Object[])new Object[0]), taxperiod)));
        baseInfoRow.createCell(6).setCellValue(ResManager.loadKDString((String)"\u5355\u4f4d:\uff08\u4efd\u3001\u5143\uff09", (String)"DeductStatisticsService_23", (String)"imc-rim-common", (Object[])new Object[0]));
        XSSFRow titleRow1 = statisticSheet.createRow(3);
        statisticSheet.addMergedRegion(new CellRangeAddress(3, 3, 1, 3));
        statisticSheet.addMergedRegion(new CellRangeAddress(3, 3, 4, 6));
        XSSFRow titleRow2 = statisticSheet.createRow(4);
        statisticSheet.addMergedRegion(new CellRangeAddress(3, 4, 0, 0));
        titleRow1.createCell(0).setCellValue((RichTextString)new XSSFRichTextString(ResManager.loadKDString((String)"\u53d1\u7968\u7c7b\u578b", (String)"DeductStatisticsService_1", (String)"imc-rim-common", (Object[])new Object[0])));
        statisticSheet.setColumnWidth(0, ResManager.loadKDString((String)"\u589e\u503c\u7a0e\u7535\u5b50\u4e13\u7528\u53d1\u7968", (String)"DeductStatisticsService_25", (String)"imc-rim-common", (Object[])new Object[0]).getBytes().length * 256);
        titleRow1.createCell(1).setCellValue((RichTextString)new XSSFRichTextString(ResManager.loadKDString((String)"\u62b5\u6263", (String)"DeductStatisticsService_26", (String)"imc-rim-common", (Object[])new Object[0])));
        titleRow1.getCell(1).setCellStyle((CellStyle)styleTitle);
        titleRow1.createCell(4).setCellValue((RichTextString)new XSSFRichTextString(ResManager.loadKDString((String)"\u4e0d\u62b5\u6263", (String)"DeductStatisticsService_27", (String)"imc-rim-common", (Object[])new Object[0])));
        titleRow1.getCell(4).setCellStyle((CellStyle)styleTitle);
        titleRow2.createCell(1).setCellValue(ResManager.loadKDString((String)"\u4efd\u6570", (String)"DeductStatisticsService_28", (String)"imc-rim-common", (Object[])new Object[0]));
        titleRow2.createCell(2).setCellValue(ResManager.loadKDString((String)"\u91d1\u989d", (String)"DeductStatisticsService_24", (String)"imc-rim-common", (Object[])new Object[0]));
        titleRow2.createCell(3).setCellValue(ResManager.loadKDString((String)"\u53ef\u62b5\u6263\u7a0e\u989d", (String)"DeductStatisticsService_6", (String)"imc-rim-common", (Object[])new Object[0]));
        statisticSheet.setColumnWidth(3, ResManager.loadKDString((String)"\u53ef\u62b5\u6263\u7a0e\u989d", (String)"DeductStatisticsService_6", (String)"imc-rim-common", (Object[])new Object[0]).getBytes().length * 256);
        titleRow2.createCell(4).setCellValue(ResManager.loadKDString((String)"\u4efd\u6570", (String)"DeductStatisticsService_28", (String)"imc-rim-common", (Object[])new Object[0]));
        titleRow2.createCell(5).setCellValue(ResManager.loadKDString((String)"\u91d1\u989d", (String)"DeductStatisticsService_24", (String)"imc-rim-common", (Object[])new Object[0]));
        titleRow2.createCell(6).setCellValue(ResManager.loadKDString((String)"\u53ef\u62b5\u6263\u7a0e\u989d", (String)"DeductStatisticsService_6", (String)"imc-rim-common", (Object[])new Object[0]));
        statisticSheet.setColumnWidth(6, ResManager.loadKDString((String)"\u53ef\u62b5\u6263\u7a0e\u989d", (String)"DeductStatisticsService_6", (String)"imc-rim-common", (Object[])new Object[0]).getBytes().length * 256);
        int rowId = 5;
        int deductNum = 0;
        int unDeductNum = 0;
        BigDecimal deductInvoiceAmount = BigDecimal.ZERO;
        BigDecimal unDeductInvoiceAmount = BigDecimal.ZERO;
        BigDecimal deducteffectiveamount = BigDecimal.ZERO;
        BigDecimal unDeducteffectiveamount = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty((Collection)statisticsArr)) {
            for (int i = 0; i < statisticsArr.size(); ++i) {
                JSONObject statistics = statisticsArr.getJSONObject(i);
                String invoiceType = statistics.getString("invoiceType");
                if ("99".equals(invoiceType)) continue;
                XSSFRow row = statisticSheet.createRow(rowId);
                String invoiceTypeName = DeductInvoiceTypeEnum.getNameByType(invoiceType);
                row.createCell(0).setCellValue(StringUtils.isNotBlank((CharSequence)invoiceTypeName) ? invoiceTypeName : invoiceType);
                String itemDeductNum = statistics.getString("deductibleNum");
                deductNum += Integer.parseInt(itemDeductNum);
                row.createCell(1).setCellValue(itemDeductNum);
                String itemDeductInvoiceAmount = statistics.getString("deductibleAmount");
                deductInvoiceAmount = deductInvoiceAmount.add(BigDecimalUtil.transDecimal(itemDeductInvoiceAmount));
                row.createCell(2).setCellValue(itemDeductInvoiceAmount);
                String itemDeducteffectiveAmount = statistics.getString("deductibleTax");
                deducteffectiveamount = deducteffectiveamount.add(BigDecimalUtil.transDecimal(itemDeducteffectiveAmount));
                row.createCell(3).setCellValue(itemDeducteffectiveAmount);
                String itemUndeductNum = statistics.getString("unDeductibleNum");
                unDeductNum += Integer.parseInt(itemUndeductNum);
                row.createCell(4).setCellValue(itemUndeductNum);
                String itemUndeductInvoiceAmount = statistics.getString("unDeductibleAmount");
                unDeductInvoiceAmount = unDeductInvoiceAmount.add(BigDecimalUtil.transDecimal(itemUndeductInvoiceAmount));
                row.createCell(5).setCellValue(itemUndeductInvoiceAmount);
                String itemUndeducteffectiveAmount = statistics.getString("unDeductibleTax");
                unDeducteffectiveamount = unDeducteffectiveamount.add(BigDecimalUtil.transDecimal(itemUndeducteffectiveAmount));
                row.createCell(6).setCellValue(itemUndeducteffectiveAmount);
                ++rowId;
            }
        }
        XSSFRow allRow = statisticSheet.createRow(rowId);
        allRow.createCell(0).setCellValue(ResManager.loadKDString((String)"\u5408\u8ba1", (String)"DeductStatisticsService_18", (String)"imc-rim-common", (Object[])new Object[0]));
        allRow.createCell(1).setCellValue(String.valueOf(deductNum));
        allRow.createCell(2).setCellValue(String.valueOf(deductInvoiceAmount));
        allRow.createCell(3).setCellValue(String.valueOf(deducteffectiveamount));
        allRow.createCell(4).setCellValue(String.valueOf(unDeductNum));
        allRow.createCell(5).setCellValue(String.valueOf(unDeductInvoiceAmount));
        allRow.createCell(6).setCellValue(String.valueOf(unDeducteffectiveamount));
        JSONObject result = new JSONObject();
        result.put("deductNum", (Object)deductNum);
        result.put("unDeductNum", (Object)unDeductNum);
        return result;
    }

    public static JSONObject createInvoicesSheet(XSSFWorkbook wb, String sheetName, JSONObject invoiceJson, Long orgId, String taxNo) {
        XSSFSheet itemsSheet = wb.createSheet(sheetName);
        XSSFRow itemsRow = itemsSheet.createRow(0);
        List<String> heads = DeductStatisticsService.getITEMS_HEADERS();
        for (int i = 0; i < heads.size(); ++i) {
            XSSFCell cell = itemsRow.createCell(i);
            XSSFRichTextString text = new XSSFRichTextString(heads.get(i));
            cell.setCellValue((RichTextString)text);
            itemsSheet.setColumnWidth(i, heads.get(i).getBytes().length * 256);
        }
        int itemRowId = 1;
        JSONArray invoices = invoiceJson.getJSONArray("data");
        if (orgId == null) {
            orgId = RequestContext.get().getOrgId();
        }
        if (!"0".equals(invoiceJson.getString("saveFlag"))) {
            DeductInvoiceOperateService deductInvoiceOperateService = new DeductInvoiceOperateService();
            deductInvoiceOperateService.saveDownInvoice(invoices.toJavaList(JSONObject.class), orgId, RequestContext.get().getUserId(), taxNo);
        }
        int deductNum = 0;
        int unDeductNum = 0;
        for (int i = 0; i < invoices.size(); ++i) {
            JSONObject invoice = invoices.getJSONObject(i);
            InputInvoiceTypeEnum invoiceType = InputInvoiceTypeEnum.getInvoiceType(invoice.getString("invoiceType"));
            XSSFRow row = itemsSheet.createRow(itemRowId);
            row.createCell(0).setCellValue((double)(i + 1));
            row.createCell(1).setCellValue(invoiceType.getName());
            row.createCell(2).setCellValue(invoice.getString("invoiceCode"));
            row.createCell(3).setCellValue(invoice.getString("invoiceNo"));
            row.createCell(4).setCellValue(invoice.getString("invoiceDate"));
            row.createCell(5).setCellValue(invoice.getString("salerName"));
            row.createCell(6).setCellValue(invoice.getString("invoiceAmount"));
            row.createCell(7).setCellValue(invoice.getString("effectiveTaxAmount"));
            String invoiceStatus = MetadataUtil.getComboItemName("rim_invoice", "invoice_status", invoice.getString("invoiceStatus"));
            row.createCell(8).setCellValue(invoiceStatus);
            String selectTime = invoice.getString("selectTime");
            String authenticateFlag = invoice.getString("authenticateFlag");
            String authenticateFlagName = MetadataUtil.getComboItemName("rim_invoice", "authenticate_flag", authenticateFlag);
            row.createCell(9).setCellValue(authenticateFlagName);
            row.createCell(10).setCellValue(selectTime);
            String deductionPurpose = invoice.getString("deductionPurpose");
            if ("1".equals(deductionPurpose)) {
                ++deductNum;
            } else {
                ++unDeductNum;
            }
            String deductionPurposeName = MetadataUtil.getComboItemName("rim_invoice", "deduction_purpose", deductionPurpose);
            row.createCell(11).setCellValue(deductionPurposeName);
            String notDeductibleType = MetadataUtil.getComboItemName("rim_invoice", "not_deductible_type", invoice.getString("notDeductibleType"));
            row.createCell(12).setCellValue(notDeductibleType);
            String manageStatus = MetadataUtil.getComboItemName("rim_invoice", "manage_status", invoice.getString("manageStatus"));
            row.createCell(13).setCellValue(manageStatus);
            ++itemRowId;
        }
        JSONObject result = new JSONObject();
        result.put("deductNum", (Object)deductNum);
        result.put("unDeductNum", (Object)unDeductNum);
        return result;
    }

    public static void inserSelectLog(String taskNo, String batchNo, String taxNo, Long orgId, String operateType, String skssq) {
        DeductStatisticsService.inserSelectLog(taskNo, batchNo, taxNo, orgId, operateType, skssq, "1", "0", null, "1");
    }

    public static void inserSelectLog(String batchNo, String taxNo, Long orgId, String operateType, String skssq) {
        DeductStatisticsService.inserSelectLog(UUID.randomUUID(), batchNo, taxNo, orgId, operateType, skssq);
    }

    public static void inserSelectLog(String taskNo, String batchNo, String taxNo, Long orgId, String operateType, String skssq, String handleStatus, String asyncFlag, JSONObject resultJson, String selectOperaType) {
        DeductStatisticsService.inserSelectLog(taskNo, batchNo, taxNo, orgId, operateType, skssq, handleStatus, asyncFlag, resultJson, selectOperaType, null, null);
    }

    public static void inserSelectLog(String taskNo, String batchNo, String taxNo, Long orgId, String operateType, String skssq, String handleStatus, String asyncFlag, JSONObject resultJson, String selectOperaType, String text, String statisticsStatus) {
        ThreadPools.executeOnceIncludeRequestContext((String)"StatisticsService.inserSelectLog", () -> DeductStatisticsService.inserSelectLogSync(taskNo, batchNo, taxNo, orgId, operateType, skssq, handleStatus, asyncFlag, resultJson, selectOperaType, text, statisticsStatus));
    }

    public static void inserSelectLogSync(String taskNo, String batchNo, String taxNo, Long orgId, String operateType, String skssq, String handleStatus, String asyncFlag, JSONObject resultJson, String selectOperaType, String statisticsStatus) {
        DeductStatisticsService.inserSelectLogSync(taskNo, batchNo, taxNo, orgId, operateType, skssq, handleStatus, asyncFlag, resultJson, selectOperaType, null, statisticsStatus);
    }

    public static void inserSelectLogSync(String taskNo, String batchNo, String taxNo, Long orgId, String operateType, String skssq, String handleStatus, String asyncFlag, JSONObject resultJson, String selectOperaType, String text, String statisticsStatus) {
        SelectLog selectLog = new SelectLog();
        selectLog.setTaskNo(taskNo);
        selectLog.setBatchNo(batchNo);
        selectLog.setSelectType("6");
        selectLog.setOperateType(operateType);
        selectLog.setSelectOperaType(selectOperaType);
        selectLog.setOrgId(orgId);
        selectLog.setTaxNo(taxNo);
        selectLog.setAsyncFlag(asyncFlag);
        selectLog.setResultJsonText(text);
        selectLog.setHandleStatus(handleStatus);
        selectLog.setSelectType("6");
        Date taxPeriod = null;
        if (StringUtils.isNotEmpty((CharSequence)skssq)) {
            taxPeriod = DateUtils.stringToDate(skssq, "yyyyMM");
            selectLog.setTaxPeriod(taxPeriod);
        }
        selectLog.setResultJson(resultJson);
        selectLog.setStatisticsStatus(statisticsStatus);
        SelectAccountService.insertSelectLog(selectLog);
    }

    public static JSONObject getLqStatisticsInfo(String taxNo, Long orgId) {
        LqDeductService deductService = new LqDeductService(orgId);
        JSONObject result = deductService.queryTaxperiod(taxNo);
        if (!ResultContant.isSuccess(result).booleanValue()) {
            return result;
        }
        JSONObject data = result.getJSONObject("data");
        String taxPeriod = data.getString("skssq");
        data.put("taxPeriod", (Object)taxPeriod);
        String status = data.getString("zt");
        Date taxPeriodDate = DateUtils.stringToDate(taxPeriod, "yyyyMM");
        data.put("updateTime", (Object)"");
        if ("0".equals(status)) {
            data.put("tjInfo", (Object)"");
            data.put("isAllowQxTj", (Object)false);
            data.put("isAllowQrtj", (Object)false);
            data.put("isAllowGxInvoice", (Object)true);
            data.put("createTjbbStatus", (Object)StatisticsStatusEnum.UN_CREATE.getCode());
            return result;
        }
        if ("1".equals(status)) {
            data.put("createTjbbStatus", (Object)StatisticsStatusEnum.CREATED_CONFIRM.getCode());
            data.put("isAllowQxTj", (Object)true);
            data.put("isAllowQrtj", (Object)true);
            data.put("isAllowGxInvoice", (Object)false);
            if (DateUtils.getLastDateOfMonth(taxPeriodDate).compareTo(new Date()) >= 0) {
                data.put("createTjbbStatus", (Object)StatisticsStatusEnum.PRE_CREATED.getCode());
                data.put("isAllowQrtj", (Object)false);
            }
        } else if ("2".equals(status)) {
            data.put("isAllowQrtj", (Object)false);
            data.put("isAllowGxInvoice", (Object)false);
            data.put("isAllowQxTj", (Object)true);
            data.put("createTjbbStatus", (Object)StatisticsStatusEnum.CONFIRMED.getCode());
        } else {
            return ResultContant.createJSONObject("0202", ResManager.loadKDString((String)"\u67e5\u8be2\u5f53\u524d\u5c5e\u671f\u7edf\u8ba1\u8868\u72b6\u6001\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"DeductStatisticsService_19", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        JSONArray tjxx = DeductStatisticsService.createStatistics(taxPeriod, taxNo);
        data.put("tjxx", (Object)tjxx);
        return result;
    }

    public static void updateLqSelected(Long orgId, String taxNo) {
        String dkType = DeductionConstant.getDkType(taxNo);
        if (!"5".equals(dkType)) {
            return;
        }
        LqDeductService deductService = new LqDeductService(orgId);
        JSONObject result = deductService.queryTaxperiod(taxNo);
        if (!ResultContant.isSuccess(result).booleanValue()) {
            return;
        }
        JSONObject data = result.getJSONObject("data");
        String taxPeriod = data.getString("skssq");
        QFilter filter = new QFilter("buyer_tax_no", "=", (Object)taxNo);
        filter.and("tax_period", "=", (Object)DateUtils.stringToDate(taxPeriod, "yyyyMM"));
        filter.and("authenticate_flag", "in", (Object)new String[]{"1", "2", "3"});
        filter.and("invoice_type", "in", (Object)InputInvoiceTypeEnum.getDeductionAllTypes());
        DeductStatisticsService.addInvoiceToLqPurposeList(filter, orgId, taxNo);
        data.put("taxPeriod", (Object)taxPeriod);
        String status = data.getString("zt");
        JSONObject queryInvoice = deductService.quereyCurrDeductInvoices(taxNo);
        if (!ResultContant.isSuccess(queryInvoice).booleanValue()) {
            return;
        }
        JSONArray invoices = queryInvoice.getJSONArray("data");
        DeductStatisticsService.updateInvoiceStatus(invoices, status, orgId);
    }

    public static void updateUnselectInvoice(String taxNo, Date taxPeriod, int deductNum, Long orgId, String userId) {
        LOGGER.info("\u5f00\u59cb\u4e0b\u8f7d\u8fd12\u4e2a\u6708\u672a\u52fe\u9009\u7684\u53d1\u7968:{}", (Object)taxNo);
        if (DeductionUtils.isNotDownDiffTable(taxNo)) {
            return;
        }
        String dkType = DeductionConstant.getDkType(taxNo);
        QFilter filters = new QFilter("invoice_type", "in", (Object)InputInvoiceTypeEnum.getDeductionTypes());
        filters.and("tenant_no", "=", (Object)TenantUtils.getTenantNo());
        filters.and("buyer_tax_no", "=", (Object)taxNo);
        filters.and("tax_period", "=", (Object)taxPeriod);
        filters.and("deduction_purpose", "in", (Object)new String[]{"1", "2"});
        filters.and("authenticate_flag", "in", (Object)new String[]{"1", "2", "3"});
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"rim_invoice", (String)"id,invoice_date", (QFilter[])filters.toArray());
        if (deductNum != collection.size()) {
            JSONArray invoices;
            LOGGER.info("\u7edf\u8ba1\u8868\u6570\u91cf\u4e0d\u4e00\u81f4:{},deductNum:{},querySize:{}", new Object[]{taxNo, deductNum, collection.size()});
            if ("4".equals(dkType)) {
                HeaderInvoiceDownServiceImpl headerInvoiceDownService = new HeaderInvoiceDownServiceImpl();
                InvoiceHeaderDownService invoiceHeaderDownService = new InvoiceHeaderDownService(orgId);
                Set dateSet = collection.stream().filter(s -> s.getDate("invoice_date") != null).map(s -> s.getDate("invoice_date")).collect(Collectors.toSet());
                if (!CollectionUtils.isEmpty(dateSet)) {
                    Date date = (Date)Collections.min(dateSet);
                    Date maxDate = (Date)Collections.max(dateSet);
                    long between = DateUtils.daysBetween(maxDate, date);
                    if (between == 0L) {
                        between = 1L;
                    }
                    long num = between % 180L == 0L ? between / 180L : between / 180L + 1L;
                    Map<Date, Date> dateDateMap = DateUtils.cutTimeRange(date, maxDate, (int)num);
                    for (Map.Entry<Date, Date> entry : dateDateMap.entrySet()) {
                        for (String billType : BILL_TYPES) {
                            Date endTime;
                            Date startTime;
                            Long longType = 0L;
                            if ("1".equals(billType)) {
                                longType = InputInvoiceTypeEnum.HGJKS.getCode();
                            }
                            if (headerInvoiceDownService.existTask(taxNo, startTime = DateUtils.trunc(entry.getKey()), endTime = DateUtils.trunc(entry.getValue()), longType, "8", true)) continue;
                            invoiceHeaderDownService.applyUnSelectTable(taxNo, billType, DateUtils.format(startTime), DateUtils.format(endTime), "-1");
                        }
                    }
                }
                for (String billType : BILL_TYPES) {
                    Long longType = 0L;
                    if ("1".equals(billType)) {
                        longType = InputInvoiceTypeEnum.HGJKS.getCode();
                    }
                    if (headerInvoiceDownService.existTask(taxNo, taxPeriod, null, longType, "9", true)) continue;
                    invoiceHeaderDownService.applySelectedTable(taxNo, billType, "1", "");
                }
                return;
            }
            String batchNo = UUID.randomUUID();
            DeductService downService = DeductServiceFactory.newInstanceForDeduct(dkType, orgId);
            JSONObject param = new JSONObject();
            param.put("taxNo", (Object)taxNo);
            param.put("synctype", (Object)"04");
            JSONObject jSONObject = new JSONObject();
            Date endDate = new Date();
            Date startDate = DateUtils.addMonth(endDate, -1);
            startDate = DateUtils.getFirstDateOfMonth(startDate);
            jSONObject.put("startTime", (Object)DateUtils.format(startDate));
            jSONObject.put("endTime", (Object)DateUtils.format(endDate));
            jSONObject.put("authenticateFlags", (Object)"0");
            param.put("synccondition", (Object)(jSONObject.getString("startTime") + "," + jSONObject.getString("endTime")));
            param.put("searchOpt", (Object)jSONObject);
            JSONObject result = downService.queryInvoices(param);
            if (ResultContant.isSuccess(result).booleanValue() && !CollectionUtils.isEmpty((Collection)(invoices = result.getJSONArray("data")))) {
                DeductInvoiceOperateService service = new DeductInvoiceOperateService();
                service.asyncSaveDownInvoice(invoices.toJavaList(JSONObject.class), orgId, userId, taxNo);
            }
        }
    }

    public static JSONArray createStatistics(String taxPeriod, String taxNo) {
        JSONArray invoices;
        JSONArray result = new JSONArray();
        Map<String, JSONObject> statisticMap = StatisticService.initStatisticMap();
        JSONObject taxPeriodInvoices = DeductStatisticsService.queryTaxPeriodInvoices(taxNo, taxPeriod);
        if (ResultContant.isSuccess(taxPeriodInvoices).booleanValue() && !CollectionUtils.isEmpty((Collection)(invoices = taxPeriodInvoices.getJSONArray("data")))) {
            for (int i = 0; i < invoices.size(); ++i) {
                JSONObject item = invoices.getJSONObject(i);
                String invoiceType = item.getString("invoiceType");
                StatisticService.getStatictMapData(statisticMap, item, invoiceType);
            }
        }
        result.addAll(statisticMap.values());
        if (!CollectionUtils.isEmpty((Collection)result)) {
            int deductibleNum = 0;
            BigDecimal deductibleAmount = BigDecimal.ZERO;
            BigDecimal deductibleTax = BigDecimal.ZERO;
            int unDeductibleNum = 0;
            BigDecimal unDeductibleAmount = BigDecimal.ZERO;
            BigDecimal unDeductibleTax = BigDecimal.ZERO;
            for (int i = 0; i < result.size(); ++i) {
                JSONObject object = result.getJSONObject(i);
                deductibleNum += object.getInteger("deductibleNum").intValue();
                deductibleAmount = deductibleAmount.add(BigDecimalUtil.transDecimal(object.get((Object)"deductibleAmount")));
                deductibleTax = deductibleTax.add(BigDecimalUtil.transDecimal(object.get((Object)"deductibleTax")));
                unDeductibleNum += object.getInteger("unDeductibleNum").intValue();
                unDeductibleAmount = unDeductibleAmount.add(BigDecimalUtil.transDecimal(object.get((Object)"unDeductibleAmount")));
                unDeductibleTax = unDeductibleTax.add(BigDecimalUtil.transDecimal(object.get((Object)"unDeductibleTax")));
            }
            JSONObject hz = new JSONObject();
            hz.put("invoiceType", (Object)"99");
            hz.put("deductibleNum", (Object)deductibleNum);
            hz.put("deductibleAmount", (Object)deductibleAmount);
            hz.put("deductibleTax", (Object)deductibleTax);
            hz.put("unDeductibleNum", (Object)unDeductibleNum);
            hz.put("unDeductibleAmount", (Object)unDeductibleAmount);
            hz.put("unDeductibleTax", (Object)unDeductibleTax);
            result.add((Object)hz);
        }
        return result;
    }

    public static void updateInvoiceStatus(JSONArray invoices, String status, Long orgId) {
        if (!CollectionUtils.isEmpty((Collection)invoices)) {
            ArrayList futureList = new ArrayList(8);
            int index = 1;
            long start = System.currentTimeMillis();
            LOGGER.info("\u5f53\u671f\u62b5\u6263\u53d1\u7968\u66f4\u65b0\u5f00\u59cb:{}", (Object)orgId);
            for (int i = 0; i < invoices.size(); ++i) {
                List idList;
                JSONObject invoice = invoices.getJSONObject(i);
                String authenticateFlag = invoice.getString("authenticateFlag");
                invoice.put("lqStatus", (Object)status);
                if ("1".equals(authenticateFlag) && "2".equals(status)) {
                    invoice.put("authenticateFlag", (Object)"2");
                }
                String invoiceCode = invoice.getString("invoiceCode");
                String invoiceNo = invoice.getString("invoiceNo");
                QFilter codeFilter = new QFilter("invoice_code", "=", (Object)StringUtils.trimToEmpty((String)invoiceCode));
                QFilter noFilter = new QFilter("invoice_no", "=", (Object)invoiceNo);
                String etaxInvoiceNo = invoice.getString("etaxInvoiceNo");
                if (StringUtils.isNotEmpty((CharSequence)etaxInvoiceNo) && StringUtils.isEmpty((CharSequence)invoiceCode)) {
                    codeFilter = null;
                    noFilter = new QFilter("electronic_no", "=", (Object)etaxInvoiceNo);
                }
                QFilter dateFilter = null;
                if (InputInvoiceTypeEnum.WITHHOLDING.getAwsType().equals(invoice.getString("invoiceType"))) {
                    Date invoiceDate = invoice.getDate("invoiceDate");
                    if (invoiceDate == null) {
                        return;
                    }
                    dateFilter = new QFilter("invoice_date", ">=", (Object)invoiceDate);
                    dateFilter.and(new QFilter("invoice_date", "<", (Object)DateUtils.addDay(invoiceDate, 1)));
                }
                if (CollectionUtils.isEmpty((Collection)(idList = QueryServiceHelper.queryPrimaryKeys((String)"rim_invoice", (QFilter[])new QFilter[]{codeFilter, noFilter, dateFilter}, null, (int)10)))) continue;
                UpdatePeriodInvoiceTask updateTask = new UpdatePeriodInvoiceTask(RequestContext.get(), idList.get(0), orgId, invoice);
                futureList.add(periodInvoiceThreadPool.submit((Callable)updateTask));
                CommonUtils.futureWait(futureList, 6, index);
                ++index;
            }
            CommonUtils.futureWait(futureList, 6, 6);
            LOGGER.info("\u5f53\u671f\u62b5\u6263\u53d1\u7968\u66f4\u65b0\u7ed3\u675f:{},\u8017\u65f6:{}", (Object)orgId, (Object)(System.currentTimeMillis() - start));
        }
    }

    public static JSONObject queryTaxPeriodInvoices(String taxNo, String taxPeriod) {
        if (StringUtils.isEmpty((CharSequence)taxNo) || StringUtils.isEmpty((CharSequence)taxPeriod)) {
            return ResultContant.createSuccessJSONObject(new JSONArray());
        }
        QFilter invoiceTypeFilter = new QFilter("invoice_type", "in", (Object)InputInvoiceTypeEnum.getDeductionAllTypes());
        Date taxperiod = DateUtils.stringToDate(taxPeriod.replaceAll("-", ""), "yyyyMM");
        QFilter taxPeriodFilter = new QFilter("tax_period", "=", (Object)taxperiod);
        QFilter buyerTaxNoFilter = new QFilter("buyer_tax_no", "=", (Object)taxNo);
        QFilter authenticateFlagFilter = new QFilter("authenticate_flag", "in", (Object)new String[]{"1", "2", "3"});
        return DeductStatisticsService.queryTableInvoices(new QFilter[]{invoiceTypeFilter, authenticateFlagFilter, buyerTaxNoFilter, taxPeriodFilter});
    }

    private static JSONObject queryTableInvoices(QFilter[] qFilters) {
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"rim_invoice", (String)SELECT_FILED, (QFilter[])qFilters);
        JSONObject result = ResultContant.createSuccessJSONObject();
        if (!CollectionUtils.isEmpty((Collection)collection)) {
            JSONArray invoices = new JSONArray();
            for (DynamicObject dynamicObject : collection) {
                JSONObject jsonObject = InvoiceConvertService.convertInviceMainInfo(dynamicObject);
                jsonObject.put("specialTypeMark", (Object)dynamicObject.getString("special_type_mark"));
                jsonObject.put("purchaseTicket", (Object)dynamicObject.getString("purchase_ticket"));
                jsonObject.put("agricHandleStatus", (Object)dynamicObject.getString("agric_handle_status"));
                jsonObject.put("etaxInvoiceNo", (Object)dynamicObject.getString("electronic_no"));
                invoices.add((Object)jsonObject);
            }
            result.put("data", (Object)invoices);
        }
        result.put("saveFlag", (Object)"0");
        return result;
    }

    public static JSONObject queryTableInvoices(List<String> serialNos) {
        QFilter serialNoFilter = new QFilter("serial_no", "in", serialNos);
        return DeductStatisticsService.queryTableInvoices(new QFilter[]{serialNoFilter});
    }

    public static void updateDeduction(String taxNo, String authenticateFlag) {
        DeductStatisticsService.updateDeduction(taxNo, authenticateFlag, "", null);
    }

    public static void updateDeduction(String taxNo, String authenticateFlag, String skssq, Date operateTime) {
        if (StringUtils.isEmpty((CharSequence)authenticateFlag) || StringUtils.isEmpty((CharSequence)taxNo)) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)skssq)) {
            skssq = DeductionConstant.getSkssq(taxNo);
        } else {
            String[] ssqs = skssq.split(";");
            skssq = ssqs[0];
        }
        if (StringUtils.isEmpty((CharSequence)skssq)) {
            return;
        }
        DeductInvoiceOperateService deductInvoiceOperateService = new DeductInvoiceOperateService();
        deductInvoiceOperateService.updateAuthenticateFlag(authenticateFlag, taxNo, DateUtils.stringToDate(skssq, "yyyyMM"), operateTime, new String[]{"1", "2"});
    }

    public static int addInvoiceToLqPurposeList(QFilter filter, Long orgId, String taxNo) {
        if (filter == null) {
            return 0;
        }
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"rim_invoice", (String)"invoice_type,invoice_code,invoice_no,electronic_no,invoice_date,serial_no,buyer_tax_no", (QFilter[])filter.toArray());
        if (!CollectionUtils.isEmpty((Collection)collection)) {
            if (StringUtils.isBlank((CharSequence)taxNo)) {
                taxNo = TenantUtils.getTaxNoByOrgId(orgId);
            }
            for (DynamicObject dynamicObject : collection) {
                DynamicObject leqiPurpose = BusinessDataServiceHelper.newDynamicObject((String)"rim_leqi_purpose");
                leqiPurpose.set("org", (Object)orgId);
                leqiPurpose.set("handle_status", (Object)"0");
                leqiPurpose.set("invoice_code", dynamicObject.get("invoice_code"));
                leqiPurpose.set("invoice_no", dynamicObject.get("invoice_no"));
                leqiPurpose.set("electronic_no", dynamicObject.get("electronic_no"));
                leqiPurpose.set("invoice_date", dynamicObject.get("invoice_date"));
                leqiPurpose.set("serial_no", dynamicObject.get("serial_no"));
                String buyerTaxNo = dynamicObject.getString("buyer_tax_no");
                if (StringUtils.isNotEmpty((CharSequence)buyerTaxNo)) {
                    leqiPurpose.set("buyer_tax_no", (Object)buyerTaxNo);
                } else {
                    leqiPurpose.set("buyer_tax_no", (Object)taxNo);
                }
                leqiPurpose.set("invoice_type", (Object)DynamicObjectUtil.getDynamicObjectLongValue(dynamicObject.get("invoice_type")));
                leqiPurpose.set("operate_type", (Object)"1");
                leqiPurpose.set("handle_num", (Object)0);
                ImcSaveServiceHelper.save(leqiPurpose);
            }
        }
        return collection.size();
    }

    public static boolean isExistSelectingTask(String taxNo) {
        QFilter qFilter = new QFilter("tax_no", "=", (Object)taxNo).and("select_type", "in", (Object)new String[]{"1", "2"}).and("handle_status", "=", (Object)"3");
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"rim_select_log", (String)"id", (QFilter[])qFilter.toArray());
        return dynamicObject != null;
    }
}

