/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.deduction;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.imc.rim.common.constant.CheckContant;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.RimPermItemEnum;
import kd.imc.rim.common.helper.ExcelHelper;
import kd.imc.rim.common.invoice.deduction.DeductInvoiceOperateService;
import kd.imc.rim.common.invoice.deduction.SelectAccountService;
import kd.imc.rim.common.invoice.deduction.impl.RecognitionReadySelectTask;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.FileUtils;
import kd.imc.rim.common.utils.PermissionUtils;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.common.utils.UUID;
import org.apache.commons.compress.utils.Lists;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.OfficeXmlFileException;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ReadyDeductSelectSerive {
    public static final String SELECT_SUCCESS = ReadyDeductSelectSerive.getMsg("SELECT_SUCCESS");
    public static final String SELECT_FAIL = ReadyDeductSelectSerive.getMsg("SELECT_FAIL");
    public static final String SELECT_NOTFOUND = ReadyDeductSelectSerive.getMsg("SELECT_NOTFOUND");
    public static final String SELECT_ILLEGAL = ReadyDeductSelectSerive.getMsg("SELECT_ILLEGAL");
    private static Log logger = LogFactory.getLog(ReadyDeductSelectSerive.class);
    private static ThreadPool recognitionThreadPool = ThreadPools.newFixedThreadPool((String)"scanner_recognitionSelect_pool", (int)2);

    private static String getMsg(String type) {
        if ("SELECT_SUCCESS".equals(type)) {
            return ResManager.loadKDString((String)"\u9884\u52fe\u9009\u6210\u529f", (String)"ReadyDeductSelectSerive_0", (String)"imc-rim-common", (Object[])new Object[0]);
        }
        if ("SELECT_FAIL".equals(type)) {
            return ResManager.loadKDString((String)"\u9884\u52fe\u9009\u5931\u8d25", (String)"ReadyDeductSelectSerive_1", (String)"imc-rim-common", (Object[])new Object[0]);
        }
        if ("SELECT_NOTFOUND".equals(type)) {
            return ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u8be5\u53d1\u7968\uff0c\u8bf7\u68c0\u67e5\u53d1\u7968\u4ee3\u7801\u53f7\u7801\u662f\u5426\u6b63\u786e\u3002", (String)"ReadyDeductSelectSerive_2", (String)"imc-rim-common", (Object[])new Object[0]);
        }
        if ("SELECT_ILLEGAL".equals(type)) {
            return ResManager.loadKDString((String)"\u4e0d\u7b26\u5408\u9884\u52fe\u9009\u6761\u4ef6", (String)"ReadyDeductSelectSerive_3", (String)"imc-rim-common", (Object[])new Object[0]);
        }
        return "";
    }

    public Map<String, List<Map<String, Object>>> queryInvoice(Date maxInvoiceDate, Long orgId, String taxNo, Long taxOrgId, String mainFields) {
        return this.queryInvoice(maxInvoiceDate, null, null, null, null, orgId, taxNo, taxOrgId, mainFields);
    }

    public Map<String, List<Map<String, Object>>> queryInvoice(Date maxInvoiceDate, Date startCreateDate, Date endCreateDate, Date accountDateStart, Date accountDateEnd, Long orgId, String taxNo, Long taxOrgId, String mainFields) {
        HashMap<String, List<Map<String, Object>>> typeInvoiceMap = new HashMap<String, List<Map<String, Object>>>();
        QFilter invoiceDateFilter = new QFilter("invoice_date", "<=", (Object)maxInvoiceDate);
        if (startCreateDate != null) {
            invoiceDateFilter.and(new QFilter("createtime", ">=", (Object)DateUtils.trunc(startCreateDate)));
        }
        if (endCreateDate != null) {
            invoiceDateFilter.and(new QFilter("createtime", "<", (Object)DateUtils.trunc(DateUtils.addDay(endCreateDate, 1))));
        }
        if (accountDateStart != null) {
            invoiceDateFilter.and(new QFilter("account_date", ">=", (Object)accountDateStart));
        }
        if (accountDateEnd != null) {
            invoiceDateFilter.and(new QFilter("account_date", "<=", (Object)accountDateEnd));
        }
        QFilter taxAmountFilter = new QFilter("total_tax_amount", ">", (Object)BigDecimal.ZERO);
        QFilter orgFilter = null;
        if (orgId != null) {
            orgFilter = new QFilter("org", "=", (Object)orgId);
        }
        QFilter taxOrgFilter = null;
        if (taxOrgId != null) {
            taxOrgFilter = new QFilter("tax_org", "=", (Object)taxOrgId);
        }
        QFilter deductionFlagFilter = new QFilter("deduction_flag", "=", (Object)"1");
        QFilter invoiceTypeFilter = new QFilter("invoice_type", "in", (Object)new Long[]{InputInvoiceTypeEnum.SPECIAL_ELECTRON.getCode(), InputInvoiceTypeEnum.SPECIAL_PAPER.getCode(), InputInvoiceTypeEnum.MOTOR_INVOICE.getCode(), InputInvoiceTypeEnum.TOLL_ELECTRON.getCode(), InputInvoiceTypeEnum.ELECTRIC_SPECIAL.getCode()});
        QFilter checkFilter = null;
        String showUncheckConfig = RimConfigUtils.getConfig("show_uncheck");
        Boolean needShow = Boolean.TRUE;
        if (StringUtils.isBlank((CharSequence)showUncheckConfig) || "0".equals(showUncheckConfig)) {
            needShow = Boolean.FALSE;
        }
        if (!needShow.booleanValue()) {
            checkFilter = new QFilter("check_status", "in", (Object)CheckContant.getSuccessStatus());
        }
        QFilter authenticateFlagFilter = new QFilter("authenticate_flag", "in", (Object)new String[]{"0", "4"});
        QFilter invoiceStatusFilter = new QFilter("invoice_status", "in", (Object)new String[]{"0", "7"});
        QFilter deleteFilter = new QFilter("delete", "=", (Object)"1");
        DeductInvoiceOperateService invoiceOperateService = new DeductInvoiceOperateService();
        QFilter[] qFilters = new QFilter[]{invoiceDateFilter, orgFilter, deductionFlagFilter, authenticateFlagFilter, invoiceTypeFilter, invoiceStatusFilter, deleteFilter, taxOrgFilter, taxAmountFilter, checkFilter};
        List<Map<String, Object>> vatDeductCollection = invoiceOperateService.queryVatDeductInvoiceData(qFilters, mainFields);
        this.putTypeInvoiceMap(vatDeductCollection, typeInvoiceMap);
        invoiceTypeFilter = new QFilter("invoice_type", "in", (Object)new long[]{InputInvoiceTypeEnum.AIR_ELE_INVOICE.getCode(), InputInvoiceTypeEnum.TRAIN_ELE_INVOICE.getCode()});
        qFilters = new QFilter[]{invoiceDateFilter, orgFilter, deductionFlagFilter, authenticateFlagFilter, invoiceTypeFilter, invoiceStatusFilter, deleteFilter, taxOrgFilter, taxAmountFilter, checkFilter};
        List<Map<String, Object>> eleAirInvoices = invoiceOperateService.queryNoVatDedectInvoiceData(qFilters, mainFields);
        this.putTypeInvoiceMap(eleAirInvoices, typeInvoiceMap);
        invoiceTypeFilter = new QFilter("invoice_type", "in", (Object)new Long[]{InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getCode(), InputInvoiceTypeEnum.ORDINARY_ELECTRON.getCode()});
        QFilter transportDeductionFilter = new QFilter("transport_deduction", "in", (Object)new String[]{"0", "2"});
        QFilter agricHandleStatus = new QFilter("agric_handle_status", "=", (Object)"");
        qFilters = new QFilter[]{invoiceDateFilter, orgFilter, deductionFlagFilter, invoiceTypeFilter, invoiceStatusFilter, transportDeductionFilter, deleteFilter, taxOrgFilter, taxAmountFilter, checkFilter, agricHandleStatus};
        List<Map<String, Object>> ordinaryInvoices = invoiceOperateService.queryVatDeductInvoiceData(qFilters, mainFields);
        this.putTypeInvoiceMap(ordinaryInvoices, typeInvoiceMap);
        invoiceTypeFilter = new QFilter("invoice_type", "in", (Object)new Long[]{InputInvoiceTypeEnum.TRAIN_INVOICE.getCode(), InputInvoiceTypeEnum.AIR_INVOICE.getCode(), InputInvoiceTypeEnum.TRANSPORT_INVOICE.getCode(), InputInvoiceTypeEnum.BOAT_INVOICE.getCode(), InputInvoiceTypeEnum.GENERAL_ELECTRON.getCode()});
        qFilters = new QFilter[]{invoiceDateFilter, orgFilter, deductionFlagFilter, invoiceTypeFilter, transportDeductionFilter, deleteFilter, taxOrgFilter, taxAmountFilter};
        List<Map<String, Object>> noVatInvoices = invoiceOperateService.queryNoVatDedectInvoiceData(qFilters, mainFields);
        this.putTypeInvoiceMap(noVatInvoices, typeInvoiceMap);
        invoiceTypeFilter = new QFilter("invoice_type", "=", (Object)InputInvoiceTypeEnum.HGJKS.getCode());
        qFilters = new QFilter[]{invoiceDateFilter, orgFilter, deductionFlagFilter, authenticateFlagFilter, invoiceTypeFilter, deleteFilter, taxOrgFilter, taxAmountFilter};
        List<Map<String, Object>> customInvoices = invoiceOperateService.queryVatDeductInvoiceData(qFilters, mainFields);
        this.putTypeInvoiceMap(customInvoices, typeInvoiceMap);
        return typeInvoiceMap;
    }

    private void putTypeInvoiceMap(List<Map<String, Object>> deductCollection, Map<String, List<Map<String, Object>>> typeInvoiceMap) {
        if (!CollectionUtils.isEmpty(deductCollection)) {
            for (Map<String, Object> map : deductCollection) {
                String invoiceType = InputInvoiceTypeEnum.getAwsType(map.get("invoice_type"));
                List invoiceList = typeInvoiceMap.getOrDefault(invoiceType, new ArrayList());
                invoiceList.add(map);
                typeInvoiceMap.put(invoiceType, invoiceList);
            }
        }
    }

    public int readyDeductSelect(JSONArray taxDeductInvoiceArray, String transportDeduction, Date taxPeriod, String batchNo) {
        int selectCount = 0;
        String deductibleMode = "-5";
        if (!CollectionUtils.isEmpty((Collection)taxDeductInvoiceArray)) {
            ArrayList<String> readySelectSerialNos = new ArrayList<String>(4);
            for (int i = 0; i < taxDeductInvoiceArray.size(); ++i) {
                readySelectSerialNos.add(taxDeductInvoiceArray.getJSONObject(i).getString("serial_no"));
            }
            QFilter filter1 = new QFilter("serial_no", "in", readySelectSerialNos);
            DynamicObjectCollection collection = QueryServiceHelper.query((String)"rim_invoice", (String)"serial_no,authenticate_flag", (QFilter[])new QFilter[]{filter1});
            List serialNos = null;
            if ("4".equals(transportDeduction)) {
                deductibleMode = "5";
                serialNos = collection.stream().filter(s -> "0".equals(s.getString("authenticate_flag")) || "4".equals(s.getString("authenticate_flag"))).map(s -> s.getString("serial_no")).collect(Collectors.toList());
            } else {
                serialNos = collection.stream().filter(s -> "4".equals(s.getString("authenticate_flag"))).map(s -> s.getString("serial_no")).collect(Collectors.toList());
            }
            Iterator iterator = taxDeductInvoiceArray.iterator();
            while (iterator.hasNext()) {
                JSONObject invoice = JSONObject.parseObject((String)JSONObject.toJSONString(iterator.next()));
                if (serialNos.contains(invoice.getString("serial_no"))) continue;
                iterator.remove();
            }
            if (!CollectionUtils.isEmpty((Collection)taxDeductInvoiceArray)) {
                DeductInvoiceOperateService operateService = new DeductInvoiceOperateService();
                selectCount += taxDeductInvoiceArray.size();
                operateService.updateBatchSelectedInvoice(taxDeductInvoiceArray, deductibleMode, null);
                this.saveSelectAccount(batchNo, taxDeductInvoiceArray, deductibleMode, taxPeriod);
            }
        }
        return selectCount;
    }

    public int readyDeductTransport(List<String> transportDeductSerialNos, String transportDeduction, Date taxPeriod, String batchNo) {
        int selectCount = 0;
        if (!CollectionUtils.isEmpty(transportDeductSerialNos)) {
            QFilter filter2 = new QFilter("serial_no", "in", transportDeductSerialNos);
            DynamicObjectCollection collection = QueryServiceHelper.query((String)"rim_invoice", (String)"serial_no,transport_deduction", (QFilter[])new QFilter[]{filter2});
            List serialNos = null;
            serialNos = "2".equals(transportDeduction) ? collection.stream().filter(s -> "0".equals(s.getString("transport_deduction")) || "2".equals(s.getString("transport_deduction"))).map(s -> s.getString("serial_no")).collect(Collectors.toList()) : collection.stream().filter(s -> "2".equals(s.getString("transport_deduction"))).map(s -> s.getString("serial_no")).collect(Collectors.toList());
            Iterator<String> iterator = transportDeductSerialNos.iterator();
            while (iterator.hasNext()) {
                String serialno = iterator.next();
                if (serialNos.contains(serialno)) continue;
                iterator.remove();
            }
            if (!CollectionUtils.isEmpty(transportDeductSerialNos)) {
                DeductInvoiceOperateService operateService = new DeductInvoiceOperateService();
                selectCount += transportDeductSerialNos.size();
                String deductibleMode = "-5";
                if ("2".equals(transportDeduction)) {
                    deductibleMode = "5";
                }
                operateService.transportDeductBySerialNo(transportDeductSerialNos, transportDeduction, taxPeriod, deductibleMode, "1");
            }
        }
        return selectCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject recognitionExcel(String url, String fileName, Long orgId, Long taxOrgId, Date taxPeriod) {
        JSONObject result = new JSONObject();
        String exportFileName = String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u7ed3\u679c_%1$s", (String)"ExcelInvoiceImportUtil_8", (String)"imc-rim-common", (Object[])new Object[0]), fileName);
        FileService service = FileServiceFactory.getAttachmentFileService();
        InputStream fileInputStream = service.getInputStream(url);
        XSSFWorkbook workbook = null;
        try {
            if (FileUtils.checkFileType(fileName, "xlsx")) {
                workbook = new XSSFWorkbook(fileInputStream);
            } else if (FileUtils.checkFileType(fileName, "xls")) {
                ByteArrayOutputStream baos = FileUtils.cloneInputStream(fileInputStream);
                ByteArrayInputStream copyInputStream1 = new ByteArrayInputStream(baos.toByteArray());
                ByteArrayInputStream copyInputStream2 = new ByteArrayInputStream(baos.toByteArray());
                try {
                    workbook = new HSSFWorkbook((InputStream)copyInputStream1);
                }
                catch (OfficeXmlFileException oxfe) {
                    workbook = new XSSFWorkbook((InputStream)copyInputStream2);
                }
            }
            if (workbook != null) {
                Throwable throwable;
                int sheetCounts = workbook.getNumberOfSheets();
                for (int i = 0; i < sheetCounts; ++i) {
                    Sheet sheetAt = workbook.getSheetAt(i);
                    String tableParamStr = sheetAt.getRow(0).getCell(0).getStringCellValue();
                    String[] tableParams = tableParamStr.split("#");
                    if (tableParams.length != 2) {
                        throw new MsgException("0001", ResManager.loadKDString((String)"\u6a21\u677f\u683c\u5f0f\u6709\u8bef\uff0c\u8bf7\u6309\u7167\u4e0b\u8f7d\u7684excel\u6a21\u677f\u586b\u5199", (String)"ReadyDeductSelectSerive_4", (String)"imc-rim-common", (Object[])new Object[0]));
                    }
                    String entityName = tableParams[1].trim();
                    Row filedNameRow = sheetAt.getRow(2);
                    int lastCellNum = filedNameRow.getLastCellNum();
                    ArrayList<String> fieldNameList = new ArrayList<String>(lastCellNum);
                    for (int j = 0; j < lastCellNum; ++j) {
                        String fieldName = ExcelHelper.getStringValueFromCell(filedNameRow.getCell(j));
                        fieldNameList.add(fieldName);
                    }
                    Row validrow = sheetAt.getRow(2);
                    int writeCellNum = validrow.getPhysicalNumberOfCells();
                    Row descRow = sheetAt.getRow(3);
                    descRow.createCell(writeCellNum).setCellValue(ResManager.loadKDString((String)"\u5bfc\u5165\u7ed3\u679c", (String)"ReadyDeductSelectSerive_5", (String)"imc-rim-common", (Object[])new Object[0]));
                    this.selectSubmit(entityName, sheetAt, fieldNameList, orgId, taxOrgId, taxPeriod);
                }
                byte[] bytes = null;
                try {
                    throwable = null;
                    try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                        workbook.write((OutputStream)os);
                        bytes = os.toByteArray();
                    }
                    catch (Throwable tableParams) {
                        throwable = tableParams;
                        throw tableParams;
                    }
                }
                catch (IOException e1) {
                    logger.error("\u5bfc\u51faExcel\u5931\u8d25", (Throwable)e1);
                }
                if (bytes != null) {
                    throwable = null;
                    try (ByteArrayInputStream in = new ByteArrayInputStream(bytes);){
                        String urls = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(exportFileName, (InputStream)in, 5000);
                        PermissionUtils.addTempFilePermission(urls, "rim_ready_dudect_select", RimPermItemEnum.RIM_EXCEL_SUBMIT.getPermId(), 5000);
                        result.put("downloadPath", (Object)urls);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
            }
            if (workbook != null) {
                this.safeCloseWorkBook((Workbook)workbook);
            }
            if (fileInputStream != null) {
                this.safeCloseFileInputStream(fileInputStream);
            }
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faExcel\u5931\u8d25", (Throwable)e);
        }
        finally {
            if (workbook != null) {
                this.safeCloseWorkBook((Workbook)workbook);
            }
            if (fileInputStream != null) {
                this.safeCloseFileInputStream(fileInputStream);
            }
        }
        return result;
    }

    private void safeCloseFileInputStream(InputStream fileInputStream) {
        try {
            fileInputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void safeCloseWorkBook(Workbook workbook) {
        try {
            workbook.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public JSONObject vatSelect(Boolean isExcel, Map<String, Object> rowInfo, DynamicObject mainInfo, Long orgId, Long taxOrgId, Date taxPeriod, String batchNo) {
        JSONObject vatSelectResult = new JSONObject();
        JSONArray taxDeductInvoiceArray = new JSONArray();
        StringBuilder stringBuffer = new StringBuilder();
        String serial_no = mainInfo.getString("serial_no");
        JSONObject object = this.checkValid(mainInfo, taxPeriod, orgId, taxOrgId, true);
        if ("0000".equals(object.get((Object)"errcode"))) {
            JSONObject submitObject = new JSONObject();
            submitObject.put("serial_no", (Object)serial_no);
            submitObject.put("invoice_type", (Object)mainInfo.getString("invoice_type"));
            submitObject.put("deduction_purpose", (Object)mainInfo.getString("deduction_purpose"));
            submitObject.put("not_deductible_type", (Object)mainInfo.getString("not_deductible_type"));
            submitObject.put("invoice_code", (Object)mainInfo.getString("invoice_code"));
            submitObject.put("invoice_no", (Object)mainInfo.getString("invoice_no"));
            String effective_tax_amount = mainInfo.getString("effective_tax_amount");
            BigDecimal eta = new BigDecimal(effective_tax_amount);
            if (eta.compareTo(BigDecimal.ZERO) == 0) {
                effective_tax_amount = mainInfo.getString("total_tax_amount");
            }
            submitObject.put("effective_tax_amount", (Object)effective_tax_amount);
            submitObject.put("tax_period", (Object)DateUtils.format(taxPeriod, "yyyyMM"));
            submitObject.put("authenticate_flag", (Object)"4");
            taxDeductInvoiceArray.add((Object)submitObject);
            DeductInvoiceOperateService operateService = new DeductInvoiceOperateService();
            operateService.updateBatchSelectedInvoice(taxDeductInvoiceArray, "5", null);
            String selectOperaType = "1";
            if (isExcel.booleanValue()) {
                selectOperaType = "4";
                Row row = (Row)rowInfo.get("row");
                int lastCellNum = (Integer)rowInfo.get("lastCellNum");
                row.createCell(lastCellNum).setCellValue(SELECT_SUCCESS);
            }
            this.saveSelectAccount(batchNo, taxDeductInvoiceArray, "5", taxPeriod, selectOperaType);
            vatSelectResult.put("errcode", (Object)"0000");
            vatSelectResult.put("desc", (Object)SELECT_SUCCESS);
        } else {
            stringBuffer.append(object.get((Object)"desc"));
            if (isExcel.booleanValue()) {
                Row row = (Row)rowInfo.get("row");
                int lastCellNum = (Integer)rowInfo.get("lastCellNum");
                row.createCell(lastCellNum).setCellValue((String)object.get((Object)"desc"));
            }
            vatSelectResult.put("errcode", (Object)"0001");
            vatSelectResult.put("desc", (Object)stringBuffer.toString());
        }
        return vatSelectResult;
    }

    public JSONObject trainSelect(Boolean isExcel, Map<String, Object> rowInfo, DynamicObject mainInfo, Long orgId, Long taxOrgId, Date taxPeriod, String batchNo) {
        JSONObject trainSelectResult = new JSONObject();
        StringBuilder stringBuffer = new StringBuilder();
        ArrayList serialNos = Lists.newArrayList();
        String serial_no = mainInfo.getString("serial_no");
        JSONObject object = this.checkValid(mainInfo, taxPeriod, orgId, taxOrgId, false);
        if ("0000".equals(object.get((Object)"errcode"))) {
            serialNos.add(serial_no);
            logger.info("\u672c\u6b21\u626b\u63cf\u4eea\u65c5\u5ba2\u8fd0\u8f93\u9884\u52fe\u9009\u7684\u5e8f\u5217\u53f7\uff1a" + serialNos);
            DeductInvoiceOperateService operateService = new DeductInvoiceOperateService();
            operateService.transportDeductBySerialNo(serialNos, "2", taxPeriod, "5", isExcel != false ? "4" : "1");
            if (isExcel.booleanValue()) {
                Row row = (Row)rowInfo.get("row");
                int lastCellNum = (Integer)rowInfo.get("lastCellNum");
                row.createCell(lastCellNum).setCellValue(SELECT_SUCCESS);
            }
            trainSelectResult.put("errcode", (Object)"0000");
            trainSelectResult.put("desc", (Object)SELECT_SUCCESS);
        } else {
            stringBuffer.append(object.get((Object)"desc"));
            if (isExcel.booleanValue()) {
                Row row = (Row)rowInfo.get("row");
                int lastCellNum = (Integer)rowInfo.get("lastCellNum");
                row.createCell(lastCellNum).setCellValue((String)object.get((Object)"desc"));
            }
            trainSelectResult.put("errcode", (Object)"0001");
            trainSelectResult.put("desc", (Object)stringBuffer.toString());
        }
        return trainSelectResult;
    }

    public JSONObject elecTrainSelect(Boolean isExcel, Map<String, Object> rowInfo, DynamicObject mainInfo, Long orgId, Long taxOrgId, Date taxPeriod, String batchNo) {
        JSONObject elecSelectResult = new JSONObject();
        StringBuilder stringBuffer = new StringBuilder();
        ArrayList serialNos = Lists.newArrayList();
        String serial_no = mainInfo.getString("serial_no");
        JSONObject object = this.checkValid(mainInfo, taxPeriod, orgId, taxOrgId, false);
        if ("0000".equals(object.get((Object)"errcode"))) {
            serialNos.add(serial_no);
            logger.info("\u672c\u6b21\u626b\u63cf\u4eea\u65c5\u5ba2\u8fd0\u8f93\u7535\u5b50\u7968\u9884\u52fe\u9009\u5e8f\u5217\u53f7\uff1a" + serialNos);
            DeductInvoiceOperateService operateService = new DeductInvoiceOperateService();
            operateService.transportDeductBySerialNo(serialNos, "2", taxPeriod, "5", isExcel != false ? "4" : "1");
            if (isExcel.booleanValue()) {
                Row row = (Row)rowInfo.get("row");
                int lastCellNum = (Integer)rowInfo.get("lastCellNum");
                row.createCell(lastCellNum).setCellValue(SELECT_SUCCESS);
            }
            elecSelectResult.put("errcode", (Object)"0000");
            elecSelectResult.put("desc", (Object)SELECT_SUCCESS);
        } else {
            stringBuffer.append(object.get((Object)"desc"));
            if (isExcel.booleanValue()) {
                Row row = (Row)rowInfo.get("row");
                int lastCellNum = (Integer)rowInfo.get("lastCellNum");
                row.createCell(lastCellNum).setCellValue((String)object.get((Object)"desc"));
            }
            elecSelectResult.put("errcode", (Object)"0001");
            elecSelectResult.put("desc", (Object)stringBuffer.toString());
        }
        return elecSelectResult;
    }

    public JSONObject selectInvoiceArray(JSONObject invoice, Long orgId, Long taxOrgId, Date taxPeriod) {
        if (ObjectUtils.isEmpty((Object)invoice)) {
            return null;
        }
        JSONObject result = new JSONObject();
        Long invoiceType = invoice.getLong("invoiceType");
        String entity = InputInvoiceTypeEnum.getEntity(invoiceType);
        QFilter[] qFilters = new QFilter[3];
        if (InputInvoiceTypeEnum.TOLL_ELECTRON.getCode().equals(invoiceType) || InputInvoiceTypeEnum.MOTOR_INVOICE.getCode().equals(invoiceType) || InputInvoiceTypeEnum.BOAT_INVOICE.getCode().equals(invoiceType) || InputInvoiceTypeEnum.TRANSPORT_INVOICE.getCode().equals(invoiceType) || InputInvoiceTypeEnum.SPECIAL_ELECTRON.getCode().equals(invoiceType) || InputInvoiceTypeEnum.SPECIAL_PAPER.getCode().equals(invoiceType) || InputInvoiceTypeEnum.ORDINARY_ELECTRON.getCode().equals(invoiceType)) {
            qFilters[0] = new QFilter("invoice_code", "=", (Object)invoice.getString("invoiceCode"));
            qFilters[1] = new QFilter("invoice_no", "=", (Object)invoice.getString("invoiceNo"));
        } else if (InputInvoiceTypeEnum.AIR_INVOICE.getCode().equals(invoiceType)) {
            qFilters[0] = new QFilter("eticket_no", "=", (Object)invoice.getString("electronicTicketNum"));
            qFilters[1] = new QFilter("customer_id_no", "=", (Object)invoice.getString("customerIdentityNum"));
        } else if (InputInvoiceTypeEnum.TRAIN_INVOICE.getCode().equals(invoiceType)) {
            qFilters[0] = new QFilter("sequence_no", "=", (Object)invoice.getString("printingSequenceNo"));
            qFilters[1] = new QFilter("train_num", "=", (Object)invoice.getString("trainNum"));
            qFilters[2] = new QFilter("invoice_date", "=", (Object)invoice.getDate("invoiceDate"));
        } else {
            result.put("errcode", (Object)"0001");
            result.put("desc", (Object)ResManager.loadKDString((String)"\u8be5\u53d1\u7968\u7c7b\u578b\u4e0d\u652f\u6301\u9884\u52fe\u9009", (String)"ReadyDeductSelectSerive_6", (String)"imc-rim-common", (Object[])new Object[0]));
            return result;
        }
        Date endDate = DateUtils.getLastDateOfMonth(taxPeriod);
        DynamicObject invoiceMain = QueryServiceHelper.queryOne((String)entity, (String)"id, serial_no", (QFilter[])qFilters);
        if (ObjectUtils.isEmpty((Object)invoiceMain)) {
            result.put("errcode", (Object)"0002");
            result.put("desc", (Object)ResManager.loadKDString((String)"\u8be5\u53d1\u7968\u67e5\u9a8c\u5931\u8d25\u6216\u4e0d\u5b58\u5728\u7cfb\u7edf\u4e2d", (String)"ReadyDeductSelectSerive_7", (String)"imc-rim-common", (Object[])new Object[0]));
            return result;
        }
        String serial_no = invoiceMain.getString("serial_no");
        logger.info("\u626b\u63cf\u4eea\u9884\u52fe\u9009\u5b50\u8868\u53d1\u7968\u5e8f\u5217\u53f7\uff1a" + serial_no);
        result = this.readySelectByTypeAndSerialNo(invoiceType, serial_no, orgId, taxOrgId, endDate);
        return result;
    }

    public JSONObject readySelectByTypeAndSerialNo(Long invoiceType, String serialNo, Long orgId, Long taxOrgId, Date endDate) {
        if (StringUtils.isEmpty((CharSequence)serialNo)) {
            return new JSONObject();
        }
        JSONObject result = new JSONObject();
        QFilter serialNoFilter = new QFilter("serial_no", "=", (Object)serialNo);
        DynamicObject mainInfo = QueryServiceHelper.queryOne((String)"rim_invoice", (String)"id, org, tax_org, serial_no, invoice_type, deduction_purpose, deduction_flag, not_deductible_type, buyer_tax_no, invoice_date, total_tax_amount, transport_deduction, invoice_code, invoice_no, effective_tax_amount, tax_period, authenticate_flag", (QFilter[])new QFilter[]{serialNoFilter});
        logger.info("\u626b\u63cf\u4eea\u9884\u52fe\u9009\u4e3b\u8868\u6570\u636eBy\u5e8f\u5217\u53f7\uff1a" + mainInfo);
        String batchNo = this.getBatchNo();
        if (!ObjectUtils.isEmpty((Object)mainInfo)) {
            ReadyDeductSelectSerive readyDeductSelectSerive = new ReadyDeductSelectSerive();
            if (InputInvoiceTypeEnum.TOLL_ELECTRON.getCode().equals(invoiceType) || InputInvoiceTypeEnum.MOTOR_INVOICE.getCode().equals(invoiceType) || InputInvoiceTypeEnum.SPECIAL_ELECTRON.getCode().equals(invoiceType) || InputInvoiceTypeEnum.SPECIAL_PAPER.getCode().equals(invoiceType)) {
                result = readyDeductSelectSerive.vatSelect(Boolean.FALSE, null, mainInfo, orgId, taxOrgId, endDate, batchNo);
            } else if (InputInvoiceTypeEnum.AIR_INVOICE.getCode().equals(invoiceType) || InputInvoiceTypeEnum.TRAIN_INVOICE.getCode().equals(invoiceType) || InputInvoiceTypeEnum.TRANSPORT_INVOICE.getCode().equals(invoiceType) || InputInvoiceTypeEnum.BOAT_INVOICE.getCode().equals(invoiceType)) {
                result = readyDeductSelectSerive.trainSelect(Boolean.FALSE, null, mainInfo, orgId, taxOrgId, endDate, batchNo);
            } else if (InputInvoiceTypeEnum.ORDINARY_ELECTRON.getCode().equals(invoiceType) || InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getCode().equals(invoiceType)) {
                result = readyDeductSelectSerive.elecTrainSelect(Boolean.FALSE, null, mainInfo, orgId, taxOrgId, endDate, batchNo);
            }
        }
        return result;
    }

    private Map<String, List<String>> selectSubmit(String entityName, Sheet sheetAt, List<String> fieldNameList, Long orgId, Long taxOrgId, Date taxPeriod) throws ParseException {
        HashMap result = Maps.newHashMap();
        int sheetRows = sheetAt.getPhysicalNumberOfRows();
        Row filedNameRow = sheetAt.getRow(2);
        int lastCellNum = filedNameRow.getLastCellNum();
        ArrayList<String> serialNos = new ArrayList<String>();
        ArrayList<String> illegalInvoiceInfo = new ArrayList<String>();
        String batchNo = this.getBatchNo();
        for (int rowIndex = 4; rowIndex < sheetRows; ++rowIndex) {
            Row filedValueRow = sheetAt.getRow(rowIndex);
            if (ObjectUtils.isEmpty((Object)filedValueRow)) continue;
            QFilter[] qFilters = new QFilter[lastCellNum];
            int filterNum = 0;
            StringBuilder sb = new StringBuilder();
            String deduction_purpose = "1";
            String not_deductible_type = "";
            String validDesc = "";
            for (int j = 0; j < lastCellNum; ++j) {
                String filedName = fieldNameList.get(j);
                if (StringUtils.isBlank((CharSequence)filedName)) continue;
                String fieldValue = ExcelHelper.getStringValueFromCell(filedValueRow.getCell(j));
                sb.append(fieldValue).append('-');
                if (StringUtils.isNotBlank((CharSequence)fieldValue)) {
                    fieldValue = fieldValue.trim();
                }
                if ("deduction_purpose".equals(filedName.trim())) {
                    switch (fieldValue) {
                        case "\u62b5\u6263": {
                            fieldValue = "1";
                            break;
                        }
                        case "\u4e0d\u62b5\u6263": {
                            fieldValue = "2";
                        }
                    }
                    deduction_purpose = fieldValue;
                } else if ("not_deductible_type".equals(filedName.trim())) {
                    if ("2".equals(deduction_purpose) && StringUtils.isEmpty((CharSequence)fieldValue)) {
                        validDesc = ResManager.loadKDString((String)"\u62b5\u6263\u7528\u9014\u4e3a\u4e0d\u62b5\u6263\uff0c\u8bf7\u586b\u5199\u4e0d\u62b5\u6263\u539f\u56e0", (String)"ReadyDeductSelectSerive_8", (String)"imc-rim-common", (Object[])new Object[0]);
                    } else if (("1".equals(deduction_purpose) || StringUtils.isEmpty((CharSequence)deduction_purpose)) && !StringUtils.isEmpty((CharSequence)fieldValue)) {
                        validDesc = ResManager.loadKDString((String)"\u62b5\u6263\u7528\u9014\u4e3a\u62b5\u6263\uff0c\u65e0\u9700\u586b\u5199\u4e0d\u62b5\u6263\u539f\u56e0", (String)"ReadyDeductSelectSerive_9", (String)"imc-rim-common", (Object[])new Object[0]);
                    } else {
                        switch (fieldValue) {
                            case "\u7528\u4e8e\u975e\u5e94\u7a0e\u9879\u76ee": {
                                fieldValue = "1";
                                break;
                            }
                            case "\u7528\u4e8e\u514d\u7a0e\u9879\u76ee": {
                                fieldValue = "2";
                                break;
                            }
                            case "\u7528\u4e8e\u96c6\u4f53\u798f\u5229\u6216\u8005\u4e2a\u4eba\u6d88\u8d39": {
                                fieldValue = "3";
                                break;
                            }
                            case "\u906d\u53d7\u975e\u6b63\u5e38\u635f\u5931": {
                                fieldValue = "4";
                                break;
                            }
                            case "\u5176\u4ed6": {
                                fieldValue = "5";
                            }
                        }
                        not_deductible_type = fieldValue;
                    }
                } else if ("invoice_date".equals(filedName.trim())) {
                    if (!StringUtils.isEmpty((CharSequence)fieldValue)) {
                        SimpleDateFormat simpleDateFormat = null;
                        simpleDateFormat = fieldValue.contains("-") ? new SimpleDateFormat("yyyy-MM-dd") : new SimpleDateFormat("yyyyMMdd");
                        Date date = simpleDateFormat.parse(fieldValue);
                        qFilters[filterNum] = new QFilter(filedName, "=", (Object)date);
                    } else {
                        validDesc = ResManager.loadKDString((String)"\u5f00\u7968\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u6a21\u677f", (String)"ReadyDeductSelectSerive_10", (String)"imc-rim-common", (Object[])new Object[0]);
                    }
                }
                if ("rim_inv_custom".equals(entityName) && "invoice_code".equals(filedName)) {
                    if (StringUtils.isEmpty((CharSequence)fieldValue)) {
                        validDesc = ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u6a21\u677f\u4e2d\u7684\u5fc5\u586b\u5b57\u6bb5", (String)"ReadyDeductSelectSerive_11", (String)"imc-rim-common", (Object[])new Object[0]);
                    }
                    qFilters[filterNum] = new QFilter("custom_declaration_no", "=", (Object)fieldValue);
                }
                if (this.isEleInvoice(entityName) && "invoice_no".equals(filedName)) {
                    if (StringUtils.isEmpty((CharSequence)fieldValue)) {
                        validDesc = ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u6a21\u677f\u4e2d\u7684\u5fc5\u586b\u5b57\u6bb5", (String)"ReadyDeductSelectSerive_11", (String)"imc-rim-common", (Object[])new Object[0]);
                    }
                    qFilters[filterNum] = new QFilter("invoice_no", "=", (Object)fieldValue);
                }
                if (filterNum < 2 && !"rim_inv_custom".equals(entityName) && !this.isEleInvoice(entityName)) {
                    if (StringUtils.isEmpty((CharSequence)fieldValue)) {
                        validDesc = ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u6a21\u677f\u4e2d\u7684\u5fc5\u586b\u5b57\u6bb5", (String)"ReadyDeductSelectSerive_11", (String)"imc-rim-common", (Object[])new Object[0]);
                    }
                    qFilters[filterNum] = new QFilter(filedName, "=", (Object)fieldValue);
                }
                ++filterNum;
            }
            String sheetName = sheetAt.getSheetName();
            Row row = sheetAt.getRow(rowIndex);
            HashMap rowInfo = Maps.newHashMap();
            rowInfo.put("row", row);
            rowInfo.put("lastCellNum", lastCellNum);
            rowInfo.put("validDesc", validDesc);
            if (!StringUtils.isEmpty((CharSequence)validDesc)) {
                row.createCell(lastCellNum).setCellValue(validDesc);
                continue;
            }
            DynamicObject object = QueryServiceHelper.queryOne((String)entityName, (String)"id, serial_no", (QFilter[])qFilters);
            if (!ObjectUtils.isEmpty((Object)object)) {
                String serailNo = (String)object.get("serial_no");
                serialNos.add(serailNo);
                QFilter serialNoFilter = new QFilter("serial_no", "=", (Object)serailNo);
                DynamicObject mainInfo = QueryServiceHelper.queryOne((String)"rim_invoice", (String)"id, org.id as org, tax_org.id as tax_org, serial_no, invoice_type, deduction_purpose, not_deductible_type, deduction_flag, buyer_tax_no, invoice_date, total_tax_amount, transport_deduction, invoice_code, invoice_no, effective_tax_amount, tax_period, authenticate_flag", (QFilter[])new QFilter[]{serialNoFilter});
                if (!ObjectUtils.isEmpty((Object)mainInfo)) {
                    mainInfo.set("deduction_purpose", (Object)deduction_purpose);
                    mainInfo.set("not_deductible_type", (Object)not_deductible_type);
                    switch (sheetName) {
                        case "\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968": 
                        case "\u589e\u503c\u7a0e\u901a\u884c\u8d39\u53d1\u7968": 
                        case "\u673a\u52a8\u8f66\u7edf\u4e00\u9500\u552e\u53d1\u7968": 
                        case "\u6d77\u5173\u7f34\u6b3e\u4e66": 
                        case "\u5168\u7535\u53d1\u7968": 
                        case "\u6570\u7535\u53d1\u7968": 
                        case "\u6570\u7535\u7968(\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968)": 
                        case "\u6570\u7535\u7968\uff08\u822a\u7a7a\u8fd0\u8f93\u7535\u5b50\u5ba2\u7968)": 
                        case "\u6570\u7535\u7968\uff08\u94c1\u8def\u7535\u5b50\u5ba2\u7968)": {
                            this.vatSelect(Boolean.TRUE, rowInfo, mainInfo, orgId, taxOrgId, taxPeriod, batchNo);
                            break;
                        }
                        case "\u98de\u673a\u884c\u7a0b\u5355": 
                        case "\u706b\u8f66\u7968": 
                        case "\u8f6e\u8239\u7968": 
                        case "\u516c\u8def\u6c7d\u8f66\u7968": {
                            this.trainSelect(Boolean.TRUE, rowInfo, mainInfo, orgId, taxOrgId, taxPeriod, batchNo);
                            break;
                        }
                        case "\u65c5\u5ba2\u8fd0\u8f93\u7535\u5b50\u53d1\u7968": 
                        case "\u65c5\u5ba2\u8fd0\u8f93\u7535\u5b50\u666e\u901a\u53d1\u7968": 
                        case "\u65c5\u5ba2\u8fd0\u8f93\u6570\u7535\u7968(\u666e\u901a\u53d1\u7968)": {
                            this.elecTrainSelect(Boolean.TRUE, rowInfo, mainInfo, orgId, taxOrgId, taxPeriod, batchNo);
                            break;
                        }
                    }
                    continue;
                }
                sheetAt.getRow(rowIndex).createCell(lastCellNum).setCellValue(SELECT_NOTFOUND);
                continue;
            }
            illegalInvoiceInfo.add(sb.substring(0, sb.length() - 1));
            sheetAt.getRow(rowIndex).createCell(lastCellNum).setCellValue(SELECT_NOTFOUND);
        }
        result.put("serialNos", serialNos);
        result.put("illegalInvoiceInfo", illegalInvoiceInfo);
        return result;
    }

    private JSONObject checkValid(DynamicObject mainInfo, Date taxPeriod, Long orgId, Long taxOrgId, boolean isVat) {
        JSONObject object = new JSONObject();
        object.put("errcode", (Object)"0000");
        String authenticate_flag = mainInfo.getString("authenticate_flag");
        String deduction_flag = mainInfo.getString("deduction_flag");
        BigDecimal total_tax_amount = mainInfo.getBigDecimal("total_tax_amount");
        BigDecimal effective_tax_amount = mainInfo.getBigDecimal("effective_tax_amount");
        Date invoice_date = mainInfo.getDate("invoice_date");
        Long invoiceType = DynamicObjectUtil.getDynamicObjectLongValue(mainInfo.get("invoice_type"));
        String transport_deduction = mainInfo.getString("transport_deduction");
        logger.info("\u9884\u52fe\u9009\u5408\u6cd5\u6027\u6821\u9a8c-\u53d1\u7968\u4ee3\u7801\uff1a{} \u53d1\u7968\u5e8f\u5217\u53f7\uff1a{} \u65c5\u5ba2\u8fd0\u8f93\u62b5\u6263\uff1a{} \u62b5\u6263\u6807\u8bc6:{} \u52fe\u9009\u72b6\u6001:{}", new Object[]{mainInfo.getString("invoice_no"), mainInfo.getString("serial_no"), transport_deduction, authenticate_flag});
        long org = DynamicObjectUtil.getDynamicObjectLongValue(mainInfo.get("org"));
        long taxorg = DynamicObjectUtil.getDynamicObjectLongValue(mainInfo.get("tax_org"));
        if (orgId != null && orgId != org) {
            object.put("errcode", (Object)"0001");
            object.put("desc", (Object)ResManager.loadKDString((String)"\u9884\u52fe\u9009\u5931\u8d25\uff0c\u8be5\u53d1\u7968\u4e0d\u5c5e\u4e8e\u5f53\u524d\u9875\u9762\u6240\u9009\u6838\u7b97\u7ec4\u7ec7", (String)"ReadyDeductSelectSerive_26", (String)"imc-rim-common", (Object[])new Object[0]));
            return object;
        }
        if (taxOrgId != null && taxorg != taxOrgId) {
            object.put("errcode", (Object)"0001");
            object.put("desc", (Object)ResManager.loadKDString((String)"\u9884\u52fe\u9009\u5931\u8d25\uff0c\u8be5\u53d1\u7968\u4e0d\u5c5e\u4e8e\u5f53\u524d\u9875\u9762\u6240\u9009\u7a0e\u52a1\u7ec4\u7ec7", (String)"ReadyDeductSelectSerive_27", (String)"imc-rim-common", (Object[])new Object[0]));
            return object;
        }
        if (isVat && !InputInvoiceTypeEnum.canDeduction(invoiceType).booleanValue()) {
            object.put("errcode", (Object)"0008");
            object.put("desc", (Object)ResManager.loadKDString((String)"\u9884\u52fe\u9009\u5931\u8d25\uff0c\u8be5\u53d1\u7968\u4e0d\u5c5e\u4e8e\u7a0e\u5c40\u62b5\u6263\u53d1\u7968\u7c7b\u578b", (String)"ReadyDeductSelectSerive_28", (String)"imc-rim-common", (Object[])new Object[0]));
            return object;
        }
        if (!isVat && !InputInvoiceTypeEnum.canTransportDeduction(invoiceType).booleanValue()) {
            object.put("errcode", (Object)"0008");
            object.put("desc", (Object)ResManager.loadKDString((String)"\u9884\u52fe\u9009\u5931\u8d25\uff0c\u8be5\u53d1\u7968\u4e0d\u5c5e\u4e8e\u65c5\u5ba2\u8fd0\u8f93\u62b5\u6263\u53d1\u7968\u7c7b\u578b", (String)"ReadyDeductSelectSerive_29", (String)"imc-rim-common", (Object[])new Object[0]));
            return object;
        }
        if (!StringUtils.isEmpty((CharSequence)authenticate_flag) && !"0".equals(authenticate_flag)) {
            object.put("errcode", (Object)"0002");
            object.put("desc", (Object)ResManager.loadKDString((String)"\u9884\u52fe\u9009\u5931\u8d25\uff0c\u8be5\u53d1\u7968\u52fe\u9009\u72b6\u6001\u4e0d\u662f\u672a\u52fe\u9009\u72b6\u6001", (String)"ReadyDeductSelectSerive_30", (String)"imc-rim-common", (Object[])new Object[0]));
        } else if (!StringUtils.isEmpty((CharSequence)transport_deduction) && !"0".equals(transport_deduction)) {
            object.put("errcode", (Object)"0003");
            object.put("desc", (Object)ResManager.loadKDString((String)"\u9884\u52fe\u9009\u5931\u8d25\uff0c\u8be5\u53d1\u7968\u65c5\u5ba2\u8fd0\u8f93\u62b5\u6263\u4e0d\u662f\u672a\u62b5\u6263\u72b6\u6001", (String)"ReadyDeductSelectSerive_31", (String)"imc-rim-common", (Object[])new Object[0]));
        } else if (!"1".equals(deduction_flag)) {
            object.put("errcode", (Object)"0004");
            object.put("desc", (Object)ResManager.loadKDString((String)"\u9884\u52fe\u9009\u5931\u8d25\uff0c\u8be5\u53d1\u7968\u62b5\u6263\u6807\u8bc6\u4e0d\u662f\u53ef\u62b5\u6263\u72b6\u6001", (String)"ReadyDeductSelectSerive_32", (String)"imc-rim-common", (Object[])new Object[0]));
        } else if (total_tax_amount.compareTo(BigDecimal.ZERO) < 0) {
            object.put("errcode", (Object)"0005");
            object.put("desc", (Object)ResManager.loadKDString((String)"\u9884\u52fe\u9009\u5931\u8d25\uff0c\u8be5\u53d1\u7968\u7a0e\u989d\u4e0d\u5f97\u5c0f\u4e8e0", (String)"ReadyDeductSelectSerive_33", (String)"imc-rim-common", (Object[])new Object[0]));
        } else if (effective_tax_amount.compareTo(total_tax_amount) > 0) {
            object.put("errcode", (Object)"0006");
            object.put("desc", (Object)ResManager.loadKDString((String)"\u9884\u52fe\u9009\u5931\u8d25\uff0c\u8be5\u53d1\u7968\u6709\u6548\u7a0e\u989d\u4e0d\u5f97\u5927\u4e8e\u53d1\u7968\u7684\u7a0e\u989d", (String)"ReadyDeductSelectSerive_34", (String)"imc-rim-common", (Object[])new Object[0]));
        } else if (!invoice_date.before(DateUtils.getLastDateOfMonth(taxPeriod))) {
            object.put("errcode", (Object)"0007");
            object.put("desc", (Object)ResManager.loadKDString((String)"\u9884\u52fe\u9009\u5931\u8d25\uff0c\u8be5\u53d1\u7968\u7684\u5f00\u7968\u65e5\u671f\u4e0d\u5f97\u5927\u4e8e\u7a0e\u63a7\u6240\u5c5e\u671f", (String)"ReadyDeductSelectSerive_35", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        return object;
    }

    public void recognitionReadySelect(RequestContext requestContext, String url, String name, String pageId, Long orgId, Long taxOrgId, Date taxPeriod) {
        logger.info("\u626b\u63cf\u4eea\u9884\u52fe\u9009-url:{}, name:{}", (Object)url, (Object)name);
        RecognitionReadySelectTask recognitionReadySelectTask = new RecognitionReadySelectTask(requestContext, url, name, pageId, orgId, taxOrgId, taxPeriod);
        recognitionThreadPool.submit((Callable)recognitionReadySelectTask);
    }

    public JSONObject getConvertInfo(Long invoiceType, JSONObject invoice) {
        JSONObject jsonObject = new JSONObject();
        if (invoiceType == null || ObjectUtils.isEmpty((Object)invoice)) {
            return jsonObject;
        }
        if (InputInvoiceTypeEnum.AIR_INVOICE.getCode().equals(invoiceType)) {
            jsonObject.put("invoice_code", (Object)invoice.getString("electronicTicketNum"));
            jsonObject.put("invoice_no", (Object)invoice.getString("printNum"));
            jsonObject.put("customer_id_no", (Object)invoice.getString("customerIdentityNum"));
        } else if (InputInvoiceTypeEnum.TRAIN_INVOICE.getCode().equals(invoiceType)) {
            jsonObject.put("invoice_code", (Object)invoice.getString("trainNum"));
            jsonObject.put("invoice_no", (Object)invoice.getString("printingSequenceNo"));
        } else {
            jsonObject.put("invoice_code", (Object)invoice.getString("invoiceCode"));
            jsonObject.put("invoice_no", (Object)invoice.getString("invoiceNo"));
        }
        return jsonObject;
    }

    private void saveSelectAccount(String batchNo, JSONArray taxDeductInvoiceArray, String deductibleMode, Date taxPeriod) {
        this.saveSelectAccount(batchNo, taxDeductInvoiceArray, deductibleMode, taxPeriod, "1");
    }

    private void saveSelectAccount(String batchNo, JSONArray taxDeductInvoiceArray, String deductibleMode, Date taxPeriod, String selectOperaType) {
        SelectAccountService selectAccountService = new SelectAccountService();
        JSONArray selectAccountList = new JSONArray();
        for (int j = 0; j < taxDeductInvoiceArray.size(); ++j) {
            JSONObject object = taxDeductInvoiceArray.getJSONObject(j);
            JSONObject account = new JSONObject();
            account.put("batch_no", (Object)batchNo);
            account.put("serial_no", (Object)object.getString("serial_no"));
            account.put("deduction_purpose", (Object)deductibleMode);
            account.put("select_status", (Object)"0");
            account.put("effective_tax_amount", (Object)object.getBigDecimal("effective_tax_amount"));
            account.put("select_result", (Object)"1");
            account.put("handle_status", (Object)"1");
            account.put("select_opera_type", (Object)selectOperaType);
            selectAccountList.add((Object)account);
        }
        selectAccountService.asyncSaveSelectAccount(selectAccountList, taxPeriod);
    }

    private String getBatchNo() {
        return UUID.getBatchNo("READY");
    }

    private boolean isEleInvoice(String entityName) {
        return "rim_inv_electric".equals(entityName) || "rim_inv_air_ele".equals(entityName) || "rim_inv_train_ele".equals(entityName);
    }
}

