/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.deduction;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Optional;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.imc.rim.common.invoice.model.SelectLog;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.TenantUtils;
import kd.imc.rim.common.utils.UUID;
import kd.sdk.annotation.SdkDeprecated;

public class SelectAccountService {
    private static Log LOGGER = LogFactory.getLog(SelectAccountService.class);
    private static final int DESCRIPTION_LENGTH = 120;
    private static final String MAIN_FILEDS = "id,invoice_code,invoice_no,total_amount,invoice_amount,total_tax_amount,saler_tax_no,saler_name,manage_status,invoice_type,org,authenticate_flag,invoice_date";

    @SdkDeprecated
    public void asyncSaveSelectAccount(JSONArray selectAccountList, Date taxPeriod) {
        ThreadPools.executeOnceIncludeRequestContext((String)"AsyncSaveSelectAccountRun", () -> this.saveSelectAccount(selectAccountList, taxPeriod));
    }

    public void asyncSaveSelectLogAndAccount(JSONObject logParam, JSONArray selectAccountList) {
        ThreadPools.executeOnceIncludeRequestContext((String)"AsyncSaveSelectLogAndAccountRun", () -> this.saveSelectLogAndAccount(logParam, selectAccountList));
    }

    public void saveSelectLogAndAccount(JSONObject logParam, JSONArray selectAccountList) {
        if (!CollectionUtils.isEmpty((Collection)selectAccountList)) {
            String userId = RequestContext.get().getUserId();
            String tenantNo = TenantUtils.getTenantNo();
            String taxPeriod = logParam.getString("taxPeriod");
            Date taxPeriodDate = null;
            if (StringUtils.isNotEmpty((CharSequence)taxPeriod)) {
                taxPeriodDate = DateUtils.stringToDate(taxPeriod, "yyyyMM");
            }
            ArrayList<DynamicObject> accountObjectList = new ArrayList<DynamicObject>(selectAccountList.size());
            DynamicObject selectLog = BusinessDataServiceHelper.newDynamicObject((String)"rim_select_log");
            String taskNo = logParam.getString("taskNo");
            if (StringUtils.isEmpty((CharSequence)taskNo)) {
                taskNo = UUID.randomUUID();
            }
            selectLog.set("task_no", (Object)taskNo);
            selectLog.set("batch_no", (Object)logParam.getString("batchNo"));
            selectLog.set("async_flag", (Object)logParam.getString("asyncFlag"));
            selectLog.set("select_type", (Object)logParam.getString("selectType"));
            selectLog.set("operate_type", (Object)logParam.getString("deductibleMode"));
            selectLog.set("select_opera_type", (Object)logParam.getString("selectOperaType"));
            selectLog.set("org", logParam.get((Object)"orgId"));
            selectLog.set("tax_no", logParam.get((Object)"taxNo"));
            selectLog.set("creater", (Object)userId);
            selectLog.set("handle_status", logParam.get((Object)"handleStatus"));
            selectLog.set("bill_type", logParam.get((Object)"billType"));
            selectLog.set("account", logParam.get((Object)"account"));
            selectLog.set("total_num", (Object)selectAccountList.size());
            selectLog.set("tenant_no", (Object)tenantNo);
            selectLog.set("tax_period", (Object)taxPeriodDate);
            selectLog.set("create_time", (Object)new Date());
            selectLog.set("update_time", (Object)new Date());
            int successNum = 0;
            int failNum = 0;
            BigDecimal totalTaxAmount = BigDecimal.ZERO;
            BigDecimal effectiveTaxAmount = BigDecimal.ZERO;
            BigDecimal invoiceAmountLog = BigDecimal.ZERO;
            for (int i = 0; i < selectAccountList.size(); ++i) {
                JSONObject account = selectAccountList.getJSONObject(i);
                String serialNo = account.getString("serial_no");
                if (StringUtils.isNotEmpty((CharSequence)serialNo)) {
                    QFilter tenantFilter = new QFilter("tenant_no", "=", (Object)tenantNo);
                    QFilter serialFilter = new QFilter("serial_no", "=", (Object)serialNo);
                    DynamicObject queryObject = QueryServiceHelper.queryOne((String)"rim_invoice", (String)MAIN_FILEDS, (QFilter[])new QFilter[]{serialFilter, tenantFilter});
                    totalTaxAmount = totalTaxAmount.add(BigDecimalUtil.transDecimal(queryObject.get("total_tax_amount")));
                    invoiceAmountLog = totalTaxAmount.add(BigDecimalUtil.transDecimal(queryObject.get("invoice_amount")));
                    BigDecimal singleEffectiveTaxAmount = BigDecimalUtil.transDecimal(account.get((Object)"effective_tax_amount"));
                    if (BigDecimal.ZERO.compareTo(singleEffectiveTaxAmount) == 0) {
                        singleEffectiveTaxAmount = totalTaxAmount;
                    }
                    effectiveTaxAmount = effectiveTaxAmount.add(singleEffectiveTaxAmount);
                    DynamicObject accountObject = this.getNewSelectAccount(account, queryObject, userId, tenantNo, taxPeriodDate, logParam.getLong("orgId"));
                    accountObjectList.add(accountObject);
                } else {
                    totalTaxAmount = totalTaxAmount.add(BigDecimalUtil.transDecimal(account.get((Object)"total_tax_amount")));
                    invoiceAmountLog = totalTaxAmount.add(BigDecimalUtil.transDecimal(account.get((Object)"invoice_amount")));
                    DynamicObject newQueryObject = BusinessDataServiceHelper.newDynamicObject((String)"rim_invoice");
                    newQueryObject.set("invoice_type", (Object)account.getLong("invoice_type"));
                    DynamicObject accountObject = this.getNewSelectAccount(account, newQueryObject, userId, tenantNo, taxPeriodDate, logParam.getLong("orgId"));
                    accountObjectList.add(accountObject);
                }
                String selectResult = account.getString("select_result");
                if ("1".equals(selectResult) || "19".equals(selectResult)) {
                    ++successNum;
                    continue;
                }
                if ("35".equals(selectResult)) continue;
                ++failNum;
            }
            selectLog.set("success_num", (Object)successNum);
            selectLog.set("fail_num", (Object)failNum);
            selectLog.set("total_tax_amount", (Object)totalTaxAmount);
            selectLog.set("effective_tax_amount", (Object)effectiveTaxAmount);
            selectLog.set("invoice_amount", (Object)invoiceAmountLog);
            try (TXHandle h = TX.required();){
                try {
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{selectLog});
                    SaveServiceHelper.save((DynamicObject[])accountObjectList.toArray(new DynamicObject[accountObjectList.size()]));
                }
                catch (Throwable e) {
                    LOGGER.error("\u52fe\u9009\u65e5\u5fd7/\u53f0\u8d26\u5931\u8d25", e);
                    h.markRollback();
                    throw e;
                }
            }
        }
    }

    public void saveSelectAccount(JSONArray selectAccountArray, Date taxPeriod) {
        if (!CollectionUtils.isEmpty((Collection)selectAccountArray)) {
            String userId = RequestContext.get().getUserId();
            String tenantNo = TenantUtils.getTenantNo();
            for (int i = 0; i < selectAccountArray.size(); ++i) {
                JSONObject account = selectAccountArray.getJSONObject(i);
                this.save(account, userId, tenantNo, taxPeriod, RequestContext.get().getOrgId());
            }
        }
    }

    private void save(JSONObject account, String userId, String tenantNo, Date taxPeriod, Long orgId) {
        String serialNo = account.getString("serial_no");
        QFilter tenantFilter = new QFilter("tenant_no", "=", (Object)tenantNo);
        QFilter serialFilter = new QFilter("serial_no", "=", (Object)serialNo);
        DynamicObject queryObject = QueryServiceHelper.queryOne((String)"rim_invoice", (String)MAIN_FILEDS, (QFilter[])new QFilter[]{serialFilter, tenantFilter});
        DynamicObject accountObject = this.getNewSelectAccount(account, queryObject, userId, tenantNo, taxPeriod, orgId);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{accountObject});
    }

    private DynamicObject getNewSelectAccount(JSONObject account, DynamicObject mainObject, String userId, String tenantNo, Date taxPeriod, Long orgId) {
        String description;
        BigDecimal singleEffectiveTaxAmount;
        DynamicObject accountObject = BusinessDataServiceHelper.newDynamicObject((String)"rim_select_account");
        accountObject.set("serial_no", (Object)account.getString("serial_no"));
        accountObject.set("batch_no", account.get((Object)"batch_no"));
        accountObject.set("invoice_type", (Object)DynamicObjectUtil.getDynamicObjectLongValue(mainObject.get("invoice_type")));
        long orgIdMain = DynamicObjectUtil.getDynamicObjectLongValue(mainObject.get("org"));
        if (orgIdMain == 0L) {
            orgIdMain = orgId;
        }
        if (orgIdMain == 0L) {
            orgIdMain = RequestContext.get().getOrgId();
        }
        accountObject.set("org", (Object)orgIdMain);
        String deductibleMode = account.getString("deduction_purpose");
        accountObject.set("deduction_purpose", (Object)deductibleMode);
        BigDecimal totalTaxAmount = mainObject.getBigDecimal("total_tax_amount");
        if (BigDecimal.ZERO.compareTo(totalTaxAmount) == 0) {
            totalTaxAmount = BigDecimalUtil.transDecimal(account.get((Object)"total_tax_amount"));
        }
        if (BigDecimal.ZERO.compareTo(singleEffectiveTaxAmount = BigDecimalUtil.transDecimal(account.get((Object)"effective_tax_amount"))) == 0) {
            singleEffectiveTaxAmount = totalTaxAmount;
        }
        accountObject.set("effective_tax_amount", (Object)singleEffectiveTaxAmount);
        accountObject.set("agric_partial_amount", account.get((Object)"agric_partial_amount"));
        accountObject.set("agric_partial_taxamount", account.get((Object)"agric_partial_taxamount"));
        accountObject.set("effective_tax_amount", (Object)singleEffectiveTaxAmount);
        accountObject.set("select_result", account.get((Object)"select_result"));
        accountObject.set("handle_status", account.get((Object)"handle_status"));
        accountObject.set("invoice_code", (Object)Optional.ofNullable(mainObject.getString("invoice_code")).filter(StringUtils::isNotEmpty).orElseGet(() -> account.getString("invoice_code")));
        accountObject.set("invoice_no", (Object)Optional.ofNullable(mainObject.getString("invoice_no")).filter(StringUtils::isNotEmpty).orElseGet(() -> account.getString("invoice_no")));
        BigDecimal invoiceAmount = BigDecimalUtil.transDecimal(mainObject.get("invoice_amount"));
        if (invoiceAmount.compareTo(BigDecimal.ZERO) > 0) {
            accountObject.set("invoice_amount", (Object)invoiceAmount);
        } else {
            accountObject.set("invoice_amount", (Object)BigDecimalUtil.transDecimal(account.get((Object)"invoice_amount")));
        }
        Date invoiceDate = mainObject.getDate("invoice_date");
        if (invoiceDate == null) {
            invoiceDate = account.getDate("invoice_date");
        }
        accountObject.set("invoice_date", (Object)invoiceDate);
        accountObject.set("total_tax_amount", (Object)totalTaxAmount);
        String salerTaxNo = StringUtils.isNotBlank((CharSequence)account.getString("saler_tax_no")) ? account.getString("saler_tax_no") : mainObject.getString("saler_tax_no");
        String salerName = StringUtils.isNotBlank((CharSequence)account.getString("saler_name")) ? account.getString("saler_name") : mainObject.getString("saler_name");
        accountObject.set("saler_tax_no", (Object)salerTaxNo);
        accountObject.set("saler_name", (Object)salerName);
        accountObject.set("manage_status", mainObject.get("manage_status"));
        accountObject.set("select_status", (Object)account.getString("select_status"));
        accountObject.set("electronic_no", (Object)account.getString("electronic_no"));
        accountObject.set("select_time", (Object)account.getDate("select_time"));
        accountObject.set("creater", (Object)userId);
        accountObject.set("tax_period", (Object)taxPeriod);
        accountObject.set("pre_authenticate_flag", account.get((Object)"pre_authenticate_flag"));
        accountObject.set("select_opera_type", account.get((Object)"select_opera_type"));
        if ("4".equals(deductibleMode)) {
            accountObject.set("not_deductible_type", account.get((Object)"not_deductible_type"));
        }
        if (StringUtils.isNotEmpty((CharSequence)(description = account.getString("description"))) && description.length() > 100) {
            description = description.substring(0, 100);
        }
        accountObject.set("description", (Object)description);
        accountObject.set("tenant_no", (Object)tenantNo);
        accountObject.set("create_time", (Object)new Date());
        accountObject.set("update_time", (Object)new Date());
        return accountObject;
    }

    public static long insertSelectLog(SelectLog selectLog) {
        String userId;
        DynamicObject selectLogObj = BusinessDataServiceHelper.newDynamicObject((String)"rim_select_log");
        selectLogObj.set("task_no", (Object)selectLog.getTaskNo());
        selectLogObj.set("batch_no", (Object)selectLog.getBatchNo());
        selectLogObj.set("select_type", (Object)selectLog.getSelectType());
        selectLogObj.set("operate_type", (Object)selectLog.getOperateType());
        selectLogObj.set("select_opera_type", (Object)selectLog.getSelectOperaType());
        Long orgId = selectLog.getOrgId();
        if (orgId == null || orgId < 1L) {
            orgId = RequestContext.get().getOrgId();
        }
        if (StringUtils.isEmpty((CharSequence)(userId = selectLog.getUserId()))) {
            userId = RequestContext.get().getUserId();
        }
        selectLogObj.set("org", (Object)orgId);
        selectLogObj.set("tax_no", (Object)selectLog.getTaxNo());
        selectLogObj.set("creater", (Object)userId);
        selectLogObj.set("handle_status", (Object)selectLog.getHandleStatus());
        String description = selectLog.getDescription();
        if (StringUtils.isNotEmpty((CharSequence)description) && description.length() > 120) {
            description = description.substring(0, 120);
        }
        selectLogObj.set("description", (Object)description);
        selectLogObj.set("total_num", (Object)selectLog.getTotalNum());
        selectLogObj.set("success_num", (Object)selectLog.getSuccessNum());
        selectLogObj.set("fail_num", (Object)selectLog.getFailNum());
        selectLogObj.set("total_tax_amount", (Object)selectLog.getTotalTaxAmount());
        selectLogObj.set("invoice_amount", (Object)selectLog.getInvoiceAmount());
        selectLogObj.set("effective_tax_amount", (Object)selectLog.getEffectiveTaxAmount());
        selectLogObj.set("tenant_no", (Object)TenantUtils.getTenantNo());
        selectLogObj.set("tax_period", (Object)selectLog.getTaxPeriod());
        selectLogObj.set("bill_type", (Object)selectLog.getBillType());
        selectLogObj.set("async_flag", (Object)selectLog.getAsyncFlag());
        selectLogObj.set("account", (Object)selectLog.getAccount());
        selectLogObj.set("create_time", (Object)new Date());
        selectLogObj.set("update_time", (Object)new Date());
        JSONObject statisticData = selectLog.getResultJson();
        if (!ObjectUtils.isEmpty((Object)statisticData)) {
            selectLogObj.set("result_json_tag", (Object)statisticData.toJSONString());
        }
        selectLogObj.set("statistics_status", (Object)selectLog.getStatisticsStatus());
        selectLogObj.set("result_json", (Object)selectLog.getResultJsonText());
        Object[] dynamicObjects = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{selectLogObj});
        if (!ObjectUtils.isEmpty((Object[])dynamicObjects)) {
            return dynamicObjects[0].getLong("id");
        }
        return 0L;
    }
}

