/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.invoice.deduction;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.Callable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.CollectTypeEnum;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.InvoiceSaveConstant;
import kd.imc.rim.common.invoice.query.InvoiceQueryService;
import kd.imc.rim.common.invoice.save.InvoiceSaveService;
import kd.imc.rim.common.service.InvoiceLog;
import kd.imc.rim.common.utils.DeductionUtils;
import kd.imc.rim.common.utils.TenantUtils;

public class UpdatePeriodInvoiceTask
implements Callable<Boolean> {
    private RequestContext ctx;
    private Object mainId;
    private Long orgId;
    private JSONObject invoice;

    public UpdatePeriodInvoiceTask(RequestContext ctx, Object mainId, Long orgId, JSONObject invoice) {
        this.ctx = ctx;
        this.mainId = mainId;
        this.orgId = orgId;
        this.invoice = invoice;
    }

    @Override
    public Boolean call() throws Exception {
        DeductionUtils.setTaxDownCollectInfo(this.invoice);
        DynamicObject mainObject = BusinessDataServiceHelper.loadSingle((Object)this.mainId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"rim_invoice"));
        Long invoiceType = mainObject.getLong("invoice_type.id");
        String authenticateFlag = this.invoice.getString("authenticateFlag");
        String preAuthenticateFlag = mainObject.getString("authenticate_flag");
        String lqStatus = this.invoice.getString("lqStatus");
        if (StringUtils.isEmpty((CharSequence)lqStatus) && "1".equals(authenticateFlag) && ("2".equals(preAuthenticateFlag) || "3".equals(preAuthenticateFlag))) {
            return Boolean.FALSE;
        }
        InvoiceSaveService saveService = InvoiceSaveService.newInstance(invoiceType + "");
        mainObject.set("modifytime", (Object)new Date());
        BigDecimal effectiveTaxAmount = mainObject.getBigDecimal("effective_tax_amount");
        if (BigDecimal.ZERO.compareTo(effectiveTaxAmount) == 0) {
            effectiveTaxAmount = mainObject.getBigDecimal("total_tax_amount");
            this.invoice.put("effectiveTaxAmount", (Object)effectiveTaxAmount);
        }
        boolean isHgjks = InputInvoiceTypeEnum.HGJKS.getCode().equals(invoiceType) || InputInvoiceTypeEnum.WITHHOLDING.getCode().equals(invoiceType);
        String invoiceStatus = this.invoice.getString("invoiceStatus");
        String serialNo = mainObject.getString("serial_no");
        ArrayList<String> serialNos = new ArrayList<String>(8);
        serialNos.add(serialNo);
        String entity = InputInvoiceTypeEnum.getEntity(invoiceType);
        Object[] dynamicObjects = InvoiceQueryService.loadAllBySerialNo(entity, TenantUtils.getTenantNo(), serialNos);
        Object bodyObject = null;
        if (!ObjectUtils.isEmpty((Object[])dynamicObjects)) {
            bodyObject = dynamicObjects[0];
            DeductionUtils.addInvoiceItems(invoiceType, (DynamicObject)bodyObject, this.invoice);
            DeductionUtils.addTrainEleBusinessType(invoiceType, (DynamicObject)bodyObject, this.invoice);
            bodyObject.set("modifytime", (Object)new Date());
            saveService.setDeductionFieldValue(invoiceType, (DynamicObject)bodyObject, this.invoice);
            if (!isHgjks && StringUtils.isNotEmpty((CharSequence)invoiceStatus)) {
                bodyObject.set("invoice_status", (Object)invoiceStatus);
                if (!"0".equals(invoiceStatus) && !"7".equals(invoiceStatus)) {
                    bodyObject.set(InvoiceSaveConstant.FIELD_DEDUCTION_FLAG, (Object)"0");
                }
            }
        }
        saveService.setDeductionFieldValue(invoiceType, mainObject, this.invoice);
        if (StringUtils.isNotEmpty((CharSequence)invoiceStatus)) {
            mainObject.set("invoice_status", (Object)invoiceStatus);
            if (!(isHgjks || "0".equals(invoiceStatus) || "7".equals(invoiceStatus))) {
                mainObject.set(InvoiceSaveConstant.FIELD_DEDUCTION_FLAG, (Object)"0");
                InvoiceSaveService.setExtInfo(mainObject, InvoiceSaveConstant.EXT_DEDUCTION_FLAG, mainObject.getString(InvoiceSaveConstant.FIELD_DEDUCTION_FLAG));
            }
        }
        saveService.setSourceAndRiskLevel(this.invoice, mainObject);
        saveService.setMainInvoiceInfo(mainObject);
        try (TXHandle h = TX.required();){
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{mainObject});
                if (bodyObject != null) {
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bodyObject});
                }
                JSONObject logInfo = new JSONObject();
                logInfo.put("authenticateFlag", (Object)authenticateFlag);
                logInfo.put("invoiceStatus", (Object)invoiceStatus);
                logInfo.put("traceId", (Object)this.ctx.getTraceId());
                InvoiceLog.insert("deduct_authenticate", mainObject.getString("serial_no"), logInfo.toJSONString(), this.orgId, CollectTypeEnum.PC_SHUIPAN.getName(), CollectTypeEnum.PC_SHUIPAN.getCode());
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
        return Boolean.TRUE;
    }
}

